/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.text.TextUtils;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class EvalSpice {
    private String expr;
    private StreamTokenizer tokenizer;
    int openParens;
    private static final Double ONE = new Double(1.0);
    private static final Double ZERO = new Double(0.0);

    public EvalSpice(String expr) {
        this.expr = expr;
        this.openParens = 0;
    }

    public Object evaluate() {
        if (this.expr == null) {
            return null;
        }
        StringReader reader = new StringReader(this.expr);
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.ordinaryChar(40);
        this.tokenizer.ordinaryChar(41);
        this.tokenizer.ordinaryChar(42);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.ordinaryChar(43);
        this.tokenizer.ordinaryChar(45);
        this.tokenizer.ordinaryChar(60);
        this.tokenizer.ordinaryChar(61);
        this.tokenizer.ordinaryChar(62);
        this.tokenizer.ordinaryChar(33);
        this.tokenizer.ordinaryChar(63);
        this.tokenizer.ordinaryChar(58);
        this.tokenizer.wordChars(95, 95);
        try {
            return this.evalEq().eval();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (ParseException e) {
            String parsed = "";
            try {
                long left = reader.skip(Long.MAX_VALUE);
                parsed = this.expr.substring(0, this.expr.length() - (int)left);
            }
            catch (IOException e2) {
                // empty catch block
            }
            if (!parsed.equals("")) {
                parsed = ": " + parsed + " <--";
            }
            System.out.println("Parse Error: " + e.getMessage() + parsed + " " + this.tokenizer.toString());
        }
        return this.expr;
    }

    private SimpleEq evalEq() throws IOException, ParseException {
        SimpleEq eq = new SimpleEq();
        while (true) {
            int tt;
            if ((tt = this.tokenizer.nextToken()) == -1 || tt == 10) {
                if (this.openParens > 0) {
                    throw new ParseException("Unmatched open parens");
                }
                return eq;
            }
            if (tt == 41) {
                --this.openParens;
                if (this.openParens < 0) {
                    throw new ParseException("Unmatched close parens");
                }
                Object value = eq.eval();
                if (value instanceof String) {
                    return new SimpleEq("(" + value.toString() + ")", null, null);
                }
                return new SimpleEq(value, null, null);
            }
            if (tt == 40) {
                ++this.openParens;
                if (!eq.addIdentifierOk()) {
                    throw new ParseException("Too many identifiers");
                }
                SimpleEq id = this.evalEq();
                eq.addIdentifier(id);
                continue;
            }
            if (tt == 44) {
                return eq;
            }
            if (tt == 58) {
                return eq;
            }
            if (tt == -2) {
                this.tokenizer.pushBack();
                eq.addIdentifier(this.parseNumber());
                continue;
            }
            if (tt == -3) {
                double b;
                double a;
                Object m2;
                Object m1;
                Object arg;
                if (this.tokenizer.sval.equalsIgnoreCase("sin")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double(Math.sin((Double)arg)) : "sin" + EvalSpice.format(arg);
                    eq.addIdentifier(arg);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("min")) {
                    this.expect(40);
                    ++this.openParens;
                    m1 = this.evalEq().eval();
                    m2 = this.evalEq().eval();
                    if (m1 instanceof Double && m2 instanceof Double) {
                        a = (Double)m1;
                        b = (Double)m2;
                        m1 = new Double(Math.min(a, b));
                    } else {
                        String m2str = EvalSpice.format(m2);
                        if (m2str.startsWith("(") && m2str.endsWith(")")) {
                            m2str = m2str.substring(1, m2str.length() - 1);
                        }
                        m1 = "min(" + EvalSpice.format(m1) + "," + m2str + ")";
                    }
                    eq.addIdentifier(m1);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("max")) {
                    this.expect(40);
                    ++this.openParens;
                    m1 = this.evalEq().eval();
                    m2 = this.evalEq().eval();
                    if (m1 instanceof Double && m2 instanceof Double) {
                        a = (Double)m1;
                        b = (Double)m2;
                        m1 = new Double(Math.max(a, b));
                    } else {
                        String m2str = EvalSpice.format(m2);
                        if (m2str.startsWith("(") && m2str.endsWith(")")) {
                            m2str = m2str.substring(1, m2str.length() - 1);
                        }
                        m1 = "max(" + EvalSpice.format(m1) + "," + m2str + ")";
                    }
                    eq.addIdentifier(m1);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("abs")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double(Math.abs((Double)arg)) : "abs" + EvalSpice.format(arg);
                    eq.addIdentifier(arg);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("sqrt")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double(Math.sqrt((Double)arg)) : "sqrt" + EvalSpice.format(arg);
                    eq.addIdentifier(arg);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("int")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double((int)((Double)arg).doubleValue()) : "int" + EvalSpice.format(arg);
                    eq.addIdentifier(arg);
                    continue;
                }
                eq.addIdentifier(this.tokenizer.sval);
                continue;
            }
            if (tt == 42) {
                eq.addOp(Op.MULT);
                continue;
            }
            if (tt == 47) {
                eq.addOp(Op.DIV);
                continue;
            }
            if (tt == 43) {
                eq.addOp(Op.PLUS);
                continue;
            }
            if (tt == 45) {
                eq.addOp(Op.MINUS);
                continue;
            }
            if (tt == 60) {
                tt = this.tokenizer.nextToken();
                if (tt == 61) {
                    eq.addOp(Op.LTOE);
                    continue;
                }
                this.tokenizer.pushBack();
                eq.addOp(Op.LT);
                continue;
            }
            if (tt == 62) {
                tt = this.tokenizer.nextToken();
                if (tt == 61) {
                    eq.addOp(Op.GTOE);
                    continue;
                }
                this.tokenizer.pushBack();
                eq.addOp(Op.GT);
                continue;
            }
            if (tt == 61) {
                this.expect(61);
                eq.addOp(Op.EQ);
                continue;
            }
            if (tt == 33) {
                this.expect(61);
                eq.addOp(Op.NE);
                continue;
            }
            if (tt != 63) continue;
            eq.addOp(Op.COND);
            Object arg1 = this.evalEq().eval();
            if (this.tokenizer.ttype != 58) {
                throw new ParseException("Expected ':' after conditional");
            }
            Object arg2 = this.evalEq().eval();
            SimpleEq condval = new SimpleEq(arg1, Op.CONDCHOICE, arg2);
            eq.addIdentifier(condval);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseNumber() throws IOException, ParseException {
        int tt = this.tokenizer.nextToken();
        if (tt != -2) throw new ParseException("Expected number");
        double val = this.tokenizer.nval;
        this.tokenizer.ordinaryChar(101);
        this.tokenizer.ordinaryChar(69);
        tt = this.tokenizer.nextToken();
        if (tt == 101 || tt == 69) {
            tt = this.tokenizer.nextToken();
            boolean minus = false;
            if (tt == 45) {
                minus = true;
                tt = this.tokenizer.nextToken();
            }
            if (tt != -2) throw new ParseException("Invalid token");
            double exp = this.tokenizer.nval;
            if (minus) {
                exp = -1.0 * exp;
            }
            val *= Math.pow(10.0, exp);
        } else if (tt == -3) {
            if (this.tokenizer.sval.equalsIgnoreCase("g")) {
                val *= 1.0E9;
            } else if (this.tokenizer.sval.equalsIgnoreCase("meg")) {
                val *= 1000000.0;
            } else if (this.tokenizer.sval.equalsIgnoreCase("k")) {
                val *= 1000.0;
            } else if (this.tokenizer.sval.equalsIgnoreCase("m")) {
                val *= 0.001;
            } else if (this.tokenizer.sval.equalsIgnoreCase("u")) {
                val *= 1.0E-6;
            } else if (this.tokenizer.sval.equalsIgnoreCase("n")) {
                val *= 1.0E-9;
            } else if (this.tokenizer.sval.equalsIgnoreCase("p")) {
                val *= 1.0E-12;
            } else {
                if (!this.tokenizer.sval.equalsIgnoreCase("f")) throw new ParseException("Invalid token");
                val *= 1.0E-15;
            }
        } else {
            this.tokenizer.pushBack();
        }
        this.tokenizer.wordChars(101, 101);
        this.tokenizer.wordChars(69, 69);
        return new Double(val);
    }

    private void expect(int token) throws IOException, ParseException {
        int tt = this.tokenizer.nextToken();
        if (tt != token) {
            throw new ParseException("Expected token " + token);
        }
    }

    private static String format(Object obj) {
        if (obj instanceof Double) {
            return TextUtils.formatDouble((Double)obj);
        }
        return obj.toString();
    }

    public static void main(String[] args) {
        EvalSpice.testEval("1 + 2", 3.0);
        EvalSpice.testEval("1 + 2 * 3", 7.0);
        EvalSpice.testEval("1 * 2 + 3", 5.0);
        EvalSpice.testEval("(1 + 2) * 3", 9.0);
        EvalSpice.testEval("(1 + 2) * x", "3.0 * x");
        EvalSpice.testEval("300 / -1.5e2", -2.0);
        EvalSpice.testEval("1.5e-2", 0.015);
        EvalSpice.testEval("20 * 1.5e-2", 0.3);
        EvalSpice.testEval("20 * 1.5m", 0.03);
        EvalSpice.testEval("(1 + a) * 3 + b", "(1.0 + a) * 3.0 + b");
        EvalSpice.testEval("1 + 2 * 3 + - 4", 3.0);
        EvalSpice.testEval("-1", -1.0);
        EvalSpice.testEval("-1 + 2 * 3 + - 4", 1.0);
        EvalSpice.testEval("-(1 + 2) * 3 + -4", -13.0);
        EvalSpice.testEval("-(1 + 2) * 3 + -4 * -2 - -4 * -3", -13.0);
        EvalSpice.testEval("-sin(3)", -Math.sin(3.0));
        EvalSpice.testEval("-sin(x)", "-sin(x)");
        EvalSpice.testEval("1-min(1,-2)", 3.0);
        EvalSpice.testEval("1-min(1,x)", null);
        EvalSpice.testEval("1-min((a+b)*c,x)", null);
        EvalSpice.testEval("1-min((a+b)*c,(a+b))", null);
        EvalSpice.testEval("-a + 2 * 3 * -b + - 4", null);
        EvalSpice.testEval("1 ? -2 : 4", -2.0);
        EvalSpice.testEval("0 ? -2 : 4", 4.0);
        EvalSpice.testEval("8 == 1 ? -2 : 4", 4.0);
        EvalSpice.testEval("8 > 1 ? -2 : 4", -2.0);
        EvalSpice.testEval("1 - 7 <= 1 ? -2 : 4", -2.0);
        EvalSpice.testEval("layer == 1 ? two + 1 : eight * 4 / 2", "layer == 1.0 ? two + 1.0 : eight * 4.0 / 2.0");
        EvalSpice.testEval("0 * 1 ? 3 / 2 : -4 + 10", 6.0);
        System.out.println("\nThese should flag as errors:\n---------------------------\n");
        EvalSpice.testEval("1 2 +", null);
        EvalSpice.testEval("1 + * 2", null);
        EvalSpice.testEval("1 + 2 * - -3", null);
        EvalSpice.testEval("300 / -1.5ee2 + 5", null);
        EvalSpice.testEval("1-min((a+b)*c,(a+b)", null);
        EvalSpice.testEval("1/0", null);
    }

    private static void testEval(String eq, String expected) {
        EvalSpice sp = new EvalSpice(eq);
        String evald = sp.evaluate().toString();
        if (expected == null) {
            System.out.println(eq + " = " + evald);
        } else {
            System.out.println(eq + " = " + evald + " -- (" + expected + ")");
            assert (expected.equals(evald));
        }
    }

    private static void testEval(String eq, double expected) {
        EvalSpice sp = new EvalSpice(eq);
        Object evald = sp.evaluate();
        System.out.println(eq + " = " + evald + " -- (" + expected + ")");
        assert (evald instanceof Double);
        double val = (Double)evald;
        assert (val == expected);
    }

    public static class SimpleEq {
        protected Object lhop;
        private Op op;
        protected Object rhop;
        boolean neglh = false;
        boolean negrh = false;

        public SimpleEq() {
            this.lhop = null;
            this.op = null;
            this.rhop = null;
        }

        public SimpleEq(Object lhop, Op op, Object rhop) {
            this.lhop = lhop;
            this.op = op;
            this.rhop = rhop;
        }

        public boolean addIdentifierOk() {
            if (this.lhop == null) {
                return true;
            }
            if (this.rhop == null && this.op != null) {
                return true;
            }
            if (this.rhop instanceof SimpleEq) {
                return ((SimpleEq)this.rhop).addIdentifierOk();
            }
            return false;
        }

        public void addIdentifier(Object id) throws ParseException {
            if (this.lhop == null) {
                this.lhop = id;
            } else if (this.rhop == null && this.op != null) {
                this.rhop = id;
            } else if (this.rhop instanceof SimpleEq) {
                ((SimpleEq)this.rhop).addIdentifier(id);
            } else {
                throw new ParseException("Two operands with no operator");
            }
        }

        public void addOp(Op operator) throws ParseException {
            if (this.lhop == null && operator == Op.MINUS && !this.neglh) {
                this.neglh = true;
            } else {
                if (this.lhop == null) {
                    throw new ParseException("Operator " + operator + " with no left hand operand");
                }
                if (this.op == null && this.rhop == null) {
                    this.op = operator;
                } else if (this.op != null && this.rhop == null && operator == Op.MINUS && !this.negrh) {
                    this.negrh = true;
                } else if (this.op != null && this.rhop != null) {
                    if (this.rhop instanceof SimpleEq) {
                        ((SimpleEq)this.rhop).addOp(operator);
                    } else if (operator.precedence < this.op.precedence) {
                        this.rhop = new SimpleEq(this.rhop, operator, null);
                        ((SimpleEq)this.rhop).neglh = this.negrh;
                        this.negrh = false;
                    } else {
                        this.lhop = new SimpleEq(this.lhop, this.op, this.rhop);
                        this.op = operator;
                        this.rhop = null;
                        ((SimpleEq)this.lhop).neglh = this.neglh;
                        ((SimpleEq)this.lhop).negrh = this.negrh;
                        this.neglh = false;
                        this.negrh = false;
                    }
                } else {
                    throw new ParseException("Two operators in a row");
                }
            }
        }

        public Object eval() throws ParseException {
            if (this.lhop instanceof SimpleEq) {
                this.lhop = ((SimpleEq)this.lhop).eval();
            }
            if (this.rhop instanceof SimpleEq) {
                this.rhop = ((SimpleEq)this.rhop).eval();
            }
            if (this.op == Op.CONDCHOICE) {
                return this;
            }
            if (this.op == Op.COND && this.rhop instanceof SimpleEq) {
                SimpleEq condval = (SimpleEq)this.rhop;
                if (this.lhop instanceof Double && condval.lhop instanceof Double && condval.rhop instanceof Double) {
                    double cond = (Double)this.lhop;
                    if (this.neglh) {
                        cond = -1.0 * cond;
                    }
                    double valt = (Double)condval.lhop;
                    if (condval.neglh) {
                        valt = -1.0 * valt;
                    }
                    double valf = (Double)condval.rhop;
                    if (condval.negrh) {
                        valf = -1.0 * valf;
                    }
                    if (cond == 0.0) {
                        return valf;
                    }
                    return valt;
                }
                String neglhstr = condval.neglh ? "-" : "";
                String negrhstr = condval.negrh ? "-" : "";
                this.rhop = neglhstr + EvalSpice.format(condval.lhop) + " : " + negrhstr + EvalSpice.format(condval.rhop);
            } else if (this.lhop instanceof Double && this.rhop instanceof Double) {
                double lh = (Double)this.lhop;
                double rh = (Double)this.rhop;
                if (this.neglh) {
                    lh = -1.0 * lh;
                }
                if (this.negrh) {
                    rh = -1.0 * rh;
                }
                if (this.op == Op.MULT) {
                    return new Double(lh * rh);
                }
                if (this.op == Op.DIV) {
                    return new Double(lh / rh);
                }
                if (this.op == Op.PLUS) {
                    return new Double(lh + rh);
                }
                if (this.op == Op.MINUS) {
                    return new Double(lh - rh);
                }
                if (this.op == Op.LT) {
                    return lh < rh ? ONE : ZERO;
                }
                if (this.op == Op.LTOE) {
                    return lh <= rh ? ONE : ZERO;
                }
                if (this.op == Op.GT) {
                    return lh > rh ? ONE : ZERO;
                }
                if (this.op == Op.GTOE) {
                    return lh >= rh ? ONE : ZERO;
                }
                if (this.op == Op.EQ) {
                    return lh == rh ? ONE : ZERO;
                }
                if (this.op == Op.NE) {
                    return lh != rh ? ONE : ZERO;
                }
                if (this.op == Op.LAND) {
                    return lh != 0.0 && rh != 0.0 ? ONE : ZERO;
                }
                if (this.op == Op.LOR) {
                    return lh != 0.0 || rh != 0.0 ? ONE : ZERO;
                }
            } else if (this.op == null && this.rhop == null) {
                if (this.neglh) {
                    if (this.lhop instanceof Double) {
                        return -1.0 * (Double)this.lhop;
                    }
                    return "-" + this.lhop.toString();
                }
                return this.lhop;
            }
            String neglhstr = this.neglh ? "-" : "";
            String negrhstr = this.negrh ? "-" : "";
            String lhstr = this.lhop == null ? "?" : EvalSpice.format(this.lhop);
            String rhstr = this.rhop == null ? "?" : EvalSpice.format(this.rhop);
            return neglhstr + lhstr + " " + this.op + " " + negrhstr + rhstr;
        }
    }

    public static class Op {
        public final String name;
        public final int precedence;
        public static final Op MULT = new Op("*", 2);
        public static final Op DIV = new Op("/", 2);
        public static final Op PLUS = new Op("+", 3);
        public static final Op MINUS = new Op("-", 3);
        public static final Op LT = new Op("<", 5);
        public static final Op LTOE = new Op("<=", 5);
        public static final Op GT = new Op(">", 5);
        public static final Op GTOE = new Op(">=", 5);
        public static final Op EQ = new Op("==", 6);
        public static final Op NE = new Op("!=", 6);
        public static final Op LAND = new Op("&&", 10);
        public static final Op LOR = new Op("||", 11);
        public static final Op COND = new Op("?", 12);
        public static final Op CONDCHOICE = new Op(":", 12);

        private Op(String name, int precedence) {
            this.name = name;
            this.precedence = precedence;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ParseException
    extends Exception {
        public ParseException(String msg) {
            super(msg);
        }
    }
}

