/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.extract.Extract;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Connectivity {
    private Technology tech;
    private HashMap layerForFunction;
    private Layer polyLayer;
    private Layer tempLayer1;
    private Layer tempLayer2;
    private Layer activeLayer;
    private HashMap arcsForLayer;
    private HashMap convertedCells;
    private HashMap exportNumbers;

    public static void extractCurCell(boolean recursive) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            System.out.println("Must be editing a cell with pure layer nodes.");
            return;
        }
        ExtractJob job = new ExtractJob(curCell, recursive);
    }

    private Connectivity(Technology tech) {
        Layer.Function fun;
        Layer layer;
        this.tech = tech;
        this.convertedCells = new HashMap();
        this.exportNumbers = new HashMap();
        this.polyLayer = null;
        this.tempLayer2 = null;
        this.tempLayer1 = null;
        this.activeLayer = null;
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            layer = (Layer)it.next();
            fun = layer.getFunction();
            if (this.polyLayer == null && fun == Layer.Function.POLY1) {
                this.polyLayer = layer;
            }
            if (fun == Layer.Function.POLY1 && (layer.getFunctionExtras() & 0x1000) != 0) {
                this.tempLayer1 = layer;
            }
            if (fun == Layer.Function.METAL1 && (layer.getFunctionExtras() & 0x1000) != 0) {
                this.tempLayer2 = layer;
            }
            if (this.activeLayer != null || !fun.isDiff()) continue;
            this.activeLayer = layer;
        }
        this.polyLayer = this.polyLayer.getNonPseudoLayer();
        this.activeLayer = this.activeLayer.getNonPseudoLayer();
        this.arcsForLayer = new HashMap();
        it = tech.getLayers();
        while (it.hasNext()) {
            layer = (Layer)it.next();
            fun = layer.getFunction();
            if (!fun.isDiff() && !fun.isPoly() && !fun.isMetal()) continue;
            ArcProto.Function oFun = null;
            if (fun.isMetal()) {
                oFun = ArcProto.Function.getMetal(fun.getLevel());
            }
            if (fun.isPoly()) {
                oFun = ArcProto.Function.getPoly(fun.getLevel());
            }
            if (oFun == null) continue;
            ArcProto type = null;
            Iterator aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = (ArcProto)aIt.next();
                if (ap.getFunction() != oFun) continue;
                type = ap;
                break;
            }
            if (type == null) continue;
            this.arcsForLayer.put(layer, type);
        }
        this.layerForFunction = new HashMap();
        it = tech.getLayers();
        while (it.hasNext()) {
            layer = (Layer)it.next();
            fun = layer.getFunction();
            if (fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN) {
                fun = Layer.Function.DIFF;
            }
            if (this.layerForFunction.get(fun) != null) continue;
            this.layerForFunction.put(fun, layer);
        }
    }

    private void doExtract(Cell oldCell, boolean recursive, boolean top) {
        if (recursive) {
            Iterator it = oldCell.getNodes();
            while (it.hasNext()) {
                Cell subCell;
                Cell convertedCell;
                NodeInst ni = (NodeInst)it.next();
                if (!(ni.getProto() instanceof Cell) || (convertedCell = (Cell)this.convertedCells.get(subCell = (Cell)ni.getProto())) != null) continue;
                this.doExtract(subCell, recursive, false);
            }
        }
        System.out.print("Extracting " + oldCell + ": ");
        String newCellName = oldCell.getName() + "{" + oldCell.getView().getAbbreviation() + "}";
        Cell newCell = Cell.makeInstance(oldCell.getLibrary(), newCellName);
        if (newCell == null) {
            System.out.println("Cannot create new cell: " + newCellName);
            return;
        }
        this.convertedCells.put(oldCell, newCell);
        this.exportNumbers.put(newCell, new GenMath.MutableInteger(1));
        PolyMerge merge = new PolyMerge();
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator nIt = oldCell.getNodes();
        while (nIt.hasNext()) {
            int i;
            Poly poly;
            Layer layer;
            NodeInst ni = (NodeInst)nIt.next();
            if (ni.getProto() == Generic.tech.cellCenterNode) continue;
            NodeProto copyType = null;
            if (ni.getProto() instanceof Cell) {
                copyType = (NodeProto)this.convertedCells.get(ni.getProto());
                if (copyType == null) {
                    copyType = ni.getProto();
                }
            } else {
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                if (np.getFunction() != PrimitiveNode.Function.NODE) {
                    copyType = ni.getProto();
                }
            }
            if (copyType != null) {
                NodeInst newNi;
                double sX = ni.getXSize();
                double sY = ni.getYSize();
                if (copyType instanceof Cell) {
                    Rectangle2D cellBounds = ((Cell)copyType).getBounds();
                    sX = cellBounds.getWidth();
                    sY = cellBounds.getHeight();
                }
                if (ni.isXMirrored()) {
                    sX = -sX;
                }
                if (ni.isYMirrored()) {
                    sY = -sY;
                }
                if ((newNi = NodeInst.makeInstance(copyType, ni.getAnchorCenter(), sX, sY, newCell, ni.getAngle(), ni.getName(), ni.getTechSpecific())) == null) {
                    System.out.println("Problem creating new instance of " + ni.getProto());
                    return;
                }
                newNodes.put(ni, newNi);
                Iterator it = ni.getExports();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    PortInst pi = newNi.findPortInstFromProto(e.getOriginalPort().getPortProto());
                    Export.newInstance(newCell, pi, e.getName());
                }
                continue;
            }
            AffineTransform trans = ni.rotateOut();
            Poly[] polys = this.tech.getShapeOfNode(ni);
            if (polys.length <= 0 || (layer = (poly = polys[0]).getLayer()) == null) continue;
            layer = this.geometricLayer(layer);
            poly.transform(trans);
            Point2D[] points = poly.getPoints();
            if (Extract.isGridAlignExtraction()) {
                for (i = 0; i < points.length; ++i) {
                    EditWindow.gridAlign(points[i]);
                }
            } else {
                for (i = 0; i < points.length; ++i) {
                    points[i].setLocation(DBMath.round(points[i].getX()), DBMath.round(points[i].getY()));
                }
            }
            merge.addPolygon(layer, poly);
        }
        Iterator aIt = oldCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = (ArcInst)aIt.next();
            NodeInst end1 = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
            NodeInst end2 = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
            if (end1 == null || end2 == null) continue;
            PortInst pi1 = end1.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
            PortInst pi2 = end2.findPortInstFromProto(ai.getTailPortInst().getPortProto());
            ArcInst newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), pi1, pi2, ai.getHeadLocation(), ai.getTailLocation(), ai.getName());
        }
        PolyMerge originalMerge = new PolyMerge();
        originalMerge.addMerge(merge, new AffineTransform());
        this.extractVias(merge, originalMerge, newCell);
        System.out.print("vias, ");
        this.extractTransistors(merge, originalMerge, newCell);
        System.out.print("transistors, ");
        this.extendGeometry(merge, originalMerge, newCell, true);
        System.out.print("extensions, ");
        this.makeWires(merge, originalMerge, newCell);
        System.out.print("wires, ");
        this.extendGeometry(merge, originalMerge, newCell, false);
        System.out.print("connections, ");
        this.convertAllGeometry(merge, originalMerge, newCell);
        System.out.print("geometry, ");
        AutoStitch.runAutoStitch(newCell, false, false, originalMerge);
        System.out.println("done.");
        if (top) {
            WindowFrame wf = WindowFrame.createEditWindow(newCell);
            EditWindow wnd = (EditWindow)wf.getContent();
            Highlighter h = wnd.getHighlighter();
            Iterator it = newCell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun != PrimitiveNode.Function.NODE) continue;
                h.addElectricObject(ni, newCell);
            }
        }
    }

    private void makeWires(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        Layer.Function fun;
        Layer layer;
        ArrayList<Layer> wireLayers = new ArrayList<Layer>();
        Iterator lIt = merge.getKeyIterator();
        while (lIt.hasNext()) {
            layer = (Layer)lIt.next();
            fun = layer.getFunction();
            if (!fun.isDiff() && !fun.isPoly() && !fun.isMetal()) continue;
            wireLayers.add(layer);
        }
        lIt = wireLayers.iterator();
        while (lIt.hasNext()) {
            layer = (Layer)lIt.next();
            fun = layer.getFunction();
            ArcProto ap = (ArcProto)this.arcsForLayer.get(layer);
            if (ap == null) continue;
            List polyList = merge.getMergedPoints(layer, true);
            Iterator pIt = polyList.iterator();
            while (pIt.hasNext()) {
                PolyBase poly = (PolyBase)pIt.next();
                List lines = this.findCenterlines(poly, layer, ap.getDefaultWidth(), merge, originalMerge);
                Iterator it = lines.iterator();
                while (it.hasNext()) {
                    Centerline cl = (Centerline)it.next();
                    Point2D.Double loc1 = new Point2D.Double();
                    PortInst pi1 = this.locatePortOnCenterline(cl, loc1, layer, ap, true, newCell);
                    Point2D.Double loc2 = new Point2D.Double();
                    PortInst pi2 = this.locatePortOnCenterline(cl, loc2, layer, ap, false, newCell);
                    int ang = cl.angle;
                    if (!loc1.equals(loc2)) {
                        ang = GenMath.figureAngle(loc1, loc2);
                    }
                    double wid = cl.width - ap.getWidthOffset();
                    boolean noEndExtend = false;
                    Poly arcPoly = Poly.makeEndPointPoly(loc1.distance(loc2), wid, ang, loc1, wid / 2.0, loc2, wid / 2.0);
                    if (!originalMerge.contains(layer, arcPoly)) {
                        arcPoly = Poly.makeEndPointPoly(loc1.distance(loc2), wid, ang, loc1, 0.0, loc2, 0.0);
                        if (originalMerge.contains(layer, arcPoly)) {
                            noEndExtend = true;
                        } else {
                            wid = ap.getWidthOffset();
                            arcPoly = Poly.makeEndPointPoly(loc1.distance(loc2), wid, ang, loc1, wid / 2.0, loc2, wid / 2.0);
                            if (originalMerge.contains(layer, arcPoly)) {
                                cl.width = 0.0;
                            } else {
                                arcPoly = Poly.makeEndPointPoly(loc1.distance(loc2), wid, ang, loc1, wid / 2.0, loc2, wid / 2.0);
                                if (!originalMerge.contains(layer, arcPoly)) continue;
                                noEndExtend = true;
                                cl.width = 0.0;
                            }
                        }
                    }
                    this.realizeArc(ap, pi1, pi2, loc1, loc2, cl.width + ap.getWidthOffset(), noEndExtend, merge);
                }
            }
        }
    }

    private List findPortInstsTouchingPoint(Point2D pt, Layer layer, Cell newCell) {
        ArrayList<PortInst> touchingNodes = new ArrayList<PortInst>();
        Rectangle2D.Double checkBounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator it = newCell.searchIterator(checkBounds);
        block0: while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            if (ni.getProto() instanceof Cell) {
                PortInst pi;
                Cell subCell = (Cell)ni.getProto();
                boolean found = false;
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi2 = (PortInst)pIt.next();
                    Poly portPoly = pi2.getPoly();
                    if (!portPoly.contains(pt)) continue;
                    touchingNodes.add(pi2);
                    found = true;
                    break;
                }
                if (found || (pi = this.makePort(ni, layer, pt)) == null) continue;
                touchingNodes.add(pi);
                continue;
            }
            Poly[] polys = this.tech.getShapeOfNode(ni, null, null, true, true, null);
            AffineTransform trans = ni.rotateOut();
            for (int i = 0; i < polys.length; ++i) {
                Poly oPoly = polys[i];
                Layer oLayer = this.geometricLayer(oPoly.getLayer());
                if (layer != oLayer) continue;
                oPoly.transform(trans);
                if (!oPoly.contains(pt)) continue;
                PortInst touchingPi = this.findPortInstClosestToPoly(ni, (PrimitivePort)oPoly.getPort(), pt);
                if (touchingPi == null) {
                    System.out.println("Can't find port for " + ni + " and " + oPoly.getPort());
                    continue;
                }
                touchingNodes.add(touchingPi);
                continue block0;
            }
        }
        return touchingNodes;
    }

    private PortInst makePort(NodeInst ni, Layer layer, Point2D pt) {
        Cell subCell = (Cell)ni.getProto();
        GenMath.MutableInteger exportNumber = (GenMath.MutableInteger)this.exportNumbers.get(subCell);
        if (exportNumber == null) {
            return null;
        }
        AffineTransform transIn = ni.rotateIn(ni.translateIn());
        Point2D.Double inside = new Point2D.Double();
        transIn.transform(pt, inside);
        Rectangle2D.Double bounds = new Rectangle2D.Double(((Point2D)inside).getX(), ((Point2D)inside).getY(), 0.0, 0.0);
        Iterator it = subCell.searchIterator(bounds);
        while (it.hasNext()) {
            PortInst foundPi;
            block4: {
                NodeInst subNi;
                block3: {
                    Geometric geom = (Geometric)it.next();
                    if (geom instanceof ArcInst) continue;
                    subNi = (NodeInst)geom;
                    foundPi = null;
                    if (!(subNi.getProto() instanceof Cell)) break block3;
                    PortInst pi = this.makePort(subNi, layer, inside);
                    if (pi == null) break block4;
                    foundPi = pi;
                    break block4;
                }
                Technology tech = subNi.getProto().getTechnology();
                AffineTransform trans = subNi.rotateOut();
                Poly[] polyList = tech.getShapeOfNode(subNi, null, null, true, true, null);
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly = polyList[i];
                    if (poly.getPort() == null || this.geometricLayer(poly.getLayer()) != layer) continue;
                    poly.transform(trans);
                    if (!poly.contains(inside)) continue;
                    foundPi = this.findPortInstClosestToPoly(subNi, (PrimitivePort)poly.getPort(), inside);
                    break;
                }
            }
            if (foundPi == null) continue;
            String exportName = "E" + exportNumber.intValue();
            exportNumber.increment();
            Export e = Export.newInstance(subCell, foundPi, exportName);
            return ni.findPortInstFromProto(e);
        }
        return null;
    }

    private PortInst findPortInstClosestToPoly(NodeInst ni, PrimitivePort pp, Point2D pt) {
        PortInst touchingPi = ni.findPortInstFromProto(pp);
        PrimitiveNode pnp = (PrimitiveNode)ni.getProto();
        Poly touchingPoly = touchingPi.getPoly();
        double bestDist = pt.distance(new Point2D.Double(touchingPoly.getCenterX(), touchingPoly.getCenterY()));
        Iterator pIt = pnp.getPorts();
        while (pIt.hasNext()) {
            PortInst testPi;
            Poly testPoly;
            double dist;
            PrimitivePort prP = (PrimitivePort)pIt.next();
            if (prP.getTopology() != pp.getTopology() || !((dist = pt.distance(new Point2D.Double((testPoly = (testPi = ni.findPortInstFromProto(prP)).getPoly()).getCenterX(), testPoly.getCenterY()))) < bestDist)) continue;
            bestDist = dist;
            touchingPi = testPi;
        }
        return touchingPi;
    }

    private PortInst locatePortOnCenterline(Centerline cl, Point2D loc1, Layer layer, ArcProto ap, boolean startSide, Cell newCell) {
        PortInst piRet = null;
        boolean isHub = cl.endHub;
        Point2D startPoint = cl.end;
        if (startSide) {
            isHub = cl.startHub;
            startPoint = cl.start;
        }
        if (!isHub) {
            List possiblePorts = this.findPortInstsTouchingPoint(startPoint, layer, newCell);
            Iterator pIt = possiblePorts.iterator();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                Poly portPoly = pi.getPoly();
                Point2D[] points = portPoly.getPoints();
                if (points.length == 1) {
                    Point2D iPt = GenMath.intersect(cl.start, cl.angle, points[0], (cl.angle + 900) % 3600);
                    if (iPt == null) continue;
                    loc1.setLocation(iPt.getX(), iPt.getY());
                    piRet = pi;
                    break;
                }
                for (int i = 0; i < points.length; ++i) {
                    int last = i - 1;
                    if (last < 0) {
                        last = points.length - 1;
                    }
                    Point2D portLineFrom = points[last];
                    Point2D portLineTo = points[i];
                    Point2D interPt = null;
                    if (portLineFrom.equals(portLineTo)) {
                        interPt = GenMath.intersect(cl.start, cl.angle, portLineFrom, (cl.angle + 900) % 3600);
                    } else {
                        int angPortLine = GenMath.figureAngle(portLineFrom, portLineTo);
                        interPt = GenMath.intersect(portLineFrom, angPortLine, cl.start, cl.angle);
                        if (interPt != null && (interPt.getX() < Math.min(portLineFrom.getX(), portLineTo.getX()) || interPt.getX() > Math.max(portLineFrom.getX(), portLineTo.getX()) || interPt.getY() < Math.min(portLineFrom.getY(), portLineTo.getY()) || interPt.getY() > Math.max(portLineFrom.getY(), portLineTo.getY()))) {
                            interPt = null;
                        }
                    }
                    if (interPt == null) continue;
                    loc1.setLocation(interPt.getX(), interPt.getY());
                    if (!portPoly.contains(loc1)) continue;
                    piRet = pi;
                    break;
                }
                if (piRet == null) continue;
                break;
            }
        }
        if (piRet == null) {
            PrimitiveNode pin = ap.findPinProto();
            int ang = GenMath.figureAngle(cl.start, cl.end);
            double xOff = GenMath.cos(ang) * cl.width / 2.0;
            double yOff = GenMath.sin(ang) * cl.width / 2.0;
            if (startSide) {
                if (!isHub) {
                    cl.start.setLocation(cl.start.getX() + xOff, cl.start.getY() + yOff);
                }
                NodeInst ni = this.wantNodeAt(cl.start, pin, cl.width, newCell);
                loc1.setLocation(cl.start.getX(), cl.start.getY());
                piRet = ni.getOnlyPortInst();
            } else {
                if (!isHub) {
                    cl.end.setLocation(cl.end.getX() - xOff, cl.end.getY() - yOff);
                }
                NodeInst ni = this.wantNodeAt(cl.end, pin, cl.width, newCell);
                loc1.setLocation(cl.end.getX(), cl.end.getY());
                piRet = ni.getOnlyPortInst();
            }
        }
        return piRet;
    }

    private void extractVias(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        ArrayList layers = new ArrayList();
        Iterator lIt = merge.getKeyIterator();
        while (lIt.hasNext()) {
            layers.add(lIt.next());
        }
        lIt = layers.iterator();
        while (lIt.hasNext()) {
            Layer layer = (Layer)lIt.next();
            Layer.Function fun = layer.getFunction();
            if (!fun.isContact()) continue;
            List possibleVias = this.findPossibleVias(layer);
            List polyList = merge.getMergedPoints(layer, true);
            Iterator it = possibleVias.iterator();
            while (it.hasNext()) {
                PossibleVia pv = (PossibleVia)it.next();
                if (Extract.isExactCutExtraction()) {
                    while (polyList.size() > 0) {
                        PolyBase poly = (PolyBase)polyList.get(0);
                        double centerX = poly.getCenterX();
                        double centerY = poly.getCenterY();
                        boolean gotMinimum = true;
                        double desiredWidth = pv.minWidth;
                        double desiredHeight = pv.minHeight;
                        for (int i = 0; i < pv.layers.length; ++i) {
                            Layer nLayer = pv.layers[i];
                            double minLayWid = desiredWidth - pv.shrink[i];
                            double minLayHei = desiredHeight - pv.shrink[i];
                            Rectangle2D.Double rect = new Rectangle2D.Double(centerX - minLayWid / 2.0, centerY - minLayHei / 2.0, minLayWid, minLayHei);
                            if (originalMerge.contains(nLayer, rect)) continue;
                            gotMinimum = false;
                            break;
                        }
                        if (!gotMinimum) continue;
                        this.checkCutSize(poly, pv.pNp, layer);
                        this.realizeNode(pv.pNp, centerX, centerY, desiredWidth, desiredHeight, 0, null, merge, newCell);
                    }
                    continue;
                }
                this.extractInexactVias(layer, pv, polyList, merge, originalMerge, newCell);
            }
        }
    }

    private void extractInexactVias(Layer layer, PossibleVia pv, List polyList, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        boolean subtractPoly = false;
        for (int i = 0; i < pv.layers.length; ++i) {
            if (pv.layers[i] == this.activeLayer) {
                subtractPoly = true;
            }
            double shrinkage = (pv.largestShrink - pv.shrink[i]) / 2.0;
            if (i == 0) {
                originalMerge.insetLayer(pv.layers[i], this.tempLayer1, shrinkage);
                continue;
            }
            originalMerge.insetLayer(pv.layers[i], this.tempLayer2, shrinkage);
            originalMerge.intersectLayers(this.tempLayer1, this.tempLayer2, this.tempLayer1);
        }
        if (subtractPoly && !originalMerge.isEmpty(this.polyLayer)) {
            originalMerge.subtractLayers(this.tempLayer1, this.polyLayer, this.tempLayer1);
        }
        block1: for (int ind = 0; ind < polyList.size(); ++ind) {
            Rectangle2D largest;
            PolyBase poly = (PolyBase)polyList.get(ind);
            double centerX = poly.getCenterX();
            double centerY = poly.getCenterY();
            List contactArea = originalMerge.getMergedPoints(this.tempLayer1, true);
            if (contactArea == null || (largest = this.findLargestRectangle(contactArea, centerX, centerY, pv.minWidth - pv.largestShrink, pv.minHeight - pv.largestShrink)) == null) continue;
            centerX = largest.getCenterX();
            centerY = largest.getCenterY();
            double desiredWidth = largest.getWidth() + pv.largestShrink;
            double desiredHeight = largest.getHeight() + pv.largestShrink;
            do {
                boolean gotMinimum = true;
                for (int i = 0; i < pv.layers.length; ++i) {
                    Layer nLayer = pv.layers[i];
                    double minLayWid = desiredWidth - pv.shrink[i];
                    double minLayHei = desiredHeight - pv.shrink[i];
                    Rectangle2D.Double rect = new Rectangle2D.Double(centerX - minLayWid / 2.0, centerY - minLayHei / 2.0, minLayWid, minLayHei);
                    if (originalMerge.contains(nLayer, rect)) continue;
                    gotMinimum = false;
                    break;
                }
                if (gotMinimum) {
                    this.checkCutSize(poly, pv.pNp, layer);
                    this.realizeNode(pv.pNp, centerX, centerY, desiredWidth, desiredHeight, 0, null, merge, newCell);
                    merge.subtract(layer, poly);
                    originalMerge.deleteLayer(this.tempLayer2);
                    double wid = desiredWidth - pv.largestShrink;
                    double hei = desiredHeight - pv.largestShrink;
                    Rectangle2D.Double rect = new Rectangle2D.Double(centerX - wid / 2.0, centerY - hei / 2.0, wid, hei);
                    originalMerge.addPolygon(this.tempLayer2, new Poly(rect));
                    originalMerge.subtractLayers(this.tempLayer1, this.tempLayer2, this.tempLayer1);
                    for (int o = 0; o < polyList.size(); ++o) {
                        double y;
                        PolyBase oPoly;
                        double x;
                        if (o == ind || !largest.contains(x = (oPoly = (PolyBase)polyList.get(o)).getCenterX(), y = oPoly.getCenterY())) continue;
                        this.checkCutSize(oPoly, pv.pNp, layer);
                        polyList.remove(oPoly);
                        merge.subtract(layer, oPoly);
                        if (o < ind) {
                            --ind;
                        }
                        --o;
                    }
                    polyList.remove(poly);
                    --ind;
                    continue block1;
                }
                desiredWidth -= 1.0;
            } while (!((desiredHeight -= 1.0) < pv.minHeight) && !(desiredWidth < pv.minWidth));
        }
        originalMerge.deleteLayer(this.tempLayer1);
        originalMerge.deleteLayer(this.tempLayer2);
    }

    private void checkCutSize(PolyBase poly, PrimitiveNode pNp, Layer cutLayer) {
        double xSize = -1.0;
        double ySize = -1.0;
        if (pNp.getSpecialType() == 3) {
            double[] values = pNp.getSpecialValues();
            xSize = values[0];
            ySize = values[1];
        } else {
            Technology.NodeLayer[] nodeLayers = pNp.getLayers();
            for (int i = 0; i < nodeLayers.length; ++i) {
                Technology.NodeLayer nodeLayer = nodeLayers[i];
                if (nodeLayer.getLayer() != cutLayer) continue;
                EdgeH leftEdge = nodeLayer.getLeftEdge();
                EdgeH rightEdge = nodeLayer.getRightEdge();
                EdgeV topEdge = nodeLayer.getTopEdge();
                EdgeV bottomEdge = nodeLayer.getBottomEdge();
                double lX = leftEdge.getMultiplier() * pNp.getDefWidth() + leftEdge.getAdder();
                double hX = rightEdge.getMultiplier() * pNp.getDefWidth() + rightEdge.getAdder();
                double lY = bottomEdge.getMultiplier() * pNp.getDefHeight() + bottomEdge.getAdder();
                double hY = topEdge.getMultiplier() * pNp.getDefHeight() + topEdge.getAdder();
                xSize = hX - lX;
                ySize = hY - lY;
            }
        }
        boolean valid = true;
        Rectangle2D polyBox = poly.getBox();
        if (polyBox != null && (xSize != polyBox.getWidth() || ySize != polyBox.getHeight())) {
            polyBox = null;
        }
        if (polyBox == null) {
            double cX = poly.getCenterX();
            double cY = poly.getCenterY();
            System.out.println("Warning: layer " + cutLayer.getName() + " at (" + cX + "," + cY + ") is the wrong size (should be " + xSize + "x" + ySize + ")");
        }
    }

    private Rectangle2D findLargestRectangle(List contactArea, double centerX, double centerY, double minWidth, double minHeight) {
        double closestTop = Double.MAX_VALUE;
        double closestBottom = Double.MAX_VALUE;
        double closestLeft = Double.MAX_VALUE;
        double closestRight = Double.MAX_VALUE;
        TreeSet<Double> xPoints = new TreeSet<Double>();
        TreeSet<Double> yPoints = new TreeSet<Double>();
        Iterator it = contactArea.iterator();
        block0: while (it.hasNext()) {
            int leftPoint;
            PolyBase poly = (PolyBase)it.next();
            if (!poly.contains(centerX, centerY)) continue;
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                double dist;
                int last = i - 1;
                if (last < 0) {
                    last = points.length - 1;
                }
                Point2D lastPt = points[last];
                Point2D thisPt = points[i];
                if (lastPt.getX() == thisPt.getX()) {
                    double lowY = Math.min(thisPt.getY(), lastPt.getY());
                    double highY = Math.max(thisPt.getY(), lastPt.getY());
                    if (lowY >= centerY + minHeight / 2.0 || highY <= centerY - minHeight / 2.0 || Math.abs(dist = lastPt.getX() - centerX) < minWidth / 2.0) continue;
                    if (dist > 0.0) {
                        if (dist < closestRight) {
                            closestRight = dist;
                            yPoints.add(new Double(lowY));
                            yPoints.add(new Double(highY));
                        }
                    } else if (-dist < closestLeft) {
                        closestLeft = -dist;
                        yPoints.add(new Double(lowY));
                        yPoints.add(new Double(highY));
                    }
                }
                if (lastPt.getY() != thisPt.getY()) continue;
                double lowX = Math.min(thisPt.getX(), lastPt.getX());
                double highX = Math.max(thisPt.getX(), lastPt.getX());
                if (lowX >= centerX + minWidth / 2.0 || highX <= centerX - minWidth / 2.0 || Math.abs(dist = lastPt.getY() - centerY) < minHeight / 2.0) continue;
                if (dist > 0.0) {
                    if (!(dist < closestTop)) continue;
                    closestTop = dist;
                    xPoints.add(new Double(lowX));
                    xPoints.add(new Double(highX));
                    continue;
                }
                if (!(-dist < closestBottom)) continue;
                closestBottom = -dist;
                xPoints.add(new Double(lowX));
                xPoints.add(new Double(highX));
            }
            if (closestTop == Double.MAX_VALUE || closestBottom == Double.MAX_VALUE || closestLeft == Double.MAX_VALUE || closestRight == Double.MAX_VALUE) {
                return null;
            }
            Rectangle2D.Double largest = new Rectangle2D.Double(centerX - closestLeft, centerY - closestBottom, closestLeft + closestRight, closestBottom + closestTop);
            if (poly.contains(largest)) {
                return largest;
            }
            double left = centerX - closestLeft;
            double right = centerX + closestRight;
            double top = centerY + closestTop;
            double bottom = centerY - closestBottom;
            double[] xValues = new double[xPoints.size()];
            int i = 0;
            Iterator dIt = xPoints.iterator();
            while (dIt.hasNext()) {
                xValues[i++] = (Double)dIt.next();
            }
            double[] yValues = new double[yPoints.size()];
            i = 0;
            Iterator dIt2 = yPoints.iterator();
            while (dIt2.hasNext()) {
                yValues[i++] = (Double)dIt2.next();
            }
            int rightPoint = xPoints.size() - 1;
            int bottomPoint = 0;
            int topPoint = yPoints.size() - 1;
            for (leftPoint = 0; leftPoint < xPoints.size() && xValues[leftPoint] <= left; ++leftPoint) {
            }
            while (rightPoint >= 0 && xValues[rightPoint] >= right) {
                --rightPoint;
            }
            while (bottomPoint < yPoints.size() && yValues[bottomPoint] <= bottom) {
                ++bottomPoint;
            }
            while (topPoint >= 0 && yValues[topPoint] >= top) {
                --topPoint;
            }
            while (true) {
                double newTop;
                double newRight;
                double newBottom;
                double newLeft;
                if (leftPoint < xPoints.size() && (newLeft = xValues[leftPoint]) > left && newLeft < centerX - minWidth / 2.0) {
                    left = newLeft;
                    largest = new Rectangle2D.Double(left, bottom, right - left, top - bottom);
                    if (poly.contains(largest)) {
                        return largest;
                    }
                    ++leftPoint;
                    continue;
                }
                if (bottomPoint < yPoints.size() && (newBottom = yValues[bottomPoint]) > bottom && newBottom < centerY - minHeight / 2.0) {
                    bottom = newBottom;
                    largest = new Rectangle2D.Double(left, bottom, right - left, top - bottom);
                    if (poly.contains(largest)) {
                        return largest;
                    }
                    ++bottomPoint;
                    continue;
                }
                if (rightPoint >= 0 && (newRight = xValues[rightPoint]) < right && newRight > centerX + minWidth / 2.0) {
                    right = newRight;
                    largest = new Rectangle2D.Double(left, bottom, right - left, top - bottom);
                    if (poly.contains(largest)) {
                        return largest;
                    }
                    --rightPoint;
                    continue;
                }
                if (topPoint < 0 || !((newTop = yValues[topPoint]) < top) || !(newTop > centerY + minHeight / 2.0)) continue block0;
                top = newTop;
                largest = new Rectangle2D.Double(left, bottom, right - left, top - bottom);
                if (poly.contains(largest)) {
                    return largest;
                }
                --topPoint;
            }
        }
        return null;
    }

    private List findPossibleVias(Layer lay) {
        ArrayList<PossibleVia> possibleVias = new ArrayList<PossibleVia>();
        Iterator nIt = this.tech.getNodes();
        while (nIt.hasNext()) {
            int i;
            PrimitiveNode pNp = (PrimitiveNode)nIt.next();
            PrimitiveNode.Function fun = pNp.getFunction();
            if (fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.WELL && fun != PrimitiveNode.Function.SUBSTRATE) continue;
            PossibleVia pv = new PossibleVia(pNp);
            Technology.NodeLayer[] nLayers = pNp.getLayers();
            pv.layers = new Layer[nLayers.length - 1];
            pv.shrink = new double[nLayers.length - 1];
            pv.minWidth = pNp.getDefWidth();
            pv.minHeight = pNp.getDefHeight();
            int fill = 0;
            boolean cutFound = false;
            for (i = 0; i < nLayers.length; ++i) {
                Technology.NodeLayer nLay = nLayers[i];
                Layer nLayer = nLay.getLayer();
                boolean cutLayer = false;
                if (nLayer == lay) {
                    cutLayer = true;
                }
                if (!cutLayer && nLayer.getFunction() == lay.getFunction()) {
                    cutLayer = true;
                }
                if (cutLayer) {
                    cutFound = true;
                    continue;
                }
                if (nLay.getLeftEdge().getMultiplier() != -0.5 || nLay.getRightEdge().getMultiplier() != 0.5 || nLay.getBottomEdge().getMultiplier() != -0.5 || nLay.getTopEdge().getMultiplier() != 0.5) {
                    System.out.println("Cannot decipher the sizing rules for layer " + nLay.getLayer().getName() + " of " + pNp + " LEFT=" + nLay.getLeftEdge().getMultiplier() + " RIGHT=" + nLay.getRightEdge().getMultiplier() + " BOTTOM=" + nLay.getBottomEdge().getMultiplier() + " TOP=" + nLay.getTopEdge().getMultiplier());
                    break;
                }
                if (nLay.getLeftEdge().getAdder() != -nLay.getRightEdge().getAdder() || nLay.getBottomEdge().getAdder() != -nLay.getTopEdge().getAdder()) {
                    System.out.println("Cannot decipher the sizing rules for layer " + nLay.getLayer().getName() + " of " + pNp + " LEFT=" + nLay.getLeftEdge().getAdder() + " RIGHT=" + nLay.getRightEdge().getAdder() + " BOTTOM=" + nLay.getBottomEdge().getAdder() + " TOP=" + nLay.getTopEdge().getAdder());
                    break;
                }
                if (fill >= nLayers.length - 1) break;
                pv.layers[fill] = this.geometricLayer(nLay.getLayer());
                pv.shrink[fill] = Math.max(nLay.getLeftEdge().getAdder(), nLay.getBottomEdge().getAdder()) * 2.0;
                ++fill;
            }
            if (!cutFound) continue;
            if (fill != nLayers.length - 1) {
                System.out.println("Errors found, not scanning for " + pNp);
                continue;
            }
            pv.largestShrink = pv.shrink[0];
            for (i = 1; i < pv.layers.length; ++i) {
                if (!(pv.shrink[i] > pv.largestShrink)) continue;
                pv.largestShrink = pv.shrink[i];
            }
            possibleVias.add(pv);
        }
        return possibleVias;
    }

    private void extractTransistors(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        if (this.polyLayer == null || this.tempLayer1 == null) {
            return;
        }
        PrimitiveNode pTransistor = null;
        PrimitiveNode nTransistor = null;
        Iterator it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pNp = (PrimitiveNode)it.next();
            if (pTransistor == null && pNp.getFunction() == PrimitiveNode.Function.TRAPMOS) {
                pTransistor = pNp;
            }
            if (nTransistor != null || pNp.getFunction() != PrimitiveNode.Function.TRANMOS) continue;
            nTransistor = pNp;
        }
        if (nTransistor != null) {
            this.findTransistors(nTransistor, merge, originalMerge, newCell);
        }
        if (pTransistor != null) {
            this.findTransistors(pTransistor, merge, originalMerge, newCell);
        }
    }

    private void findTransistors(PrimitiveNode transistor, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        originalMerge.intersectLayers(this.polyLayer, this.activeLayer, this.tempLayer1);
        Technology.NodeLayer[] layers = transistor.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            Technology.NodeLayer lay = layers[i];
            Layer layer = this.geometricLayer(lay.getLayer());
            if (layer == this.polyLayer || layer == this.activeLayer) continue;
            originalMerge.intersectLayers(layer, this.tempLayer1, this.tempLayer1);
        }
        List polyList = originalMerge.getMergedPoints(this.tempLayer1, true);
        if (polyList == null) {
            return;
        }
        Iterator pIt = polyList.iterator();
        while (pIt.hasNext()) {
            PolyBase poly = (PolyBase)pIt.next();
            Rectangle2D transBox = poly.getBox();
            if (transBox != null) {
                Point2D.Double left = new Point2D.Double(transBox.getMinX() - 1.0, transBox.getCenterY());
                Point2D.Double right = new Point2D.Double(transBox.getMaxX() + 1.0, transBox.getCenterY());
                Point2D.Double bottom = new Point2D.Double(transBox.getCenterX(), transBox.getMinY() - 1.0);
                Point2D.Double top = new Point2D.Double(transBox.getCenterX(), transBox.getMaxY() + 1.0);
                int angle = 0;
                double wid = transBox.getWidth();
                double hei = transBox.getHeight();
                if (!(originalMerge.contains(this.polyLayer, left) && originalMerge.contains(this.polyLayer, right) && originalMerge.contains(this.activeLayer, top) && originalMerge.contains(this.activeLayer, bottom))) {
                    if (originalMerge.contains(this.activeLayer, left) && originalMerge.contains(this.activeLayer, right) && originalMerge.contains(this.polyLayer, top) && originalMerge.contains(this.polyLayer, bottom)) {
                        angle = 900;
                        wid = transBox.getHeight();
                        hei = transBox.getWidth();
                    } else {
                        System.out.println("Transistor doesn't have proper tabs...ignored");
                        continue;
                    }
                }
                SizeOffset so = transistor.getProtoSizeOffset();
                double width = wid + so.getLowXOffset() + so.getHighXOffset();
                double height = hei + so.getLowYOffset() + so.getHighYOffset();
                this.realizeNode(transistor, poly.getCenterX(), poly.getCenterY(), width, height, angle, null, merge, newCell);
                continue;
            }
            this.extractNonManhattanTransistor(poly, transistor, merge, originalMerge, newCell);
        }
        originalMerge.deleteLayer(this.tempLayer1);
    }

    private void extractNonManhattanTransistor(PolyBase poly, PrimitiveNode transistor, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        SizeOffset so = transistor.getProtoSizeOffset();
        double minWidth = transistor.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
        List lines = this.findCenterlines(poly, this.tempLayer1, minWidth, merge, originalMerge);
        if (lines.size() == 0) {
            return;
        }
        if (lines.size() == 1) {
            Centerline cl = (Centerline)lines.get(0);
            double polySize = cl.start.distance(cl.end);
            double activeSize = cl.width;
            double cX = (cl.start.getX() + cl.end.getX()) / 2.0;
            double cY = (cl.start.getY() + cl.end.getY()) / 2.0;
            double sX = polySize + so.getLowXOffset() + so.getHighXOffset();
            double sY = activeSize + so.getLowYOffset() + so.getHighYOffset();
            this.realizeNode(transistor, cX, cY, sX, sY, cl.angle, null, merge, newCell);
            return;
        }
        Point2D[] points = new Point2D[lines.size() + 1];
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            Centerline cl = (Centerline)it.next();
            cl.handled = false;
        }
        Centerline firstCL = (Centerline)lines.get(0);
        firstCL.handled = true;
        points[0] = firstCL.start;
        points[1] = firstCL.end;
        int pointsSeen = 2;
        while (pointsSeen < points.length) {
            boolean added = false;
            Iterator it2 = lines.iterator();
            while (it2.hasNext()) {
                int i;
                Centerline cl = (Centerline)it2.next();
                if (cl.handled) continue;
                if (cl.start.equals(points[0])) {
                    for (i = pointsSeen; i > 0; --i) {
                        points[i] = points[i - 1];
                    }
                    points[0] = cl.end;
                    ++pointsSeen;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (cl.end.equals(points[0])) {
                    for (i = pointsSeen; i > 0; --i) {
                        points[i] = points[i - 1];
                    }
                    points[0] = cl.start;
                    ++pointsSeen;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (cl.start.equals(points[pointsSeen - 1])) {
                    points[pointsSeen++] = cl.end;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (!cl.end.equals(points[pointsSeen - 1])) continue;
                points[pointsSeen++] = cl.start;
                cl.handled = true;
                added = true;
                break;
            }
            if (added) continue;
            break;
        }
        if (pointsSeen != points.length) {
            return;
        }
        double lX = points[0].getX();
        double hX = points[0].getX();
        double lY = points[0].getY();
        double hY = points[0].getY();
        for (int i = 1; i < points.length; ++i) {
            if (points[i].getX() < lX) {
                lX = points[i].getX();
            }
            if (points[i].getX() > hX) {
                hX = points[i].getX();
            }
            if (points[i].getY() < lY) {
                lY = points[i].getY();
            }
            if (!(points[i].getY() > hY)) continue;
            hY = points[i].getY();
        }
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        for (int i = 0; i < points.length; ++i) {
            points[i].setLocation(points[i].getX() - cX, points[i].getY() - cY);
        }
        this.realizeNode(transistor, cX, cY, hX - lX, hY - lY, 0, points, merge, newCell);
    }

    private void extendGeometry(PolyMerge merge, PolyMerge originalMerge, Cell newCell, boolean justExtend) {
        Iterator lIt = merge.getKeyIterator();
        while (lIt.hasNext()) {
            Layer layer = (Layer)lIt.next();
            ArcProto ap = (ArcProto)this.arcsForLayer.get(layer);
            if (ap == null) continue;
            List polyList = merge.getMergedPoints(layer, true);
            Iterator pIt = polyList.iterator();
            while (pIt.hasNext()) {
                ArcInst ai2;
                ArcInst ai1;
                PortInst pi;
                NodeInst ni;
                PrimitiveNode np;
                ArcInst ai;
                Point2D.Double pt2;
                Point2D.Double pt1;
                PortInst pi2;
                PolyBase poly = (PolyBase)pIt.next();
                HashMap netsThatTouch = this.getNetsThatTouch(poly, layer, newCell);
                ArrayList objectsToConnect = new ArrayList();
                Iterator it = netsThatTouch.keySet().iterator();
                while (it.hasNext()) {
                    Object entry = netsThatTouch.get(it.next());
                    if (entry == null) continue;
                    objectsToConnect.add(entry);
                }
                if (objectsToConnect.size() == 1) {
                    this.extendObject((ElectricObject)objectsToConnect.get(0), poly, layer, ap, merge, originalMerge, newCell);
                    continue;
                }
                if (justExtend || objectsToConnect.size() != 2) continue;
                ElectricObject obj1 = (ElectricObject)objectsToConnect.get(0);
                ElectricObject obj2 = (ElectricObject)objectsToConnect.get(1);
                if (obj1 instanceof ArcInst) {
                    pi2 = this.findArcEnd((ArcInst)obj1, poly);
                    if (pi2 == null) {
                        this.findArcEnd((ArcInst)obj1, poly);
                        continue;
                    }
                    obj1 = pi2;
                }
                if (obj2 instanceof ArcInst) {
                    pi2 = this.findArcEnd((ArcInst)obj2, poly);
                    if (pi2 == null) {
                        this.findArcEnd((ArcInst)obj2, poly);
                        continue;
                    }
                    obj2 = pi2;
                }
                PortInst pi1 = (PortInst)obj1;
                PortInst pi22 = (PortInst)obj2;
                Poly poly1 = pi1.getPoly();
                Poly poly2 = pi22.getPoly();
                Rectangle2D polyBounds1 = poly1.getBounds2D();
                Rectangle2D polyBounds2 = poly2.getBounds2D();
                if (polyBounds1.getMinX() <= polyBounds2.getMaxX() && polyBounds1.getMaxX() >= polyBounds2.getMinX()) {
                    double xpos = polyBounds1.getCenterX();
                    if (xpos < polyBounds2.getMinX()) {
                        xpos = polyBounds2.getMinX();
                    }
                    if (xpos > polyBounds2.getMaxX()) {
                        xpos = polyBounds2.getMaxX();
                    }
                    pt1 = new Point2D.Double(xpos, polyBounds1.getCenterY());
                    pt2 = new Point2D.Double(xpos, polyBounds2.getCenterY());
                    ai = this.realizeArc(ap, pi1, pi22, pt1, pt2, ap.getDefaultWidth(), false, merge);
                    continue;
                }
                if (polyBounds1.getMinY() <= polyBounds2.getMaxY() && polyBounds1.getMaxY() >= polyBounds2.getMinY()) {
                    double ypos = polyBounds1.getCenterY();
                    if (ypos < polyBounds2.getMinY()) {
                        ypos = polyBounds2.getMinY();
                    }
                    if (ypos > polyBounds2.getMaxY()) {
                        ypos = polyBounds2.getMaxY();
                    }
                    pt1 = new Point2D.Double(polyBounds1.getCenterX(), ypos);
                    pt2 = new Point2D.Double(polyBounds2.getCenterX(), ypos);
                    ai = this.realizeArc(ap, pi1, pi22, pt1, pt2, ap.getDefaultWidth(), false, merge);
                    continue;
                }
                Point2D.Double pt12 = new Point2D.Double(polyBounds1.getCenterX(), polyBounds1.getCenterY());
                Point2D.Double pt22 = new Point2D.Double(polyBounds2.getCenterX(), polyBounds2.getCenterY());
                Point2D.Double corner1 = new Point2D.Double(polyBounds1.getCenterX(), polyBounds2.getCenterY());
                Point2D.Double corner2 = new Point2D.Double(polyBounds2.getCenterX(), polyBounds1.getCenterY());
                if (poly.contains(corner1)) {
                    np = ap.findPinProto();
                    ni = NodeInst.makeInstance(np, corner1, np.getDefWidth(), np.getDefHeight(), newCell);
                    pi = ni.getOnlyPortInst();
                    ai1 = this.realizeArc(ap, pi1, pi, pt12, corner1, ap.getDefaultWidth(), false, merge);
                    ai2 = this.realizeArc(ap, pi22, pi, pt22, corner1, ap.getDefaultWidth(), false, merge);
                }
                if (!poly.contains(corner2)) continue;
                np = ap.findPinProto();
                ni = NodeInst.makeInstance(np, corner2, np.getDefWidth(), np.getDefHeight(), newCell);
                pi = ni.getOnlyPortInst();
                ai1 = this.realizeArc(ap, pi1, pi, pt12, corner2, ap.getDefaultWidth(), false, merge);
                ai2 = this.realizeArc(ap, pi22, pi, pt22, corner2, ap.getDefaultWidth(), false, merge);
            }
        }
    }

    private void extendObject(ElectricObject obj, PolyBase poly, Layer layer, ArcProto ap, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        Rectangle2D totalBounds;
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null && originalMerge.contains(layer, totalBounds = poly.getBounds2D())) {
            polyBounds = totalBounds;
        }
        if (polyBounds == null) {
            return;
        }
        Point2D.Double polyCtr = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getCenterY());
        PrimitiveNode np = ap.findPinProto();
        if (obj instanceof ArcInst) {
            double tailDist;
            ArcInst ai = (ArcInst)obj;
            double headDist = polyCtr.distance(ai.getHeadLocation());
            obj = headDist < (tailDist = polyCtr.distance(ai.getTailLocation())) ? ai.getHeadPortInst() : ai.getTailPortInst();
        }
        PortInst pi = (PortInst)obj;
        Poly portPoly = pi.getPoly();
        Rectangle2D portRect = portPoly.getBounds2D();
        double width = polyBounds.getWidth();
        double height = polyBounds.getHeight();
        double actualWidth = ap.getDefaultWidth() - ap.getWidthOffset();
        if (((Point2D)polyCtr).getX() >= portRect.getMinX() && ((Point2D)polyCtr).getX() <= portRect.getMaxX()) {
            Point2D.Double objPt = new Point2D.Double(((Point2D)polyCtr).getX(), portRect.getCenterY());
            Point2D.Double pinPt = null;
            boolean noEndExtend = false;
            double endExtension = polyBounds.getWidth() / 2.0;
            if (polyBounds.getHeight() < polyBounds.getWidth()) {
                noEndExtend = true;
                endExtension = 0.0;
            }
            pinPt = ((Point2D)polyCtr).getY() > portRect.getCenterY() ? new Point2D.Double(((Point2D)polyCtr).getX(), polyBounds.getMaxY() - endExtension) : new Point2D.Double(((Point2D)polyCtr).getX(), polyBounds.getMinY() + endExtension);
            NodeInst ni1 = NodeInst.makeInstance(np, pinPt, polyBounds.getWidth(), polyBounds.getWidth(), newCell);
            ArcInst ai = this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPt, objPt, polyBounds.getWidth() + ap.getWidthOffset(), noEndExtend, merge);
            return;
        }
        if (((Point2D)polyCtr).getY() >= portRect.getMinY() && ((Point2D)polyCtr).getY() <= portRect.getMaxY()) {
            Point2D.Double objPt = new Point2D.Double(portRect.getCenterX(), ((Point2D)polyCtr).getY());
            Point2D.Double pinPt = null;
            boolean noEndExtend = false;
            double endExtension = polyBounds.getHeight() / 2.0;
            if (polyBounds.getWidth() < polyBounds.getHeight()) {
                noEndExtend = true;
                endExtension = 0.0;
            }
            pinPt = ((Point2D)polyCtr).getX() > portRect.getCenterX() ? new Point2D.Double(polyBounds.getMaxX() - endExtension, ((Point2D)polyCtr).getY()) : new Point2D.Double(polyBounds.getMinX() + endExtension, ((Point2D)polyCtr).getY());
            NodeInst ni1 = NodeInst.makeInstance(np, pinPt, polyBounds.getHeight(), polyBounds.getHeight(), newCell);
            ArcInst ai = this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPt, objPt, polyBounds.getHeight() + ap.getWidthOffset(), noEndExtend, merge);
        }
    }

    private PortInst findArcEnd(ArcInst ai, PolyBase poly) {
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        int ang = GenMath.figureAngle(tail, head);
        int angPlus = (ang + 900) % 3600;
        int angMinus = (ang + 2700) % 3600;
        double width = (ai.getWidth() - ai.getProto().getWidthOffset()) / 2.0;
        Point2D.Double headButFarther = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(ang), ((Point2D)head).getY() + width * GenMath.sin(ang));
        if (poly.contains(headButFarther)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double headOneSide = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(angPlus), ((Point2D)head).getY() + width * GenMath.sin(angPlus));
        if (poly.contains(headOneSide)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double headOtherSide = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(angPlus), ((Point2D)head).getY() + width * GenMath.sin(angPlus));
        if (poly.contains(headOtherSide)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double tailButFarther = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(ang), ((Point2D)tail).getY() - width * GenMath.sin(ang));
        if (poly.contains(tailButFarther)) {
            return ai.getTailPortInst();
        }
        Point2D.Double tailOneSide = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(angPlus), ((Point2D)tail).getY() - width * GenMath.sin(angPlus));
        if (poly.contains(tailOneSide)) {
            return ai.getTailPortInst();
        }
        Point2D.Double tailOtherSide = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(angPlus), ((Point2D)tail).getY() - width * GenMath.sin(angPlus));
        if (poly.contains(tailOtherSide)) {
            return ai.getTailPortInst();
        }
        return null;
    }

    private boolean polysTouch(PolyBase poly1, PolyBase poly2) {
        int i;
        Point2D[] points2;
        Point2D[] points1 = poly1.getPoints();
        if (points1.length > (points2 = poly2.getPoints()).length) {
            Point2D[] swapPts = points1;
            points1 = points2;
            points2 = swapPts;
            PolyBase swapPoly = poly1;
            poly1 = poly2;
            poly2 = swapPoly;
        }
        for (i = 0; i < points1.length; ++i) {
            if (!poly2.contains(points1[i])) continue;
            return true;
        }
        for (i = 0; i < points1.length; ++i) {
            Point2D.Double midPoint;
            int last = i - 1;
            if (last < 0) {
                last = points1.length - 1;
            }
            if (!poly2.contains(midPoint = new Point2D.Double((points1[last].getX() + points1[i].getX()) / 2.0, (points1[last].getY() + points1[i].getY()) / 2.0))) continue;
            return true;
        }
        return false;
    }

    private HashMap getNetsThatTouch(PolyBase poly, Layer layer, Cell newCell) {
        Geometric geom;
        HashMap<Network, ElectricObject> netsThatTouch = new HashMap<Network, ElectricObject>();
        Rectangle2D bounds = poly.getBounds2D();
        Point2D.Double centerPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Netlist nl = newCell.acquireUserNetlist();
        Iterator it = newCell.searchIterator(bounds);
        block0: while (it.hasNext()) {
            NodeInst ni;
            geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() instanceof Cell) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] nodePolys = tech.getShapeOfNode(ni, null, null, true, true, null);
            for (int i = 0; i < nodePolys.length; ++i) {
                PortInst pi;
                Network net;
                PrimitivePort pp;
                Poly nodePoly = nodePolys[i];
                if (this.geometricLayer(nodePoly.getLayer()) != layer) continue;
                nodePoly.transform(trans);
                if (!this.polysTouch(nodePoly, poly) || (pp = (PrimitivePort)nodePoly.getPort()) == null || (net = nl.getNetwork(pi = this.findPortInstClosestToPoly(ni, pp, centerPoint))) == null) continue;
                netsThatTouch.put(net, pi);
                continue block0;
            }
        }
        it = newCell.searchIterator(bounds);
        block2: while (it.hasNext()) {
            geom = (Geometric)it.next();
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Network net;
                Poly arcPoly = polys[i];
                if (this.geometricLayer(arcPoly.getLayer()) != layer || !this.polysTouch(arcPoly, poly) || (net = nl.getNetwork(ai, 0)) == null) continue;
                if (netsThatTouch.get(net) != null) continue block2;
                netsThatTouch.put(net, ai);
                continue block2;
            }
        }
        return netsThatTouch;
    }

    private List findCenterlines(PolyBase poly, Layer layer, double minWidth, PolyMerge merge, PolyMerge originalMerge) {
        Centerline oCl;
        Centerline cl;
        int i;
        boolean foundNew;
        ArrayList<Centerline> validCenterlines = new ArrayList<Centerline>();
        merge.deleteLayer(this.tempLayer1);
        merge.addPolygon(this.tempLayer1, poly);
        List<PolyBase> polysToAnalyze = new ArrayList<PolyBase>();
        polysToAnalyze.add(poly);
        do {
            foundNew = false;
            Iterator pIt = polysToAnalyze.iterator();
            block1: while (pIt.hasNext()) {
                PolyBase aPoly = (PolyBase)pIt.next();
                List centerlines = this.gatherCenterlines(aPoly);
                double lastWidth = -1.0;
                Iterator it = centerlines.iterator();
                while (it.hasNext()) {
                    Poly clPoly;
                    Centerline cl2 = (Centerline)it.next();
                    if (cl2.width < minWidth) continue;
                    if (lastWidth < 0.0) {
                        lastWidth = cl2.width;
                    }
                    if (cl2.width != lastWidth) continue block1;
                    double length = cl2.start.distance(cl2.end);
                    if (length < DBMath.getEpsilon() || !merge.intersects(this.tempLayer1, clPoly = Poly.makeEndPointPoly(length, cl2.width, cl2.angle, cl2.start, 0.0, cl2.end, 0.0)) || !originalMerge.contains(layer, clPoly)) continue;
                    validCenterlines.add(cl2);
                    merge.subtract(this.tempLayer1, clPoly);
                    foundNew = true;
                }
            }
        } while (foundNew && (polysToAnalyze = merge.getMergedPoints(this.tempLayer1, true)) != null);
        merge.deleteLayer(this.tempLayer1);
        int numCenterlines = validCenterlines.size();
        Centerline[] lines = new Centerline[numCenterlines];
        for (i = 0; i < numCenterlines; ++i) {
            lines[i] = (Centerline)validCenterlines.get(i);
        }
        for (i = 0; i < numCenterlines; ++i) {
            cl = lines[i];
            for (int j = i + 1; j < numCenterlines; ++j) {
                oCl = lines[j];
                if (!this.isColinear(cl, oCl)) continue;
                for (int k = j; k < numCenterlines - 1; ++k) {
                    lines[k] = lines[k + 1];
                }
                --numCenterlines;
                --j;
            }
        }
        for (i = 0; i < numCenterlines; ++i) {
            cl = lines[i];
            for (int j = i + 1; j < numCenterlines; ++j) {
                Point2D intersect;
                oCl = lines[j];
                double maxDist = (cl.width + oCl.width) / 2.0;
                if (!(cl.start.distance(oCl.start) <= maxDist) && !(cl.start.distance(oCl.end) <= maxDist) && !(cl.end.distance(oCl.start) <= maxDist) && !(cl.end.distance(oCl.end) <= maxDist) || (intersect = GenMath.intersect(cl.start, cl.angle, oCl.start, oCl.angle)) == null) continue;
                Point2D newStart = cl.start;
                Point2D newEnd = cl.end;
                double extendStart = 0.0;
                double extendEnd = 0.0;
                if (intersect.distance(newStart) < intersect.distance(newEnd)) {
                    newStart = intersect;
                    extendStart = cl.width / 2.0;
                } else {
                    newEnd = intersect;
                    extendEnd = cl.width / 2.0;
                }
                Poly extended = Poly.makeEndPointPoly(newStart.distance(newEnd), cl.width, cl.angle, newStart, extendStart, newEnd, extendEnd);
                if (originalMerge.contains(layer, extended)) {
                    cl.start = newStart;
                    cl.end = newEnd;
                    if (extendStart != 0.0) {
                        cl.startHub = true;
                    }
                    if (extendEnd != 0.0) {
                        cl.endHub = true;
                    }
                }
                newStart = oCl.start;
                newEnd = oCl.end;
                extendStart = 0.0;
                extendEnd = 0.0;
                if (intersect.distance(newStart) < intersect.distance(newEnd)) {
                    newStart = intersect;
                    extendStart = oCl.width / 2.0;
                } else {
                    newEnd = intersect;
                    extendEnd = oCl.width / 2.0;
                }
                extended = Poly.makeEndPointPoly(newStart.distance(newEnd), oCl.width, oCl.angle, newStart, extendStart, newEnd, extendEnd);
                if (!originalMerge.contains(layer, extended)) continue;
                oCl.start = newStart;
                oCl.end = newEnd;
                if (extendStart != 0.0) {
                    oCl.startHub = true;
                }
                if (extendEnd == 0.0) continue;
                oCl.endHub = true;
            }
        }
        ArrayList<Centerline> finalCenterlines = new ArrayList<Centerline>();
        for (int i2 = 0; i2 < numCenterlines; ++i2) {
            finalCenterlines.add(lines[i2]);
        }
        return finalCenterlines;
    }

    private List gatherCenterlines(PolyBase poly) {
        ArrayList<Centerline> centerlines = new ArrayList<Centerline>();
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            Point2D thisPt;
            Point2D lastPt;
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            if ((lastPt = points[lastI]).equals(thisPt = points[i])) continue;
            int angle = GenMath.figureAngle(thisPt, lastPt) % 1800;
            for (int j = i + 2; j < points.length; ++j) {
                Point2D swapPt;
                double swap;
                int oAngle;
                Point2D oLastPt = points[j - 1];
                Point2D oThisPt = points[j];
                if (oLastPt.equals(oThisPt) || (oAngle = GenMath.figureAngle(oThisPt, oLastPt) % 1800) != angle) continue;
                int perpAngle = angle + 900;
                Point2D oneSide = thisPt;
                Point2D otherSide = GenMath.intersect(thisPt, perpAngle, oThisPt, oAngle);
                Point2D.Double centerPt = new Point2D.Double((oneSide.getX() + otherSide.getX()) / 2.0, (oneSide.getY() + otherSide.getY()) / 2.0);
                double width = oneSide.distance(otherSide);
                Point2D lastPtCL = GenMath.intersect(lastPt, perpAngle, centerPt, angle);
                Point2D thisPtCL = GenMath.intersect(thisPt, perpAngle, centerPt, angle);
                Point2D oLastPtCL = GenMath.intersect(oLastPt, perpAngle, centerPt, angle);
                Point2D oThisPtCL = GenMath.intersect(oThisPt, perpAngle, centerPt, angle);
                double minX = Math.min(Math.min(lastPtCL.getX(), thisPtCL.getX()), Math.min(oLastPtCL.getX(), oThisPtCL.getX()));
                double maxX = Math.max(Math.max(lastPtCL.getX(), thisPtCL.getX()), Math.max(oLastPtCL.getX(), oThisPtCL.getX()));
                double minY = Math.min(Math.min(lastPtCL.getY(), thisPtCL.getY()), Math.min(oLastPtCL.getY(), oThisPtCL.getY()));
                double maxY = Math.max(Math.max(lastPtCL.getY(), thisPtCL.getY()), Math.max(oLastPtCL.getY(), oThisPtCL.getY()));
                Point2D[] corners = new Point2D[]{new Point2D.Double(minX, minY), new Point2D.Double(minX, maxY), new Point2D.Double(maxX, maxY), new Point2D.Double(maxX, minY)};
                boolean lastCorner = false;
                boolean thisCorner = false;
                boolean oLastCorner = false;
                boolean oThisCorner = false;
                Point2D aCorner = null;
                for (int k = 0; k < 4; ++k) {
                    if (lastPtCL.equals(corners[k])) {
                        aCorner = lastPtCL;
                        lastCorner = true;
                    }
                    if (thisPtCL.equals(corners[k])) {
                        aCorner = thisPtCL;
                        thisCorner = true;
                    }
                    if (oLastPtCL.equals(corners[k])) {
                        aCorner = oLastPtCL;
                        oLastCorner = true;
                    }
                    if (!oThisPtCL.equals(corners[k])) continue;
                    aCorner = oThisPtCL;
                    oThisCorner = true;
                }
                if (!lastCorner && !thisCorner) {
                    Centerline newCL = new Centerline(width, lastPtCL, thisPtCL);
                    if (newCL.angle < 0) continue;
                    centerlines.add(newCL);
                    continue;
                }
                if (!oLastCorner && !oThisCorner) {
                    Centerline newCL = new Centerline(width, oLastPtCL, oThisPtCL);
                    if (newCL.angle < 0) continue;
                    centerlines.add(newCL);
                    continue;
                }
                double lastDist = aCorner.distance(lastPtCL);
                double thisDist = aCorner.distance(thisPtCL);
                double oLastDist = aCorner.distance(oLastPtCL);
                double oThisDist = aCorner.distance(oThisPtCL);
                if (lastDist > thisDist) {
                    swap = lastDist;
                    lastDist = thisDist;
                    thisDist = swap;
                    swapPt = lastPtCL;
                    lastPtCL = thisPtCL;
                    thisPtCL = swapPt;
                }
                if (oLastDist > oThisDist) {
                    swap = oLastDist;
                    oLastDist = oThisDist;
                    oThisDist = swap;
                    swapPt = oLastPtCL;
                    oLastPtCL = oThisPtCL;
                    oThisPtCL = swapPt;
                }
                if (thisDist <= oLastDist || oThisDist <= lastDist) continue;
                Point2D start = lastPtCL;
                if (oLastDist > lastDist) {
                    start = oLastPtCL;
                }
                Point2D end = thisPtCL;
                if (oThisDist < thisDist) {
                    end = oThisPtCL;
                }
                Centerline newCL = new Centerline(width, start, end);
                if (newCL.angle < 0) continue;
                centerlines.add(newCL);
            }
        }
        Collections.sort(centerlines, new ParallelWiresByWidth());
        return centerlines;
    }

    private boolean isColinear(Centerline cl, Centerline oCl) {
        int oAng;
        double fx = cl.start.getX();
        double fy = cl.start.getY();
        double tx = cl.end.getX();
        double ty = cl.end.getY();
        double oFx = oCl.start.getX();
        double oFy = oCl.start.getY();
        double oTx = oCl.end.getX();
        double oTy = oCl.end.getY();
        if (oFx == oTx && oFy == oTy) {
            return false;
        }
        double lowX = Math.min(fx, tx);
        double highX = Math.max(fx, tx);
        double lowY = Math.min(fy, ty);
        double highY = Math.max(fy, ty);
        if (fx == tx) {
            double oLow = Math.min(oFy, oTy);
            double oHigh = Math.max(oFy, oTy);
            if (oFx != fx || oTx != fx) {
                return false;
            }
            if (lowY > oHigh || highY < oLow) {
                return false;
            }
            cl.start.setLocation(tx, Math.min(lowY, oLow));
            cl.end.setLocation(tx, Math.max(highY, oHigh));
            return true;
        }
        if (fy == ty) {
            double oLow = Math.min(oFx, oTx);
            double oHigh = Math.max(oFx, oTx);
            if (oFy != fy || oTy != fy) {
                return false;
            }
            if (lowX > oHigh || highX < oLow) {
                return false;
            }
            cl.start.setLocation(Math.min(lowX, oLow), ty);
            cl.end.setLocation(Math.max(highX, oHigh), ty);
            return true;
        }
        int ang = GenMath.figureAngle(new Point2D.Double(fx, fy), new Point2D.Double(tx, ty));
        if (ang != (oAng = GenMath.figureAngle(new Point2D.Double(oFx, oFy), new Point2D.Double(oTx, oTy))) && Math.min(ang, oAng) + 1800 != Math.max(ang, oAng)) {
            return false;
        }
        if ((oFx - fx) * (ty - fy) / (tx - fx) != oFy - fy) {
            return false;
        }
        if ((oTx - fx) * (ty - fy) / (tx - fx) != oTy - fy) {
            return false;
        }
        double oLow = Math.min(oFy, oTy);
        double oHigh = Math.max(oFy, oTy);
        if (lowY >= oHigh || highY <= oLow) {
            return false;
        }
        oLow = Math.min(oFx, oTx);
        oHigh = Math.max(oFx, oTx);
        if (lowX >= oHigh || highX <= oLow) {
            return false;
        }
        Point2D[] points = new Point2D[]{cl.start, cl.end, oCl.start, oCl.end};
        double bestDist = 0.0;
        int bestEnd = -1;
        for (int i = 1; i < 3; ++i) {
            double dist = points[0].distance(points[i]);
            if (!(dist > bestDist)) continue;
            bestDist = dist;
            bestEnd = i;
        }
        if (bestEnd < 0) {
            return false;
        }
        bestDist = 0.0;
        int bestOtherEnd = -1;
        for (int i = 0; i < 4; ++i) {
            double dist;
            if (i == bestEnd || !((dist = points[bestEnd].distance(points[i])) > bestDist)) continue;
            bestDist = dist;
            bestOtherEnd = i;
        }
        double newEndAX = points[bestEnd].getX();
        double newEndAY = points[bestEnd].getY();
        double newEndBX = points[bestOtherEnd].getX();
        double newEndBY = points[bestOtherEnd].getY();
        cl.start.setLocation(newEndAX, newEndAY);
        cl.end.setLocation(newEndBX, newEndBY);
        return true;
    }

    private void convertAllGeometry(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        Iterator lIt = merge.getKeyIterator();
        while (lIt.hasNext()) {
            Layer layer = (Layer)lIt.next();
            ArcProto ap = (ArcProto)this.arcsForLayer.get(layer);
            List polyList = merge.getMergedPoints(layer, true);
            Iterator pIt = polyList.iterator();
            while (pIt.hasNext()) {
                PolyBase poly = (PolyBase)pIt.next();
                if (poly.getArea() < DBMath.getEpsilon()) continue;
                if (ap != null) {
                    Rectangle2D totalBounds;
                    Rectangle2D polyBounds = poly.getBox();
                    if (polyBounds == null && originalMerge.contains(layer, totalBounds = poly.getBounds2D())) {
                        polyBounds = totalBounds;
                    }
                    if (polyBounds != null) {
                        double width = polyBounds.getWidth();
                        double height = polyBounds.getHeight();
                        double actualWidth = ap.getDefaultWidth() - ap.getWidthOffset();
                        if (width >= actualWidth && height >= actualWidth) {
                            ArcInst ai;
                            NodeInst ni2;
                            NodeInst ni1;
                            Point2D.Double end1;
                            PrimitiveNode np = ap.findPinProto();
                            if (width > height) {
                                end1 = new Point2D.Double(polyBounds.getMinX() + height / 2.0, polyBounds.getCenterY());
                                Point2D.Double end2 = new Point2D.Double(polyBounds.getMaxX() - height / 2.0, polyBounds.getCenterY());
                                ni1 = NodeInst.makeInstance(np, end1, height, height, newCell);
                                ni2 = NodeInst.makeInstance(np, end2, height, height, newCell);
                                ai = this.realizeArc(ap, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), end1, end2, height + ap.getWidthOffset(), false, merge);
                                continue;
                            }
                            end1 = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getMinY() + width / 2.0);
                            Point2D.Double end2 = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getMaxY() - width / 2.0);
                            ni1 = NodeInst.makeInstance(np, end1, width, width, newCell);
                            ni2 = NodeInst.makeInstance(np, end2, width, width, newCell);
                            ai = this.realizeArc(ap, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), end1, end2, width + ap.getWidthOffset(), false, merge);
                            continue;
                        }
                    }
                }
                double centerX = poly.getCenterX();
                double centerY = poly.getCenterY();
                Point2D.Double center = new Point2D.Double(centerX, centerY);
                PrimitiveNode pNp = poly.getLayer().getPureLayerNode();
                if (pNp == null) {
                    System.out.println("CANNOT FIND PURE LAYER NODE FOR LAYER " + poly.getLayer().getName());
                    continue;
                }
                NodeInst ni = NodeInst.makeInstance(pNp, center, poly.getBounds2D().getWidth(), poly.getBounds2D().getHeight(), newCell);
                if (poly.getBox() != null) continue;
                Point2D[] points = poly.getPoints();
                Point2D[] newPoints = new Point2D[points.length];
                for (int i = 0; i < points.length; ++i) {
                    newPoints[i] = new Point2D.Double(points[i].getX() - centerX, points[i].getY() - centerY);
                }
                ni.newVar(NodeInst.TRACE, (Object)newPoints);
            }
        }
    }

    private void realizeNode(PrimitiveNode pNp, double centerX, double centerY, double width, double height, int angle, Point2D[] points, PolyMerge merge, Cell newCell) {
        NodeInst ni = NodeInst.makeInstance(pNp, new Point2D.Double(centerX, centerY), width, height, newCell, angle, null, 0);
        if (ni == null) {
            return;
        }
        if (points != null) {
            ni.newVar(NodeInst.TRACE, (Object)points);
        }
        AffineTransform trans = ni.rotateOut();
        Poly[] polys = this.tech.getShapeOfNode(ni);
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            Layer layer = poly.getLayer();
            layer = this.geometricLayer(layer);
            poly.transform(trans);
            merge.subtract(layer, poly);
        }
    }

    private ArcInst realizeArc(ArcProto ap, PortInst pi1, PortInst pi2, Point2D pt1, Point2D pt2, double width, boolean noEndExtend, PolyMerge merge) {
        ArcInst ai = ArcInst.makeInstance(ap, width, pi1, pi2, pt1, pt2, null);
        if (ai == null) {
            return null;
        }
        if (noEndExtend) {
            ai.setHeadExtended(false);
            ai.setTailExtended(false);
        }
        Poly[] polys = this.tech.getShapeOfArc(ai);
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            Layer layer = poly.getLayer();
            layer = this.geometricLayer(layer);
            merge.subtract(layer, poly);
        }
        return ai;
    }

    private NodeInst wantNodeAt(Point2D pt, NodeProto pin, double size, Cell newCell) {
        Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator it = newCell.searchIterator(bounds);
        while (it.hasNext()) {
            NodeInst ni;
            Geometric geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != pin || !ni.getAnchorCenter().equals(pt)) continue;
            return ni;
        }
        NodeInst ni = NodeInst.makeInstance(pin, pt, size, size, newCell);
        return ni;
    }

    private Layer geometricLayer(Layer layer) {
        Layer properLayer;
        Layer polyLayer;
        Layer.Function fun = layer.getFunction();
        if (fun == Layer.Function.GATE && (polyLayer = (Layer)this.layerForFunction.get(Layer.Function.POLY1)) != null) {
            return polyLayer;
        }
        if (fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN) {
            fun = Layer.Function.DIFF;
        }
        if ((properLayer = (Layer)this.layerForFunction.get(fun)) != null) {
            return properLayer;
        }
        return layer;
    }

    public static String describeLayer(PolyMerge merge, Layer layer) {
        List polyList = merge.getMergedPoints(layer, true);
        if (polyList == null) {
            return "DOES NOT EXIST";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iit = polyList.iterator();
        while (iit.hasNext()) {
            PolyBase p = (PolyBase)iit.next();
            Point2D[] points = p.getPoints();
            sb.append(" [");
            for (int j = 0; j < points.length; ++j) {
                Point2D pt = points[j];
                if (j > 0) {
                    sb.append(" ");
                }
                sb.append("(" + TextUtils.formatDouble(pt.getX()) + "," + TextUtils.formatDouble(pt.getY()) + ")");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static class ParallelWiresByWidth
    implements Comparator {
        private ParallelWiresByWidth() {
        }

        public int compare(Object o1, Object o2) {
            double cll2;
            Centerline cl1 = (Centerline)o1;
            Centerline cl2 = (Centerline)o2;
            if (cl1.width < cl2.width) {
                return -1;
            }
            if (cl1.width > cl2.width) {
                return 1;
            }
            double cll1 = cl1.start.distance(cl1.end);
            if (cll1 > (cll2 = cl2.start.distance(cl2.end))) {
                return -1;
            }
            if (cll1 < cll2) {
                return 1;
            }
            return 0;
        }
    }

    private static class PossibleVia {
        PrimitiveNode pNp;
        double minWidth;
        double minHeight;
        double largestShrink;
        Layer[] layers;
        double[] shrink;

        PossibleVia(PrimitiveNode pNp) {
            this.pNp = pNp;
        }
    }

    private static class Centerline {
        Point2D start;
        Point2D end;
        boolean startHub;
        boolean endHub;
        double width;
        boolean handled;
        int angle;

        Centerline(double width, Point2D start, Point2D end) {
            this.width = width;
            this.start = start;
            this.end = end;
            this.endHub = false;
            this.startHub = false;
            this.angle = start.equals(end) ? -1 : GenMath.figureAngle(start, end);
        }
    }

    private static class TouchingNode {
        NodeInst ni;
        PortInst pi;
        double width;
        Point2D endPt;

        private TouchingNode() {
        }
    }

    private static class ExtractJob
    extends Job {
        private Cell cell;
        private boolean recursive;

        private ExtractJob(Cell cell, boolean recursive) {
            super("Extract Connectivity from " + cell, Extract.getExtractTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.recursive = recursive;
            this.startJob();
        }

        public boolean doIt() {
            Connectivity c = new Connectivity(this.cell.getTechnology());
            c.doExtract(this.cell, this.recursive, true);
            return false;
        }
    }
}

