/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;

public class Routing
extends Listener {
    private Activity current;
    private Activity past = null;
    private boolean checkAutoStitch = false;
    public static Routing tool = new Routing();
    private static Cell copiedTopologyCell;
    private static Pref cacheAutoStitchOn;
    private static Pref cacheMimicStitchOn;
    private static Pref cacheMimicStitchCanUnstitch;
    private static Pref cacheMimicStitchInteractive;
    private static Pref cacheMimicStitchMatchPorts;
    private static Pref cacheMimicStitchMatchNumArcs;
    private static Pref cacheMimicStitchMatchNodeSize;
    private static Pref cacheMimicStitchMatchNodeType;
    private static Pref cacheMimicStitchNoOtherArcsSameDir;
    private static Pref cachePreferredRoutingArc;

    private Routing() {
        super("routing");
    }

    public void init() {
        this.setOn();
    }

    public void startBatch(Tool tool, boolean undoRedo) {
        this.current = new Activity();
        this.checkAutoStitch = false;
    }

    public void endBatch() {
        if (this.current == null) {
            return;
        }
        if (this.current.numCreatedArcs > 0 || this.current.numCreatedNodes > 0 || this.current.numDeletedArcs > 0 || this.current.numDeletedNodes > 0) {
            this.past = this.current;
            if (Routing.isMimicStitchOn()) {
                MimicStitch.mimicStitch(false);
                return;
            }
        }
        if (this.checkAutoStitch && Routing.isAutoStitchOn()) {
            AutoStitch.autoStitch(false, false);
        }
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        this.checkAutoStitch = true;
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        this.checkAutoStitch = true;
    }

    public void newObject(ElectricObject obj) {
        if (obj instanceof NodeInst) {
            this.checkAutoStitch = true;
            if (this.current.numCreatedNodes < 3) {
                this.current.createdNodes[this.current.numCreatedNodes++] = (NodeInst)obj;
            }
        } else if (obj instanceof ArcInst && this.current.numCreatedArcs < 3) {
            this.current.createdArcs[this.current.numCreatedArcs++] = (ArcInst)obj;
        }
    }

    public void killObject(ElectricObject obj) {
        if (obj instanceof NodeInst) {
            if (this.current.numDeletedNodes < 2) {
                this.current.deletedNodes[this.current.numDeletedNodes++] = (NodeInst)obj;
            }
        } else if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            if (this.current.numDeletedArcs < 3) {
                this.current.deletedArcs[this.current.numDeletedArcs++] = ai;
            }
            this.current.deletedNodes[0] = ai.getHead().getPortInst().getNodeInst();
            this.current.deletedPorts[0] = ai.getHead().getPortInst().getPortProto();
            this.current.deletedNodes[1] = ai.getTail().getPortInst().getNodeInst();
            this.current.deletedPorts[1] = ai.getTail().getPortInst().getPortProto();
            this.current.numDeletedNodes = 2;
        }
    }

    public void mimicSelected() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        ArcInst ai = (ArcInst)highlighter.getOneElectricObject(ArcInst.class);
        if (ai == null) {
            return;
        }
        this.past = new Activity();
        this.past.createdArcs[this.past.numCreatedArcs++] = ai;
        MimicStitch.mimicStitch(false);
    }

    public static void unrouteCurrent() {
        UnrouteJob job = new UnrouteJob();
    }

    public static List findNetEnds(Network net, HashSet arcsToDelete, HashSet nodesToDelete, Netlist netList) {
        Cell cell = net.getParent();
        ArrayList<Connection> endList = new ArrayList<Connection>();
        Iterator it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Network aNet = netList.getNetwork(ai, 0);
            if (aNet != net) continue;
            arcsToDelete.add(ai);
            for (int i = 0; i < 2; ++i) {
                Connection thisCon = ai.getConnection(i);
                NodeInst ni = thisCon.getPortInst().getNodeInst();
                boolean term = true;
                Iterator cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    if (con == thisCon || netList.getNetwork(con.getArc(), 0) != net) continue;
                    term = false;
                    break;
                }
                if (ni.getNumExports() > 0) {
                    term = true;
                }
                if (ni.getProto() instanceof Cell) {
                    term = true;
                }
                if (term) {
                    if (endList.contains(thisCon)) continue;
                    endList.add(thisCon);
                    continue;
                }
                nodesToDelete.add(ni);
            }
        }
        return endList;
    }

    public Activity getLastActivity() {
        return this.past;
    }

    public static void toggleEnableAutoStitching(ActionEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (b.isSelected()) {
            Routing.setAutoStitchOn(true);
            System.out.println("Auto-stitching enabled");
        } else {
            Routing.setAutoStitchOn(false);
            System.out.println("Auto-stitching disabled");
        }
    }

    public static void toggleEnableMimicStitching(ActionEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (b.isSelected()) {
            Routing.setMimicStitchOn(true);
            System.out.println("Mimic-stitching enabled");
        } else {
            Routing.setMimicStitchOn(false);
            System.out.println("Mimic-stitching disabled");
        }
    }

    public static void copyRoutingTopology() {
        Cell np = WindowFrame.needCurCell();
        if (np == null) {
            return;
        }
        copiedTopologyCell = np;
        System.out.println("Cell " + np.describe() + " will have its connectivity remembered");
    }

    public static void pasteRoutingTopology() {
        if (copiedTopologyCell == null) {
            System.out.println("Must copy topology before pasting it");
            return;
        }
        if (!copiedTopologyCell.isActuallyLinked()) {
            System.out.println("Copied cell is no longer valid");
            return;
        }
        Cell toCell = WindowFrame.needCurCell();
        if (toCell == null) {
            return;
        }
        if (copiedTopologyCell == toCell) {
            System.out.println("Topology must be copied to a different cell");
            return;
        }
        CopyRoutingTopology job = new CopyRoutingTopology(copiedTopologyCell, toCell);
    }

    public static boolean copyTopology(Cell fromCell, Cell toCell) {
        Network oNet;
        Iterator oFPIt;
        NodeInst tNi;
        System.out.println("Copying topology of cell " + fromCell.describe() + " to cell " + toCell.describe());
        int wiresMade = 0;
        HashMap<NodeInst, NodeInst> nodesAssoc = new HashMap<NodeInst, NodeInst>();
        Iterator it = toCell.getNodes();
        block0: while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() == Generic.tech.cellCenterNode || ni.getProto() == Generic.tech.essentialBoundsNode || nodesAssoc.get(ni) != null) continue;
            PrimitiveNode.Function fun = null;
            if (ni.getProto() instanceof PrimitiveNode && ((fun = ni.getFunction()) == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE)) {
                if (ni.getNumExports() <= 0) continue;
                Iterator eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export e = (Export)eIt.next();
                    Export fromE = fromCell.findExport(e.getName());
                    if (fromE == null) continue;
                    nodesAssoc.put(ni, fromE.getOriginalPort().getNodeInst());
                    continue block0;
                }
                continue;
            }
            ArrayList<NodeInst> fromList = new ArrayList<NodeInst>();
            Iterator nIt = fromCell.getNodes();
            while (nIt.hasNext()) {
                NodeInst oNi = (NodeInst)nIt.next();
                if (ni.getProto() instanceof Cell) {
                    if (((Cell)oNi.getProto()).getCellGroup() != ((Cell)ni.getProto()).getCellGroup()) continue;
                    fromList.add(oNi);
                    continue;
                }
                PrimitiveNode.Function oFun = oNi.getFunction();
                if (oFun != fun) continue;
                fromList.add(oNi);
            }
            ArrayList<NodeInst> toList = new ArrayList<NodeInst>();
            Iterator nIt2 = toCell.getNodes();
            while (nIt2.hasNext()) {
                NodeInst oNi = (NodeInst)nIt2.next();
                if (ni.getProto() instanceof Cell) {
                    if (oNi.getProto() != ni.getProto()) continue;
                    toList.add(oNi);
                    continue;
                }
                PrimitiveNode.Function oFun = oNi.getFunction();
                if (oFun != fun) continue;
                toList.add(oNi);
            }
            if (toList.size() != fromList.size()) {
                if (fromList.size() == 0) continue;
                System.out.println("Warning: " + fromCell.describe() + " has " + fromList.size() + " of " + ni.getProto().describe() + " but cell " + toCell.describe() + " has " + toList.size());
                return false;
            }
            ArrayList copyList = new ArrayList();
            Iterator fIt = fromList.iterator();
            while (fIt.hasNext()) {
                copyList.add(fIt.next());
            }
            fIt = copyList.iterator();
            while (fIt.hasNext()) {
                NodeInst fNi = (NodeInst)fIt.next();
                String fName = fNi.getName();
                NodeInst matchedNode = null;
                Iterator tIt = toList.iterator();
                while (tIt.hasNext()) {
                    NodeInst tNi2 = (NodeInst)tIt.next();
                    String tName = tNi2.getName();
                    if (!fName.equals(tName)) continue;
                    matchedNode = tNi2;
                    break;
                }
                if (matchedNode == null) continue;
                nodesAssoc.put(matchedNode, fNi);
                fromList.remove(fNi);
            }
            if (toList.size() != fromList.size()) {
                System.out.println("Error: after name match, there are " + fromList.size() + " instances of " + ni.getProto().describe() + " in source and " + toList.size() + " in destination");
                return false;
            }
            if (fromList.size() == 0) continue;
            Collections.sort(fromList, new InstacesSpatially());
            Collections.sort(toList, new InstacesSpatially());
            for (int i = 0; i < Math.min(toList.size(), fromList.size()); ++i) {
                NodeInst tNi3 = (NodeInst)toList.get(i);
                NodeInst fNi = (NodeInst)fromList.get(i);
                nodesAssoc.put(tNi3, fNi);
            }
        }
        Netlist fNl = fromCell.getUserNetlist();
        Iterator tIt = toCell.getNodes();
        while (tIt.hasNext()) {
            tNi = (NodeInst)tIt.next();
            NodeInst fNi = (NodeInst)nodesAssoc.get(tNi);
            if (fNi == null) continue;
            Iterator oTIt = toCell.getNodes();
            while (oTIt.hasNext()) {
                NodeInst oFNi;
                NodeInst oTNi = (NodeInst)oTIt.next();
                if (tNi == oTNi || (oFNi = (NodeInst)nodesAssoc.get(oTNi)) == null) continue;
                PortInst fPi = null;
                PortInst oFPi = null;
                Iterator fPIt = fNi.getPortInsts();
                while (fPIt.hasNext()) {
                    PortInst pi = (PortInst)fPIt.next();
                    Network net = fNl.getNetwork(pi);
                    oFPIt = oFNi.getPortInsts();
                    while (oFPIt.hasNext()) {
                        PortInst oPi = (PortInst)oFPIt.next();
                        oNet = fNl.getNetwork(oPi);
                        if (net != oNet) continue;
                        fPi = pi;
                        oFPi = oPi;
                        break;
                    }
                    if (fPi == null) continue;
                    break;
                }
                if (fPi == null) continue;
                PortProto tPp = tNi.getProto().findPortProto(fPi.getPortProto().getName());
                PortInst tPi = null;
                if (tPp != null) {
                    tPi = tNi.findPortInstFromProto(tPp);
                }
                if (tPi == null) continue;
                PortProto oTPp = oTNi.getProto().findPortProto(oFPi.getPortProto().getName());
                PortInst oTPi = null;
                if (oTPp != null) {
                    oTPi = oTNi.findPortInstFromProto(oTPp);
                }
                if (oTPi == null) continue;
                int result = Routing.makeUnroutedConnection(tPi, oTPi, toCell);
                if (result < 0) {
                    return false;
                }
                wiresMade += result;
            }
        }
        tIt = toCell.getNodes();
        while (tIt.hasNext()) {
            PortProto oTPp;
            PortInst oPi;
            PrimitiveNode.Function fun;
            tNi = (NodeInst)tIt.next();
            if (nodesAssoc.get(tNi) != null || tNi.getProto() instanceof Cell || tNi.getNumExports() == 0 || (fun = tNi.getFunction()) != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT) continue;
            PortProto tPp = tNi.getProto().getPort(0);
            String matchName = ((Export)tNi.getExports().next()).getName();
            Network net = null;
            Iterator fIt = fromCell.getPorts();
            while (fIt.hasNext()) {
                Export fPp = (Export)fIt.next();
                int width = fNl.getBusWidth(fPp);
                for (int i = 0; i < width; ++i) {
                    Network aNet = fNl.getNetwork(fPp, i);
                    if (aNet == null || !aNet.toString().equalsIgnoreCase(matchName)) continue;
                    net = aNet;
                    break;
                }
                if (net == null) continue;
                break;
            }
            if (net == null) continue;
            PortInst oFPi = null;
            NodeInst oTNi = null;
            Iterator oTIt = toCell.getNodes();
            while (oTIt.hasNext()) {
                NodeInst ni = (NodeInst)oTIt.next();
                NodeInst oFNi = (NodeInst)nodesAssoc.get(ni);
                if (oFNi == null) continue;
                oFPIt = oFNi.getPortInsts();
                while (oFPIt.hasNext()) {
                    PortInst pi = (PortInst)oFPIt.next();
                    oNet = fNl.getNetwork(pi);
                    if (oNet == null || oNet != net) continue;
                    oFPi = pi;
                    break;
                }
                if (oFPi == null) continue;
                oTNi = ni;
                break;
            }
            if (oTNi == null || (oPi = oTNi.findPortInstFromProto(oTPp = oTNi.getProto().findPortProto(oFPi.getPortProto().getName()))) == null) continue;
            int result = Routing.makeUnroutedConnection(tNi.getPortInst(0), oPi, toCell);
            if (result < 0) {
                return false;
            }
            wiresMade += result;
        }
        if (wiresMade == 0) {
            System.out.println("No topology was copied");
        } else {
            System.out.println("Created " + wiresMade + " arcs to copy the topology");
        }
        return true;
    }

    private static int makeUnroutedConnection(PortInst fPi, PortInst tPi, Cell cell) {
        Network tNet;
        Netlist nl;
        Network fNet;
        if (fPi != null && tPi != null && (fNet = (nl = cell.getUserNetlist()).getNetwork(fPi)) == (tNet = nl.getNetwork(tPi))) {
            return 0;
        }
        Poly fPoly = fPi.getPoly();
        Poly tPoly = tPi.getPoly();
        Point2D.Double fPt = new Point2D.Double(fPoly.getCenterX(), fPoly.getCenterY());
        Point2D.Double tPt = new Point2D.Double(tPoly.getCenterX(), tPoly.getCenterY());
        double wid = Generic.tech.unrouted_arc.getDefaultWidth();
        ArcInst ai = ArcInst.makeInstance(Generic.tech.unrouted_arc, wid, fPi, tPi, fPt, tPt, null);
        if (ai == null) {
            return -1;
        }
        return 1;
    }

    public static boolean isAutoStitchOn() {
        return cacheAutoStitchOn.getBoolean();
    }

    public static void setAutoStitchOn(boolean on) {
        cacheAutoStitchOn.setBoolean(on);
    }

    public static boolean isMimicStitchOn() {
        return cacheMimicStitchOn.getBoolean();
    }

    public static void setMimicStitchOn(boolean on) {
        cacheMimicStitchOn.setBoolean(on);
    }

    public static boolean isMimicStitchCanUnstitch() {
        return cacheMimicStitchCanUnstitch.getBoolean();
    }

    public static void setMimicStitchCanUnstitch(boolean on) {
        cacheMimicStitchCanUnstitch.setBoolean(on);
    }

    public static boolean isMimicStitchInteractive() {
        return cacheMimicStitchInteractive.getBoolean();
    }

    public static void setMimicStitchInteractive(boolean on) {
        cacheMimicStitchInteractive.setBoolean(on);
    }

    public static boolean isMimicStitchMatchPorts() {
        return cacheMimicStitchMatchPorts.getBoolean();
    }

    public static void setMimicStitchMatchPorts(boolean on) {
        cacheMimicStitchMatchPorts.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNumArcs() {
        return cacheMimicStitchMatchNumArcs.getBoolean();
    }

    public static void setMimicStitchMatchNumArcs(boolean on) {
        cacheMimicStitchMatchNumArcs.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNodeSize() {
        return cacheMimicStitchMatchNodeSize.getBoolean();
    }

    public static void setMimicStitchMatchNodeSize(boolean on) {
        cacheMimicStitchMatchNodeSize.setBoolean(on);
    }

    public static boolean isMimicStitchMatchNodeType() {
        return cacheMimicStitchMatchNodeType.getBoolean();
    }

    public static void setMimicStitchMatchNodeType(boolean on) {
        cacheMimicStitchMatchNodeType.setBoolean(on);
    }

    public static boolean isMimicStitchNoOtherArcsSameDir() {
        return cacheMimicStitchNoOtherArcsSameDir.getBoolean();
    }

    public static void setMimicStitchNoOtherArcsSameDir(boolean on) {
        cacheMimicStitchNoOtherArcsSameDir.setBoolean(on);
    }

    public static String getPreferredRoutingArc() {
        return cachePreferredRoutingArc.getString();
    }

    public static void setPreferredRoutingArc(String arcName) {
        cachePreferredRoutingArc.setString(arcName);
    }

    static {
        cacheAutoStitchOn = Pref.makeBooleanPref("AutoStitchOn", Routing.tool.prefs, false);
        cacheMimicStitchOn = Pref.makeBooleanPref("MimicStitchOn", Routing.tool.prefs, false);
        cacheMimicStitchCanUnstitch = Pref.makeBooleanPref("MimicStitchCanUnstitch", Routing.tool.prefs, false);
        cacheMimicStitchInteractive = Pref.makeBooleanPref("MimicStitchInteractive", Routing.tool.prefs, false);
        cacheMimicStitchMatchPorts = Pref.makeBooleanPref("MimicStitchMatchPorts", Routing.tool.prefs, false);
        cacheMimicStitchMatchNumArcs = Pref.makeBooleanPref("MimicStitchMatchNumArcs", Routing.tool.prefs, false);
        cacheMimicStitchMatchNodeSize = Pref.makeBooleanPref("MimicStitchMatchNodeSize", Routing.tool.prefs, false);
        cacheMimicStitchMatchNodeType = Pref.makeBooleanPref("MimicStitchMatchNodeType", Routing.tool.prefs, true);
        cacheMimicStitchNoOtherArcsSameDir = Pref.makeBooleanPref("MimicStitchNoOtherArcsSameDir", Routing.tool.prefs, true);
        cachePreferredRoutingArc = Pref.makeStringPref("PreferredRoutingArc", Routing.tool.prefs, "");
    }

    public static class InstacesSpatially
    implements Comparator {
        public int compare(Object o1, Object o2) {
            NodeInst n1 = (NodeInst)o1;
            NodeInst n2 = (NodeInst)o2;
            double x1 = n1.getAnchorCenterX();
            double y1 = n1.getAnchorCenterY();
            double x2 = n2.getAnchorCenterX();
            double y2 = n2.getAnchorCenterY();
            if (y1 == y2) {
                if (x1 == x2) {
                    return 0;
                }
                if (x1 > x2) {
                    return 1;
                }
                return -1;
            }
            if (y1 == y2) {
                return 0;
            }
            if (y1 > y2) {
                return 1;
            }
            return -1;
        }
    }

    private static class CopyRoutingTopology
    extends Job {
        Cell fromCell;
        Cell toCell;

        protected CopyRoutingTopology(Cell fromCell, Cell toCell) {
            super("Copy Routing Topology", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fromCell = fromCell;
            this.toCell = toCell;
            this.startJob();
        }

        public boolean doIt() {
            return Routing.copyTopology(this.fromCell, this.toCell);
        }
    }

    private static class UnrouteJob
    extends Job {
        protected UnrouteJob() {
            super("Unroute", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return false;
            }
            Highlighter highlighter = wf.getContent().getHighlighter();
            if (highlighter == null) {
                return false;
            }
            Set nets = highlighter.getHighlightedNetworks();
            if (nets.size() == 0) {
                System.out.println("Must select networks to unroute");
                return false;
            }
            Cell cell = wf.getContent().getCell();
            Netlist netList = cell.getUserNetlist();
            highlighter.clear();
            int total = nets.size();
            Network[] netsToUnroute = new Network[total];
            List[] netEnds = new List[total];
            HashSet[] arcsToDelete = new HashSet[total];
            HashSet[] nodesToDelete = new HashSet[total];
            int i = 0;
            Iterator it = nets.iterator();
            while (it.hasNext()) {
                Network net;
                netsToUnroute[i] = net = (Network)it.next();
                arcsToDelete[i] = new HashSet();
                nodesToDelete[i] = new HashSet();
                netEnds[i] = Routing.findNetEnds(net, arcsToDelete[i], nodesToDelete[i], netList);
                ++i;
            }
            for (int j = 0; j < total; ++j) {
                if (!UnrouteJob.unrouteNet(netsToUnroute[j], arcsToDelete[j], nodesToDelete[j], netEnds[j], netList, highlighter)) continue;
                return false;
            }
            highlighter.finished();
            return true;
        }

        private static boolean unrouteNet(Network net, HashSet arcsToDelete, HashSet nodesToDelete, List netEnds, Netlist netList, Highlighter highlighter) {
            Iterator it = arcsToDelete.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ai.kill();
            }
            it = nodesToDelete.iterator();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.kill();
            }
            double wid = Generic.tech.unrouted_arc.getDefaultWidth();
            int count = netEnds.size();
            int[] covered = new int[count];
            Point2D[] points = new Point2D[count];
            for (int i = 0; i < count; ++i) {
                Connection con = (Connection)netEnds.get(i);
                PortInst pi = con.getPortInst();
                Poly poly = pi.getPoly();
                points[i] = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                covered[i] = 0;
            }
            int first = 0;
            while (true) {
                PortInst tail;
                boolean found = true;
                double bestdist = 0.0;
                int besti = 0;
                int bestj = 0;
                for (int i = 0; i < count; ++i) {
                    for (int j = i + 1; j < count; ++j) {
                        if (first != 0 && covered[i] + covered[j] != 1) continue;
                        double dist = points[i].distance(points[j]);
                        if (!found && dist >= bestdist) continue;
                        found = false;
                        bestdist = dist;
                        besti = i;
                        bestj = j;
                    }
                }
                if (found) break;
                covered[bestj] = 1;
                covered[besti] = 1;
                PortInst head = ((Connection)netEnds.get(besti)).getPortInst();
                ArcInst ai = ArcInst.makeInstance(Generic.tech.unrouted_arc, wid, head, tail = ((Connection)netEnds.get(bestj)).getPortInst());
                if (ai == null) {
                    System.out.println("Could not create unrouted arc");
                    return true;
                }
                highlighter.addElectricObject(ai, ai.getParent());
                ++first;
            }
            return false;
        }
    }

    public static class Activity {
        int numCreatedArcs = 0;
        int numCreatedNodes = 0;
        ArcInst[] createdArcs = new ArcInst[3];
        NodeInst[] createdNodes = new NodeInst[3];
        int numDeletedArcs = 0;
        int numDeletedNodes = 0;
        ArcInst[] deletedArcs = new ArcInst[3];
        NodeInst[] deletedNodes = new NodeInst[2];
        PortProto[] deletedPorts = new PortProto[2];

        Activity() {
        }
    }
}

