/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.jemNets.NetObject;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.StratCount;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.HashMap;

public class ReportHashCodeFailure {
    private NccGlobals globals;

    private static void pr(String s) {
        System.out.print(s);
    }

    private static void prln(String s) {
        System.out.println(s);
    }

    private StratCount.Counts printCounts() {
        NccOptions options = this.globals.getOptions();
        int saveHowMuchStatus = options.howMuchStatus;
        options.howMuchStatus = 10;
        StratCount.Counts counts = StratCount.doYourJob(this.globals);
        options.howMuchStatus = saveHowMuchStatus;
        return counts;
    }

    private ReportHashCodeFailure(NccGlobals globals) {
        this.globals = globals;
        ReportHashCodeFailure.prln("Hash Code Partitioning Failed!!!");
        StratCount.Counts counts = this.printCounts();
        StratPrintMismatched.doYourJob(counts, globals);
        StratPrintMatched.doYourJob(counts, globals);
    }

    public static void reportHashCodeFailure(NccGlobals globals) {
        new ReportHashCodeFailure(globals);
    }

    private static class StratPrintMatched
    extends Strategy {
        private int classNum = 1;
        private String netObjDescr;
        private int maxMatches;

        private void printEquivRecs(String type, EquivRecord partsOrWires, int num) {
            this.classNum = 1;
            this.netObjDescr = "Part";
            ReportHashCodeFailure.prln("  " + num + " matched " + type + " equivalence classes:");
            this.maxMatches = this.globals.getOptions().maxMatchedEquivRecsToPrint;
            if (num > this.maxMatches) {
                ReportHashCodeFailure.prln("    Too many, I'm only printing " + this.maxMatches + ".");
            }
            if (partsOrWires == null) {
                this.error(num != 0, "non-zero matched objects but no objects!");
                return;
            }
            this.doFor(partsOrWires);
        }

        private StratPrintMatched(StratCount.Counts counts, NccGlobals globals) {
            super(globals);
            this.printEquivRecs("Part", globals.getParts(), counts.numMatchedPartEquivRecs);
            this.printEquivRecs("Wire", globals.getWires(), counts.numMatchedWireEquivRecs);
        }

        public LeafList doFor(EquivRecord er) {
            if (this.classNum <= this.maxMatches) {
                if (er.isLeaf()) {
                    if (er.isMatched()) {
                        ReportHashCodeFailure.pr("    " + this.netObjDescr + " match " + this.classNum++ + " between: ");
                        int numDesigns = this.globals.getNumNetlistsBeingCompared();
                        for (int i = 0; i < numDesigns; ++i) {
                            if (i != 0) {
                                ReportHashCodeFailure.pr(" and ");
                            }
                            ReportHashCodeFailure.pr(this.globals.getRootCellNames()[i]);
                        }
                        ReportHashCodeFailure.prln("");
                        super.doFor(er);
                    }
                } else {
                    super.doFor(er);
                }
            }
            return new LeafList();
        }

        public HashMap doFor(Circuit c) {
            return super.doFor(c);
        }

        public Integer doFor(NetObject n) {
            ReportHashCodeFailure.prln("      " + n.fullDescription());
            return CODE_NO_CHANGE;
        }

        public static void doYourJob(StratCount.Counts counts, NccGlobals globals) {
            new StratPrintMatched(counts, globals);
        }
    }

    private static class StratPrintMismatched
    extends Strategy {
        private int cktNdx;
        private int classNum;
        private String netObjDescr;
        private int maxMismatches;

        private void printEquivRecs(String type, EquivRecord partsOrWires, int num) {
            this.classNum = 1;
            this.netObjDescr = "Part";
            ReportHashCodeFailure.prln("  " + num + " mismatched " + type + " equivalence classes:");
            this.maxMismatches = this.globals.getOptions().maxMismatchedEquivRecsToPrint;
            if (num > this.maxMismatches) {
                ReportHashCodeFailure.prln("    Too many, I'm only printing " + this.maxMismatches + ".");
            }
            if (partsOrWires == null) {
                this.error(num != 0, "non-zero mismatched objects but no objects!");
                return;
            }
            this.doFor(partsOrWires);
        }

        private StratPrintMismatched(StratCount.Counts counts, NccGlobals globals) {
            super(globals);
            this.printEquivRecs("Part", globals.getParts(), counts.numMismatchedPartEquivRecs);
            this.printEquivRecs("Wire", globals.getWires(), counts.numMismatchedWireEquivRecs);
        }

        public LeafList doFor(EquivRecord er) {
            if (this.classNum <= this.maxMismatches) {
                if (er.isLeaf()) {
                    if (er.isMismatched()) {
                        ReportHashCodeFailure.prln("    Mismatched " + this.netObjDescr + " equivalence class " + this.classNum++);
                        this.cktNdx = 0;
                        super.doFor(er);
                    }
                } else {
                    super.doFor(er);
                }
            }
            return new LeafList();
        }

        public HashMap doFor(Circuit c) {
            ReportHashCodeFailure.prln("      Cell " + this.globals.getRootCellNames()[this.cktNdx] + " has " + c.numNetObjs() + " mismatched objects");
            ++this.cktNdx;
            return super.doFor(c);
        }

        public Integer doFor(NetObject n) {
            ReportHashCodeFailure.prln("        " + n.fullDescription());
            return CODE_NO_CHANGE;
        }

        public static void doYourJob(StratCount.Counts counts, NccGlobals globals) {
            new StratPrintMismatched(counts, globals);
        }
    }
}

