/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryContents;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.LibraryStatistics;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ELIB1
extends LibraryFiles {
    private Header header;
    private int clippedIntegers;
    private int toolCount;
    private int toolBCount;
    private Tool[] toolList;
    private String[] toolError;
    private LibraryContents.ToolRef[] toolRefs;
    private boolean toolBitsMessed;
    private int techCount;
    private Technology[] techList;
    private String[] techError;
    private LibraryContents.TechnologyRef[] techRefs;
    private double[] techScale;
    private int arcProtoCount;
    private PrimitiveArc[] arcProtoList;
    private String[] arcProtoError;
    private LibraryContents.ArcProtoRef[] arcProtoRefs;
    private int primNodeProtoCount;
    private PrimitiveNode[] primNodeProtoList;
    private boolean[] primNodeProtoError;
    private LibraryContents.PrimitiveNodeRef[] primNodeProtoRefs;
    private String[] primNodeProtoOrig;
    private int[] primNodeProtoTech;
    private int primPortProtoCount;
    private PrimitivePort[] primPortProtoList;
    private String[] primPortProtoError;
    private LibraryContents.PrimitivePortRef[] primPortProtoRefs;
    private Technology layoutTech;
    private int cellCount;
    private int curCell;
    private Input.FakeCell[] fakeCellList;
    private int[] nodeCounts;
    private int[] firstNodeIndex;
    private int[] arcCounts;
    private int[] firstArcIndex;
    private int[] portCounts;
    private int[] firstPortIndex;
    private int[] cellXOff;
    private int[] cellYOff;
    private boolean[] xLibRefSatisfied;
    private HashMap viewMapping;
    private int nodeCount;
    private LibraryFiles.NodeInstList nodeInstList;
    private int arcCount;
    private ArcInst[] arcList;
    private ArcProto[] arcTypeList;
    private Name[] arcNameList;
    private int[] arcWidthList;
    private int[] arcHeadXPosList;
    private int[] arcHeadYPosList;
    private int[] arcHeadNodeList;
    private Object[] arcHeadPortList;
    private int[] arcTailXPosList;
    private int[] arcTailYPosList;
    private int[] arcTailNodeList;
    private Object[] arcTailPortList;
    private int[] arcUserBits;
    private int portProtoCount;
    private int portProtoIndex;
    private Object[] portProtoList;
    private int[] portProtoSubNodeList;
    private Object[] portProtoSubPortList;
    private String[] portProtoNameList;
    private int[] portProtoUserbits;
    private int geomCount;
    private boolean[] geomType;
    private int[] geomMoreUp;
    private int nameCount;
    private LibraryContents.VariableKeyRef[] varKeys;
    private boolean convertTextDescriptors;
    private boolean alwaysTextDescriptors;
    private LibraryContents libraryContents;
    private static View[] permanentViews;
    private static LibraryContents.ViewRef[] permanentViewRefs;
    private static ByteBuffer bb;
    private static byte[] rawData;
    static final /* synthetic */ boolean $assertionsDisabled;

    ELIB1() {
    }

    public static synchronized void convertLibrary(URL fileURL, String outFilePath) {
        errorLogger = ErrorLogger.newInstance("Library Convert");
        try {
            ELIB1 in = new ELIB1();
            if (in.openBinaryInput(fileURL)) {
                return;
            }
            in.libraryContents = new LibraryContents(TextUtils.getFileNameWithoutExtension(fileURL), in);
            boolean error = in.readTheLibrary(null);
            in.closeInput();
            errorLogger.termLogging(true);
            if (error) {
                System.out.println("Error reading library " + fileURL);
                return;
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outFilePath)));
            in.libraryContents.printJelib(printWriter);
            printWriter.close();
            System.out.println("Written " + outFilePath);
        }
        catch (IOException e) {
            System.out.println("Error " + e + " opening " + outFilePath);
        }
    }

    public static synchronized Header readLibraryHeader(URL fileURL) {
        errorLogger = ErrorLogger.newInstance("Read Library Header");
        try {
            ELIB1 in = new ELIB1();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
            Header header = in.readHeader();
            in.closeInput();
            errorLogger.termLogging(true);
            return header;
        }
        catch (IOException e) {
            System.out.println("Error " + e + " in " + fileURL);
            return null;
        }
    }

    public static synchronized Version readLibraryVersion(URL fileURL) {
        errorLogger = ErrorLogger.newInstance("Read Library Version");
        try {
            ELIB1 in = new ELIB1();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
            in.libraryContents = new LibraryContents(TextUtils.getFileNameWithoutExtension(fileURL), in);
            boolean error = in.readTheLibrary(null);
            in.closeInput();
            errorLogger.termLogging(true);
            if (error) {
                System.out.println("Error reading library " + fileURL);
                if (in.topLevelLibrary) {
                    mainLibDirectory = null;
                }
                return null;
            }
            return in.libraryContents.getVersion();
        }
        catch (IOException e) {
            System.out.println("Error " + e + " in " + fileURL);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLibraryStat(LibraryStatistics.FileContents fc, LibraryStatistics stat) {
        errorLogger = ErrorLogger.newInstance("Read Library Statistics");
        try {
            String fileName = fc.fileName();
            URL fileURL = TextUtils.makeURLToFile(fileName);
            ELIB1 in = new ELIB1();
            if (in.openBinaryInput(fileURL)) {
                System.out.println(fileName + " OPEN FAILED");
                return;
            }
            in.dataInputStream.mark(512);
            fc.header = in.readHeader();
            if (fc.header == null) {
                System.out.println(fileName + " INVALID HEADER");
                return;
            }
            in.dataInputStream.reset();
            in.libraryContents = new LibraryContents(TextUtils.getFileNameWithoutExtension(fileURL), in);
            try {
                if (in.readTheLibrary(stat)) {
                    System.out.println(fileName + " ERROR");
                    return;
                }
                fc.readOk = true;
            }
            finally {
                in.closeInput();
                errorLogger.termLogging(true);
            }
            in.libraryContents.fillStat(fc, stat.totalLibraryContents);
            if (!$assertionsDisabled && fc.toolCount != in.toolCount) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && fc.techCount != in.techCount) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && fc.primNodeProtoCount != in.primNodeProtoCount) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && fc.primPortProtoCount != in.primPortProtoCount) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && fc.arcProtoCount != in.arcProtoCount) {
                throw new AssertionError();
            }
            fc.nodeProtoCount = in.nodeProtoCount;
            fc.nodeInstCount = in.nodeCount;
            fc.portProtoCount = in.portProtoCount;
            fc.arcInstCount = in.arcCount;
            fc.geomCount = in.geomCount;
            fc.cellCount = in.cellCount;
            if (!$assertionsDisabled && fc.varNameCount != in.nameCount) {
                throw new AssertionError();
            }
            fc.bytesRead = in.byteCount;
        }
        catch (Throwable e) {
            System.out.println(fc.fileName() + " ERROR " + e);
            e.printStackTrace(System.out);
        }
    }

    protected boolean readLib() {
        try {
            return this.readTheLibrary(null);
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    private boolean readTheLibrary(LibraryStatistics stat) throws IOException {
        boolean external;
        int i;
        int i2;
        int i3;
        int j;
        int i4;
        this.clippedIntegers = 0;
        this.byteCount = 0;
        this.layoutTech = null;
        this.header = this.readHeader();
        if (this.header == null) {
            System.out.println("Error reading header");
            return true;
        }
        this.libraryContents.setElibHeader(this.header);
        this.toolCount = this.readBigInteger();
        this.techCount = this.readBigInteger();
        this.primNodeProtoCount = this.readBigInteger();
        this.primPortProtoCount = this.readBigInteger();
        this.arcProtoCount = this.readBigInteger();
        this.nodeProtoCount = this.readBigInteger();
        this.nodeCount = this.readBigInteger();
        this.portProtoCount = this.readBigInteger();
        this.arcCount = this.readBigInteger();
        this.geomCount = this.readBigInteger();
        this.cellCount = this.header.magic <= -1589 && this.header.magic >= -1593 ? this.readBigInteger() : this.nodeProtoCount;
        this.curCell = this.readBigInteger();
        String versionString = this.header.magic <= -1587 ? this.readString() : "3.35";
        this.version = Version.parseVersion(versionString);
        this.libraryContents.setVersion(this.version);
        this.convertMosisCmosTechnologies = this.version.compareTo(Version.parseVersion("6.03q")) < 0;
        this.convertTextDescriptors = this.version.compareTo(Version.parseVersion("6.04c")) < 0;
        this.alwaysTextDescriptors = this.version.compareTo(Version.parseVersion("6.05x")) >= 0;
        this.scaleLambdaBy20 = this.version.compareTo(Version.parseVersion("5")) < 0;
        this.rotationMirrorBits = this.version.compareTo(Version.parseVersion("7.01")) >= 0;
        this.viewMapping = new HashMap();
        if (this.header.magic <= -1589) {
            int numExtraViews = this.readBigInteger();
            for (int i5 = 0; i5 < numExtraViews; ++i5) {
                String viewName = this.readString();
                String viewShortName = this.readString();
                LibraryContents.ViewRef viewRef = this.libraryContents.newViewRef(viewShortName, viewName);
                this.viewMapping.put(new Integer(i5 + 1), viewRef);
            }
        }
        this.toolBCount = this.header.magic <= -1577 && this.header.magic >= -1583 ? this.readBigInteger() : this.toolCount;
        this.techList = new Technology[this.techCount];
        this.techError = new String[this.techCount];
        this.techRefs = new LibraryContents.TechnologyRef[this.techCount];
        this.techScale = new double[Technology.getNumTechnologies()];
        Arrays.fill(this.techScale, 1.0);
        this.arcProtoList = new PrimitiveArc[this.arcProtoCount];
        this.arcProtoError = new String[this.arcProtoCount];
        this.arcProtoRefs = new LibraryContents.ArcProtoRef[this.arcProtoCount];
        this.primNodeProtoList = new PrimitiveNode[this.primNodeProtoCount];
        this.primNodeProtoError = new boolean[this.primNodeProtoCount];
        this.primNodeProtoRefs = new LibraryContents.PrimitiveNodeRef[this.primNodeProtoCount];
        this.primNodeProtoOrig = new String[this.primNodeProtoCount];
        this.primNodeProtoTech = new int[this.primNodeProtoCount];
        this.primPortProtoList = new PrimitivePort[this.primPortProtoCount];
        this.primPortProtoError = new String[this.primPortProtoCount];
        this.primPortProtoRefs = new LibraryContents.PrimitivePortRef[this.primPortProtoCount];
        this.toolList = new Tool[this.toolCount];
        this.toolError = new String[this.toolCount];
        this.toolRefs = new LibraryContents.ToolRef[this.toolCount];
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.nodeCounts = new int[this.nodeProtoCount];
        this.firstNodeIndex = new int[this.nodeProtoCount + 1];
        this.arcCounts = new int[this.nodeProtoCount];
        this.firstArcIndex = new int[this.nodeProtoCount + 1];
        this.portCounts = new int[this.nodeProtoCount];
        this.firstPortIndex = new int[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        this.cellXOff = new int[this.nodeProtoCount];
        this.cellYOff = new int[this.nodeProtoCount];
        this.xLibRefSatisfied = new boolean[this.nodeProtoCount];
        this.nodeInstList = new LibraryFiles.NodeInstList();
        this.nodeInstList.theNode = new NodeInst[this.nodeCount];
        this.nodeInstList.protoType = new NodeProto[this.nodeCount];
        this.nodeInstList.name = new Name[this.nodeCount];
        this.nodeInstList.lowX = new int[this.nodeCount];
        this.nodeInstList.highX = new int[this.nodeCount];
        this.nodeInstList.lowY = new int[this.nodeCount];
        this.nodeInstList.highY = new int[this.nodeCount];
        this.nodeInstList.anchorX = new int[this.nodeCount];
        this.nodeInstList.anchorY = new int[this.nodeCount];
        this.nodeInstList.rotation = new short[this.nodeCount];
        this.nodeInstList.transpose = new int[this.nodeCount];
        this.nodeInstList.userBits = new int[this.nodeCount];
        this.arcList = new ArcInst[this.arcCount];
        this.arcTypeList = new ArcProto[this.arcCount];
        this.arcNameList = new Name[this.arcCount];
        this.arcWidthList = new int[this.arcCount];
        this.arcHeadXPosList = new int[this.arcCount];
        this.arcHeadYPosList = new int[this.arcCount];
        this.arcHeadNodeList = new int[this.arcCount];
        this.arcHeadPortList = new Object[this.arcCount];
        this.arcTailXPosList = new int[this.arcCount];
        this.arcTailYPosList = new int[this.arcCount];
        this.arcTailNodeList = new int[this.arcCount];
        this.arcTailPortList = new Object[this.arcCount];
        this.arcUserBits = new int[this.arcCount];
        for (i4 = 0; i4 < this.arcCount; ++i4) {
            this.arcHeadNodeList[i4] = -1;
            this.arcHeadPortList[i4] = null;
            this.arcTailNodeList[i4] = -1;
            this.arcTailPortList[i4] = null;
            this.arcNameList[i4] = null;
            this.arcUserBits[i4] = 0;
        }
        this.portProtoList = new Object[this.portProtoCount];
        this.portProtoSubNodeList = new int[this.portProtoCount];
        this.portProtoSubPortList = new Object[this.portProtoCount];
        this.portProtoNameList = new String[this.portProtoCount];
        this.portProtoUserbits = new int[this.portProtoCount];
        if (this.header.magic <= -1589 && this.header.magic >= -1593) {
            this.fakeCellList = new Input.FakeCell[this.cellCount];
            for (i4 = 0; i4 < this.cellCount; ++i4) {
                this.fakeCellList[i4] = new Input.FakeCell();
            }
        }
        if (this.header.magic > -1581) {
            this.geomType = new boolean[this.geomCount];
            this.geomMoreUp = new int[this.geomCount];
        }
        if (this.header.magic != -1573) {
            int nodeInstPos = 0;
            int arcInstPos = 0;
            int portProtoPos = 0;
            for (int i6 = 0; i6 < this.nodeProtoCount; ++i6) {
                this.arcCounts[i6] = this.readBigInteger();
                this.nodeCounts[i6] = this.readBigInteger();
                this.portCounts[i6] = this.readBigInteger();
                if (this.arcCounts[i6] > 0 || this.nodeCounts[i6] > 0) {
                    arcInstPos += this.arcCounts[i6];
                    nodeInstPos += this.nodeCounts[i6];
                }
                portProtoPos += this.portCounts[i6];
            }
            if (nodeInstPos != this.nodeCount) {
                System.out.println("Error: cells have " + nodeInstPos + " nodes but library has " + this.nodeCount);
                return true;
            }
            if (arcInstPos != this.arcCount) {
                System.out.println("Error: cells have " + arcInstPos + " arcs but library has " + this.arcCount);
                return true;
            }
            if (portProtoPos != this.portProtoCount) {
                System.out.println("Error: cells have " + portProtoPos + " ports but library has " + this.portProtoCount);
                return true;
            }
        } else {
            this.arcCounts[0] = this.arcCount;
            this.nodeCounts[0] = this.nodeCount;
            this.portCounts[0] = this.portProtoCount;
            for (i4 = 1; i4 < this.nodeProtoCount; ++i4) {
                this.portCounts[i4] = 0;
                this.nodeCounts[i4] = 0;
                this.arcCounts[i4] = 0;
            }
        }
        for (i4 = 0; i4 < this.nodeProtoCount; ++i4) {
            if (this.arcCounts[i4] < 0 && this.nodeCounts[i4] < 0) {
                this.nodeProtoList[i4] = null;
                this.xLibRefSatisfied[i4] = false;
                continue;
            }
            this.xLibRefSatisfied[i4] = true;
        }
        int nodeinstpos = 0;
        int arcinstpos = 0;
        int portprotopos = 0;
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            int thisone;
            int i7;
            boolean external2 = this.arcCounts[cellIndex] < 0 && this.nodeCounts[cellIndex] < 0;
            Cell cell = this.nodeProtoList[cellIndex];
            if (external2) {
                for (i7 = 0; i7 < this.portCounts[cellIndex]; ++i7) {
                    this.portProtoList[portprotopos + i7] = null;
                }
                portprotopos += this.portCounts[cellIndex];
                continue;
            }
            for (i7 = 0; i7 < this.nodeCounts[cellIndex]; ++i7) {
                thisone = i7 + nodeinstpos;
            }
            nodeinstpos += this.nodeCounts[cellIndex];
            for (i7 = 0; i7 < this.portCounts[cellIndex]; ++i7) {
                thisone = i7 + portprotopos;
            }
            portprotopos += this.portCounts[cellIndex];
            for (i7 = 0; i7 < this.arcCounts[cellIndex]; ++i7) {
                thisone = i7 + arcinstpos;
            }
            arcinstpos += this.arcCounts[cellIndex];
        }
        this.primNodeProtoCount = 0;
        this.primPortProtoCount = 0;
        this.arcProtoCount = 0;
        for (int techIndex = 0; techIndex < this.techCount; ++techIndex) {
            LibraryContents.TechnologyRef techRef;
            String name = this.readString();
            this.techRefs[techIndex] = techRef = this.libraryContents.newTechnologyRef(name);
            int numPrimNodes = this.readBigInteger();
            for (j = 0; j < numPrimNodes; ++j) {
                this.primNodeProtoOrig[this.primNodeProtoCount] = null;
                this.primNodeProtoError[this.primNodeProtoCount] = false;
                name = this.readString();
                LibraryContents.PrimitiveNodeRef primitiveNodeRef = techRef.newPrimitiveNodeRef(name);
                this.primNodeProtoTech[this.primNodeProtoCount] = techIndex;
                this.primNodeProtoRefs[this.primNodeProtoCount] = primitiveNodeRef;
                int numPrimPorts = this.readBigInteger();
                for (int i8 = 0; i8 < numPrimPorts; ++i8) {
                    this.primPortProtoError[this.primPortProtoCount] = null;
                    name = this.readString();
                    LibraryContents.PrimitivePortRef primitivePortRef = primitiveNodeRef.newPrimitivePortRef(name);
                    this.primPortProtoRefs[this.primPortProtoCount++] = primitivePortRef;
                }
                ++this.primNodeProtoCount;
            }
            int numArcProtos = this.readBigInteger();
            for (int j2 = 0; j2 < numArcProtos; ++j2) {
                this.arcProtoError[this.arcProtoCount] = null;
                name = this.readString();
                LibraryContents.ArcProtoRef arcProtoRef = techRef.newArcProtoRef(name);
                this.arcProtoRefs[this.arcProtoCount++] = arcProtoRef;
            }
        }
        this.toolBitsMessed = false;
        int ioCount = 0;
        for (i3 = 0; i3 < this.toolCount; ++i3) {
            LibraryContents.ToolRef toolRef;
            String name = this.readString();
            if (name.equals("io")) {
                if (ioCount != 0) {
                    name = name + ioCount;
                }
                if (ioCount == 1) {
                    System.out.println(this.filePath + " io*" + this.version);
                }
                ++ioCount;
            }
            this.toolError[i3] = null;
            this.toolRefs[i3] = toolRef = this.libraryContents.newToolRef(name);
        }
        if (this.header.magic <= -1577 && this.header.magic >= -1583) {
            for (i3 = 0; i3 < this.toolBCount; ++i3) {
                this.readString();
            }
        }
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i9 = 1; i9 < this.toolBCount; ++i9) {
                this.readBigInteger();
            }
        }
        if (stat != null) {
            stat.varStat.addUserBits(userBits, "H");
        }
        this.libraryContents.setUserBits(userBits);
        for (i2 = 0; i2 < this.techCount; ++i2) {
            int lambda = this.readBigInteger();
            this.techRefs[i2].setLambda(lambda);
        }
        if (this.readNameSpace()) {
            System.out.println("Error reading namespace");
            return true;
        }
        this.libraryContents.setVars(this.readVariables(stat, "H"));
        for (i2 = 0; i2 < this.toolCount; ++i2) {
            this.toolRefs[i2].setVars(this.readVariables(stat, "O" + this.toolRefs[i2].getFullName()));
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            this.techRefs[i2].setVars(this.readVariables(stat, "T" + this.techRefs[i2].getFullName()));
        }
        for (i2 = 0; i2 < this.arcProtoCount; ++i2) {
            this.arcProtoRefs[i2].setVars(this.readVariables(stat, "W" + this.arcProtoRefs[i2].getFullName()));
        }
        for (i2 = 0; i2 < this.primNodeProtoCount; ++i2) {
            this.primNodeProtoRefs[i2].setVars(this.readVariables(stat, "D" + this.primNodeProtoRefs[i2].getFullName()));
        }
        for (i2 = 0; i2 < this.primPortProtoCount; ++i2) {
            this.primPortProtoRefs[i2].setVars(this.readVariables(stat, "P" + this.primPortProtoRefs[i2].getFullName()));
        }
        if (this.header.magic <= -1589) {
            int count = this.readBigInteger();
            for (int i10 = 0; i10 < count; ++i10) {
                j = this.readBigInteger();
                LibraryContents.ViewRef viewRef = this.getViewRef(j);
                if (viewRef != null) {
                    viewRef.setVars(this.readVariables(stat, "V" + viewRef.getFullName()));
                    continue;
                }
                System.out.println("View index " + j + " not found");
                this.readVariables(stat, "V?");
            }
        }
        if (this.header.magic <= -1589 && this.header.magic >= -1593) {
            for (i2 = 0; i2 < this.cellCount; ++i2) {
                String thecellname = this.readString();
                this.libraryContents.addFakeVars(this.readVariables(stat, "F"));
                this.fakeCellList[i2].cellName = this.convertCellName(thecellname);
            }
        }
        this.portProtoIndex = 0;
        HashMap nextInCellGroup = new HashMap();
        for (i = 0; i < this.nodeProtoCount; ++i) {
            external = this.arcCounts[i] < 0 && this.nodeCounts[i] < 0;
            Cell cell = this.nodeProtoList[i];
            if (external || !this.readNodeProto(cell, i, nextInCellGroup, stat)) continue;
            System.out.println("Error reading cell");
            return true;
        }
        for (i = 0; i < this.nodeProtoCount; ++i) {
            external = this.arcCounts[i] < 0 && this.nodeCounts[i] < 0;
            Cell cell = this.nodeProtoList[i];
            if (!external || !this.readExternalNodeProto(this.lib, i, stat)) continue;
            System.out.println("Error reading external cell");
            return true;
        }
        int nodeIndex = 0;
        int arcIndex = 0;
        int geomIndex = 0;
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            int j3;
            Cell cell = this.nodeProtoList[cellIndex];
            this.firstNodeIndex[cellIndex] = nodeIndex;
            this.firstArcIndex[cellIndex] = arcIndex;
            if (this.header.magic > -1581) {
                j3 = geomIndex;
                this.readGeom(this.geomType, this.geomMoreUp, j3);
                this.readGeom(this.geomType, this.geomMoreUp, ++j3);
                int top = ++j3;
                this.readGeom(this.geomType, this.geomMoreUp, j3);
                int bot = ++j3;
                this.readGeom(this.geomType, this.geomMoreUp, j3);
                ++j3;
                do {
                    this.readGeom(this.geomType, this.geomMoreUp, j3);
                } while (this.geomMoreUp[++j3 - 1] != top);
                geomIndex = j3;
                int look = bot;
                while (look != top) {
                    if (!this.geomType[look]) {
                        if (this.readArcInst(arcIndex, stat)) {
                            System.out.println("Error reading arc");
                            ErrorLogger.MessageLog error = Input.errorLogger.logError("Error reading arc index " + arcIndex, cell, 1);
                            return true;
                        }
                        ++arcIndex;
                    } else {
                        if (this.readNodeInst(nodeIndex, cellIndex, stat)) {
                            System.out.println("Error reading node");
                            ErrorLogger.MessageLog error = Input.errorLogger.logError("Error reading node index " + nodeIndex, cell, 1);
                            return true;
                        }
                        ++nodeIndex;
                    }
                    look = this.geomMoreUp[look];
                }
                continue;
            }
            for (j3 = 0; j3 < this.arcCounts[cellIndex]; ++j3) {
                if (this.readArcInst(arcIndex, stat)) {
                    System.out.println("Error reading arc");
                    ErrorLogger.MessageLog error = Input.errorLogger.logError("Error reading arc index " + arcIndex, cell, 1);
                    return true;
                }
                ++arcIndex;
            }
            for (j3 = 0; j3 < this.nodeCounts[cellIndex]; ++j3) {
                if (this.readNodeInst(nodeIndex, cellIndex, stat)) {
                    ErrorLogger.MessageLog error = Input.errorLogger.logError("Error reading node index " + nodeIndex, cell, 1);
                    System.out.println("Error reading node index " + nodeIndex + " in cell " + cell.describe() + " of library " + this.lib.getName());
                    return true;
                }
                ++nodeIndex;
            }
        }
        this.firstNodeIndex[this.nodeProtoCount] = nodeIndex;
        this.firstArcIndex[this.nodeProtoCount] = arcIndex;
        return this.errorCount > 0;
    }

    protected void realizeCellsRecursively(Cell cell, FlagSet recursiveSetupFlag, String scaledCellName, double scaleX, double scaleY) {
        int i;
        double lambdaX;
        int j;
        boolean dummyCell;
        if (cell.getLibrary() != this.lib) {
            return;
        }
        boolean bl = dummyCell = cell.getVar(IO_DUMMY_OBJECT) != null;
        if (dummyCell) {
            return;
        }
        int cellIndex = cell.getTempInt();
        if (cellIndex + 1 >= this.firstNodeIndex.length) {
            return;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        block0: for (int i2 = startNode; i2 < endNode; ++i2) {
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i2];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getLibrary() == this.lib) continue;
            for (int cI = 0; cI < this.nodeProtoCount; ++cI) {
                LibraryFiles reader;
                if (this.nodeProtoList[cI] != subCell) continue;
                if (this.xLibRefSatisfied[cI]) continue block0;
                if (!subCell.isBit(recursiveSetupFlag) && (reader = this.getReaderForLib(subCell.getLibrary())) != null) {
                    reader.realizeCellsRecursively(subCell, recursiveSetupFlag, null, 0.0, 0.0);
                }
                int startPort = this.firstPortIndex[cI];
                int endPort = startPort + this.portCounts[cI];
                for (j = startPort; j < endPort; ++j) {
                    Object obj = this.portProtoList[j];
                    Export pp = null;
                    Cell otherCell = null;
                    if (!(obj instanceof Cell) || (pp = (otherCell = (Cell)obj).findExport(this.portProtoNameList[j])) == null) continue;
                    this.portProtoList[j] = pp;
                }
                this.xLibRefSatisfied[cI] = true;
                continue block0;
            }
        }
        this.scanNodesForRecursion(cell, recursiveSetupFlag, this.nodeInstList.protoType, startNode, endNode);
        progress.setProgress(++cellsConstructed * 100 / totalCells);
        if (!$assertionsDisabled && !(this.cellLambda[cellIndex] > 0.0)) {
            throw new AssertionError();
        }
        double lambdaY = lambdaX = this.cellLambda[cellIndex];
        NodeInst[] oldNodes = null;
        if (scaledCellName != null) {
            Cell oldCell = cell;
            cell = Cell.lowLevelAllocate(cell.getLibrary());
            cell.lowLevelPopulate(scaledCellName);
            cell.lowLevelLink();
            cell.setTempInt(cellIndex);
            cell.setBit(recursiveSetupFlag);
            cell.joinGroup(oldCell);
            if (scaleX != scaleY) {
                this.skewedCells.add(cell);
            } else {
                this.scaledCells.add(cell);
            }
            lambdaX /= scaleX;
            lambdaY /= scaleY;
            oldNodes = new NodeInst[endNode - startNode];
            j = 0;
            for (int i3 = startNode; i3 < endNode; ++i3) {
                oldNodes[j] = this.nodeInstList.theNode[i3];
                this.nodeInstList.theNode[i3] = NodeInst.lowLevelAllocate();
                ++j;
            }
        } else {
            scaleY = 1.0;
            scaleX = 1.0;
        }
        int xoff = 0;
        int yoff = 0;
        for (i = startNode; i < endNode; ++i) {
            if (this.nodeInstList.protoType[i] != Generic.tech.cellCenterNode) continue;
            this.realizeNode(i, xoff, yoff, lambdaX, lambdaY, cell, recursiveSetupFlag);
            xoff = (this.nodeInstList.lowX[i] + this.nodeInstList.highX[i]) / 2;
            yoff = (this.nodeInstList.lowY[i] + this.nodeInstList.highY[i]) / 2;
            break;
        }
        this.cellXOff[cellIndex] = xoff;
        this.cellYOff[cellIndex] = yoff;
        for (i = startNode; i < endNode; ++i) {
            if (this.nodeInstList.protoType[i] == Generic.tech.cellCenterNode) continue;
            this.realizeNode(i, xoff, yoff, lambdaX, lambdaY, cell, recursiveSetupFlag);
        }
        this.realizeExports(cell, cellIndex, scaledCellName);
        this.realizeArcs(cell, cellIndex, scaledCellName, scaleX, scaleY);
        if (scaledCellName != null) {
            int j2 = 0;
            for (int i4 = startNode; i4 < endNode; ++i4) {
                this.nodeInstList.theNode[i4] = oldNodes[j2++];
            }
        }
    }

    protected boolean spreadLambda(Cell cell, int cellIndex) {
        boolean changed = false;
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        double thisLambda = this.cellLambda[cellIndex];
        for (int i = startNode; i < endNode; ++i) {
            int subCellIndex;
            double subLambda;
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getVar(IO_DUMMY_OBJECT) != null) continue;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib && (reader = this.getReaderForLib(subCell.getLibrary())) == null || !((subLambda = reader.cellLambda[subCellIndex = subCell.getTempInt()]) < thisLambda)) continue;
            reader.cellLambda[subCellIndex] = thisLambda;
            changed = true;
        }
        return changed;
    }

    protected double computeLambda(Cell cell, int cellIndex) {
        double lambda = 1.0;
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        Technology cellTech = Technology.whatTechnology(cell, this.nodeInstList.protoType, startNode, endNode, this.arcTypeList, startArc, endArc);
        cell.setTechnology(cellTech);
        if (cellTech != null) {
            lambda = this.techScale[cellTech.getIndex()];
        }
        return lambda;
    }

    protected boolean canScale() {
        return true;
    }

    private void realizeExports(Cell cell, int cellIndex, String scaledCellName) {
        int startPort = this.firstPortIndex[cellIndex];
        int endPort = startPort + this.portCounts[cellIndex];
        for (int i = startPort; i < endPort; ++i) {
            int nodeIndex;
            if (!(this.portProtoList[i] instanceof Export)) {
                if (cell.getVar(IO_DUMMY_OBJECT) != null) continue;
                System.out.println("ERROR: Cell " + cell.describe() + ": export " + this.portProtoNameList[i] + " is unresolved");
                continue;
            }
            Export pp = (Export)this.portProtoList[i];
            if (scaledCellName != null) {
                String oldName = pp.getName();
                pp = Export.lowLevelAllocate();
                pp.lowLevelName(cell, oldName);
            }
            if ((nodeIndex = this.portProtoSubNodeList[i]) < 0) {
                System.out.println("ERROR: Cell " + cell.describe() + ": cannot find the node on which export " + pp.getName() + " resides");
                continue;
            }
            NodeInst subNodeInst = this.nodeInstList.theNode[nodeIndex];
            if (this.portProtoSubPortList[i] instanceof Integer) {
                int index = (Integer)this.portProtoSubPortList[i];
                this.portProtoSubPortList[i] = this.convertPortProto(index);
            }
            PortProto subPortProto = (PortProto)this.portProtoSubPortList[i];
            if (subNodeInst == null || subPortProto == null) {
                System.out.println("ERROR: Cell " + cell.describe() + ": export " + this.portProtoNameList[i] + " could not be created");
                continue;
            }
            if (subNodeInst.getProto() == null) {
                System.out.println("ERROR: Cell " + cell.describe() + ": export " + this.portProtoNameList[i] + " could not be created...proto bad!");
                continue;
            }
            String exportName = this.portProtoNameList[i];
            PortInst pi = subNodeInst.findPortInst(subPortProto.getName());
            if (pp.lowLevelPopulate(pi)) {
                return;
            }
            if (pp.lowLevelLink(null)) {
                return;
            }
            pp.lowLevelSetUserbits(this.portProtoUserbits[i]);
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        for (int i = startNode; i < endNode; ++i) {
            NodeInst ni = this.nodeInstList.theNode[i];
            boolean found = true;
            block2: while (found) {
                found = false;
                Iterator it = ni.getVariables();
                while (it.hasNext()) {
                    String thePortName;
                    PortInst pi;
                    Variable origVar = (Variable)it.next();
                    Variable.Key origVarKey = origVar.getKey();
                    String origVarName = origVarKey.getName();
                    if (!origVarName.startsWith("ATTRP_")) continue;
                    StringBuffer portName = new StringBuffer();
                    String varName = null;
                    int len = origVarName.length();
                    for (int j = 6; j < len; ++j) {
                        char ch = origVarName.charAt(j);
                        if (ch == '\\') {
                            portName.append(origVarName.charAt(++j));
                            continue;
                        }
                        if (ch == '_') {
                            varName = origVarName.substring(j + 1);
                            break;
                        }
                        portName.append(ch);
                    }
                    if (varName == null || (pi = ni.findPortInst(thePortName = portName.toString())) == null) continue;
                    Variable var = pi.newVar(varName, origVar.getObject());
                    if (var != null) {
                        if (origVar.isDisplay()) {
                            var.setDisplay(true);
                        }
                        var.setCode(origVar.getCode());
                        var.setTextDescriptor(origVar.getTextDescriptor());
                    }
                    ni.delVar(origVarKey);
                    found = true;
                    continue block2;
                }
            }
        }
    }

    private void realizeArcs(Cell cell, int cellIndex, String scaledCellName, double scaleX, double scaleY) {
        double lambdaX = this.cellLambda[cellIndex] / scaleX;
        double lambdaY = this.cellLambda[cellIndex] / scaleY;
        int xoff = this.cellXOff[cellIndex];
        int yoff = this.cellYOff[cellIndex];
        boolean arcInfoError = false;
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        for (int i = startArc; i < endArc; ++i) {
            Connection con;
            ArcInst ai = this.arcList[i];
            if (scaledCellName != null) {
                ai = ArcInst.lowLevelAllocate();
            }
            ArcProto ap = this.arcTypeList[i];
            Name name = this.arcNameList[i];
            double width = (double)this.arcWidthList[i] / lambdaX;
            double headX = (double)(this.arcHeadXPosList[i] - xoff) / lambdaX;
            double headY = (double)(this.arcHeadYPosList[i] - yoff) / lambdaY;
            double tailX = (double)(this.arcTailXPosList[i] - xoff) / lambdaX;
            double tailY = (double)(this.arcTailYPosList[i] - yoff) / lambdaY;
            if (this.arcHeadNodeList[i] < 0) {
                System.out.println("ERROR: head of arc " + ap.describe() + " not known");
                continue;
            }
            NodeInst headNode = this.nodeInstList.theNode[this.arcHeadNodeList[i]];
            Object headPort = this.arcHeadPortList[i];
            int headPortIntValue = -1;
            String headname = "Port name not found";
            if (headPort instanceof Integer) {
                headPortIntValue = (Integer)headPort;
                headPort = this.convertPortProto(headPortIntValue);
            }
            if (headPort != null) {
                headname = ((PortProto)headPort).getName();
            } else if (headPortIntValue >= 0 && headPortIntValue < this.portProtoNameList.length) {
                headname = this.portProtoNameList[headPortIntValue];
            }
            if (this.arcTailNodeList[i] < 0) {
                System.out.println("ERROR: tail of arc " + ap.describe() + " not known");
                continue;
            }
            NodeInst tailNode = this.nodeInstList.theNode[this.arcTailNodeList[i]];
            Object tailPort = this.arcTailPortList[i];
            int tailPortIntValue = -1;
            String tailname = "Port name not found";
            if (tailPort instanceof Integer) {
                tailPortIntValue = (Integer)tailPort;
                tailPort = this.convertPortProto(tailPortIntValue);
                if (tailPortIntValue > 0 && tailPortIntValue < this.portProtoNameList.length) {
                    tailname = this.portProtoNameList[tailPortIntValue];
                }
            }
            if (tailPort != null) {
                tailname = ((PortProto)tailPort).getName();
            } else if (tailPortIntValue >= 0 && tailPortIntValue < this.portProtoNameList.length) {
                tailname = this.portProtoNameList[tailPortIntValue];
            }
            PortInst headPortInst = this.getArcEnd(ai, ap, headNode, headname, headX, headY, cell);
            PortInst tailPortInst = this.getArcEnd(ai, ap, tailNode, tailname, tailX, tailY, cell);
            if (headPortInst == null || tailPortInst == null) {
                System.out.println("Cannot create arc of type " + ap.getName() + " in cell " + cell.getName() + " because ends are unknown");
                continue;
            }
            ai.lowLevelSetUserbits(this.arcUserBits[i]);
            int defAngle = ai.lowLevelGetArcAngle() * 10;
            ai.lowLevelPopulate(ap, width, tailPortInst, new Point2D.Double(tailX, tailY), headPortInst, new Point2D.Double(headX, headY), defAngle);
            if (name != null) {
                ai.setNameKey(name);
            }
            if ((this.arcUserBits[i] & 0x40000) != 0) {
                con = ai.getTail();
                if (ai.isReverseEnds()) {
                    con = ai.getHead();
                }
                con.setNegated(true);
            }
            if ((this.arcUserBits[i] & 0x10000) != 0) {
                con = ai.getHead();
                if (ai.isReverseEnds()) {
                    con = ai.getTail();
                }
                con.setNegated(true);
            }
            ai.lowLevelLink();
        }
    }

    private void realizeNode(int i, int xoff, int yoff, double lambdaX, double lambdaY, Cell cell, FlagSet recursiveSetupFlag) {
        Rectangle2D bounds;
        NodeInst ni = this.nodeInstList.theNode[i];
        NodeProto np = this.nodeInstList.protoType[i];
        Name name = this.nodeInstList.name[i];
        double lowX = this.nodeInstList.lowX[i] - xoff;
        double lowY = this.nodeInstList.lowY[i] - yoff;
        double highX = this.nodeInstList.highX[i] - xoff;
        double highY = this.nodeInstList.highY[i] - yoff;
        Point2D.Double center = new Point2D.Double((lowX + highX) / 2.0 / lambdaX, (lowY + highY) / 2.0 / lambdaY);
        double width = (highX - lowX) / lambdaX;
        double height = (highY - lowY) / lambdaY;
        double anchorX = (double)(this.nodeInstList.anchorX[i] - xoff) / lambdaX;
        double anchorY = (double)(this.nodeInstList.anchorY[i] - yoff) / lambdaY;
        if (np instanceof Cell) {
            Cell subCell = (Cell)np;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib) {
                reader = this.getReaderForLib(subCell.getLibrary());
            }
            if (((bounds = subCell.getBounds()).getWidth() != width || bounds.getHeight() != height) && reader != null && reader.canScale()) {
                if (Math.abs(bounds.getWidth() - width) > 0.5 || Math.abs(bounds.getHeight() - height) > 0.5) {
                    double scaleX = width / bounds.getWidth();
                    double scaleY = height / bounds.getHeight();
                    String scaledCellName = subCell.getName() + "-SCALED-BY-" + scaleX + "{" + subCell.getView().getAbbreviation() + "}";
                    if (!GenMath.doublesClose(scaleX, scaleY)) {
                        scaledCellName = subCell.getName() + "-SCALED-BY-" + scaleX + "-AND-" + scaleY + "{" + subCell.getView().getAbbreviation() + "}";
                    } else {
                        Cell scaledCell = subCell.getLibrary().findNodeProto(scaledCellName);
                        if (scaledCell == null) {
                            if (reader != null) {
                                reader.realizeCellsRecursively(subCell, recursiveSetupFlag, scaledCellName, scaleX, scaleY);
                            }
                            if ((scaledCell = subCell.getLibrary().findNodeProto(scaledCellName)) == null) {
                                System.out.println("Error scaling cell " + subCell.describe() + " by " + scaleX);
                            }
                        }
                        if (scaledCell != null) {
                            bounds = scaledCell.getBounds();
                            np = scaledCell;
                        }
                        if (Math.abs(bounds.getWidth() - width) > 0.5 || Math.abs(bounds.getHeight() - height) > 0.5) {
                            Cell dummyCell = null;
                            if (dummyCell == null) {
                                System.out.println("Cell " + cell.describe() + ": adjusting size of instance of " + subCell.describe() + " (cell is " + bounds.getWidth() + "x" + bounds.getHeight() + " but instance is " + width + "x" + height + ")");
                            } else {
                                np = dummyCell;
                                bounds = dummyCell.getBounds();
                            }
                        }
                    }
                }
                width = bounds.getWidth();
                height = bounds.getHeight();
            }
        }
        int rotation = this.nodeInstList.rotation[i];
        if (this.rotationMirrorBits) {
            if ((this.nodeInstList.transpose[i] & 1) != 0) {
                height = -height;
                rotation = (rotation + 900) % 3600;
            }
            if ((this.nodeInstList.transpose[i] & 2) != 0) {
                width = -width;
            }
            if ((this.nodeInstList.transpose[i] & 4) != 0) {
                height = -height;
            }
        } else if (this.nodeInstList.transpose[i] != 0) {
            height = -height;
            rotation = (rotation + 900) % 3600;
        }
        if (np instanceof Cell) {
            Cell subCell = (Cell)np;
            bounds = subCell.getBounds();
            Point2D.Double shift = new Point2D.Double(-bounds.getCenterX(), -bounds.getCenterY());
            AffineTransform trans = NodeInst.pureRotate(rotation, width < 0.0, height < 0.0);
            trans.transform(shift, shift);
            if (this.header.magic <= -1597) {
                ((Point2D)center).setLocation(anchorX, anchorY);
            } else {
                ((Point2D)center).setLocation(((Point2D)center).getX() + ((Point2D)shift).getX(), ((Point2D)center).getY() + ((Point2D)shift).getY());
            }
        }
        this.scaleOutlineInformation(ni, np, lambdaX, lambdaY);
        ni.lowLevelSetUserbits(this.nodeInstList.userBits[i]);
        ni.lowLevelPopulate(np, center, width, height, rotation, cell);
        if (name != null) {
            ni.setNameKey(name);
        }
        ni.lowLevelLink();
        if (np instanceof Cell && ((Cell)np).getVar(IO_DUMMY_OBJECT) != null) {
            ErrorLogger.MessageLog error = Input.errorLogger.logError("Instance of dummy cell " + np.getName(), cell, 1);
            error.addGeom(ni, true, cell, null);
        }
    }

    protected boolean readerHasExport(Cell c, String portName) {
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            if (cell != c) continue;
            int startPort = this.firstPortIndex[cellIndex];
            int endPort = startPort + this.portCounts[cellIndex];
            for (int i = startPort; i < endPort; ++i) {
                String exportName = this.portProtoNameList[i];
                if (!exportName.equalsIgnoreCase(portName)) continue;
                return true;
            }
            break;
        }
        return false;
    }

    protected PortInst getArcEnd(ArcInst ai, ArcProto ap, NodeInst node, String portname, double x, double y, Cell cell) {
        PortInst pi = null;
        String whatHappenedToPort = "not found";
        String nodeName = "missing node";
        if (node != null) {
            pi = node.findPortInst(portname);
            nodeName = node.getName();
            if (pi != null) {
                Poly portLocation = pi.getPoly();
                String extra = "";
                if (portLocation.contains(x, y) || portLocation.polyDistance(x, y) < TINYDISTANCE) {
                    return pi;
                }
                Rectangle2D box = portLocation.getBox();
                extra = box != null ? "...expected (" + x + "," + y + "), found (" + box.getCenterX() + "," + box.getCenterY() + ")" : "...expected (" + x + "," + y + "), polyDistance=" + portLocation.polyDistance(x, y);
                whatHappenedToPort = "has moved" + extra;
                pi = null;
            } else {
                Iterator it = node.getPortInsts();
                while (it.hasNext()) {
                    pi = (PortInst)it.next();
                    Poly portLocation = pi.getPoly();
                    if (portLocation.contains(x, y) && pi.getPortProto().connectsTo(ap)) {
                        String msg = "Cell " + cell.describe() + ": Port '" + portname + "' on '" + nodeName + "' not found, connecting to port '" + pi.getPortProto().getName() + "' at the same location";
                        System.out.println("ERROR: " + msg);
                        ErrorLogger.MessageLog error = Input.errorLogger.logError(msg, cell, 0);
                        error.addGeom(ai, true, cell, null);
                        return pi;
                    }
                    pi = null;
                }
                whatHappenedToPort = "is missing";
            }
            Cell c = null;
            if (node.getProto() != null && node.getProto() instanceof Cell && ((Cell)node.getProto()).getVar(IO_DUMMY_OBJECT) != null) {
                c = (Cell)node.getProto();
            }
            if (c != null) {
                double anchorX = node.getAnchorCenterX();
                double anchorY = node.getAnchorCenterY();
                Point2D expected = new Point2D.Double(x, y);
                PrimitiveNode pn = Generic.tech.universalPinNode;
                AffineTransform trans = node.rotateIn();
                expected = trans.transform(expected, expected);
                Point2D.Double center = new Point2D.Double(expected.getX() - anchorX, expected.getY() - anchorY);
                NodeInst ni = NodeInst.newInstance(pn, center, 0.0, 0.0, c, 0, "", 0);
                Export ex = Export.newInstance(c, ni.getOnlyPortInst(), portname, false);
                if (ex != null) {
                    return node.findPortInst(portname);
                }
            }
        }
        String msg = "Cell " + cell.describe() + ": Port '" + portname + "' on '" + nodeName + "' " + whatHappenedToPort + ": leaving arc disconnected";
        System.out.println("ERROR: " + msg);
        ErrorLogger.MessageLog error = Input.errorLogger.logError(msg, cell, 0);
        error.addGeom(ai, true, cell, null);
        PrimitiveNode pn = ((PrimitiveArc)ap).findOverridablePinProto();
        node = NodeInst.newInstance(pn, new Point2D.Double(x, y), pn.getDefWidth(), pn.getDefHeight(), cell);
        error.addGeom(node, true, cell, null);
        return node.getOnlyPortInst();
    }

    private Header readHeader() throws IOException {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        byte byte1 = this.readByte();
        byte byte2 = this.readByte();
        byte byte3 = this.readByte();
        byte byte4 = this.readByte();
        int magic = (byte4 & 0xFF) << 24 | (byte3 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte1 & 0xFF;
        if (magic != -1573 && magic != -1575 && magic != -1577 && magic != -1579 && magic != -1581 && magic != -1583 && magic != -1585 && magic != -1587 && magic != -1589 && magic != -1591 && magic != -1593 && magic != -1595 && magic != -1597) {
            magic = (byte1 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
            if (magic != -1573 && magic != -1575 && magic != -1577 && magic != -1579 && magic != -1581 && magic != -1583 && magic != -1585 && magic != -1587 && magic != -1589 && magic != -1591 && magic != -1593 && magic != -1595 && magic != -1597) {
                System.out.println("Bad file format: does not start with proper magic number");
                return null;
            }
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        int sizeOfBig = 4;
        int sizeOfSmall = 2;
        byte sizeOfChar = 1;
        if (magic <= -1591) {
            sizeOfSmall = this.readByte();
            sizeOfBig = this.readByte();
        }
        if (magic <= -1593) {
            sizeOfChar = this.readByte();
        }
        return new Header(magic, byteOrder, sizeOfBig, sizeOfSmall, sizeOfChar);
    }

    private boolean readNodeProto(Cell cell, int cellIndex, HashMap nextInCellGroup, LibraryStatistics stat) throws IOException {
        String theProtoName;
        if (this.header.magic <= -1589) {
            int k;
            if (this.header.magic >= -1593) {
                k = this.readBigInteger();
                theProtoName = this.fakeCellList[k].cellName;
            } else {
                theProtoName = this.convertCellName(this.readString());
                k = this.readBigInteger();
                if (k == -1) {
                    for (int i = 0; i < this.nodeProtoList.length; ++i) {
                        if (cell != this.nodeProtoList[i]) continue;
                        k = i;
                        break;
                    }
                }
                k = this.readBigInteger();
            }
            this.readBigInteger();
            int version = this.readBigInteger();
            int creationDate = this.readBigInteger();
            int revisionDate = this.readBigInteger();
        } else {
            theProtoName = this.readString();
        }
        int lowX = this.readBigInteger();
        int highX = this.readBigInteger();
        int lowY = this.readBigInteger();
        int highY = this.readBigInteger();
        if (this.header.magic >= -1581) {
            int prevIndex = this.readBigInteger();
            int nextIndex = this.readBigInteger();
        }
        this.firstPortIndex[cellIndex] = this.portProtoIndex;
        int portCount = this.readBigInteger();
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (int j = 0; j < portCount; ++j) {
            String exportName;
            Export pp = (Export)this.portProtoList[this.portProtoIndex];
            this.portProtoSubNodeList[this.portProtoIndex] = -1;
            int whichNode = this.readBigInteger();
            if (whichNode >= 0 && whichNode < this.nodeCount) {
                this.portProtoSubNodeList[this.portProtoIndex] = whichNode;
            }
            this.portProtoSubPortList[this.portProtoIndex] = null;
            int whichPort = this.readBigInteger();
            this.portProtoNameList[this.portProtoIndex] = exportName = this.readString();
            if (this.portProtoSubNodeList[this.portProtoIndex] == -1) {
                System.out.println("Error: Export '" + exportName + "' of cell " + theProtoName + " cannot be read properly");
            }
            int descript0 = 0;
            int descript1 = 0;
            if (this.header.magic <= -1589) {
                if (this.convertTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = 0;
                } else {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                }
            }
            if (stat != null) {
                stat.varStat.addVarDesc("", 0, descript0, descript1, "e");
            }
            if (this.header.magic > -1589) {
                this.readBigInteger();
            }
            this.portProtoUserbits[this.portProtoIndex] = 0;
            if (this.header.magic <= -1585) {
                this.portProtoUserbits[this.portProtoIndex] = this.readBigInteger();
                if (this.header.magic >= -1587) {
                    this.readBigInteger();
                }
            } else {
                if (this.toolBCount >= 1) {
                    this.portProtoUserbits[this.portProtoIndex] = this.readBigInteger();
                }
                for (int i = 1; i < this.toolBCount; ++i) {
                    this.readBigInteger();
                }
            }
            if (stat != null) {
                stat.varStat.addUserBits(this.portProtoUserbits[this.portProtoIndex], "E");
            }
            this.readVariables(stat, "E");
            ++this.portProtoIndex;
        }
        if (this.header.magic > -1581) {
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
        }
        int dirty = this.readBigInteger();
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.header.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        if (stat != null) {
            stat.varStat.addUserBits(userBits, "C");
        }
        this.readVariables(stat, "C");
        return false;
    }

    private boolean readExternalNodeProto(Library lib, int cellIndex, LibraryStatistics stat) throws IOException {
        int j;
        String theProtoName;
        int k;
        if (this.header.magic >= -1593) {
            k = this.readBigInteger();
            theProtoName = this.fakeCellList[k].cellName;
        } else {
            theProtoName = this.convertCellName(this.readString());
            k = this.readBigInteger();
            k = this.readBigInteger();
        }
        this.readBigInteger();
        int version = this.readBigInteger();
        Date creationDate = ELIBConstants.secondsToDate(this.readBigInteger());
        Date revisionDate = ELIBConstants.secondsToDate(this.readBigInteger());
        int lowX = this.readBigInteger();
        int highX = this.readBigInteger();
        int lowY = this.readBigInteger();
        int highY = this.readBigInteger();
        String elibName = this.readString();
        int portCount = this.readBigInteger();
        String[] localPortNames = new String[portCount];
        for (j = 0; j < portCount; ++j) {
            localPortNames[j] = this.readString();
        }
        this.firstPortIndex[cellIndex] = this.portProtoIndex;
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (j = 0; j < portCount; ++j) {
            String protoName;
            this.portProtoNameList[this.portProtoIndex] = protoName = localPortNames[j];
            ++this.portProtoIndex;
        }
        return false;
    }

    private boolean readNodeInst(int nodeIndex, int cellIndex, LibraryStatistics stat) throws IOException {
        String instName;
        Cell parent = this.nodeProtoList[cellIndex];
        NodeInst ni = this.nodeInstList.theNode[nodeIndex];
        int protoIndex = this.readBigInteger();
        this.nodeInstList.lowX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.lowY[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highY[nodeIndex] = this.readBigInteger();
        if (this.header.magic <= -1597 && protoIndex >= 0) {
            this.nodeInstList.anchorX[nodeIndex] = this.readBigInteger();
            this.nodeInstList.anchorY[nodeIndex] = this.readBigInteger();
        }
        this.nodeInstList.transpose[nodeIndex] = this.readBigInteger();
        this.nodeInstList.rotation[nodeIndex] = (short)this.readBigInteger();
        this.nodeInstList.name[nodeIndex] = null;
        int descript0 = 0;
        int descript1 = 0;
        if (this.header.magic <= -1589) {
            if (this.convertTextDescriptors) {
                descript0 = this.readBigInteger();
            } else {
                descript0 = this.readBigInteger();
                descript1 = this.readBigInteger();
            }
        }
        if (stat != null) {
            stat.varStat.addVarDesc("", 0, descript0, descript1, protoIndex >= 0 ? "i" : "n");
        }
        if (this.header.magic >= -1577 && (instName = this.readString()).length() > 0) {
            ni.setName(instName);
        }
        if (this.header.magic > -1581) {
            this.readBigInteger();
        }
        int numPorts = this.readBigInteger();
        for (int j = 0; j < numPorts; ++j) {
            int k = this.readBigInteger();
            int arcIndex = k >> 1;
            if (k < 0 || arcIndex >= this.arcCount) {
                return true;
            }
            int portIndex = this.readBigInteger();
            this.readVariables(stat, "t");
        }
        int numExports = this.readBigInteger();
        for (int j = 0; j < numExports; ++j) {
            this.readBigInteger();
            this.readBigInteger();
            this.readVariables(stat, "x");
        }
        if (this.header.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        this.nodeInstList.userBits[nodeIndex] = userBits;
        if (stat != null) {
            stat.varStat.addUserBits(userBits, protoIndex >= 0 ? "I" : "N");
        }
        this.readVariables(stat, protoIndex >= 0 ? "I" : "N");
        return false;
    }

    private boolean readArcInst(int arcIndex, LibraryStatistics stat) throws IOException {
        String instName;
        ArcInst ai = this.arcList[arcIndex];
        int protoIndex = this.readBigInteger();
        if (this.header.magic >= -1581) {
            this.readBigInteger();
        }
        this.arcWidthList[arcIndex] = this.readBigInteger();
        if (this.header.magic <= -1583 && this.header.magic >= -1587) {
            this.readBigInteger();
        }
        if (this.header.magic >= -1577 && (instName = this.readString()).length() > 0) {
            ai.setName(instName);
        }
        this.arcHeadXPosList[arcIndex] = this.readBigInteger();
        this.arcHeadYPosList[arcIndex] = this.readBigInteger();
        int nodeIndex = this.readBigInteger();
        if (nodeIndex >= 0 && nodeIndex < this.nodeCount) {
            this.arcHeadNodeList[arcIndex] = nodeIndex;
        }
        this.arcTailXPosList[arcIndex] = this.readBigInteger();
        this.arcTailYPosList[arcIndex] = this.readBigInteger();
        nodeIndex = this.readBigInteger();
        if (nodeIndex >= 0 && nodeIndex < this.nodeCount) {
            this.arcTailNodeList[arcIndex] = nodeIndex;
        }
        if (this.header.magic > -1581) {
            this.readBigInteger();
        }
        if (this.header.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.header.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        this.arcUserBits[arcIndex] = userBits;
        if (stat != null) {
            stat.varStat.addUserBits(userBits, "A");
        }
        this.readVariables(stat, "A");
        return false;
    }

    private void readGeom(boolean[] isNode, int[] moreup, int index) throws IOException {
        int type = this.readBigInteger();
        isNode[index] = type != 0;
        if (isNode[index]) {
            this.readBigInteger();
        }
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        moreup[index] = this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.ignoreVariables();
    }

    private boolean readNameSpace() throws IOException {
        this.nameCount = this.readBigInteger();
        if (this.nameCount == 0) {
            return false;
        }
        this.varKeys = new LibraryContents.VariableKeyRef[this.nameCount];
        for (int i = 0; i < this.nameCount; ++i) {
            this.varKeys[i] = this.libraryContents.newVariableKeyRef(this.readString());
        }
        return false;
    }

    private int readVariables(ElectricObject obj, int index) throws IOException {
        int count = this.readBigInteger();
        for (int i = 0; i < count; ++i) {
            Object[] newAddr;
            short key = this.readSmallInteger();
            int newtype = this.readBigInteger();
            boolean definedDescript = false;
            int descript0 = 0;
            int descript1 = 0;
            if (this.header.magic <= -1589) {
                if (this.alwaysTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                    definedDescript = true;
                } else if ((newtype & 0x40) != 0) {
                    if (this.convertTextDescriptors) {
                        descript0 = this.readBigInteger();
                    } else {
                        descript0 = this.readBigInteger();
                        descript1 = this.readBigInteger();
                    }
                    definedDescript = true;
                }
            }
            if (!definedDescript) {
                // empty if block
            }
            if ((newtype & 0x80) != 0) {
                int j;
                int len;
                int cou = len = this.readBigInteger();
                if ((newtype & 0x1FFFFE00) == 0) {
                    ++cou;
                }
                Object[] newAddrArray = null;
                switch (newtype & 0x1F) {
                    case 1: 
                    case 2: {
                        newAddrArray = new Integer[cou];
                        break;
                    }
                    case 5: 
                    case 19: {
                        newAddrArray = new Float[cou];
                        break;
                    }
                    case 6: {
                        newAddrArray = new Double[cou];
                        break;
                    }
                    case 25: {
                        newAddrArray = new Short[cou];
                        break;
                    }
                    case 3: 
                    case 30: {
                        newAddrArray = new Byte[cou];
                        break;
                    }
                    case 4: {
                        newAddrArray = new String[cou];
                        break;
                    }
                    case 7: {
                        newAddrArray = new NodeInst[cou];
                        break;
                    }
                    case 8: {
                        newAddrArray = new NodeProto[cou];
                        break;
                    }
                    case 13: {
                        newAddrArray = new ArcProto[cou];
                        break;
                    }
                    case 11: {
                        newAddrArray = new PortProto[cou];
                        break;
                    }
                    case 12: {
                        newAddrArray = new ArcInst[cou];
                        break;
                    }
                    case 16: {
                        newAddrArray = new Technology[cou];
                        break;
                    }
                    case 15: {
                        newAddrArray = new Library[cou];
                        break;
                    }
                    case 17: {
                        newAddrArray = new Tool[cou];
                    }
                }
                if (newAddrArray == null) {
                    System.out.println("Cannot figure out the type for code " + (newtype & 0x1F));
                }
                newAddr = newAddrArray;
                if ((newtype & 0x1F) == 27) {
                    for (j = 0; j < len; j += 2) {
                        int type = this.readBigInteger();
                        int addr = this.readBigInteger();
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = null;
                    }
                } else {
                    for (j = 0; j < len; ++j) {
                        Object ret = this.getInVar(newtype);
                        if (ret == null) {
                            System.out.println("Error reading array variable type");
                            return -1;
                        }
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = ret;
                    }
                }
            } else {
                newAddr = this.getInVar(newtype);
                if (newAddr == null) {
                    System.out.println("Error reading variable type " + newtype);
                    return -1;
                }
            }
            if (key < 0 || key >= this.nameCount) {
                System.out.println("Bad variable index (" + key + ", limit is " + this.nameCount + ") on " + obj + " object");
                return -1;
            }
            if (newAddr instanceof String && (obj instanceof NodeInst && this.varKeys[key].getVariableKey() == NodeInst.NODE_NAME || obj instanceof ArcInst && this.varKeys[key].getVariableKey() == ArcInst.ARC_NAME)) {
                Geometric geom = (Geometric)obj;
                TextDescriptor nameDescript = new TextDescriptor(null, descript0, descript1, 0);
                Input.fixTextDescriptorFont(nameDescript);
                geom.setNameTextDescriptor(nameDescript);
                Name name = this.makeGeomName(geom, newAddr, newtype);
                if (obj instanceof NodeInst) {
                    this.nodeInstList.name[index] = name;
                    continue;
                }
                this.arcNameList[index] = name;
                continue;
            }
            Variable.Key varKey = this.varKeys[key].getVariableKey();
            if (obj.isDeprecatedVariable(varKey)) continue;
            Variable var = obj.newVar(varKey, (Object)newAddr);
            if (var == null) {
                System.out.println("Error reading variable");
                return -1;
            }
            var.setTextDescriptor(new TextDescriptor(null, descript0, descript1, 0));
            var.lowLevelSetFlags(newtype);
        }
        return count;
    }

    private LibraryContents.VariableContents[] readVariables(LibraryStatistics stat, String role) throws IOException {
        int count = this.readBigInteger();
        LibraryContents.VariableContents[] vars = new LibraryContents.VariableContents[count];
        for (int i = 0; i < count; ++i) {
            short key = this.readSmallInteger();
            int newtype = this.readBigInteger();
            if ((newtype & 0x1F) == 7) {
                System.out.println("VNODEINST in " + this.filePath);
            }
            if ((newtype & 0x1F) == 8) {
                System.out.println("VNODEPROTO in " + this.filePath);
            }
            boolean definedDescript = false;
            int descript0 = 0;
            int descript1 = 0;
            if (this.header.magic <= -1589) {
                if (this.alwaysTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                    definedDescript = true;
                } else if ((newtype & 0x40) != 0) {
                    if (this.convertTextDescriptors) {
                        descript0 = this.readBigInteger();
                    } else {
                        descript0 = this.readBigInteger();
                        descript1 = this.readBigInteger();
                    }
                    definedDescript = true;
                }
            }
            if (stat != null) {
                stat.varStat.addVarDesc(this.varKeys[key].getName(), newtype, descript0, descript1, role);
            }
            if (!definedDescript) {
                // empty if block
            }
            char typeChar = '?';
            String valString = "";
            switch (newtype & 0x1F) {
                case 1: 
                case 2: {
                    typeChar = 'I';
                    break;
                }
                case 5: 
                case 19: {
                    typeChar = 'F';
                    break;
                }
                case 6: {
                    typeChar = 'D';
                    break;
                }
                case 25: {
                    typeChar = 'S';
                    break;
                }
                case 30: {
                    typeChar = 'B';
                    break;
                }
                case 3: {
                    typeChar = 'C';
                    break;
                }
                case 4: {
                    typeChar = 'S';
                    break;
                }
                case 7: {
                    typeChar = 'N';
                    break;
                }
                case 8: {
                    typeChar = 'C';
                    break;
                }
                case 13: {
                    typeChar = 'R';
                    break;
                }
                case 11: {
                    typeChar = 'E';
                    break;
                }
                case 12: {
                    typeChar = 'A';
                    break;
                }
                case 16: {
                    typeChar = 'T';
                    break;
                }
                case 15: {
                    typeChar = 'L';
                    break;
                }
                case 17: {
                    typeChar = 'O';
                }
            }
            if ((newtype & 0x80) != 0) {
                int j;
                int len = this.readBigInteger();
                valString = "[]";
                if ((newtype & 0x1F) == 27) {
                    for (j = 0; j < len; j += 2) {
                        int type = this.readBigInteger();
                        int addr = this.readBigInteger();
                    }
                } else {
                    for (j = 0; j < len; ++j) {
                        Object ret = this.getInVar(newtype);
                    }
                }
            } else {
                Object newAddr = this.getInVar(newtype);
            }
            if (key < 0 || key >= this.nameCount) {
                System.out.println("Bad variable index (" + key + ", limit is " + this.nameCount + ")");
                continue;
            }
            vars[i] = this.libraryContents.newVariableContents(this.varKeys[key], "", typeChar, valString);
        }
        return vars;
    }

    private void ignoreVariables() throws IOException {
        this.readVariables(null, null);
    }

    private int readMeaningPrefs(Object obj) throws IOException {
        int count = this.readBigInteger();
        for (int i = 0; i < count; ++i) {
            short key = this.readSmallInteger();
            int newtype = this.readBigInteger();
            if (this.header.magic <= -1589) {
                if (this.alwaysTextDescriptors) {
                    this.readBigInteger();
                    this.readBigInteger();
                } else if ((newtype & 0x40) != 0) {
                    if (this.convertTextDescriptors) {
                        this.readBigInteger();
                    } else {
                        this.readBigInteger();
                        this.readBigInteger();
                    }
                }
            }
            if ((newtype & 0x80) != 0) {
                int len = this.readBigInteger();
                if ((newtype & 0x1F) == 27) {
                    for (int j = 0; j < len; j += 2) {
                        this.readBigInteger();
                        this.readBigInteger();
                    }
                    continue;
                }
                for (int j = 0; j < len; ++j) {
                    this.getInVar(newtype);
                }
                continue;
            }
            Object value = this.getInVar(newtype);
            if (value == null) {
                System.out.println("Error reading variable type " + newtype);
                return -1;
            }
            if (key < 0 || key >= this.nameCount) {
                System.out.println("Bad variable index (" + key + ", limit is " + this.nameCount + ") on " + obj + " object");
                return -1;
            }
            if (!(value instanceof Integer) && !(value instanceof Float) && !(value instanceof Double) && !(value instanceof String) || !this.topLevelLibrary) continue;
            String varName = this.varKeys[key].getName();
            Pref.Meaning meaning = Pref.getMeaningVariable(obj, varName);
            if (meaning != null) {
                Pref.changedMeaningVariable(meaning, value);
                continue;
            }
            if (!(obj instanceof Technology)) continue;
            ((Technology)obj).convertOldVariable(varName, value);
        }
        return count;
    }

    private void fixExternalVariables(ElectricObject obj) {
    }

    private Object getInVar(int ty) throws IOException {
        if ((ty & 0x20000020) != 0) {
            ty = 4;
        }
        switch (ty & 0x1F) {
            case 1: 
            case 2: {
                return new Integer(this.readBigInteger());
            }
            case 19: {
                return new Float((float)this.readBigInteger() / 120.0f);
            }
            case 5: {
                return new Float(this.readFloat());
            }
            case 6: {
                return new Double(this.readDouble());
            }
            case 25: {
                return new Short(this.readSmallInteger());
            }
            case 3: 
            case 30: {
                return new Byte(this.readByte());
            }
            case 4: {
                return this.readString();
            }
            case 7: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.nodeCount) {
                    System.out.println("Variable of type NodeInst has index " + i + " when range is 0 to " + this.nodeCount);
                    return null;
                }
                return new Integer(i);
            }
            case 8: {
                int i = this.readBigInteger();
                return new Integer(i);
            }
            case 13: {
                int i = this.readBigInteger();
                return new Integer(i);
            }
            case 11: {
                int i = this.readBigInteger();
                return new Integer(i);
            }
            case 12: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.arcCount) {
                    System.out.println("Variable of type ArcInst has index " + i + " when range is 0 to " + this.arcCount);
                    return null;
                }
                return new Integer(i);
            }
            case 14: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type Geometric");
                return null;
            }
            case 16: {
                int i = this.readBigInteger();
                if (i == -1) {
                    System.out.println("Variable of type Technology has negative index");
                    return null;
                }
                return new Integer(i);
            }
            case 9: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortArcInst");
                return null;
            }
            case 10: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortExpInst");
                return null;
            }
            case 15: {
                String libName = this.readString();
                return new String(libName);
            }
            case 17: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.toolCount) {
                    return null;
                }
                return new Integer(i);
            }
            case 18: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type RTNode");
                return null;
            }
        }
        System.out.println("Cannot read variable of type " + (ty & 0x1F));
        return null;
    }

    private NodeProto convertNodeProto(int i) {
        boolean error = false;
        if (i < 0) {
            int nindex = -i - 2;
            if (nindex >= this.primNodeProtoCount) {
                System.out.println("Error: want primitive node index " + nindex + " when limit is " + this.primNodeProtoCount);
                nindex = 0;
                error = true;
            }
            return this.getPrimNodeProtoList(nindex);
        }
        if (i >= this.nodeProtoCount) {
            System.out.println("Error: want cell index " + i + " when limit is " + this.nodeProtoCount);
            return null;
        }
        return this.nodeProtoList[i];
    }

    private PrimitiveArc convertArcProto(int i) {
        if (i == -1) {
            return null;
        }
        int aindex = -i - 2;
        if (aindex >= this.arcProtoCount || aindex < 0) {
            System.out.println("Want primitive arc index " + aindex + " when range is 0 to " + this.arcProtoCount);
            aindex = 0;
        }
        return this.getArcProtoList(aindex);
    }

    private PortProto convertPortProto(int i) {
        if (i < 0) {
            int pindex = -i - 2;
            if (pindex >= this.primPortProtoCount) {
                System.out.println("Error: want primitive port index " + pindex + " when limit is " + this.primPortProtoCount);
                pindex = 0;
            }
            return this.getPrimPortProtoList(pindex);
        }
        if (i >= this.portProtoCount) {
            System.out.println("Error: want port index " + i + " when limit is " + this.portProtoCount);
            i = 0;
        }
        if (this.portProtoList[i] instanceof Cell) {
            return null;
        }
        return (Export)this.portProtoList[i];
    }

    private NodeProto getPrimNodeProtoList(int i) {
        if (i == -1) {
            return null;
        }
        this.getTechList(this.primNodeProtoTech[i]);
        if (this.primNodeProtoError[i]) {
            System.out.println("Cannot find primitive '" + this.primNodeProtoOrig[i] + "', using " + this.primNodeProtoList[i].getName());
            this.primNodeProtoError[i] = false;
        }
        return this.primNodeProtoList[i];
    }

    private PrimitiveArc getArcProtoList(int i) {
        if (i == -1) {
            return null;
        }
        if (this.arcProtoError[i] != null) {
            System.out.println("Cannot find arc '" + this.arcProtoError[i] + "', using " + this.arcProtoList[i].getName());
            this.arcProtoError[i] = null;
        }
        return this.arcProtoList[i];
    }

    private PortProto getPrimPortProtoList(int i) {
        if (i == -1) {
            return null;
        }
        if (this.primPortProtoError[i] != null) {
            System.out.println("WARNING: port " + this.primPortProtoError[i] + " not found, using " + this.primPortProtoList[i].getName());
            this.primPortProtoError[i] = null;
        }
        return this.primPortProtoList[i];
    }

    private Technology getTechList(int i) {
        if (i == -1) {
            return null;
        }
        if (this.techError[i] != null) {
            System.out.println("WARNING: technology '" + this.techError[i] + "' does not exist, using '" + this.techList[i].getTechName() + "'");
            this.techError[i] = null;
        }
        return this.techList[i];
    }

    private View getView(int i) {
        View v = (View)this.viewMapping.get(new Integer(i));
        return v;
    }

    private LibraryContents.ViewRef getViewRef(int i) {
        if (i < 0 && i >= -permanentViewRefs.length) {
            LibraryContents.ViewRef viewRef = permanentViewRefs[-i - 1];
            if (viewRef == null) {
                View v = permanentViews[-i - 1];
                ELIB1.permanentViewRefs[-i - 1] = viewRef = this.libraryContents.newViewRef(v.getAbbreviation(), v.getFullName());
            }
            return viewRef;
        }
        return (LibraryContents.ViewRef)this.viewMapping.get(new Integer(i));
    }

    private byte readByte() throws IOException {
        int value = this.dataInputStream.read();
        if (value == -1) {
            throw new IOException();
        }
        this.updateProgressDialog(1);
        return (byte)value;
    }

    private int readBigInteger() throws IOException {
        if (this.header.sizeOfBig == 4) {
            this.updateProgressDialog(4);
            int data = this.dataInputStream.readInt();
            if (!this.header.bytesSwapped) {
                data = data >> 24 & 0xFF | data >> 8 & 0xFF00 | (data & 0xFF00) << 8 | (data & 0xFF) << 24;
            }
            return data;
        }
        this.readBytes(rawData, this.header.sizeOfBig, 4, true);
        if (this.header.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
            bb.put(2, rawData[2]);
            bb.put(3, rawData[3]);
        } else {
            bb.put(0, rawData[3]);
            bb.put(1, rawData[2]);
            bb.put(2, rawData[1]);
            bb.put(3, rawData[0]);
        }
        return bb.getInt(0);
    }

    private float readFloat() throws IOException {
        if (this.header.bytesSwapped) {
            this.updateProgressDialog(4);
            return this.dataInputStream.readFloat();
        }
        this.readBytes(rawData, this.header.sizeOfBig, 4, true);
        bb.put(0, rawData[3]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[1]);
        bb.put(3, rawData[0]);
        return bb.getFloat(0);
    }

    private double readDouble() throws IOException {
        if (this.header.bytesSwapped) {
            this.updateProgressDialog(8);
            return this.dataInputStream.readDouble();
        }
        this.readBytes(rawData, this.header.sizeOfBig, 8, true);
        bb.put(0, rawData[7]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[3]);
        bb.put(3, rawData[4]);
        bb.put(4, rawData[3]);
        bb.put(5, rawData[2]);
        bb.put(6, rawData[1]);
        bb.put(7, rawData[0]);
        return bb.getDouble(0);
    }

    private short readSmallInteger() throws IOException {
        if (this.header.sizeOfSmall == 2) {
            this.updateProgressDialog(2);
            int data = this.dataInputStream.readShort();
            if (!this.header.bytesSwapped) {
                data = data >> 8 & 0xFF | (data & 0xFF) << 8;
            }
            return (short)data;
        }
        this.readBytes(rawData, this.header.sizeOfSmall, 2, true);
        if (this.header.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
        } else {
            bb.put(0, rawData[1]);
            bb.put(1, rawData[0]);
        }
        return bb.getShort(0);
    }

    private String readString() throws IOException {
        int ret;
        if (this.header.sizeOfChar != 1) {
            System.out.println("Cannot handle library files with unicode strings");
            return null;
        }
        int len = this.readBigInteger();
        if (len <= 0) {
            return "";
        }
        byte[] stringBytes = new byte[len];
        if (len > 150 || len < 0) {
            System.out.flush();
        }
        if ((ret = this.dataInputStream.read(stringBytes, 0, len)) != len) {
            throw new IOException();
        }
        this.updateProgressDialog(len);
        String theString = new String(stringBytes);
        return theString;
    }

    private void readBytes(byte[] data, int diskSize, int memorySize, boolean signExtend) throws IOException {
        if (diskSize == memorySize) {
            int ret = this.dataInputStream.read(data, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
        } else {
            int ret = this.dataInputStream.read(rawData, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
            if (diskSize > memorySize) {
                int i;
                for (i = 0; i < memorySize; ++i) {
                    data[i] = rawData[i];
                }
                for (i = memorySize; i < diskSize; ++i) {
                    if (rawData[i] == 0 || rawData[i] == 255) continue;
                    ++this.clippedIntegers;
                }
            } else {
                int i;
                if (!signExtend || (rawData[diskSize - 1] & 0x80) == 0) {
                    for (i = diskSize; i < memorySize; ++i) {
                        ELIB1.rawData[i] = 0;
                    }
                } else {
                    for (i = diskSize; i < memorySize; ++i) {
                        ELIB1.rawData[i] = -1;
                    }
                }
                for (i = 0; i < memorySize; ++i) {
                    data[i] = rawData[i];
                }
            }
        }
        this.updateProgressDialog(diskSize);
    }

    static {
        $assertionsDisabled = !ELIB1.class.desiredAssertionStatus();
        permanentViews = new View[]{View.UNKNOWN, View.LAYOUT, View.SCHEMATIC, View.ICON, View.DOCWAVE, View.LAYOUTSKEL, View.VHDL, View.NETLIST, View.DOC, View.NETLISTNETLISP, View.NETLISTALS, View.NETLISTQUISC, View.NETLISTRSIM, View.NETLISTSILOS, View.VERILOG};
        permanentViewRefs = new LibraryContents.ViewRef[permanentViews.length];
        bb = ByteBuffer.allocateDirect(8);
        rawData = new byte[8];
    }

    public static class Header
    implements Comparable,
    Serializable {
        static final Header DEFAULT = new Header(-1597, ByteOrder.BIG_ENDIAN, 4, 2, 1);
        private final int magic;
        private transient ByteOrder byteOrder;
        private final boolean bytesSwapped;
        private final int sizeOfBig;
        private final int sizeOfSmall;
        private final int sizeOfChar;
        private final String s;

        Header(int magic, ByteOrder byteOrder, int sizeOfBig, int sizeOfSmall, int sizeOfChar) {
            this.magic = magic;
            this.byteOrder = byteOrder;
            this.bytesSwapped = byteOrder == ByteOrder.BIG_ENDIAN;
            this.sizeOfBig = sizeOfBig;
            this.sizeOfSmall = sizeOfSmall;
            this.sizeOfChar = sizeOfChar;
            int magicNum = -1571 - magic;
            String s = "MAGIC" + magicNum / 2;
            if (magicNum % 2 != 0) {
                s = s + "?";
            }
            if (byteOrder != ByteOrder.BIG_ENDIAN) {
                s = s + "L";
            }
            if (sizeOfBig != 4) {
                s = s + "I" + sizeOfBig;
            }
            if (sizeOfSmall != 2) {
                s = s + "S" + sizeOfSmall;
            }
            if (sizeOfChar != 1) {
                s = s + "C" + sizeOfChar;
            }
            this.s = s;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.byteOrder = this.bytesSwapped ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Header) {
                Header h = (Header)obj;
                return this.s.equals(h.s);
            }
            return false;
        }

        public int compareTo(Object o) {
            Header h = (Header)o;
            return TextUtils.nameSameNumeric(this.s, h.s);
        }

        public String toString() {
            return this.s;
        }
    }
}

