/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import org.apache.uima.caseditor.editor.AnnotationDocument;
import org.apache.uima.caseditor.editor.CasDocumentProvider;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

class TextDocumentProvider
extends AbstractDocumentProvider {
    private final CasDocumentProvider documentProvider;

    public TextDocumentProvider(CasDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
        this.documentProvider.addElementStateListener(new IElementStateListener(){

            public void elementMoved(Object originalElement, Object movedElement) {
                TextDocumentProvider.this.fireElementMoved(originalElement, movedElement);
            }

            public void elementDirtyStateChanged(Object element, boolean isDirty) {
                TextDocumentProvider.this.fireElementDirtyStateChanged(element, isDirty);
            }

            public void elementDeleted(Object element) {
                TextDocumentProvider.this.fireElementDeleted(element);
            }

            public void elementContentReplaced(Object element) {
                TextDocumentProvider.this.fireElementContentReplaced(element);
            }

            public void elementContentAboutToBeReplaced(Object element) {
                TextDocumentProvider.this.fireElementContentAboutToBeReplaced(element);
            }
        });
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new AnnotationModel();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        ICasDocument casDocument = this.documentProvider.createDocument(element);
        if (casDocument != null) {
            AnnotationDocument document = new AnnotationDocument();
            document.setDocument(casDocument);
            return document;
        }
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (document instanceof AnnotationDocument) {
            AnnotationDocument annotationDocument = (AnnotationDocument)document;
            this.documentProvider.doSaveDocument(monitor, element, annotationDocument.getDocument(), overwrite);
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = super.createElementInfo(element);
        CasElementInfo casElementInfo = new CasElementInfo(elementInfo.fDocument, elementInfo.fModel);
        casElementInfo.casInfo = this.documentProvider.createElementInfo(element);
        return casElementInfo;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        super.disposeElementInfo(element, info);
        CasElementInfo casElementInfo = (CasElementInfo)info;
        this.documentProvider.disposeElementInfo(element, casElementInfo.casInfo);
    }

    public IStatus getStatus(Object element) {
        IStatus status = this.documentProvider.getStatus(element);
        if (status == null) {
            status = super.getStatus(element);
        }
        return status;
    }

    private class CasElementInfo
    extends AbstractDocumentProvider.ElementInfo {
        private CasDocumentProvider.ElementInfo casInfo;

        public CasElementInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)TextDocumentProvider.this, document, model);
        }
    }
}

