/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.messages;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.MessageHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.jsr356.DecoderFactory;
import org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;

public class BinaryWholeMessage
extends SimpleBinaryMessage {
    private final MessageHandlerWrapper msgWrapper;
    private final MessageHandler.Whole<Object> wholeHandler;

    public BinaryWholeMessage(EventDriver onEvent, MessageHandlerWrapper wrapper) {
        super(onEvent);
        this.msgWrapper = wrapper;
        this.wholeHandler = (MessageHandler.Whole)wrapper.getHandler();
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        byte[] data = this.out.toByteArray();
        DecoderFactory.Wrapper decoder = this.msgWrapper.getDecoder();
        Decoder.Binary binaryDecoder = (Decoder.Binary)decoder.getDecoder();
        try {
            Object obj = binaryDecoder.decode(BufferUtil.toBuffer(data));
            this.wholeHandler.onMessage(obj);
        }
        catch (DecodeException e) {
            throw new WebSocketException("Unable to decode binary data", e);
        }
    }
}

