/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.client.MessageSender;
import org.apache.uima.adapter.jms.message.PendingMessage;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.jms.error.handler.BrokerConnectionException;
import org.apache.uima.util.Level;

public abstract class BaseMessageSender
implements Runnable,
MessageSender {
    private static final Class CLASS_NAME = BaseMessageSender.class;
    protected BlockingQueue<PendingMessage> messageQueue = new LinkedBlockingQueue<PendingMessage>();
    protected volatile boolean done;
    protected BaseUIMAAsynchronousEngineCommon_impl engine;
    protected volatile boolean workerThreadFailed;
    protected Exception exception;
    private MessageProducer producer = null;
    private CountDownLatch stopLatch = new CountDownLatch(1);

    @Override
    public abstract MessageProducer getMessageProducer();

    protected abstract void initializeProducer() throws Exception;

    protected abstract void cleanup() throws Exception;

    protected abstract void dispatchMessage(PendingMessage var1, BaseUIMAAsynchronousEngineCommon_impl var2, boolean var3) throws Exception;

    protected abstract String getDestinationEndpoint() throws Exception;

    @Override
    public abstract void setConnection(Connection var1);

    public BaseMessageSender(BaseUIMAAsynchronousEngineCommon_impl anEngine) {
        this.messageQueue = anEngine.pendingMessageQueue;
        this.engine = anEngine;
        try {
            this.engine.producerSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        this.done = true;
        PendingMessage emptyMessage = new PendingMessage(0);
        this.messageQueue.add(emptyMessage);
        PendingMessage pendingMessage = emptyMessage;
        synchronized (pendingMessage) {
            try {
                emptyMessage.wait(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.messageQueue.add(emptyMessage);
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "doStop", "jms_adapter_messages", "UIMAJMS_STOP_DISPATCH_THREAD_INFO");
        }
        try {
            this.stopLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Exception getReasonForFailure() {
        return this.exception;
    }

    @Override
    public boolean failed() {
        return this.workerThreadFailed;
    }

    private boolean reject(PendingMessage pm) {
        return this.reject(pm, new BrokerConnectionException("Unable To Deliver Message To Destination. Connection To Broker " + this.engine.getBrokerURI() + " Has Been Lost"));
    }

    private boolean reject(PendingMessage pm, Exception e) {
        boolean rejectRequest;
        block16: {
            rejectRequest = false;
            BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = this.engine.lookupConnection(this.engine.getBrokerURI());
            if (sharedConnection != null && !sharedConnection.isConnectionValid()) {
                String messageKind = "";
                if (pm.getMessageType() == 2001) {
                    messageKind = "GetMeta";
                } else if (pm.getMessageType() == 2000) {
                    messageKind = "Process";
                } else if (pm.getMessageType() == 2002) {
                    messageKind = "CollectionProcessComplete";
                }
                rejectRequest = true;
                try {
                    if (pm.getMessageType() == 2000) {
                        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cacheEntry = this.engine.getCache().get(pm.get("CasReference"));
                        if (cacheEntry != null) {
                            boolean notifyListener;
                            cacheEntry.setProcessException();
                            boolean bl = notifyListener = !cacheEntry.isSynchronousInvocation();
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "reject", "jms_adapter_messages", "UIMAJMS_client_rejected_process_request_broker_down__INFO", new Object[]{messageKind});
                            }
                            this.engine.serviceDelegate.setState(2);
                            this.engine.handleException(e, cacheEntry.getCasReferenceId(), null, cacheEntry, notifyListener, false);
                        }
                    } else if (!this.engine.serviceDelegate.isAwaitingPingReply()) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "reject", "jms_adapter_messages", "UIMAJMS_client_rejected_nonprocess_request_broker_down__INFO", new Object[]{messageKind});
                        }
                        this.engine.handleNonProcessException(e);
                    } else if (pm.getMessageType() == 2001) {
                        rejectRequest = false;
                    }
                }
                catch (Exception ex) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block16;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "reject", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                }
            }
        }
        return rejectRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String destination = null;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "run", "jms_adapter_messages", "UIMAJMS_START_DISPATCH_THREAD_INFO");
        }
        boolean addTimeToLive = true;
        if (System.getProperty("NoTTL") != null) {
            addTimeToLive = false;
        }
        try {
            this.initializeProducer();
            destination = this.getDestinationEndpoint();
            if (destination == null) {
                throw new InvalidDestinationException("Unable to determine the destination");
            }
        }
        catch (Exception e) {
            this.workerThreadFailed = true;
            this.exception = e;
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "run", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            return;
        }
        finally {
            this.engine.producerSemaphore.release();
        }
        this.engine.onProducerInitialized();
        PendingMessage pm = null;
        Object cacheEntry = null;
        boolean doCallback = false;
        block11: while (!this.done) {
            try {
                pm = this.messageQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.done) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "run", "jms_adapter_messages", "UIMAJMS_EXIT_DISPATCH_THREAD_INFO");
                }
                this.stopLatch.countDown();
                break;
            }
            boolean rejectRequest = this.reject(pm);
            if (!this.engine.running) break;
            this.engine.recoverSharedConnectionIfClosed();
            BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sharedConnection = this.engine.lookupConnection(this.engine.getBrokerURI());
            if (!this.engine.running || sharedConnection.getClientCount() == 0) break;
            if (rejectRequest || !this.engine.running) continue;
            if (this.engine.serviceDelegate.isAwaitingPingReply() && pm.getMessageType() == 2001 && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "run", "jms_adapter_messages", "UIMAJMS_client_dispatching_getmeta_ping__INFO", new Object[0]);
            }
            while (this.engine.running) {
                try {
                    this.engine.recoverSharedConnectionIfClosed();
                    BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sc = this.engine.lookupConnection(this.engine.getBrokerURI());
                    this.dispatchMessage(pm, this.engine, this.isProcessRequest(pm));
                    continue block11;
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            this.cleanup();
            if (this.stopLatch.getCount() > 0L) {
                this.stopLatch.countDown();
            }
            this.stopLatch.countDown();
        }
        catch (Exception e) {
            this.handleException(e, destination);
        }
    }

    protected void initializeMessage(PendingMessage aPm, Message anOutgoingMessage) throws Exception {
        switch (aPm.getMessageType()) {
            case 2001: {
                this.engine.setMetaRequestMessage(anOutgoingMessage);
                break;
            }
            case 2000: {
                String casReferenceId = (String)aPm.get("CasReference");
                if (this.engine.getSerialFormat() == SerialFormat.XMI) {
                    String serializedCAS = (String)aPm.get("CAS");
                    this.engine.setCASMessage(casReferenceId, serializedCAS, anOutgoingMessage);
                    break;
                }
                byte[] serializedCAS = (byte[])aPm.get("CAS");
                this.engine.setCASMessage(casReferenceId, serializedCAS, anOutgoingMessage);
                break;
            }
            case 2002: {
                this.engine.setCPCMessage(anOutgoingMessage);
                break;
            }
            case 2005: {
                String casRefId = (String)aPm.get("CasReference");
                String selector = (String)aPm.get("TargetingSelector");
                this.engine.setFreeCasMessage(anOutgoingMessage, casRefId, selector);
                break;
            }
            case 2006: {
                String casRefId2 = (String)aPm.get("CasReference");
                this.engine.setStopMessage(anOutgoingMessage, casRefId2);
            }
        }
    }

    private boolean isProcessRequest(PendingMessage pm) {
        return pm.getMessageType() == 2000;
    }

    private void handleException(Exception e, String aDestination) {
        this.workerThreadFailed = true;
        this.exception = e;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleException", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
        }
        this.engine.recoverSharedConnectionIfClosed();
        this.engine.onException(e, aDestination);
    }

    @Override
    public MessageProducer getMessageProducer(Destination destination) throws Exception {
        return null;
    }
}

