/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.Value;

public class IntegerRange
extends Value {
    public long start;
    public long end;

    public IntegerRange(long l, long l2) {
        this.start = l;
        this.end = l2;
    }

    public boolean isMultiValued() {
        return this.start != this.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public SequenceIterator iterate() throws XPathException {
        return new RangeIterator(this.start, this.end);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.INTEGER;
    }

    public int getCardinality() {
        return 32768;
    }

    public Item itemAt(int n) throws XPathException {
        if (n < 0 || (long)n > this.end - this.start) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.start + (long)n);
    }

    public int getLength() throws XPathException {
        return (int)(this.end - this.start + 1L);
    }
}

