/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.regex.RegexTranslator;

public abstract class SurrogateRegexTranslator
extends RegexTranslator {
    protected static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    protected static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];

    public static class Complement
    extends CharClass {
        private final CharClass cc;

        public Complement(CharClass charClass) {
            super(-charClass.getContainsBmp(), -charClass.getContainsNonBmp());
            this.cc = charClass;
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            this.cc.outputComplementBmp(fastStringBuffer);
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            this.cc.outputBmp(fastStringBuffer);
        }

        public void addNonBmpRanges(List list) {
            ArrayList arrayList = new ArrayList(5);
            this.cc.addNonBmpRanges(arrayList);
            RegexTranslator.sortRangeList(arrayList);
            int n = 65536;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                RegexTranslator.Range range = (RegexTranslator.Range)arrayList.get(i);
                if (range.getMin() > n) {
                    list.add(new RegexTranslator.Range(n, range.getMin() - 1));
                }
                n = range.getMax() + 1;
            }
            if (n != 0x110000) {
                list.add(new RegexTranslator.Range(n, 0x10FFFF));
            }
        }
    }

    public static class Dot
    extends CharClass {
        public Dot() {
            super(0, -1);
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("(?:.|");
            fastStringBuffer.append("[\ud800-\udbff]");
            fastStringBuffer.append("[\udc00-\udfff]");
            fastStringBuffer.append(")");
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("[^\\n]");
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append(".");
        }
    }

    public static class BackReference
    extends CharClass {
        private final int i;

        public BackReference(int n) {
            super(0, -1);
            this.i = n;
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            if (this.i != -1) {
                fastStringBuffer.append("(?:\\" + this.i + ")");
            } else {
                fastStringBuffer.append("(?:)");
            }
        }
    }

    public static class Property
    extends SimpleCharClass {
        private final String name;

        public Property(String string) {
            super(0, -1);
            this.name = string;
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        public void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\p{");
            fastStringBuffer.append(this.name);
            fastStringBuffer.append('}');
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\P{");
            fastStringBuffer.append(this.name);
            fastStringBuffer.append('}');
        }
    }

    public static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        public CharRange(int n, int n2) {
            super(n < 65536 ? 0 : -1, n2 >= 65536 ? 0 : -1);
            this.lower = n;
            this.upper = n2;
        }

        public void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (RegexTranslator.isJavaMetaChar((char)this.lower)) {
                fastStringBuffer.append('\\');
            }
            fastStringBuffer.append((char)this.lower);
            fastStringBuffer.append('-');
            if (this.upper < 65536) {
                if (RegexTranslator.isJavaMetaChar((char)this.upper)) {
                    fastStringBuffer.append('\\');
                }
                fastStringBuffer.append((char)this.upper);
            } else {
                fastStringBuffer.append('\uffff');
            }
        }

        public void addNonBmpRanges(List list) {
            if (this.upper >= 65536) {
                list.add(new RegexTranslator.Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    public static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        public static Empty getInstance() {
            return instance;
        }

        public void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            throw new RuntimeException("BMP output botch");
        }
    }

    public static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        public WideSingleChar(int n) {
            super(-1, 0);
            if (n <= 65535) {
                throw new IllegalArgumentException("Internal error: bad call on WideSingleChar");
            }
            this.c = n;
        }

        public void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            throw new RuntimeException("BMP output botch");
        }

        public int getSingleChar() {
            return this.c;
        }

        public void addNonBmpRanges(List list) {
            list.add(new RegexTranslator.Range(this.c, this.c));
        }
    }

    public static class SingleChar
    extends SimpleCharClass {
        private final char c;

        public SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        public int getSingleChar() {
            return this.c;
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        public void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            if (RegexTranslator.isJavaMetaChar(this.c)) {
                fastStringBuffer.append('\\');
                fastStringBuffer.append(this.c);
            } else {
                switch (this.c) {
                    case '\r': {
                        fastStringBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        fastStringBuffer.append("\\n");
                        break;
                    }
                    case '\t': {
                        fastStringBuffer.append("\\t");
                        break;
                    }
                    case ' ': {
                        fastStringBuffer.append("\\x20");
                        break;
                    }
                    default: {
                        fastStringBuffer.append(this.c);
                    }
                }
            }
        }
    }

    public static abstract class SimpleCharClass
    extends CharClass {
        public SimpleCharClass(int n, int n2) {
            super(n, n2);
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.inClassOutputBmp(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            if (this.getContainsBmp() == -1) {
                fastStringBuffer.append("[\u0000-\uffff]");
            } else {
                fastStringBuffer.append("[^");
                this.inClassOutputBmp(fastStringBuffer);
                fastStringBuffer.append(']');
            }
        }

        public abstract void inClassOutputBmp(FastStringBuffer var1);
    }

    protected static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int n, int n2) {
            this.containsBmp = n;
            this.containsNonBmp = n2;
        }

        public int getContainsBmp() {
            return this.containsBmp;
        }

        public int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        public final void output(FastStringBuffer fastStringBuffer) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        fastStringBuffer.append("[\u0000&&[^\u0000]]");
                        break;
                    }
                    this.outputBmp(fastStringBuffer);
                    break;
                }
                case 1: {
                    fastStringBuffer.append("(?:");
                    if (this.containsBmp == -1) {
                        fastStringBuffer.append("[\ud800-\udbff]");
                        fastStringBuffer.append("[\udc00-\udfff]");
                    } else {
                        this.outputBmp(fastStringBuffer);
                        fastStringBuffer.append("[\udc00-\udfff]");
                        fastStringBuffer.append('?');
                    }
                    fastStringBuffer.append(')');
                    break;
                }
                case 0: {
                    char c;
                    int n;
                    int n2;
                    fastStringBuffer.append("(?:");
                    boolean bl = false;
                    if (this.containsBmp != -1) {
                        bl = true;
                        this.outputBmp(fastStringBuffer);
                    }
                    ArrayList arrayList = new ArrayList(10);
                    this.addNonBmpRanges(arrayList);
                    RegexTranslator.sortRangeList(arrayList);
                    String string = RegexTranslator.highSurrogateRanges(arrayList);
                    if (string.length() > 0) {
                        if (bl) {
                            fastStringBuffer.append('|');
                        } else {
                            bl = true;
                        }
                        fastStringBuffer.append('[');
                        n2 = string.length();
                        for (int i = 0; i < n2; i += 2) {
                            n = string.charAt(i);
                            if (n == (c = string.charAt(i + 1))) {
                                fastStringBuffer.append((char)n);
                                continue;
                            }
                            fastStringBuffer.append((char)n);
                            fastStringBuffer.append('-');
                            fastStringBuffer.append(c);
                        }
                        fastStringBuffer.append(']');
                        fastStringBuffer.append("[\udc00-\udfff]");
                    }
                    String string2 = RegexTranslator.lowSurrogateRanges(arrayList);
                    n = string2.length();
                    for (n2 = 0; n2 < n; n2 += 3) {
                        if (bl) {
                            fastStringBuffer.append('|');
                        } else {
                            bl = true;
                        }
                        fastStringBuffer.append(string2.charAt(n2));
                        c = string2.charAt(n2 + 1);
                        char c2 = string2.charAt(n2 + 2);
                        if (c == c2 && (n2 + 3 >= n || string2.charAt(n2 + 3) != string2.charAt(n2))) {
                            fastStringBuffer.append(c);
                            continue;
                        }
                        fastStringBuffer.append('[');
                        while (true) {
                            if (c == c2) {
                                fastStringBuffer.append(c);
                            } else {
                                fastStringBuffer.append(c);
                                fastStringBuffer.append('-');
                                fastStringBuffer.append(c2);
                            }
                            if (n2 + 3 >= n || string2.charAt(n2 + 3) != string2.charAt(n2)) break;
                            c = string2.charAt((n2 += 3) + 1);
                            c2 = string2.charAt(n2 + 2);
                        }
                        fastStringBuffer.append(']');
                    }
                    if (!bl) {
                        fastStringBuffer.append("[\u0000&&[^\u0000]]");
                    }
                    fastStringBuffer.append(')');
                }
            }
        }

        public abstract void outputBmp(FastStringBuffer var1);

        public abstract void outputComplementBmp(FastStringBuffer var1);

        public int getSingleChar() {
            return -1;
        }

        public void addNonBmpRanges(List list) {
        }
    }
}

