/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;

public class Lang
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.argument.length == 1) {
            if (itemType == null) {
                StaticError staticError = new StaticError("The context item for lang() is undefined");
                staticError.setErrorCode("XPDY0002");
                staticError.setIsTypeError(true);
                staticError.setLocator(this);
                throw staticError;
            }
            if (itemType instanceof AtomicType) {
                StaticError staticError = new StaticError("The context item for lang() is not a node");
                staticError.setErrorCode("XPTY0004");
                staticError.setIsTypeError(true);
                staticError.setLocator(this);
                throw staticError;
            }
        }
        return super.typeCheck(staticContext, itemType);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        NodeInfo nodeInfo;
        if (this.argument.length > 1) {
            nodeInfo = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        } else {
            item = xPathContext.getContextItem();
            if (item == null) {
                DynamicError dynamicError = new DynamicError("The context item is undefined");
                dynamicError.setErrorCode("XPDY0002");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            if (!(item instanceof NodeInfo)) {
                DynamicError dynamicError = new DynamicError("The context item is not a node");
                dynamicError.setErrorCode("XPTY0004");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            nodeInfo = (NodeInfo)item;
        }
        item = this.argument[0].evaluateItem(xPathContext);
        String string = item == null ? "" : item.getStringValue();
        boolean bl = Lang.isLang(string, nodeInfo);
        return BooleanValue.get(bl);
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public static boolean isLang(String string, NodeInfo nodeInfo) {
        String string2 = null;
        NodeInfo nodeInfo2 = nodeInfo;
        while (nodeInfo2 != null && (string2 = nodeInfo2.getAttributeValue(387)) == null) {
            if ((nodeInfo2 = nodeInfo2.getParent()) != null) continue;
            return false;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n = string2.indexOf("-");
        if (n < 0) {
            return false;
        }
        return string.equalsIgnoreCase(string2 = string2.substring(0, n));
    }
}

