/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;

public class AnnotationError
implements Comparable<AnnotationError> {
    private TextRulerExample error;
    private TextRulerExample truth;
    private AnnotationErrorType type;

    public AnnotationError(TextRulerExample error, TextRulerExample truth, AnnotationErrorType type) {
        this.error = error;
        this.truth = truth;
        this.type = type;
    }

    public TextRulerExample getError() {
        return this.error;
    }

    public TextRulerExample getTruth() {
        return this.truth;
    }

    public AnnotationErrorType getType() {
        return this.type;
    }

    public TrabalAnnotation getAnnotation() {
        if (this.error != null) {
            return (TrabalAnnotation)this.error.getAnnotation();
        }
        return null;
    }

    public TrabalAnnotation getTargetAnnotation() {
        if (this.truth != null) {
            return (TrabalAnnotation)this.truth.getAnnotation();
        }
        return null;
    }

    public String toString() {
        if (this.error != null && this.truth != null) {
            return this.type + ": " + this.error.getAnnotation().getType().getShortName() + "(" + this.error.getAnnotation().getBegin() + ", " + this.error.getAnnotation().getEnd() + ") -> " + this.truth.getAnnotation().getType().getShortName() + "(" + this.truth.getAnnotation().getBegin() + ", " + this.truth.getAnnotation().getEnd() + ")";
        }
        if (this.truth != null) {
            return this.type + ": " + this.truth.getAnnotation().getType().getShortName() + "(" + this.truth.getAnnotation().getBegin() + ", " + this.truth.getAnnotation().getEnd() + ")";
        }
        return this.type + ": " + this.error.getAnnotation().getType().getShortName() + "(" + this.error.getAnnotation().getBegin() + ", " + this.error.getAnnotation().getEnd() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(AnnotationError o) {
        int comp;
        if (this.error != null) {
            if (o.getError() == null) return 1;
            comp = this.error.getAnnotation().getType().toString().compareTo(o.getError().getAnnotation().getType().toString());
            if (comp != 0) {
                return comp;
            }
        } else if (o.getError() != null) {
            return -1;
        }
        if (this.truth != null) {
            if (o.getTruth() == null) return 1;
            comp = this.truth.getAnnotation().getType().toString().compareTo(o.getTruth().getAnnotation().getType().toString());
            if (comp == 0) return this.type.compareTo(o.getType());
            return comp;
        }
        if (o.getTruth() == null) return this.type.compareTo(o.getType());
        return -1;
    }
}

