/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class LogAction
extends AbstractRutaAction {
    public static final String LOGGER_NAME = Logger.getGlobal().getName();
    private final IStringExpression text;
    private final Level level;

    public LogAction(IStringExpression text, Level level) {
        this.text = text;
        this.level = level == null ? Level.INFO : level;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        String msg = this.text.getStringValue(context, stream);
        Logger.getLogger(LOGGER_NAME).log(this.level, msg);
    }

    public IStringExpression getText() {
        return this.text;
    }

    public Level getLevel() {
        return this.level;
    }
}

