/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.parser;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;

public class RutaParseUtils {
    public static boolean isAtLineStart(ASTNode node, String content) {
        boolean blockStart = false;
        int sourceStart = node.sourceStart();
        while (sourceStart >= 0) {
            char c;
            if (Character.isWhitespace(c = content.charAt(--sourceStart))) continue;
            if (c == '\n' || c == '\r' || c == ';') {
                return true;
            }
            if (c == '{') {
                blockStart = true;
                continue;
            }
            return c == '}' && blockStart;
        }
        return false;
    }

    public static int endLineOrSymbol(int from, String content) {
        int pos = 0;
        for (pos = from; pos < content.length(); ++pos) {
            char c = content.charAt(pos);
            if (c == '\n' || c == '\r' || c == ';') {
                return pos;
            }
            if (Character.isWhitespace(c)) continue;
            return pos;
        }
        if (pos == content.length()) {
            return pos;
        }
        return from;
    }

    public static int startLineOrSymbol(int from, String content) {
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        for (int pos = from - 1; pos > 0; --pos) {
            char c = content.charAt(pos);
            if (c == '\n' || c == '\r' || c == ';') {
                return pos + 1;
            }
            if (Character.isWhitespace(c)) continue;
            return pos + 1;
        }
        return from;
    }

    public static int endLineOrNoSymbol(int from, String content) {
        int pos = 0;
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        for (pos = from; pos < content.length(); ++pos) {
            if (!RutaParseUtils.checkBounds(content, pos)) continue;
            return pos;
        }
        if (pos == content.length()) {
            return pos;
        }
        return pos;
    }

    private static boolean checkBounds(String content, int pos) {
        char[] syms = new char[]{' ', '\t', '\n', '\r', ']', '[', '}', '{', '(', ')'};
        char c = content.charAt(pos);
        for (int i = 0; i < syms.length; ++i) {
            if (syms[i] != c) continue;
            return true;
        }
        return false;
    }

    public static int startLineOrNoSymbol(int from, String content) {
        int pos;
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        for (pos = from; pos > 0; --pos) {
            if (!RutaParseUtils.checkBounds(content, pos)) continue;
            return pos + 1;
        }
        return pos;
    }

    public static String[] returnVariable(Statement node) {
        return null;
    }

    public static SimpleReference extractVariableFromString(int sourceStart, int sourceEnd, int i, String name) {
        return null;
    }

    public static SimpleReference extractVariableFromString(StringLiteral completionNode, int pos) {
        return null;
    }

    public static ASTNode getScopeParent(ModuleDeclaration module, Expression s) {
        return null;
    }

    public static String processFieldName(IField field, String token) {
        return null;
    }

    public static String processMethodName(IMethod method, String token) {
        return null;
    }

    public static String processTypeName(IType method, String token) {
        return null;
    }

    public static final int[] getBounds(Token token) throws IllegalArgumentException {
        if (token == null) {
            throw new IllegalArgumentException();
        }
        if (!(token instanceof CommonToken)) {
            throw new IllegalArgumentException();
        }
        CommonToken ct = (CommonToken)token;
        int[] bounds = new int[]{ct.getStartIndex(), ct.getStopIndex() + 1};
        return bounds;
    }

    public static final int[] getBounds(Token tokenA, Token tokenB) throws IllegalArgumentException {
        if (!(tokenA instanceof CommonToken) || !(tokenB instanceof CommonToken) && tokenB != null) {
            throw new IllegalArgumentException();
        }
        CommonToken ctA = (CommonToken)tokenA;
        if (tokenB == null) {
            int[] bounds = new int[]{ctA.getStartIndex(), ctA.getStopIndex() + 1};
            return bounds;
        }
        CommonToken ctB = (CommonToken)tokenB;
        int[] bounds = new int[]{ctA.getStartIndex(), ctB.getStopIndex() + 1};
        return bounds;
    }

    public static final int getTypeOfIModelElement(IMember member) {
        try {
            int type = member.getFlags();
        }
        catch (ModelException e) {
            return -1;
        }
        return type &= 0xFFFC0000;
    }
}

