/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.FilterManager;
import org.apache.uima.ruta.ReindexUpdateMode;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaIndexingConfiguration;
import org.apache.uima.ruta.TypeUsageInformation;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.IBooleanListExpression;
import org.apache.uima.ruta.expression.feature.CoveredTextFeature;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.feature.GenericFeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.feature.SimpleFeatureExpression;
import org.apache.uima.ruta.expression.feature.TypeFeature;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.INumberListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.IStringListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.expression.type.ITypeListExpression;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaAnnotation;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.type.RutaOptional;
import org.apache.uima.ruta.utils.RutaListUtils;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RutaStream {
    private final CAS cas;
    private FSIterator<AnnotationFS> basicIt;
    private FSIterator<AnnotationFS> currentIt;
    private AnnotationFS documentAnnotation;
    private Type documentAnnotationType;
    private Type basicType;
    private NavigableMap<Integer, RutaBasic> beginAnchors = new TreeMap<Integer, RutaBasic>();
    private NavigableMap<Integer, RutaBasic> endAnchors = new TreeMap<Integer, RutaBasic>();
    private FilterManager filter;
    private boolean dynamicAnchoring;
    private double indexPenalty = 0.0;
    private double anchoringFactor;
    private boolean lowMemoryProfile;
    private boolean simpleGreedyForComposed;
    private InferenceCrowd crowd;
    private TypeUsageInformation typeUsage;
    private Boolean greedyRuleElement;
    private Boolean greedyRule;
    private boolean onlyOnce = false;
    private Annotation documentBeginAnchor;
    private Annotation documentEndAnchor;
    private boolean emptyIsInvisible;
    private long maxRuleMatches;
    private long maxRuleElementMatches;

    public RutaStream(CAS cas, Type basicType, FilterManager filter, boolean lowMemoryProfile, boolean simpleGreedyForComposed, boolean emptyIsInvisible, TypeUsageInformation typeUsage, InferenceCrowd crowd) {
        this.cas = cas;
        this.filter = filter;
        this.basicType = basicType;
        this.lowMemoryProfile = lowMemoryProfile;
        this.simpleGreedyForComposed = simpleGreedyForComposed;
        this.emptyIsInvisible = emptyIsInvisible;
        this.typeUsage = typeUsage;
        this.crowd = crowd;
        AnnotationFS additionalWindow = filter.getWindowAnnotation();
        this.updateIterators(cas, basicType, filter, additionalWindow);
        if (additionalWindow == null) {
            this.documentAnnotation = cas.getDocumentAnnotation();
            this.documentAnnotationType = this.getCas().getDocumentAnnotation().getType();
            this.basicIt.moveToFirst();
            this.documentBeginAnchor = new RutaOptional(this.getJCas(), 0, 0);
            this.documentEndAnchor = new RutaOptional(this.getJCas(), this.documentAnnotation.getEnd(), this.documentAnnotation.getEnd());
        } else {
            this.documentAnnotation = additionalWindow;
            this.documentAnnotationType = filter.getWindowType();
        }
    }

    protected RutaStream(CAS cas, Type basicType, NavigableMap<Integer, RutaBasic> beginAnchors, NavigableMap<Integer, RutaBasic> endAnchors, FilterManager filter, boolean lowMemoryProfile, boolean simpleGreedyForComposed, boolean emptyIsInvisible, TypeUsageInformation typeUsage, InferenceCrowd crowd) {
        this.cas = cas;
        this.beginAnchors = beginAnchors;
        this.endAnchors = endAnchors;
        this.filter = filter;
        this.basicType = basicType;
        this.lowMemoryProfile = lowMemoryProfile;
        this.simpleGreedyForComposed = simpleGreedyForComposed;
        this.emptyIsInvisible = emptyIsInvisible;
        this.typeUsage = typeUsage;
        this.crowd = crowd;
        AnnotationFS additionalWindow = filter.getWindowAnnotation();
        this.updateIterators(cas, basicType, filter, additionalWindow);
        if (additionalWindow == null) {
            this.documentAnnotation = cas.getDocumentAnnotation();
            this.documentAnnotationType = this.getCas().getDocumentAnnotation().getType();
            this.basicIt.moveToFirst();
        } else {
            this.documentAnnotation = additionalWindow;
            this.documentAnnotationType = filter.getWindowType();
        }
    }

    private void updateIterators(AnnotationFS additionalWindow) {
        this.updateIterators(this.cas, this.basicType, this.filter, additionalWindow);
    }

    private void updateIterators(CAS cas, Type basicType, FilterManager filter, AnnotationFS additionalWindow) {
        this.basicIt = additionalWindow != null ? cas.getAnnotationIndex(basicType).select().coveredBy(additionalWindow).fsIterator() : cas.getAnnotationIndex(basicType).iterator();
        this.currentIt = filter.createFilteredIterator(cas, basicType);
    }

    @Deprecated
    public void initalizeBasics(String[] reindexOnly, boolean reindexOnlyMentionedTypes) {
        RutaIndexingConfiguration config = new RutaIndexingConfiguration();
        config.setReindexOnly(reindexOnly);
        config.setReindexOnlyMentionedTypes(reindexOnlyMentionedTypes);
        config.setReindexUpdateMode(ReindexUpdateMode.ADDITIVE);
        this.initalizeBasics(config);
    }

    public void initalizeBasics(RutaIndexingConfiguration config) {
        boolean basicsAvailable;
        AnnotationIndex basicIndex = this.cas.getAnnotationIndex(this.basicType);
        boolean bl = basicsAvailable = basicIndex.size() != 0;
        if (config.getReindexUpdateMode() == ReindexUpdateMode.NONE && basicsAvailable) {
            this.initializeInternalAnchorMaps((AnnotationIndex<AnnotationFS>)basicIndex);
            return;
        }
        if (!basicsAvailable) {
            this.createBasics(config);
        } else {
            this.updateBasics((AnnotationIndex<AnnotationFS>)basicIndex, config);
        }
    }

    private void createBasics(RutaIndexingConfiguration config) {
        TypeSystem typeSystem = this.cas.getTypeSystem();
        Collection<Type> indexTypes = config.isIndexOnlyMentionedTypes() ? this.convertNamesToTypes(this.typeUsage.getUsedTypes().toArray(new String[0]), typeSystem) : this.convertNamesToTypes(config.getIndexOnly(), typeSystem);
        Collection<Type> indexSkipTypes = this.convertNamesToTypes(config.getIndexSkipTypes(), typeSystem);
        Collection<Type> indexParentTypes = this.removeSubsumedTypes(indexTypes, typeSystem);
        Collection<Type> allIndexTypes = this.expandToAllSubtypes(indexTypes, indexSkipTypes, typeSystem);
        List<FSIndex<AnnotationFS>> relevantIndexes = this.getRelevantIndexes(typeSystem, indexParentTypes, indexSkipTypes);
        this.createBasics(relevantIndexes, allIndexTypes);
    }

    private void updateBasics(AnnotationIndex<AnnotationFS> basicIndex, RutaIndexingConfiguration config) {
        TypeSystem typeSystem = this.cas.getTypeSystem();
        Collection<Type> reindexTypes = config.isReindexOnlyMentionedTypes() ? this.convertNamesToTypes(this.typeUsage.getUsedTypes().toArray(new String[0]), typeSystem) : this.convertNamesToTypes(config.getReindexOnly(), typeSystem);
        Collection<Type> reindexSkipTypes = this.convertNamesToTypes(config.getReindexSkipTypes(), typeSystem);
        Collection<Type> reindexParentTypes = this.removeSubsumedTypes(reindexTypes, typeSystem);
        Collection<Type> allReindexTypes = this.expandToAllSubtypes(reindexTypes, reindexSkipTypes, typeSystem);
        List<FSIndex<AnnotationFS>> relevantIndexes = this.getRelevantIndexes(typeSystem, reindexParentTypes, reindexSkipTypes);
        this.updateBasics(basicIndex, relevantIndexes, allReindexTypes, config.getReindexUpdateMode());
    }

    private List<FSIndex<AnnotationFS>> getRelevantIndexes(TypeSystem typeSystem, Collection<Type> rootReindexTypeList, Collection<Type> skipTypeList) {
        ArrayList<FSIndex<AnnotationFS>> relevantIndexes = new ArrayList<FSIndex<AnnotationFS>>();
        for (Type type : rootReindexTypeList) {
            if (this.skipTypeForIndexing(type, skipTypeList, typeSystem)) continue;
            if (StringUtils.equals((CharSequence)type.getName(), (CharSequence)"uima.tcas.Annotation")) {
                relevantIndexes.add((FSIndex<AnnotationFS>)this.cas.getAnnotationIndex().withSnapshotIterators());
                continue;
            }
            relevantIndexes.add((FSIndex<AnnotationFS>)this.cas.getAnnotationIndex(type).withSnapshotIterators());
        }
        return relevantIndexes;
    }

    private boolean skipTypeForIndexing(Type type, Collection<Type> skipTypeList, TypeSystem typeSystem) {
        if (typeSystem.subsumes(this.basicType, type)) {
            return true;
        }
        if (skipTypeList != null) {
            if (skipTypeList.contains(type)) {
                return true;
            }
            for (Type skipType : skipTypeList) {
                if (!typeSystem.subsumes(skipType, type)) continue;
                return true;
            }
        }
        return false;
    }

    private void createBasics(List<FSIndex<AnnotationFS>> relevantIndexes, Collection<Type> allIndexTypes) {
        List<Integer> anchors = this.getSortedUniqueAnchors(relevantIndexes);
        this.createBasicsForAnchors(anchors);
        for (FSIndex<AnnotationFS> index : relevantIndexes) {
            for (AnnotationFS a : index) {
                if (allIndexTypes != null && !allIndexTypes.contains(a.getType())) continue;
                this.addAnnotation(a, false, false, null);
            }
        }
        this.updateIterators(this.documentAnnotation);
    }

    private void createBasicsForAnchors(List<Integer> anchors) {
        if (anchors.size() == 0) {
            this.createRutaBasic(0, 0);
        } else if (anchors.size() == 1) {
            Integer first = anchors.get(0);
            if (first >= 0 && first <= this.cas.getDocumentText().length()) {
                this.createRutaBasic(first, first);
            }
        } else {
            for (int i = 0; i < anchors.size() - 1; ++i) {
                Integer first = anchors.get(i);
                Integer second = anchors.get(i + 1);
                if (first >= second || first < 0 || second > this.cas.getDocumentText().length()) continue;
                this.createRutaBasic(first, second);
            }
        }
    }

    private List<Integer> getSortedUniqueAnchors(List<FSIndex<AnnotationFS>> relevantIndexes) {
        HashSet<Integer> anchorSet = new HashSet<Integer>();
        for (FSIndex<AnnotationFS> annotationIndex : relevantIndexes) {
            for (AnnotationFS a : annotationIndex) {
                anchorSet.add(a.getBegin());
                anchorSet.add(a.getEnd());
            }
        }
        ArrayList<Integer> anchors = new ArrayList<Integer>(anchorSet);
        Collections.sort(anchors);
        return anchors;
    }

    private void updateBasics(AnnotationIndex<AnnotationFS> basicIndex, List<FSIndex<AnnotationFS>> relevantIndexes, Collection<Type> allReindexTypes, ReindexUpdateMode indexUpdateMode) {
        this.initializeInternalAnchorMaps(basicIndex);
        this.updateRutaBasicMemoryProfile(basicIndex);
        switch (indexUpdateMode) {
            case COMPLETE: {
                this.updateBasicsComplete(basicIndex, relevantIndexes, allReindexTypes);
                break;
            }
            case ADDITIVE: {
                this.updateBasicsAdditive(basicIndex, relevantIndexes);
                break;
            }
            case SAFE_ADDITIVE: {
                this.updateBasicsSafeAdditive(basicIndex, relevantIndexes, allReindexTypes);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The given IndexUpdateMode is not supported: " + (Object)((Object)indexUpdateMode));
            }
        }
    }

    private void updateBasicsComplete(AnnotationIndex<AnnotationFS> basicIndex, List<FSIndex<AnnotationFS>> relevantIndexes, Collection<Type> completeReindexTypeList) {
        for (AnnotationFS each : basicIndex) {
            RutaBasic rutaBasic = (RutaBasic)each;
            for (Type type : completeReindexTypeList) {
                int code = ((TypeImpl)type).getCode();
                rutaBasic.getPartOf()[code] = 0;
                rutaBasic.getBeginMap()[code] = null;
                rutaBasic.getEndMap()[code] = null;
            }
        }
        for (FSIndex index : relevantIndexes) {
            for (AnnotationFS a : index) {
                if (!completeReindexTypeList.contains(a.getType())) continue;
                this.addAnnotation(a, false, false, null);
            }
        }
    }

    private void updateBasicsAdditive(AnnotationIndex<AnnotationFS> basicIndex, List<FSIndex<AnnotationFS>> relevantIndexes) {
        for (FSIndex<AnnotationFS> annotationIndex : relevantIndexes) {
            for (AnnotationFS a : annotationIndex) {
                Type type = a.getType();
                RutaBasic beginAnchor = this.getBeginAnchor(a.getBegin());
                RutaBasic endAnchor = this.getEndAnchor(a.getEnd());
                boolean shouldBeAdded = false;
                if (beginAnchor == null || endAnchor == null) {
                    shouldBeAdded = true;
                } else {
                    Collection set = beginAnchor.getBeginAnchors(type);
                    if (!set.contains(a)) {
                        shouldBeAdded = true;
                    }
                }
                if (!shouldBeAdded) continue;
                this.addAnnotation(a, false, false, null);
            }
        }
    }

    private void updateBasicsSafeAdditive(AnnotationIndex<AnnotationFS> basicIndex, List<FSIndex<AnnotationFS>> relevantIndexes, Collection<Type> completeReindexTypeList) {
        for (AnnotationFS each : basicIndex) {
            RutaBasic rutaBasic = (RutaBasic)each;
            for (Type type : completeReindexTypeList) {
                Collection beginAnchors = rutaBasic.getBeginAnchors(type);
                ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
                for (AnnotationFS annotationAtAnchor : beginAnchors) {
                    if (annotationAtAnchor.getCAS().getAnnotationIndex().contains((FeatureStructure)annotationAtAnchor)) continue;
                    toRemove.add(annotationAtAnchor);
                }
                toRemove.forEach(a -> this.removeAnnotation((AnnotationFS)a));
            }
        }
        this.updateBasicsAdditive(basicIndex, relevantIndexes);
    }

    private void initializeInternalAnchorMaps(AnnotationIndex<AnnotationFS> basicIndex) {
        for (AnnotationFS e : basicIndex) {
            this.beginAnchors.put(e.getBegin(), (RutaBasic)e);
            this.endAnchors.put(e.getEnd(), (RutaBasic)e);
        }
    }

    private void updateRutaBasicMemoryProfile(AnnotationIndex<AnnotationFS> basicIndex) {
        RutaBasic firstBasic = (RutaBasic)basicIndex.iterator().get();
        if (firstBasic.isLowMemoryProfile() != this.lowMemoryProfile) {
            for (AnnotationFS each : basicIndex) {
                RutaBasic eachBasic = (RutaBasic)each;
                eachBasic.setLowMemoryProfile(this.lowMemoryProfile);
            }
        }
    }

    private RutaBasic createRutaBasic(int begin, int end) {
        RutaBasic newTMB = new RutaBasic(this.getJCas(), begin, end);
        newTMB.setLowMemoryProfile(this.lowMemoryProfile);
        this.beginAnchors.put(begin, newTMB);
        this.endAnchors.put(end, newTMB);
        this.cas.addFsToIndexes((FeatureStructure)newTMB);
        return newTMB;
    }

    public void addAnnotation(AnnotationFS annotation, boolean addToIndex, AbstractRuleMatch<? extends AbstractRule> creator) {
        this.addAnnotation(annotation, addToIndex, true, creator);
    }

    public void addAnnotation(AnnotationFS annotation, AbstractRuleMatch<? extends AbstractRule> creator) {
        this.addAnnotation(annotation, false, true, creator);
    }

    public void addAnnotation(AnnotationFS annotation, boolean addToIndex, boolean updateInternal, AbstractRuleMatch<? extends AbstractRule> creator) {
        Type type = annotation.getType();
        if (type.equals(this.basicType) || annotation.getBegin() >= annotation.getEnd() && !annotation.equals(this.cas.getDocumentAnnotation())) {
            return;
        }
        if (this.indexType(annotation.getType())) {
            boolean modified = this.checkSpan(annotation);
            if (modified && updateInternal) {
                this.updateIterators(this.filter.getWindowAnnotation());
            }
            RutaBasic beginAnchor = this.getBeginAnchor(annotation.getBegin());
            RutaBasic endAnchor = this.getEndAnchor(annotation.getEnd());
            if (beginAnchor != null) {
                beginAnchor.addBegin(annotation, type);
            }
            if (endAnchor != null) {
                endAnchor.addEnd(annotation, type);
            }
            Collection<RutaBasic> basicAnnotationsInWindow = this.getAllBasicsInWindow(annotation);
            for (RutaBasic basic : basicAnnotationsInWindow) {
                basic.addPartOf(type);
            }
        }
        if (addToIndex) {
            this.cas.addFsToIndexes((FeatureStructure)annotation);
        }
        this.crowd.annotationAdded(annotation, creator);
    }

    private boolean indexType(Type type) {
        if (this.typeUsage != null) {
            boolean contains = this.typeUsage.getUsedTypesWithSubTypes().contains(type.getName());
            return contains;
        }
        return true;
    }

    private boolean checkSpan(AnnotationFS annotation) {
        boolean result = false;
        int begin = annotation.getBegin();
        int end = annotation.getEnd();
        RutaBasic beginAnchor = this.getBeginAnchor(begin);
        RutaBasic endAnchor = this.getEndAnchor(end);
        if (beginAnchor != null && endAnchor != null) {
            result = false;
        } else {
            if (beginAnchor == null) {
                result |= this.checkAnchor(begin);
            }
            if (endAnchor == null) {
                result |= this.checkAnchor(end);
            }
        }
        return result;
    }

    private boolean checkAnchor(int anchor) {
        Map.Entry<Integer, RutaBasic> floorEntry = this.endAnchors.floorEntry(anchor);
        if (floorEntry == null) {
            floorEntry = this.beginAnchors.floorEntry(anchor);
        }
        Map.Entry<Integer, RutaBasic> ceilingEntry = this.endAnchors.ceilingEntry(anchor);
        if (floorEntry != null && ceilingEntry != null) {
            RutaBasic floor = floorEntry.getValue();
            RutaBasic ceiling = ceilingEntry.getValue();
            RutaBasic toSplit = null;
            toSplit = floor.getEnd() > anchor ? floor : ceiling;
            int newEnd = toSplit.getEnd();
            if (newEnd == anchor) {
                return false;
            }
            this.cas.removeFsFromIndexes((FeatureStructure)toSplit);
            toSplit.setEnd(anchor);
            RutaBasic newRB = new RutaBasic(this.getJCas(), anchor, newEnd);
            newRB.setLowMemoryProfile(this.lowMemoryProfile);
            newRB.setEndMap((Collection[])toSplit.getEndMap().clone());
            newRB.setPartOf((int[])toSplit.getPartOf().clone());
            toSplit.clearEndMap();
            this.cas.addFsToIndexes((FeatureStructure)toSplit);
            this.cas.addFsToIndexes((FeatureStructure)newRB);
            this.beginAnchors.put(floor.getBegin(), floor);
            this.beginAnchors.put(newRB.getBegin(), newRB);
            this.beginAnchors.put(ceiling.getBegin(), ceiling);
            this.endAnchors.put(floor.getEnd(), floor);
            this.endAnchors.put(newRB.getEnd(), newRB);
            this.endAnchors.put(ceiling.getEnd(), ceiling);
            return true;
        }
        return false;
    }

    public void removeAnnotation(AnnotationFS annotationFS) {
        this.removeAnnotation(annotationFS, annotationFS.getType());
    }

    public void removeAnnotation(AnnotationFS annotation, Type type) {
        if (type.getName().equals("uima.tcas.DocumentAnnotation")) {
            return;
        }
        Collection<RutaBasic> basicAnnotationsInWindow = this.getAllBasicsInWindow(annotation);
        for (RutaBasic basic : basicAnnotationsInWindow) {
            basic.removePartOf(type);
        }
        Type parent = type;
        RutaBasic beginAnchor = this.getBeginAnchor(annotation.getBegin());
        RutaBasic endAnchor = this.getEndAnchor(annotation.getEnd());
        if (beginAnchor != null) {
            beginAnchor.removeBegin(annotation, parent);
        }
        if (endAnchor != null) {
            endAnchor.removeEnd(annotation, parent);
        }
        if (!(annotation instanceof RutaBasic)) {
            this.cas.removeFsFromIndexes((FeatureStructure)annotation);
        }
    }

    public FSIterator<AnnotationFS> getFilteredBasicIterator(FSMatchConstraint constraint) {
        ConstraintFactory cf = this.cas.getConstraintFactory();
        FSMatchConstraint matchConstraint = cf.and(constraint, this.filter.getDefaultConstraint());
        return this.cas.createFilteredIterator(this.basicIt, matchConstraint);
    }

    public RutaStream getWindowStream(AnnotationFS windowAnnotation, Type windowType) {
        if (windowAnnotation.getBegin() == this.documentAnnotation.getBegin() && windowAnnotation.getEnd() == this.documentAnnotation.getEnd()) {
            return this;
        }
        FilterManager filterManager = new FilterManager(this.filter.getDefaultFilterTypes(), this.filter.getCurrentFilterTypes(), this.filter.getCurrentRetainTypes(), windowAnnotation, windowType, this.emptyIsInvisible, this.cas);
        RutaStream stream = new RutaStream(this.cas, this.basicType, this.beginAnchors, this.endAnchors, filterManager, this.lowMemoryProfile, this.simpleGreedyForComposed, this.emptyIsInvisible, this.typeUsage, this.crowd);
        stream.setDynamicAnchoring(this.dynamicAnchoring);
        stream.setGreedyRuleElement(this.greedyRuleElement);
        stream.setGreedyRule(this.greedyRule);
        stream.setMaxRuleMatches(this.maxRuleMatches);
        stream.setMaxRuleElementMatches(this.maxRuleElementMatches);
        return stream;
    }

    public RutaStream copy() {
        RutaStream stream = new RutaStream(this.cas, this.basicType, this.beginAnchors, this.endAnchors, this.filter, this.lowMemoryProfile, this.simpleGreedyForComposed, this.emptyIsInvisible, this.typeUsage, this.crowd);
        stream.setDynamicAnchoring(this.dynamicAnchoring);
        stream.setGreedyRuleElement(this.greedyRuleElement);
        stream.setGreedyRule(this.greedyRule);
        stream.setMaxRuleMatches(this.maxRuleMatches);
        stream.setMaxRuleElementMatches(this.maxRuleElementMatches);
        return stream;
    }

    public AnnotationFS get() throws NoSuchElementException {
        return (AnnotationFS)this.currentIt.get();
    }

    public boolean isValid() {
        return this.currentIt.isValid();
    }

    public void moveTo(FeatureStructure fs) {
        try {
            this.currentIt.moveTo(fs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasNext() {
        return this.currentIt.hasNext();
    }

    public AnnotationFS next() {
        return (AnnotationFS)this.currentIt.next();
    }

    public void moveToFirst() {
        this.currentIt.moveToFirst();
    }

    public void moveToLast() {
        this.currentIt.moveToLast();
    }

    public void moveToNext() {
        this.currentIt.moveToNext();
    }

    public void moveToPrevious() {
        this.currentIt.moveToPrevious();
    }

    public List<AnnotationFS> getOverappingAnnotations(AnnotationFS window, Type type) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        AnnotationFS newWindow = this.cas.createAnnotation(type, window.getBegin(), window.getEnd() - 1);
        FSIterator iterator = this.cas.getAnnotationIndex(type).iterator((FeatureStructure)newWindow);
        if (!iterator.isValid()) {
            iterator.moveToLast();
        }
        while (iterator.isValid()) {
            AnnotationFS a;
            FeatureStructure fs = iterator.get();
            if (fs instanceof AnnotationFS && (a = (AnnotationFS)fs).getEnd() >= window.getEnd() && a.getBegin() <= window.getBegin()) {
                result.add(a);
            }
            iterator.moveToPrevious();
        }
        return result;
    }

    public List<Annotation> getAnnotationsFollowing(Annotation annotation) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        this.moveTo((FeatureStructure)annotation);
        while (this.currentIt.isValid()) {
            this.currentIt.moveToNext();
            if (!this.currentIt.isValid()) continue;
            Annotation nextAnnotation = (Annotation)this.currentIt.get();
            if (nextAnnotation.getBegin() == annotation.getEnd()) {
                result.add(nextAnnotation);
                continue;
            }
            if (nextAnnotation.getBegin() < annotation.getEnd()) continue;
            break;
        }
        return result;
    }

    public CAS getCas() {
        return this.cas;
    }

    public JCas getJCas() {
        try {
            return this.cas.getJCas();
        }
        catch (CASException cASException) {
            return null;
        }
    }

    public List<AnnotationFS> getAllofType(Type type) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        FSIterator iterator = this.cas.getAnnotationIndex(type).iterator();
        while (iterator.isValid()) {
            FeatureStructure featureStructure = iterator.get();
            result.add((AnnotationFS)featureStructure);
            iterator.moveToNext();
        }
        return result;
    }

    public List<AnnotationFS> getAnnotationsInWindow(AnnotationFS windowAnnotation, Type type) {
        return this.getAnnotationsInWindow(type, windowAnnotation, false);
    }

    public Collection<RutaBasic> getAllBasicsInWindow(AnnotationFS windowAnnotation) {
        if (windowAnnotation.getBegin() >= windowAnnotation.getEnd()) {
            return Collections.emptySet();
        }
        RutaBasic beginAnchor = this.getBeginAnchor(windowAnnotation.getBegin());
        if (beginAnchor != null && beginAnchor.getEnd() == windowAnnotation.getEnd()) {
            return Arrays.asList(beginAnchor);
        }
        if (windowAnnotation.getEnd() == this.cas.getDocumentAnnotation().getEnd() && windowAnnotation.getBegin() == 0) {
            return this.beginAnchors.values();
        }
        return this.beginAnchors.subMap(windowAnnotation.getBegin(), true, windowAnnotation.getEnd(), false).values();
    }

    public RutaBasic getBasicNextTo(boolean before, AnnotationFS annotation) {
        if (annotation == null) {
            return null;
        }
        if (before) {
            RutaBasic pointer = (RutaBasic)this.endAnchors.get(annotation.getBegin());
            while (pointer != null && pointer.getBegin() >= this.documentAnnotation.getBegin()) {
                if (this.isVisible((AnnotationFS)pointer)) {
                    return pointer;
                }
                Map.Entry<Integer, RutaBasic> lowerEntry = this.endAnchors.lowerEntry(pointer.getEnd());
                if (lowerEntry != null) {
                    pointer = lowerEntry.getValue();
                    continue;
                }
                pointer = null;
            }
        } else {
            RutaBasic pointer = (RutaBasic)this.beginAnchors.get(annotation.getEnd());
            while (pointer != null && pointer.getEnd() <= this.documentAnnotation.getEnd()) {
                if (this.isVisible((AnnotationFS)pointer)) {
                    return pointer;
                }
                Map.Entry<Integer, RutaBasic> higherEntry = this.beginAnchors.higherEntry(pointer.getBegin());
                if (higherEntry != null) {
                    pointer = higherEntry.getValue();
                    continue;
                }
                pointer = null;
            }
        }
        return null;
    }

    public List<RutaBasic> getBasicsInWindow(AnnotationFS windowAnnotation) {
        ArrayList<RutaBasic> result = new ArrayList<RutaBasic>();
        if (windowAnnotation instanceof RutaBasic) {
            result.add((RutaBasic)windowAnnotation);
            return result;
        }
        FSMatchConstraint defaultConstraint = this.filter.getDefaultConstraint();
        FSIterator iterator = this.cas.createFilteredIterator(this.cas.getAnnotationIndex(this.basicType).select().coveredBy(windowAnnotation).fsIterator(), defaultConstraint);
        while (iterator.isValid()) {
            result.add((RutaBasic)iterator.get());
            iterator.moveToNext();
        }
        return result;
    }

    public RutaBasic getFirstBasicInWindow(AnnotationFS windowAnnotation) {
        return this.getFirstBasicInWindow(windowAnnotation, this.currentIt);
    }

    public RutaBasic getFirstBasicInWindow(AnnotationFS windowAnnotation, FSIterator<AnnotationFS> it) {
        if (windowAnnotation instanceof RutaBasic) {
            return (RutaBasic)windowAnnotation;
        }
        it.moveTo((FeatureStructure)windowAnnotation);
        if (it.isValid()) {
            return (RutaBasic)it.get();
        }
        return null;
    }

    public List<RutaBasic> getAnnotationsOverlappingWindow(AnnotationFS annotation) {
        if (annotation != null) {
            return this.getBasicsInWindow(annotation);
        }
        return new ArrayList<RutaBasic>();
    }

    public FSIterator<AnnotationFS> getUnfilteredBasicIterator() {
        return this.basicIt;
    }

    public FSIterator<AnnotationFS> getCurrentIterator() {
        return this.currentIt;
    }

    public AnnotationFS getDocumentAnnotation() {
        return this.documentAnnotation;
    }

    public void retainTypes(List<Type> list) {
        this.filter.retainTypes(list);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void filterTypes(List<Type> list) {
        this.filter.filterTypes(list);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void addFilterTypes(List<Type> types) {
        this.filter.addFilterTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void addRetainTypes(List<Type> types) {
        this.filter.addRetainTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void removeFilterTypes(List<Type> types) {
        this.filter.removeFilterTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void removeRetainTypes(List<Type> types) {
        this.filter.removeRetainTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public FilterManager getFilter() {
        return this.filter;
    }

    public RutaBasic getFirstBasicOfAll() {
        if (this.beginAnchors.isEmpty()) {
            return null;
        }
        return this.beginAnchors.firstEntry().getValue();
    }

    public RutaBasic getLastBasicOfAll() {
        if (this.endAnchors.isEmpty()) {
            return null;
        }
        return this.endAnchors.lastEntry().getValue();
    }

    public Type getDocumentAnnotationType() {
        return this.documentAnnotationType;
    }

    public RutaBasic getNextBasic2(AnnotationFS previous) {
        AnnotationFS pointer = this.cas.createAnnotation(this.basicType, previous.getEnd() - 1, previous.getEnd());
        this.currentIt.moveTo((FeatureStructure)pointer);
        if (this.currentIt.isValid()) {
            RutaBasic basic = (RutaBasic)this.currentIt.get();
            return basic;
        }
        return null;
    }

    public long getHistogram(Type type) {
        return this.cas.getAnnotationIndex(type).size();
    }

    public double getIndexPenalty() {
        return this.indexPenalty;
    }

    public RutaBasic getEndAnchor(int end) {
        return (RutaBasic)this.endAnchors.get(end);
    }

    public RutaBasic getBeginAnchor(int begin) {
        return (RutaBasic)this.beginAnchors.get(begin);
    }

    public boolean isDynamicAnchoring() {
        return this.dynamicAnchoring;
    }

    public void setDynamicAnchoring(boolean dynamicAnchoring) {
        this.dynamicAnchoring = dynamicAnchoring;
    }

    public boolean isGreedyRuleElement() {
        return this.greedyRuleElement;
    }

    public void setGreedyRuleElement(Boolean greedyAnchoring) {
        this.greedyRuleElement = greedyAnchoring;
    }

    public boolean isGreedyRule() {
        return this.greedyRule;
    }

    public void setGreedyRule(Boolean greedyAnchoring) {
        this.greedyRule = greedyAnchoring;
    }

    public void setIndexPenalty(double indexPenalty) {
        this.indexPenalty = indexPenalty;
    }

    public double getAnchoringFactor() {
        return this.anchoringFactor;
    }

    public void setAnchoringFactor(double anchoringFactor) {
        this.anchoringFactor = anchoringFactor;
    }

    public boolean isSimpleGreedyForComposed() {
        return this.simpleGreedyForComposed;
    }

    public void setSimpleGreedyForComposed(boolean simpleGreedyForComposed) {
        this.simpleGreedyForComposed = simpleGreedyForComposed;
    }

    public boolean isGreedyAnchoring() {
        return this.greedyRule != false || this.greedyRuleElement != false;
    }

    public boolean isOnlyOnce() {
        return this.onlyOnce;
    }

    public void setOnlyOnce(Boolean onlyOnce) {
        this.onlyOnce = onlyOnce;
    }

    public boolean isVisible(AnnotationFS annotationFS) {
        return this.isVisible(annotationFS, false);
    }

    public boolean isVisible(AnnotationFS annotationFS, boolean ignoreWindow) {
        RutaBasic endAnchor;
        if (annotationFS == null) {
            return false;
        }
        if (annotationFS.getBegin() >= annotationFS.getEnd()) {
            return false;
        }
        AnnotationFS windowAnnotation = this.filter.getWindowAnnotation();
        if (!(ignoreWindow || windowAnnotation == null || annotationFS.getBegin() >= windowAnnotation.getBegin() && annotationFS.getEnd() <= windowAnnotation.getEnd())) {
            return false;
        }
        int begin = annotationFS.getBegin();
        int end = annotationFS.getEnd();
        Set<Type> currentHiddenTypes = this.filter.getCurrentHiddenTypes();
        RutaBasic beginAnchor = this.getBeginAnchor(begin);
        if (beginAnchor != null) {
            if (beginAnchor.isEmpty() && this.emptyIsInvisible) {
                return false;
            }
            for (Type type : currentHiddenTypes) {
                boolean partOf = beginAnchor.isPartOf(type);
                if (!partOf) continue;
                return false;
            }
        }
        if ((endAnchor = this.getEndAnchor(end)) != null) {
            if (endAnchor.isEmpty() && this.emptyIsInvisible) {
                return false;
            }
            for (Type type : currentHiddenTypes) {
                boolean partOf = endAnchor.isPartOf(type);
                if (!partOf) continue;
                return false;
            }
        }
        if (beginAnchor == null && endAnchor == null) {
            Map.Entry<Integer, RutaBasic> floorEntry = this.beginAnchors.floorEntry(begin);
            Map.Entry<Integer, RutaBasic> ceilingEntry = this.endAnchors.ceilingEntry(end);
            if (floorEntry != null && ceilingEntry != null) {
                for (Type type : currentHiddenTypes) {
                    if (!floorEntry.getValue().isPartOf(type) && !ceilingEntry.getValue().isPartOf(type)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public RutaBasic getAnchor(boolean direction, int pointer) {
        if (direction) {
            return this.getBeginAnchor(pointer);
        }
        return this.getEndAnchor(pointer);
    }

    public RutaBasic getAnchor(boolean direction, AnnotationFS annotation) {
        if (direction) {
            return this.getEndAnchor(annotation.getEnd());
        }
        return this.getBeginAnchor(annotation.getBegin());
    }

    public Collection<AnnotationFS> getAnnotations(Type type) {
        return this.getAnnotations(type, this.filter.getWindowAnnotation());
    }

    public Collection<AnnotationFS> getAnnotations(Type type, AnnotationFS windowAnnotation) {
        LinkedList<AnnotationFS> result = new LinkedList<AnnotationFS>();
        if (windowAnnotation != null && (windowAnnotation.getBegin() != this.cas.getDocumentAnnotation().getBegin() || windowAnnotation.getEnd() != this.cas.getDocumentAnnotation().getEnd())) {
            return this.getAnnotationsInWindow(type, windowAnnotation, true);
        }
        AnnotationIndex annotationIndex = this.cas.getAnnotationIndex(type);
        for (AnnotationFS each : annotationIndex) {
            if (!this.isVisible(each)) continue;
            result.add(each);
        }
        return result;
    }

    public List<AnnotationFS> getAnnotationsInWindow(Type type, AnnotationFS windowAnnotation, boolean sensitiveToVisibility) {
        if (type == null || windowAnnotation == null) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationFS> result = new LinkedList<AnnotationFS>();
        if (this.cas.getTypeSystem().subsumes(type, windowAnnotation.getType()) && (!sensitiveToVisibility || this.isVisible(windowAnnotation)) && this.cas.getAnnotationIndex(windowAnnotation.getType()).contains((FeatureStructure)windowAnnotation)) {
            result.add(windowAnnotation);
        }
        List selectCovered = CasUtil.selectCovered((CAS)this.cas, (Type)type, (AnnotationFS)windowAnnotation);
        for (AnnotationFS each : selectCovered) {
            if (sensitiveToVisibility && !this.isVisible(each)) continue;
            result.add(each);
        }
        return result;
    }

    public String getVisibleCoveredText(AnnotationFS annotationFS) {
        StringBuilder result = new StringBuilder();
        List<RutaBasic> basicsInWindow = this.getBasicsInWindow(annotationFS);
        for (RutaBasic each : basicsInWindow) {
            if (!this.isVisible((AnnotationFS)each)) continue;
            result.append(each.getCoveredText());
        }
        return result.toString();
    }

    public void assignFeatureValues(FeatureStructure annotation, Map<IStringExpression, IRutaExpression> map, MatchContext context) {
        Type type = annotation.getType();
        Set<Map.Entry<IStringExpression, IRutaExpression>> entrySet = map.entrySet();
        for (Map.Entry<IStringExpression, IRutaExpression> entry : entrySet) {
            IStringExpression key = entry.getKey();
            IRutaExpression value = entry.getValue();
            String featureName = key.getStringValue(context, this);
            Feature feature = type.getFeatureByBaseName(featureName);
            if (feature == null) {
                throw new IllegalArgumentException("Not able to assign feature value for feature '" + featureName + "'. Feature is not defined for type '" + type.getName() + "' in script " + context.getParent().getName());
            }
            this.assignFeatureValue(annotation, feature, value, context);
        }
    }

    public void assignFeatureValue(FeatureStructure annotation, Feature feature, IRutaExpression value, MatchContext context) {
        if (feature == null || feature instanceof CoveredTextFeature || feature instanceof TypeFeature) {
            throw new IllegalArgumentException("Not able to assign feature value (e.g., coveredText, type) in script " + context.getParent().getName());
        }
        if (feature instanceof LazyFeature) {
            LazyFeature lazyFeature = (LazyFeature)feature;
            feature = lazyFeature.initialize(annotation);
        }
        CAS cas = annotation.getCAS();
        TypeSystem typeSystem = cas.getTypeSystem();
        Type range = feature.getRange();
        String rangeName = range.getName();
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) {
            if (value instanceof IStringExpression) {
                IStringExpression stringExpr = (IStringExpression)value;
                String string = stringExpr.getStringValue(context, this);
                annotation.setStringValue(feature, string);
            }
        } else if (rangeName.equals("uima.cas.StringArray")) {
            if (value instanceof IStringListExpression) {
                IStringListExpression stringListExpr = (IStringListExpression)((Object)value);
                List<String> stringList = stringListExpr.getStringList(context, this);
                StringArrayFS stringArray = FSCollectionFactory.createStringArrayFS((CAS)cas, stringList);
                annotation.setFeatureValue(feature, (FeatureStructure)stringArray);
            } else if (value instanceof IStringExpression) {
                IStringExpression stringExpr = (IStringExpression)value;
                String string = stringExpr.getStringValue(context, this);
                StringArrayFS array = FSCollectionFactory.createStringArrayFS((CAS)cas, (String[])new String[]{string});
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            }
        } else if (rangeName.equals("uima.cas.Integer") || rangeName.equals("uima.cas.Long") || rangeName.equals("uima.cas.Short") || rangeName.equals("uima.cas.Byte")) {
            if (value instanceof INumberExpression) {
                INumberExpression numberExpr = (INumberExpression)value;
                int v = numberExpr.getIntegerValue(context, this);
                if (annotation instanceof AnnotationFS && StringUtils.equals((CharSequence)feature.getShortName(), (CharSequence)"begin")) {
                    this.changeBegin((AnnotationFS)annotation, v, context.getRuleMatch());
                } else if (annotation instanceof AnnotationFS && StringUtils.equals((CharSequence)feature.getShortName(), (CharSequence)"end")) {
                    this.changeEnd((AnnotationFS)annotation, v, context.getRuleMatch());
                } else {
                    annotation.setIntValue(feature, v);
                }
            }
        } else if (rangeName.equals("uima.cas.IntegerArray")) {
            if (value instanceof INumberExpression) {
                INumberExpression numberExpr = (INumberExpression)value;
                int v = numberExpr.getIntegerValue(context, this);
                IntArrayFS array = FSCollectionFactory.createIntArrayFS((CAS)cas, (int[])new int[]{v});
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            } else if (value instanceof INumberListExpression) {
                INumberListExpression expr = (INumberListExpression)((Object)value);
                List<Number> list = expr.getNumberList(context, this);
                IntArrayFS array = FSCollectionFactory.createIntArrayFS((CAS)cas, (int[])RutaListUtils.toIntArray(list));
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            }
        } else if (rangeName.equals("uima.cas.Double")) {
            if (value instanceof INumberExpression) {
                INumberExpression numberExpr = (INumberExpression)value;
                double v = numberExpr.getDoubleValue(context, this);
                annotation.setDoubleValue(feature, v);
            }
        } else if (rangeName.equals("uima.cas.DoubleArray")) {
            if (value instanceof INumberExpression) {
                INumberExpression numberExpr = (INumberExpression)value;
                double v = numberExpr.getDoubleValue(context, this);
                DoubleArrayFS array = FSCollectionFactory.createDoubleArrayFS((CAS)cas, (double[])new double[]{v});
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            } else if (value instanceof INumberListExpression) {
                INumberListExpression expr = (INumberListExpression)((Object)value);
                List<Number> list = expr.getNumberList(context, this);
                DoubleArrayFS array = FSCollectionFactory.createDoubleArrayFS((CAS)cas, (double[])RutaListUtils.toDoubleArray(list));
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            }
        } else if (rangeName.equals("uima.cas.Float")) {
            if (value instanceof INumberExpression) {
                INumberExpression numberExpr = (INumberExpression)value;
                float v = numberExpr.getFloatValue(context, this);
                annotation.setFloatValue(feature, v);
            }
        } else if (rangeName.equals("uima.cas.FloatArray")) {
            if (value instanceof INumberExpression) {
                INumberExpression numberExpr = (INumberExpression)value;
                float v = numberExpr.getFloatValue(context, this);
                FloatArrayFS array = FSCollectionFactory.createFloatArrayFS((CAS)cas, (float[])new float[]{v});
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            } else if (value instanceof INumberListExpression) {
                INumberListExpression expr = (INumberListExpression)((Object)value);
                List<Number> list = expr.getNumberList(context, this);
                FloatArrayFS array = FSCollectionFactory.createFloatArrayFS((CAS)cas, (float[])RutaListUtils.toFloatArray(list));
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            }
        } else if (rangeName.equals("uima.cas.Boolean")) {
            if (value instanceof IBooleanExpression) {
                IBooleanExpression expr = (IBooleanExpression)value;
                Boolean v = expr.getBooleanValue(context, this);
                annotation.setBooleanValue(feature, v.booleanValue());
            }
        } else if (rangeName.equals("uima.cas.BooleanArray")) {
            if (value instanceof IBooleanListExpression) {
                IBooleanListExpression expr = (IBooleanListExpression)((Object)value);
                List<Boolean> list = expr.getBooleanList(context, this);
                BooleanArrayFS array = FSCollectionFactory.createBooleanArrayFS((CAS)cas, list);
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            } else if (value instanceof IBooleanExpression) {
                IBooleanExpression expr = (IBooleanExpression)value;
                Boolean v = expr.getBooleanValue(context, this);
                BooleanArrayFS array = FSCollectionFactory.createBooleanArrayFS((CAS)cas, (boolean[])new boolean[]{v});
                annotation.setFeatureValue(feature, (FeatureStructure)array);
            }
        } else if (value instanceof AnnotationTypeExpression && !range.isPrimitive()) {
            AnnotationTypeExpression ate = (AnnotationTypeExpression)value;
            if (range.isArray()) {
                List<AnnotationFS> annotations = ate.getAnnotationList(context, this);
                annotation.setFeatureValue(feature, UIMAUtils.toFSArray(this.getJCas(), annotations));
            } else {
                AnnotationFS a = ate.getAnnotation(context, this);
                annotation.setFeatureValue(feature, (FeatureStructure)a);
            }
        } else if (value instanceof IAnnotationExpression && !range.isPrimitive()) {
            IAnnotationExpression ae = (IAnnotationExpression)value;
            boolean rangeSubsumesAnnotation = cas.getTypeSystem().subsumes(cas.getAnnotationType(), range);
            Object a = null;
            a = rangeSubsumesAnnotation ? ae.getAnnotation(context, this) : ae.getFeatureStructure(context, this);
            if (range.isArray()) {
                ArrayList<AnnotationFS> c = new ArrayList<AnnotationFS>();
                c.add((AnnotationFS)a);
                annotation.setFeatureValue(feature, UIMAUtils.toFSArray(this.getJCas(), c));
            } else {
                annotation.setFeatureValue(feature, (FeatureStructure)a);
            }
        } else if (value instanceof IAnnotationListExpression && !range.isPrimitive()) {
            IAnnotationListExpression ale = (IAnnotationListExpression)value;
            List<AnnotationFS> annotations = ale.getAnnotationList(context, this);
            if (annotations != null) {
                if (range.isArray()) {
                    annotation.setFeatureValue(feature, UIMAUtils.toFSArray(this.getJCas(), annotations));
                } else if (annotations.isEmpty()) {
                    annotation.setFeatureValue(feature, null);
                } else {
                    annotation.setFeatureValue(feature, (FeatureStructure)annotations.get(0));
                }
            } else {
                annotation.setFeatureValue(feature, null);
            }
        } else if (value instanceof ITypeExpression && !range.isPrimitive()) {
            ITypeExpression typeExpr = (ITypeExpression)value;
            Type t = typeExpr.getType(context, this);
            this.assignAnnotationByTypeInWindow(annotation, feature, context, t);
        } else if (value instanceof GenericFeatureExpression && !range.isPrimitive()) {
            FeatureExpression fe = ((GenericFeatureExpression)value).getFeatureExpression();
            Type t = fe.getInitialType(context, this);
            List<AnnotationFS> inWindow = this.getAnnotationsInWindow(context.getAnnotation(), t);
            if (fe instanceof SimpleFeatureExpression) {
                SimpleFeatureExpression sfe = (SimpleFeatureExpression)fe;
                List<Object> featureAnnotations = null;
                featureAnnotations = fe.getFeatures(context, this) != null ? new ArrayList<FeatureStructure>(sfe.getFeatureStructures(inWindow, false, context, this)) : inWindow;
                if (range.isArray()) {
                    annotation.setFeatureValue(feature, UIMAUtils.toFSArray(this.getJCas(), featureAnnotations));
                } else if (!featureAnnotations.isEmpty()) {
                    FeatureStructure a = (FeatureStructure)featureAnnotations.get(0);
                    annotation.setFeatureValue(feature, a);
                }
            } else if (range.isArray()) {
                annotation.setFeatureValue(feature, UIMAUtils.toFSArray(this.getJCas(), inWindow));
            } else {
                AnnotationFS a = inWindow.get(0);
                annotation.setFeatureValue(feature, (FeatureStructure)a);
            }
        }
    }

    private void assignAnnotationByTypeInWindow(FeatureStructure annotation, Feature feature, MatchContext context, Type type) {
        List<AnnotationFS> inWindow = this.getAnnotationsInWindow(context.getAnnotation(), type);
        if (feature.getRange().isArray()) {
            annotation.setFeatureValue(feature, UIMAUtils.toFSArray(this.getJCas(), inWindow));
        } else if (inWindow != null && !inWindow.isEmpty()) {
            AnnotationFS a = inWindow.get(0);
            annotation.setFeatureValue(feature, (FeatureStructure)a);
        } else {
            annotation.setFeatureValue(feature, null);
        }
    }

    public void assignVariable(String var, IRutaExpression expression, MatchContext context) {
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        Class<?> clazz = environment.getVariableType(var);
        if (clazz.equals(Double.class) && expression instanceof INumberExpression) {
            double v = ((INumberExpression)expression).getDoubleValue(context, this);
            environment.setVariableValue(var, v);
        } else if (clazz.equals(Float.class) && expression instanceof INumberExpression) {
            float v = (float)((INumberExpression)expression).getDoubleValue(context, this);
            environment.setVariableValue(var, Float.valueOf(v));
        } else if (clazz.equals(Integer.class) && expression instanceof INumberExpression) {
            int v = ((INumberExpression)expression).getIntegerValue(context, this);
            environment.setVariableValue(var, v);
        } else if (clazz.equals(Type.class) && expression instanceof ITypeExpression) {
            Type v = ((ITypeExpression)expression).getType(context, this);
            environment.setVariableValue(var, v);
        } else if (clazz.equals(Boolean.class) && expression instanceof IBooleanExpression) {
            boolean v = ((IBooleanExpression)expression).getBooleanValue(context, this);
            environment.setVariableValue(var, v);
        } else if (clazz.equals(String.class) && expression instanceof IStringExpression) {
            String v = ((IStringExpression)expression).getStringValue(context, this);
            environment.setVariableValue(var, v);
        } else if (clazz.equals(AnnotationFS.class) && expression instanceof IAnnotationExpression) {
            AnnotationFS v = ((IAnnotationExpression)expression).getAnnotation(context, this);
            environment.setVariableValue(var, v);
        } else if (clazz.equals(List.class)) {
            Class<?> variableGenericType = environment.getVariableGenericType(var);
            if (variableGenericType.equals(AnnotationFS.class) && expression instanceof IAnnotationListExpression) {
                List<AnnotationFS> v = ((IAnnotationListExpression)expression).getAnnotationList(context, this);
                environment.setVariableValue(var, v);
            } else if (variableGenericType.equals(Boolean.class) && expression instanceof IBooleanListExpression) {
                List<Boolean> v = ((IBooleanListExpression)((Object)expression)).getBooleanList(context, this);
                environment.setVariableValue(var, v);
            } else if (Number.class.isAssignableFrom(variableGenericType) && expression instanceof INumberListExpression) {
                List<Number> v = ((INumberListExpression)((Object)expression)).getNumberList(context, this);
                environment.setVariableValue(var, v);
            } else if (variableGenericType.equals(String.class) && expression instanceof IStringListExpression) {
                List<String> v = ((IStringListExpression)((Object)expression)).getStringList(context, this);
                environment.setVariableValue(var, v);
            } else if (variableGenericType.equals(Type.class) && expression instanceof ITypeListExpression) {
                List<Type> v = ((ITypeListExpression)expression).getTypeList(context, this);
                environment.setVariableValue(var, v);
            }
        } else if (clazz.equals(Boolean.class) && expression instanceof AnnotationTypeExpression) {
            FeatureMatchExpression fme;
            IRutaExpression arg;
            AnnotationTypeExpression ate = (AnnotationTypeExpression)expression;
            AnnotationFS annotation = ate.getAnnotation(context, this);
            FeatureExpression featureExpression = ate.getFeatureExpression();
            if (featureExpression instanceof FeatureMatchExpression && (arg = (fme = (FeatureMatchExpression)featureExpression).getArg()) instanceof IAnnotationExpression) {
                AnnotationFS argAnnotation = ((IAnnotationExpression)arg).getAnnotation(context, this);
                if (StringUtils.equals((CharSequence)fme.getOp(), (CharSequence)"==")) {
                    environment.setVariableValue(var, annotation == argAnnotation);
                } else if (StringUtils.equals((CharSequence)fme.getOp(), (CharSequence)"!=")) {
                    environment.setVariableValue(var, annotation != argAnnotation);
                }
            }
        }
    }

    public <T> T getExpressionValue(Class<T> clazz, IRutaExpression expression, MatchContext context) {
        if (clazz.equals(Double.class) && expression instanceof INumberExpression) {
            double v = ((INumberExpression)expression).getDoubleValue(context, this);
            return (T)Double.valueOf(v);
        }
        if (clazz.equals(Float.class) && expression instanceof INumberExpression) {
            float v = (float)((INumberExpression)expression).getDoubleValue(context, this);
            return (T)Float.valueOf(v);
        }
        if (clazz.equals(Integer.class) && expression instanceof INumberExpression) {
            int v = ((INumberExpression)expression).getIntegerValue(context, this);
            return (T)Integer.valueOf(v);
        }
        if (clazz.equals(Type.class) && expression instanceof ITypeExpression) {
            Type v = ((ITypeExpression)expression).getType(context, this);
            return (T)v;
        }
        if (clazz.equals(Boolean.class) && expression instanceof IBooleanExpression) {
            boolean v = ((IBooleanExpression)expression).getBooleanValue(context, this);
            return (T)Boolean.valueOf(v);
        }
        if (clazz.equals(String.class) && expression instanceof IStringExpression) {
            String v = ((IStringExpression)expression).getStringValue(context, this);
            return (T)v;
        }
        if (clazz.equals(AnnotationFS.class) && expression instanceof IAnnotationExpression) {
            AnnotationFS v = ((IAnnotationExpression)expression).getAnnotation(context, this);
            return (T)v;
        }
        return null;
    }

    public AnnotationFS getSingleAnnotationByTypeInContext(Type type, MatchContext context) {
        List<AnnotationFS> inWindow = this.getAnnotationsInWindow(context.getAnnotation(), type);
        if (inWindow != null && !inWindow.isEmpty()) {
            return inWindow.get(0);
        }
        return null;
    }

    public List<AnnotationFS> getAnnotationsByTypeInContext(Type type, MatchContext context) {
        List<AnnotationFS> inWindow = this.getAnnotationsInWindow(context.getAnnotation(), type);
        return inWindow;
    }

    public List<AnnotationFS> getBestGuessedAnnotationsAt(AnnotationFS window, Type type) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        if (window == null || type == null) {
            return result;
        }
        TypeSystem typeSystem = this.getCas().getTypeSystem();
        if (typeSystem.subsumes(type, window.getType())) {
            result.add(window);
        } else {
            Collection beginAnchors = this.getBeginAnchor(window.getBegin()).getBeginAnchors(type);
            Collection endAnchors = this.getEndAnchor(window.getEnd()).getEndAnchors(type);
            Collection intersection = CollectionUtils.intersection((Iterable)beginAnchors, (Iterable)endAnchors);
            result.addAll(intersection);
        }
        return result;
    }

    public void changeOffsets(AnnotationFS annotation, int begin, int end, AbstractRuleMatch<? extends AbstractRule> modifikator) {
        if (!(annotation instanceof Annotation)) {
            return;
        }
        Annotation a = (Annotation)annotation;
        if (annotation.getBegin() == begin && annotation.getEnd() == end) {
            return;
        }
        this.removeAnnotation((AnnotationFS)a);
        a.setBegin(begin);
        a.setEnd(end);
        this.addAnnotation((AnnotationFS)a, true, modifikator);
    }

    public void changeBegin(AnnotationFS annotation, int begin, AbstractRuleMatch<? extends AbstractRule> modifikator) {
        this.changeOffsets(annotation, begin, annotation.getEnd(), modifikator);
    }

    public void changeEnd(AnnotationFS annotation, int end, AbstractRuleMatch<? extends AbstractRule> modifikator) {
        this.changeOffsets(annotation, annotation.getBegin(), end, modifikator);
    }

    public AnnotationFS getVeryFirstBeforeWindow(boolean direction) {
        if (direction) {
            RutaBasic firstBasicOfAll = this.getFirstBasicOfAll();
            int begin = firstBasicOfAll.getBegin();
            if (begin == 0) {
                return this.documentBeginAnchor;
            }
            return this.getEndAnchor(begin);
        }
        RutaBasic lastBasicOfAll = this.getLastBasicOfAll();
        int end = lastBasicOfAll.getEnd();
        if (end == this.cas.getDocumentAnnotation().getEnd()) {
            return this.documentEndAnchor;
        }
        return this.getBeginAnchor(end);
    }

    public Type getSharedParentType(List<Type> types) {
        if (types == null || types.isEmpty()) {
            return this.cas.getAnnotationType();
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        TypeSystem typeSystem = this.cas.getTypeSystem();
        Type parentType = types.get(0);
        for (Type type : types) {
            parentType = this.getSharedParentType(parentType, type, typeSystem);
        }
        return parentType;
    }

    private Type getSharedParentType(Type type1, Type type2, TypeSystem typeSystem) {
        if (this.cas.getAnnotationType().equals(type1) || this.cas.getAnnotationType().equals(type2)) {
            return this.cas.getAnnotationType();
        }
        if (type1.equals(type2)) {
            return type1;
        }
        if (typeSystem.subsumes(type1, type2)) {
            return type1;
        }
        if (typeSystem.subsumes(type2, type1)) {
            return type2;
        }
        Type parentType = typeSystem.getParent(type1);
        while (parentType != null && !this.cas.getAnnotationType().equals(parentType)) {
            if (!typeSystem.subsumes(parentType, type2)) continue;
            return parentType;
        }
        return this.cas.getAnnotationType();
    }

    public RutaAnnotation getRutaAnnotationFor(AnnotationFS annotation, boolean create, RutaStream stream) {
        Type heuristicType = this.cas.getTypeSystem().getType(RutaAnnotation.class.getName());
        List ras = CasUtil.selectAt((CAS)this.cas, (Type)heuristicType, (int)annotation.getBegin(), (int)annotation.getEnd());
        for (AnnotationFS each : ras) {
            if (((RutaAnnotation)each).getAnnotation() != annotation) continue;
            return (RutaAnnotation)each;
        }
        if (create) {
            JCas jCas = stream.getJCas();
            RutaAnnotation result = new RutaAnnotation(jCas, annotation.getBegin(), annotation.getEnd());
            result.setAnnotation((Annotation)annotation);
            result.addToIndexes();
            return result;
        }
        return null;
    }

    private Collection<Type> removeSubsumedTypes(Collection<Type> types, TypeSystem typeSystem) {
        ArrayList<Type> rootTypes = new ArrayList<Type>(types);
        for (Type type1 : types) {
            for (Type type2 : types) {
                if (type1 == type2 || !typeSystem.subsumes(type1, type2)) continue;
                rootTypes.remove(type2);
            }
        }
        return rootTypes;
    }

    private Collection<Type> expandToAllSubtypes(Collection<Type> reindexTypeList, Collection<Type> reindexSkipTypes, TypeSystem typeSystem) {
        if (reindexTypeList.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Type> result = new LinkedHashSet<Type>();
        for (Type type : reindexTypeList) {
            if (this.skipTypeForIndexing(type, reindexSkipTypes, typeSystem)) continue;
            result.add(type);
            List properlySubsumedTypes = typeSystem.getProperlySubsumedTypes(type);
            for (Type subType : properlySubsumedTypes) {
                if (this.skipTypeForIndexing(subType, reindexSkipTypes, typeSystem)) continue;
                result.add(subType);
            }
            if (!type.getName().equals("uima.tcas.Annotation")) continue;
            return result;
        }
        return result;
    }

    private Collection<Type> convertNamesToTypes(String[] typeNames, TypeSystem typeSystem) {
        if (typeNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>(typeNames.length);
        for (String each : typeNames) {
            Type type = typeSystem.getType(each);
            if (type == null) continue;
            result.add(type);
        }
        return result;
    }

    public void setMaxRuleMatches(long maxRuleMatches) {
        this.maxRuleMatches = maxRuleMatches;
    }

    public void setMaxRuleElementMatches(long maxRuleElementMatches) {
        this.maxRuleElementMatches = maxRuleElementMatches;
    }

    public long getMaxRuleMatches() {
        return this.maxRuleMatches;
    }

    public long getMaxRuleElementMatches() {
        return this.maxRuleElementMatches;
    }
}

