/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Clazz {
    public static boolean hasClazz(ClassLoader classLoader, String clazzName) {
        try {
            classLoader.loadClass(clazzName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class getClazz(ClassLoader classLoader, String clazzName) throws ClassNotFoundException {
        return classLoader.loadClass(clazzName);
    }

    public static Object newInstance(Class clazz, Class[] signature, Object[] args) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Object result = null;
        Constructor constructor = clazz.getConstructor(signature);
        result = constructor.newInstance(args);
        return result;
    }

    public static Object invoke(Object instance, String methodName, Class[] signature, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object result = null;
        Method method = instance.getClass().getMethod(methodName, signature);
        result = method.invoke(instance, args);
        return result;
    }

    public static Object invoke(Class clazz, String methodName, Class[] signature, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object result = null;
        Method method = clazz.getMethod(methodName, signature);
        result = method.invoke(null, args);
        return result;
    }

    public static List getAllInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList<Class> list = new ArrayList<Class>();
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                List superInterfaces = Clazz.getAllInterfaces(interfaces[i]);
                for (Class intface : superInterfaces) {
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
            }
            cls = cls.getSuperclass();
        }
        return list;
    }
}

