/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.crypto;

import java.io.InputStream;
import org.apache.fulcrum.yaafi.framework.reflection.Clazz;

public class CryptoStreamFactory {
    private static boolean isInitialized;
    private static Object cryptoStreamFactory;
    private static String className;

    public static InputStream getDecryptingInputStream(InputStream is, String isEncrypted) throws Exception {
        InputStream result;
        if (isEncrypted.equalsIgnoreCase("true")) {
            result = CryptoStreamFactory.createDecryptingInputStream(is, "getInputStream");
        } else if (isEncrypted.equalsIgnoreCase("auto") && CryptoStreamFactory.hasCryptoStreamFactory()) {
            result = CryptoStreamFactory.createDecryptingInputStream(is, "getSmartInputStream");
        } else if (isEncrypted.equalsIgnoreCase("auto") && !CryptoStreamFactory.hasCryptoStreamFactory()) {
            result = is;
        } else if (isEncrypted.equalsIgnoreCase("false")) {
            result = is;
        } else {
            throw new IllegalArgumentException("Unknown decryption mode : " + isEncrypted);
        }
        return result;
    }

    private static InputStream createDecryptingInputStream(InputStream is, String factoryMethodName) throws Exception {
        Class[] signature = new Class[]{InputStream.class};
        Object[] args = new Object[]{is};
        Object cryptoStreamFactory = CryptoStreamFactory.getCryptoStreamFactory();
        if (cryptoStreamFactory == null) {
            throw new IllegalStateException("No CryptoStreamFactory available - unable to create a decrypting input stream");
        }
        return (InputStream)Clazz.invoke(cryptoStreamFactory, factoryMethodName, signature, args);
    }

    private static synchronized Object getCryptoStreamFactory() throws Exception {
        if (!isInitialized) {
            isInitialized = true;
            ClassLoader clazzLoader = CryptoStreamFactory.class.getClassLoader();
            if (Clazz.hasClazz(clazzLoader, className)) {
                Class[] signature = new Class[]{};
                Object[] args = new Object[]{};
                Class clazz = Clazz.getClazz(clazzLoader, className);
                cryptoStreamFactory = Clazz.newInstance(clazz, signature, args);
            }
        }
        return cryptoStreamFactory;
    }

    private static boolean hasCryptoStreamFactory() throws Exception {
        return CryptoStreamFactory.getCryptoStreamFactory() != null;
    }

    static {
        className = "org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl";
    }
}

