/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.DefaultLogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.DefaultLogTargetManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class DefaultLogKitManager
extends AbstractLogEnabled
implements LogKitManager,
Loggable,
Contextualizable,
Configurable {
    private final Map m_loggers = new HashMap();
    private Context m_context;
    private Hierarchy m_hierarchy;
    private String m_prefix;

    public DefaultLogKitManager() {
        this(new Hierarchy());
    }

    public DefaultLogKitManager(Hierarchy hierarchy) {
        this(null, hierarchy);
    }

    public DefaultLogKitManager(String prefix) {
        this(prefix, new Hierarchy());
    }

    public DefaultLogKitManager(String prefix, Hierarchy hierarchy) {
        this.m_prefix = prefix;
        this.m_hierarchy = hierarchy;
    }

    public void setLogger(Logger logger) {
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(logger));
    }

    public final Logger getLogger(String categoryName) {
        Logger logger = (Logger)this.m_loggers.get(categoryName);
        if (null != logger) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Logger for category " + categoryName + " returned");
            }
            return logger;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Logger for category " + categoryName + " not defined in configuration. New Logger created and returned");
        }
        return this.m_hierarchy.getLoggerFor(categoryName);
    }

    public Hierarchy getHierarchy() {
        return this.m_hierarchy;
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration factories = configuration.getChild("factories");
        LogTargetFactoryManager targetFactoryManager = this.setupTargetFactoryManager(factories);
        Configuration targets = configuration.getChild("targets");
        LogTargetManager targetManager = this.setupTargetManager(targets, targetFactoryManager);
        Configuration categories = configuration.getChild("categories");
        String debugURL = configuration.getAttribute("debug", null);
        Configuration[] category = categories.getChildren("category");
        this.setupLoggers(targetManager, this.m_prefix, category);
        if (null != debugURL) {
            try {
                File rootContext = (File)this.m_context.get((Object)"context-root");
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration debugCategories = builder.buildFromFile(new File(rootContext, debugURL));
                Configuration[] debugCat = debugCategories.getChildren("category");
                this.setupLoggers(targetManager, this.m_prefix, debugCat);
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception e) {
                this.getLogger().info("Either there was no \"debug.xlog\" file, or there was a problem reading it.");
                this.getLogger().debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private final LogTargetFactoryManager setupTargetFactoryManager(Configuration configuration) throws ConfigurationException {
        DefaultLogTargetFactoryManager targetFactoryManager = new DefaultLogTargetFactoryManager();
        ContainerUtil.enableLogging((Object)targetFactoryManager, (org.apache.avalon.framework.logger.Logger)this.getLogger());
        try {
            ContainerUtil.contextualize((Object)targetFactoryManager, (Context)this.m_context);
        }
        catch (ContextException ce) {
            String message = "cannot contextualize default factory manager";
            throw new ConfigurationException("cannot contextualize default factory manager", (Throwable)ce);
        }
        ContainerUtil.configure((Object)targetFactoryManager, (Configuration)configuration);
        return targetFactoryManager;
    }

    private final LogTargetManager setupTargetManager(Configuration configuration, LogTargetFactoryManager targetFactoryManager) throws ConfigurationException {
        DefaultLogTargetManager targetManager = new DefaultLogTargetManager();
        ContainerUtil.enableLogging((Object)targetManager, (org.apache.avalon.framework.logger.Logger)this.getLogger());
        try {
            ContainerUtil.contextualize((Object)targetManager, (Context)this.m_context);
        }
        catch (ContextException ce) {
            String message = "cannot contextualize factory manager";
            throw new ConfigurationException("cannot contextualize factory manager", (Throwable)ce);
        }
        targetManager.setLogTargetFactoryManager(targetFactoryManager);
        ContainerUtil.configure((Object)targetManager, (Configuration)configuration);
        return targetManager;
    }

    private final void setupLoggers(LogTargetManager targetManager, String parentCategory, Configuration[] categories) throws ConfigurationException {
        for (int i = 0; i < categories.length; ++i) {
            String category = categories[i].getAttribute("name");
            String loglevel = categories[i].getAttribute("log-level").toUpperCase();
            Configuration[] targets = categories[i].getChildren("log-target");
            LogTarget[] logTargets = new LogTarget[targets.length];
            for (int j = 0; j < targets.length; ++j) {
                String id = targets[j].getAttribute("id-ref");
                logTargets[j] = targetManager.getLogTarget(id);
            }
            if ("".equals(category) && logTargets.length > 0) {
                this.m_hierarchy.setDefaultPriority(Priority.getPriorityForName((String)loglevel));
                this.m_hierarchy.setDefaultLogTargets(logTargets);
            }
            String fullCategory = null == parentCategory ? category : parentCategory + '.' + category;
            Logger logger = this.m_hierarchy.getLoggerFor(fullCategory);
            this.m_loggers.put(fullCategory, logger);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("added logger for category " + fullCategory);
            }
            logger.setPriority(Priority.getPriorityForName((String)loglevel));
            logger.setLogTargets(logTargets);
            Configuration[] subCategories = categories[i].getChildren("category");
            if (null == subCategories) continue;
            this.setupLoggers(targetManager, fullCategory, subCategories);
        }
    }
}

