/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.parser.ParserService;
import org.apache.fulcrum.parser.ParserServiceSupport;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;
import org.apache.fulcrum.upload.UploadService;

public class DefaultParserService
extends AbstractLogEnabled
implements ParserService,
Configurable,
Serviceable {
    private ValueParser.URLCaseFolding folding = ValueParser.URLCaseFolding.NONE;
    private boolean automaticUpload = false;
    private String parameterEncoding = "ISO-8859-1";
    private UploadService uploadService = null;
    private PoolService poolService = null;

    @Override
    public String getParameterEncoding() {
        return this.parameterEncoding;
    }

    @Override
    public String convert(String value) {
        return this.convertAndTrim(value);
    }

    @Override
    public String convertAndTrim(String value) {
        return this.convertAndTrim(value, this.getUrlFolding());
    }

    @Override
    public String convertAndTrim(String value, ValueParser.URLCaseFolding fold) {
        if (value == null) {
            return "";
        }
        String tmp = value.trim();
        switch (fold) {
            case NONE: {
                break;
            }
            case LOWER: {
                tmp = tmp.toLowerCase();
                break;
            }
            case UPPER: {
                tmp = tmp.toUpperCase();
                break;
            }
            default: {
                this.getLogger().error("Passed " + (Object)((Object)fold) + " as fold rule, which is illegal!");
            }
        }
        return tmp;
    }

    @Override
    public ValueParser.URLCaseFolding getUrlFolding() {
        return this.folding;
    }

    @Override
    public boolean getAutomaticUpload() {
        return this.automaticUpload;
    }

    @Override
    public List<FileItem> parseUpload(HttpServletRequest request) throws ServiceException {
        if (this.uploadService == null) {
            throw new ServiceException(ParserService.ROLE, "UploadService is not available.");
        }
        return this.uploadService.parseRequest(request);
    }

    public FileItemIterator getItemIterator(HttpServletRequest request) throws ServiceException {
        if (this.uploadService == null) {
            throw new ServiceException(ParserService.ROLE, "UploadService is not available.");
        }
        return this.uploadService.getItemIterator(request);
    }

    @Override
    public <P extends ValueParser> P getParser(Class<P> ppClass) throws InstantiationException {
        ValueParser vp = null;
        try {
            ValueParser parserInstance;
            vp = parserInstance = (ValueParser)this.poolService.getInstance(ppClass);
            if (vp instanceof ParserServiceSupport) {
                ((ParserServiceSupport)((Object)vp)).setParserService(this);
            }
            if (vp instanceof LogEnabled) {
                ((LogEnabled)vp).enableLogging(this.getLogger().getChildLogger(ppClass.getSimpleName()));
            }
        }
        catch (PoolException pe) {
            throw new InstantiationException("Parser class '" + ppClass + "' is illegal. " + pe.getMessage());
        }
        catch (ClassCastException x) {
            throw new InstantiationException("Parser class '" + ppClass + "' is illegal. " + x.getMessage());
        }
        return (P)vp;
    }

    @Override
    public void putParser(ValueParser parser) {
        parser.clear();
        this.poolService.putInstance((Object)parser);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String foldString = conf.getChild("urlCaseFolding").getValue(ValueParser.URLCaseFolding.NONE.name()).toLowerCase();
        this.folding = ValueParser.URLCaseFolding.NONE;
        this.getLogger().debug("Setting folding from " + foldString);
        if (StringUtils.isNotEmpty((String)foldString)) {
            try {
                this.folding = ValueParser.URLCaseFolding.valueOf(foldString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().error("Got " + foldString + " from " + "urlCaseFolding" + " property, which is illegal!");
                throw new ConfigurationException("Value " + foldString + " is illegal!", (Throwable)e);
            }
        }
        this.parameterEncoding = conf.getChild("parameterEncoding").getValue("ISO-8859-1").toLowerCase();
        this.automaticUpload = conf.getChild("automaticUpload").getValueAsBoolean(false);
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(UploadService.ROLE)) {
            this.uploadService = (UploadService)manager.lookup(UploadService.ROLE);
        } else if (this.getAutomaticUpload()) {
            throw new ServiceException(ParserService.ROLE, "automaticUpload = true requires " + UploadService.ROLE + " to be available");
        }
        if (!manager.hasService(PoolService.ROLE)) {
            throw new ServiceException(ParserService.ROLE, "Service requires " + PoolService.ROLE + " to be available");
        }
        this.poolService = (PoolService)manager.lookup(PoolService.ROLE);
    }
}

