/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.webapp;

import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.xml.XmlParser;

public abstract class Descriptor {
    protected Resource _xml;
    protected XmlParser.Node _root;
    protected XmlParser _parser;
    protected boolean _validating;

    public Descriptor(Resource xml) {
        this._xml = xml;
    }

    public abstract void ensureParser() throws ClassNotFoundException;

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws Exception {
        if (this._parser == null) {
            this.ensureParser();
        }
        if (this._root == null) {
            try {
                this._root = this._parser.parse(this._xml.getInputStream());
            }
            finally {
                this._xml.close();
            }
        }
    }

    public Resource getResource() {
        return this._xml;
    }

    public XmlParser.Node getRoot() {
        return this._root;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._xml + ")";
    }
}

