/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.xbean.finder.util.Files;

public final class ClassLoaders {
    private static final boolean DONT_USE_GET_URLS = Boolean.getBoolean("xbean.finder.use.get-resources");
    private static final ClassLoader SYSTEM = ClassLoader.getSystemClassLoader();
    private static final boolean UNIX = !System.getProperty("os.name").toLowerCase().contains("win");
    private static final Pattern MJAR_PATTERN = Pattern.compile(".*/META-INF/versions/[0-9]+/$");

    public static Set<URL> findUrls(ClassLoader classLoader) throws IOException {
        if (classLoader == null || SYSTEM.getParent() != null && classLoader == SYSTEM.getParent()) {
            return Collections.emptySet();
        }
        HashSet<URL> urls = new HashSet<URL>();
        if (URLClassLoader.class.isInstance(classLoader) && !DONT_USE_GET_URLS) {
            if (!ClassLoaders.isSurefire(classLoader)) {
                for (Collection item : Arrays.asList(Arrays.asList(((URLClassLoader)URLClassLoader.class.cast(classLoader)).getURLs()), ClassLoaders.findUrls(classLoader.getParent()))) {
                    for (URL url : item) {
                        ClassLoaders.addIfNotSo(urls, url);
                    }
                }
            } else {
                urls.addAll(ClassLoaders.fromClassPath());
            }
        }
        if (urls.size() <= 1) {
            URL theUrl;
            Set<URL> urlFromResources = ClassLoaders.findUrlFromResources(classLoader);
            if (!urls.isEmpty() && "file".equals((theUrl = (URL)urls.iterator().next()).getProtocol())) {
                urlFromResources.remove(new URL("jar:" + theUrl.toExternalForm() + "!/"));
            }
            urls.addAll(urlFromResources);
        }
        return urls;
    }

    private static void addIfNotSo(Set<URL> urls, URL url) {
        if (UNIX && ClassLoaders.isNative(url)) {
            return;
        }
        urls.add(url);
    }

    public static boolean isNative(URL url) {
        String name;
        File file = Files.toFile(url);
        return file != null && !(name = file.getName()).endsWith(".jar") && !file.isDirectory() && name.contains(".so") && file.getAbsolutePath().startsWith("/usr/lib");
    }

    private static boolean isSurefire(ClassLoader classLoader) {
        return System.getProperty("surefire.real.class.path") != null && classLoader == SYSTEM;
    }

    private static Collection<URL> fromClassPath() {
        String[] cp = System.getProperty("java.class.path").split(System.getProperty("path.separator", ":"));
        HashSet<URL> urls = new HashSet<URL>();
        for (String path : cp) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    public static Set<URL> findUrlFromResources(ClassLoader classLoader) throws IOException {
        String externalForm;
        HashSet<URL> set = new HashSet<URL>();
        for (URL url : Collections.list(classLoader.getResources("META-INF"))) {
            externalForm = url.toExternalForm();
            set.add(new URL(externalForm.substring(0, externalForm.lastIndexOf("META-INF"))));
        }
        for (URL url : Collections.list(classLoader.getResources(""))) {
            externalForm = url.toExternalForm();
            if (MJAR_PATTERN.matcher(externalForm).matches()) {
                set.add(new URL(externalForm.substring(0, externalForm.lastIndexOf("META-INF"))));
                continue;
            }
            set.add(url);
        }
        return set;
    }

    private ClassLoaders() {
    }
}

