/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChain;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="service-refType", propOrder={"descriptions", "displayNames", "icon", "serviceRefName", "serviceInterface", "serviceRefType", "wsdlFile", "jaxrpcMappingFile", "serviceQname", "portComponentRef", "handler", "handlerChains", "mappedName", "injectionTarget", "lookupName"})
public class ServiceRef
implements JndiReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    @XmlElement(name="service-ref-name", required=true)
    protected String serviceRefName;
    @XmlElement(name="service-interface", required=true)
    protected String serviceInterface;
    @XmlElement(name="service-ref-type")
    protected String serviceRefType;
    @XmlElement(name="wsdl-file")
    protected String wsdlFile;
    @XmlElement(name="jaxrpc-mapping-file")
    protected String jaxrpcMappingFile;
    @XmlElement(name="service-qname")
    protected QName serviceQname;
    @XmlElement(name="port-component-ref", required=true)
    protected List<PortComponentRef> portComponentRef;
    @XmlElement(required=true)
    protected List<Handler> handler;
    @XmlElement(name="handler-chains")
    protected HandlerChains handlerChains;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public ServiceRef name(String serviceRefName) {
        this.serviceRefName = serviceRefName;
        return this;
    }

    public ServiceRef type(String serviceRefType) {
        this.serviceRefType = serviceRefType;
        return this;
    }

    public ServiceRef type(Class<?> serviceRefType) {
        return this.type(serviceRefType.getName());
    }

    public ServiceRef wsdl(String wsdlFile) {
        this.wsdlFile = wsdlFile;
        return this;
    }

    public ServiceRef qname(QName serviceQname) {
        this.serviceQname = serviceQname;
        return this;
    }

    public ServiceRef jaxrpcMappingFile(String jaxrpcMappingFile) {
        this.jaxrpcMappingFile = jaxrpcMappingFile;
        return this;
    }

    public ServiceRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public ServiceRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public ServiceRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.serviceRefName == null) {
            this.serviceRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public ServiceRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    public String getName() {
        return this.getServiceRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    public String getType() {
        return this.getServiceRefType();
    }

    @Override
    public void setName(String name) {
        this.setServiceRefName(name);
    }

    @Override
    public void setType(String type) {
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    public Icon getIcon() {
        return this.icon.getLocal();
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setServiceRefName(String value) {
        this.serviceRefName = value;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String value) {
        this.serviceInterface = value;
    }

    public String getServiceRefType() {
        return this.serviceRefType;
    }

    public void setServiceRefType(String value) {
        this.serviceRefType = value;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String value) {
        this.wsdlFile = value;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String value) {
        this.jaxrpcMappingFile = value;
    }

    public QName getServiceQname() {
        return this.serviceQname;
    }

    public void setServiceQname(QName value) {
        this.serviceQname = value;
    }

    public List<PortComponentRef> getPortComponentRef() {
        if (this.portComponentRef == null) {
            this.portComponentRef = new ArrayList<PortComponentRef>();
        }
        return this.portComponentRef;
    }

    public HandlerChains getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(HandlerChains value) {
        this.handlerChains = value;
    }

    public List<Handler> getHandler() {
        if (this.handler == null) {
            this.handler = new ArrayList<Handler>();
        }
        return this.handler;
    }

    public HandlerChains getAllHandlers() {
        if (this.handlerChains == null && this.handler != null) {
            HandlerChains handlerChains = new HandlerChains();
            HandlerChain handlerChain = new HandlerChain();
            handlerChain.getHandler().addAll(this.handler);
            handlerChains.getHandlerChain().add(handlerChain);
            return handlerChains;
        }
        return this.handlerChains;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "ServiceRef{name='" + this.serviceRefName + "', interface='" + this.serviceInterface + "', type='" + this.serviceRefType + "', wsdl='" + this.wsdlFile + "', qname=" + String.valueOf(this.serviceQname) + ", mappedName='" + this.mappedName + "', lookupName='" + this.lookupName + "'}";
    }
}

