/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StatementWithFinallyBlock;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class BranchStatement
extends Statement {
    public char[] label;
    public BranchLabel targetLabel;
    public StatementWithFinallyBlock[] statementsWithFinallyBlock;
    public int initStateIndex = -1;

    public BranchStatement(char[] label, int sourceStart, int sourceEnd) {
        this.label = label;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.statementsWithFinallyBlock != null) {
            int i = 0;
            int max = this.statementsWithFinallyBlock.length;
            while (i < max) {
                StatementWithFinallyBlock stmt = this.statementsWithFinallyBlock[i];
                boolean didEscape = stmt.generateFinallyBlock(currentScope, codeStream, this.initStateIndex);
                if (didEscape) {
                    codeStream.recordPositionsFrom(pc, this.sourceStart);
                    StatementWithFinallyBlock.reenterAllExceptionHandlers(this.statementsWithFinallyBlock, i, codeStream);
                    if (this.initStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.initStateIndex);
                        codeStream.addDefinitelyAssignedVariables(currentScope, this.initStateIndex);
                    }
                    return;
                }
                ++i;
            }
        }
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        StatementWithFinallyBlock.reenterAllExceptionHandlers(this.statementsWithFinallyBlock, -1, codeStream);
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.initStateIndex);
        }
    }

    @Override
    public void resolve(BlockScope scope) {
    }
}

