/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CallStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CallStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.DummyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.service.Service;
import org.apache.tinkerpop.gremlin.structure.service.ServiceRegistry;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class CallStepPlaceholder<S, E>
extends AbstractStep<S, E>
implements CallStepContract<S, E>,
GValueHolder<S, E> {
    private final boolean isStart;
    private final String serviceName;
    private GValue<Map<?, ?>> staticParams;
    private Traversal.Admin<S, Map> mapTraversal;
    private Parameters parameters;

    public CallStepPlaceholder(Traversal.Admin traversal, boolean isStart) {
        this(traversal, isStart, null);
    }

    public CallStepPlaceholder(Traversal.Admin traversal, boolean isStart, String service) {
        this(traversal, isStart, service, null);
    }

    public CallStepPlaceholder(Traversal.Admin traversal, boolean isStart, String service, GValue<Map<?, ?>> staticParams) {
        this(traversal, isStart, service, staticParams, null);
    }

    public CallStepPlaceholder(Traversal.Admin traversal, boolean isStart, String service, GValue<Map<?, ?>> staticParams, Traversal.Admin<S, Map<?, ?>> mapTraversal) {
        super(traversal);
        this.isStart = isStart;
        this.serviceName = service;
        this.staticParams = staticParams == null ? GValue.of(new LinkedHashMap()) : staticParams;
        this.mapTraversal = mapTraversal == null ? null : this.integrateChild(mapTraversal);
        this.parameters = new Parameters();
        if (this.staticParams.isVariable()) {
            traversal.getGValueManager().register(this.staticParams);
        }
    }

    @Override
    public Service<S, E> service() {
        if (this.staticParams.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.staticParams.getName());
        }
        return this.getServiceRegistry().get(this.serviceName, this.isStart, this.staticParams.get());
    }

    @Override
    public Service<S, E> serviceGValueSafe() {
        return this.getServiceRegistry().get(this.serviceName, this.isStart, this.staticParams.get());
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        throw new IllegalStateException("GValuePlaceholder step is not executable");
    }

    @Override
    public Map getStaticParams() {
        if (this.staticParams.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.staticParams.getName());
        }
        return Collections.unmodifiableMap(this.staticParams.get());
    }

    @Override
    public GValue<Map> getStaticParamsAsGValue() {
        if (this.staticParams == null) {
            return GValue.ofMap(null);
        }
        return GValue.of(this.staticParams.getName(), Collections.unmodifiableMap(this.staticParams.get()));
    }

    @Override
    public Map getMergedParams() {
        if (this.mapTraversal == null && this.parameters.isEmpty()) {
            return this.getStaticParams();
        }
        return this.getMergedParams(new DummyTraverser(this.traversal.getTraverserGenerator()));
    }

    protected Map getMergedParams(Traverser.Admin<S> traverser) {
        if (this.mapTraversal == null && this.parameters.isEmpty()) {
            return this.getStaticParams();
        }
        LinkedHashMap<Object, Object> params = new LinkedHashMap<Object, Object>(this.getStaticParams());
        if (this.mapTraversal != null) {
            params.putAll(TraversalUtil.apply(traverser, this.mapTraversal));
        }
        Object[] kvs = this.parameters.getKeyValues(traverser, new Object[0]);
        for (int i = 0; i < kvs.length; i += 2) {
            params.put(kvs[i], kvs[i + 1]);
        }
        return params;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        Graph graph = this.traversal.getGraph().get();
        return graph.getServiceRegistry();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.mapTraversal != null) {
            this.mapTraversal.reset();
        }
        this.parameters.getTraversals().forEach(Traversal.Admin::reset);
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        ArrayList children = new ArrayList();
        if (this.mapTraversal != null) {
            children.add(this.mapTraversal);
        }
        children.addAll(this.parameters.getTraversals());
        return children;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (this.mapTraversal != null) {
            this.integrateChild(this.mapTraversal);
        }
        this.parameters.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        Set<TraverserRequirement> requirements = this.getSelfAndChildRequirements(new TraverserRequirement[0]);
        requirements.addAll(this.service().getRequirements());
        return requirements;
    }

    @Override
    public String toString() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.serviceName);
        if (!this.staticParams.get().isEmpty()) {
            args.add(this.staticParams);
        }
        if (this.mapTraversal != null) {
            args.add(this.mapTraversal);
        }
        if (!this.parameters.isEmpty()) {
            args.add(this.parameters);
        }
        return StringFactory.stepString(this, args.toArray());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CallStepPlaceholder that = (CallStepPlaceholder)o;
        return this.isStart == that.isStart && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.staticParams, that.staticParams) && Objects.equals(this.mapTraversal, that.mapTraversal) && Objects.equals(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isStart, this.serviceName, this.staticParams, this.mapTraversal, this.parameters);
    }

    @Override
    public CallStepPlaceholder<S, E> clone() {
        CallStepPlaceholder clone = (CallStepPlaceholder)super.clone();
        clone.staticParams = this.staticParams != null ? this.staticParams.clone() : null;
        clone.mapTraversal = this.mapTraversal != null ? this.mapTraversal.clone() : null;
        clone.parameters = this.parameters.clone();
        return clone;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(this, keyValues);
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public CallStep<S, E> asConcreteStep() {
        CallStep step = new CallStep(this.traversal, this.isStart, this.serviceName, this.staticParams.get(), this.mapTraversal);
        for (Map.Entry<Object, List<Object>> entry : this.parameters.getRaw(new Object[0]).entrySet()) {
            for (Object value : entry.getValue()) {
                step.configure(entry.getKey(), value);
            }
        }
        return step;
    }

    @Override
    public boolean isParameterized() {
        return this.staticParams.isVariable();
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (name.equals(this.staticParams.getName())) {
            this.staticParams = GValue.of(name, (Map)value);
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        return this.staticParams.isVariable() ? List.of(this.staticParams) : Collections.emptyList();
    }
}

