/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GremlinScriptChecker {
    public static final Result EMPTY_RESULT = new Result(null, null, null);
    private static final Set<String> tokens = new HashSet<String>(Arrays.asList("evaluationTimeout", "scriptEvaluationTimeout", "ARGS_EVAL_TIMEOUT", "ARGS_SCRIPT_EVAL_TIMEOUT", "requestId", "REQUEST_ID", "materializeProperties", "ARGS_MATERIALIZE_PROPERTIES"));
    private static final Pattern patternClean = Pattern.compile("//.*$|/\\*(.|[\\r\\n])*?\\*/|\\s", 8);
    private static final String timeoutTokens = "[\"']evaluationTimeout[\"']|[\"']scriptEvaluationTimeout[\"']|(?:Tokens\\.)?ARGS_EVAL_TIMEOUT|(?:Tokens\\.)?ARGS_SCRIPT_EVAL_TIMEOUT";
    private static final String requestIdTokens = "[\"']requestId[\"']|(?:Tokens\\.)?REQUEST_ID";
    private static final String materializePropertiesTokens = "[\"']materializeProperties[\"']|(?:Tokens\\.)?ARGS_MATERIALIZE_PROPERTIES";
    private static final Pattern patternWithOptions = Pattern.compile("\\.with\\((((?:[\"']evaluationTimeout[\"']|[\"']scriptEvaluationTimeout[\"']|(?:Tokens\\.)?ARGS_EVAL_TIMEOUT|(?:Tokens\\.)?ARGS_SCRIPT_EVAL_TIMEOUT),(?<to>\\d*)(:?L|l)?)|((?:[\"']materializeProperties[\"']|(?:Tokens\\.)?ARGS_MATERIALIZE_PROPERTIES),[\"'](?<mp>.*?)[\"']?)|((?:[\"']requestId[\"']|(?:Tokens\\.)?REQUEST_ID),[\"'](?<rid>.*?)[\"']))\\)");

    public static Result parse(String gremlin) {
        if (gremlin.isEmpty()) {
            return EMPTY_RESULT;
        }
        if (tokens.stream().noneMatch(gremlin::contains)) {
            return EMPTY_RESULT;
        }
        String cleanGremlin = patternClean.matcher(gremlin).replaceAll("");
        Matcher m = patternWithOptions.matcher(cleanGremlin);
        if (!m.find()) {
            return EMPTY_RESULT;
        }
        Long timeout = null;
        String requestId = null;
        String materializeProperties = null;
        do {
            String mp;
            String rid;
            String to;
            if ((to = m.group("to")) != null) {
                if (null == timeout) {
                    timeout = 0L;
                }
                timeout = timeout + Long.parseLong(to);
            }
            if ((rid = m.group("rid")) != null) {
                requestId = rid;
            }
            if ((mp = m.group("mp")) == null) continue;
            materializeProperties = mp;
        } while (m.find());
        return new Result(timeout, requestId, materializeProperties);
    }

    public static class Result {
        private final Long timeout;
        private final String requestId;
        private final String materializeProperties;

        private Result(Long timeout, String requestId, String materializeProperties) {
            this.timeout = timeout;
            this.requestId = requestId;
            this.materializeProperties = materializeProperties;
        }

        public final Optional<Long> getTimeout() {
            return null == this.timeout ? Optional.empty() : Optional.of(this.timeout);
        }

        public Optional<String> getRequestId() {
            return null == this.requestId ? Optional.empty() : Optional.of(this.requestId);
        }

        public Optional<String> getMaterializeProperties() {
            return null == this.materializeProperties ? Optional.empty() : Optional.of(this.materializeProperties);
        }

        public String toString() {
            return "GremlinScriptChecker.Result{timeout=" + this.timeout + ", requestId='" + this.requestId + "', materializeProperties='" + this.materializeProperties + "'}";
        }
    }
}

