/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.util.List;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.shared.AttributeConvention;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.filter.sqlmm.SpatialFunction;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class TwoGeometries<R>
extends SpatialFunction<R> {
    private static final long serialVersionUID = -5209470632171445234L;
    final Expression<R, GeometryWrapper> geometry1;
    final Expression<R, GeometryWrapper> geometry2;

    TwoGeometries(SQLMM operation, Expression<R, ?>[] parameters, Geometries<?> library) {
        super(operation, parameters);
        this.geometry1 = TwoGeometries.toGeometryWrapper(library, parameters[0]);
        this.geometry2 = TwoGeometries.toGeometryWrapper(library, parameters[1]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new TwoGeometries<R>(this.operation, effective, this.getGeometryLibrary());
    }

    @Override
    public Expression<R, ?> optimize(Optimization optimization) {
        Expression<R, ?> p1;
        DefaultFeatureType featureType = optimization.getFeatureType();
        if (featureType != null && (p1 = TwoGeometries.unwrap(this.geometry1)) instanceof ValueReference && TwoGeometries.unwrap(this.geometry2) instanceof Literal) {
            try {
                GeometryWrapper tr;
                GeometryWrapper literal;
                CoordinateReferenceSystem targetCRS = AttributeConvention.getCRSCharacteristic(featureType, featureType.getProperty(((ValueReference)p1).getXPath()));
                if (targetCRS != null && (literal = this.geometry2.apply((Object)null)) != null && (tr = literal.transform(targetCRS)) != literal) {
                    Expression[] effective = (Expression[])this.getParameters().toArray(Expression[]::new);
                    effective[1] = Optimization.literal(tr);
                    return this.recreate(effective);
                }
            }
            catch (IllegalArgumentException | TransformException e) {
                this.warning((Exception)e, true);
            }
        }
        return super.optimize(optimization);
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return TwoGeometries.getGeometryLibrary(this.geometry1);
    }

    @Override
    public Class<? super R> getResourceClass() {
        return TwoGeometries.specializedClass(this.geometry1.getResourceClass(), this.geometry2.getResourceClass());
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return List.of(TwoGeometries.unwrap(this.geometry1), TwoGeometries.unwrap(this.geometry2));
    }

    @Override
    public Object apply(R input) {
        GeometryWrapper other;
        GeometryWrapper value = this.geometry1.apply(input);
        if (value != null && (other = this.geometry2.apply(input)) != null) {
            try {
                return value.operation(this.operation, other);
            }
            catch (RuntimeException | TransformException e) {
                this.warning((Exception)e, false);
            }
        }
        return null;
    }

    static final class WithArgument<R>
    extends TwoGeometries<R> {
        private static final long serialVersionUID = -121819663224041806L;
        final Expression<R, ?> argument;

        WithArgument(SQLMM operation, Expression<R, ?>[] parameters, Geometries<?> library) {
            super(operation, parameters, library);
            this.argument = parameters[2];
        }

        @Override
        public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
            return new WithArgument<R>(this.operation, effective, this.getGeometryLibrary());
        }

        @Override
        public Class<? super R> getResourceClass() {
            return WithArgument.specializedClass(super.getResourceClass(), this.argument.getResourceClass());
        }

        @Override
        public List<Expression<R, ?>> getParameters() {
            return List.of(WithArgument.unwrap(this.geometry1), WithArgument.unwrap(this.geometry2), this.argument);
        }

        @Override
        public Object apply(R input) {
            GeometryWrapper other;
            GeometryWrapper value = (GeometryWrapper)this.geometry1.apply(input);
            if (value != null && (other = (GeometryWrapper)this.geometry2.apply(input)) != null) {
                try {
                    return value.operationWithArgument(this.operation, other, this.argument.apply(input));
                }
                catch (RuntimeException | TransformException e) {
                    this.warning((Exception)e, false);
                }
            }
            return null;
        }
    }
}

