/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.referencing.operation.provider.GeocentricToGeographic;
import org.apache.sis.referencing.operation.provider.Geographic3Dto2D;
import org.apache.sis.referencing.operation.provider.GeographicToGeocentric;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class EllipsoidToCentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -4692632613706143460L;
    private static final int VERTICAL_DIM = 2;
    private static final int NUM_CENTRIC_DIM = 3;
    private static ParameterDescriptorGroup DESCRIPTOR;
    private static final double ECCENTRICITY_THRESHOLD = 0.16;
    protected final double eccentricitySquared;
    private final double axisRatio;
    private final boolean useIterations;
    protected final boolean withHeight;
    final boolean toSphericalCS;
    final ContextualParameters context;
    private final Inverse inverse;
    private static ParameterDescriptorGroup INVERSE_DESCRIPTOR;

    private EllipsoidToCentricTransform(EllipsoidToCentricTransform source) {
        this.eccentricitySquared = source.eccentricitySquared;
        this.axisRatio = source.axisRatio;
        this.useIterations = source.useIterations;
        this.toSphericalCS = source.toSphericalCS;
        this.context = source.context.redimension(2, 3);
        this.withHeight = false;
        this.inverse = new Inverse();
    }

    @Deprecated(since="1.5", forRemoval=true)
    public EllipsoidToCentricTransform(double semiMajor, double semiMinor, Unit<Length> unit, boolean withHeight, TargetType csType) {
        this(DefaultEllipsoid.createEllipsoid(Map.of("name", "source"), semiMajor, semiMinor, unit), withHeight, csType);
    }

    public EllipsoidToCentricTransform(Ellipsoid source, boolean withHeight, TargetType csType) {
        int i;
        MatrixSIS normalize;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"csType", (Object)((Object)csType));
        this.toSphericalCS = csType == TargetType.SPHERICAL;
        DefaultEllipsoid ellipsoid = DefaultEllipsoid.castOrCopy(source);
        double semiMajor = ellipsoid.getSemiMajorAxis();
        double semiMinor = ellipsoid.getSemiMinorAxis();
        this.axisRatio = semiMinor / semiMajor;
        this.eccentricitySquared = ellipsoid.getEccentricitySquared();
        this.withHeight = withHeight;
        this.useIterations = withHeight || this.eccentricitySquared >= 0.0256;
        Unit<Length> unit = ellipsoid.getAxisUnit();
        this.context = new ContextualParameters(GeographicToGeocentric.PARAMETERS, withHeight ? 3 : 2, 3);
        this.context.getOrCreate(MapProjection.SEMI_MAJOR).setValue(semiMajor, unit);
        this.context.getOrCreate(MapProjection.SEMI_MINOR).setValue(semiMinor, unit);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        if (this.toSphericalCS) {
            normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            normalize.convertBefore(1, (Number)DoubleDouble.DEGREES_TO_RADIANS, null);
            denormalize.convertAfter(1, (Number)DoubleDouble.RADIANS_TO_DEGREES, null);
        } else {
            normalize = this.context.normalizeGeographicInputs(0.0);
        }
        DoubleDouble a = DoubleDouble.of((double)semiMajor, (boolean)true);
        if (withHeight) {
            normalize.convertBefore(2, (Number)a.inverse(), null);
        }
        int n = i = this.toSphericalCS ? 2 : 0;
        while (i < 3) {
            denormalize.convertAfter(i, (Number)a, null);
            ++i;
        }
        this.inverse = new Inverse();
    }

    @Deprecated(since="1.5", forRemoval=true)
    public static MathTransform createGeodeticConversion(MathTransformFactory factory, double semiMajor, double semiMinor, Unit<Length> unit, boolean withHeight, TargetType csType) throws FactoryException {
        DefaultEllipsoid source = DefaultEllipsoid.createEllipsoid(Map.of("name", "source"), semiMajor, semiMinor, unit);
        return EllipsoidToCentricTransform.createGeodeticConversion(factory, source, withHeight, csType);
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory factory, Ellipsoid source, boolean withHeight, TargetType target) throws FactoryException {
        MathTransform sphericalToTarget;
        if (Formulas.isEllipsoidal(source)) {
            EllipsoidToCentricTransform kernel = new EllipsoidToCentricTransform(source, withHeight, target);
            return kernel.context.completeTransform(factory, kernel);
        }
        MatrixSIS m = Matrices.createDiagonal(4, withHeight ? 4 : 3);
        m.setElement(2, withHeight ? 3 : 2, source.getSemiMajorAxis());
        if (!withHeight) {
            m.setElement(3, 2, 1.0);
        }
        MathTransform toSpherical = factory.createAffineTransform((Matrix)m);
        switch (target.ordinal()) {
            case 1: {
                return toSpherical;
            }
            case 0: {
                sphericalToTarget = SphericalToCartesian.INSTANCE.completeTransform(factory);
                break;
            }
            default: {
                throw new AssertionError((Object)target);
            }
        }
        return factory.createConcatenatedTransform(toSpherical, sphericalToTarget);
    }

    public static MathTransform createGeodeticConversion(MathTransformFactory factory, Ellipsoid ellipsoid, boolean withHeight) throws FactoryException {
        return EllipsoidToCentricTransform.createGeodeticConversion(factory, ellipsoid, withHeight, TargetType.CARTESIAN);
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(MapProjection.ECCENTRICITY).setValue(Math.sqrt(this.eccentricitySquared));
        pg.parameter("csType").setValue((Object)this.getTargetType());
        pg.getOrCreate(GeocentricAffineBetweenGeographic.DIMENSION).setValue(this.getSourceDimensions());
        return pg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<EllipsoidToCentricTransform> clazz = EllipsoidToCentricTransform.class;
        synchronized (EllipsoidToCentricTransform.class) {
            if (DESCRIPTOR == null) {
                ParameterBuilder builder = (ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.SIS, "SIS");
                ParameterDescriptor<TargetType> target = ((ParameterBuilder)builder.setRequired(true).addName("csType")).create(TargetType.class, TargetType.CARTESIAN);
                DESCRIPTOR = ((ParameterBuilder)builder.addName("Ellipsoid (radians domain) to centric")).createGroup(1, 1, new GeneralParameterDescriptor[]{MapProjection.ECCENTRICITY, target, GeocentricAffineBetweenGeographic.DIMENSION});
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }

    @Override
    public final int getSourceDimensions() {
        return this.withHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    public final TargetType getTargetType() {
        return this.toSphericalCS ? TargetType.SPHERICAL : TargetType.CARTESIAN;
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        double h;
        boolean wh;
        int dim = point.getDimension();
        switch (dim) {
            default: {
                throw EllipsoidToCentricTransform.mismatchedDimension("point", this.getSourceDimensions(), dim);
            }
            case 3: {
                wh = true;
                h = point.getOrdinate(2);
                break;
            }
            case 2: {
                wh = false;
                h = 0.0;
            }
        }
        return this.transform(point.getOrdinate(0), point.getOrdinate(1), h, null, 0, true, wh);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        return this.transform(srcPts[srcOff], srcPts[srcOff + 1], this.withHeight ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, derivate, this.withHeight);
    }

    private Matrix transform(double \u03bb, double \u03c6, double h, double[] dstPts, int dstOff, boolean derivate, boolean wh) {
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double \u03bd2 = 1.0 / (1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
        double \u03bd = Math.sqrt(\u03bd2);
        double \u03bd\u212f = \u03bd * (1.0 - this.eccentricitySquared);
        double r = \u03bd + h;
        double rcos\u03c6 = r * cos\u03c6;
        double Z = (\u03bd\u212f + h) * sin\u03c6;
        if (!this.toSphericalCS) {
            double cos\u03bb = Math.cos(\u03bb);
            double sin\u03bb = Math.sin(\u03bb);
            if (dstPts != null) {
                dstPts[dstOff] = rcos\u03c6 * cos\u03bb;
                dstPts[dstOff + 1] = rcos\u03c6 * sin\u03bb;
                dstPts[dstOff + 2] = Z;
            }
            if (!derivate) {
                return null;
            }
            double sd\u03c6 = \u03bd\u212f * \u03bd2 + h;
            double dX_dh = cos\u03c6 * cos\u03bb;
            double dY_dh = cos\u03c6 * sin\u03bb;
            double dX_d\u03bb = -r * dY_dh;
            double dY_d\u03bb = r * dX_dh;
            double dX_d\u03c6 = -sd\u03c6 * (sin\u03c6 * cos\u03bb);
            double dY_d\u03c6 = -sd\u03c6 * (sin\u03c6 * sin\u03bb);
            double dZ_d\u03c6 = sd\u03c6 * cos\u03c6;
            if (wh) {
                return new Matrix3(dX_d\u03bb, dX_d\u03c6, dX_dh, dY_d\u03bb, dY_d\u03c6, dY_dh, 0.0, dZ_d\u03c6, sin\u03c6);
            }
            return Matrices.create(3, 2, new double[]{dX_d\u03bb, dX_d\u03c6, dY_d\u03bb, dY_d\u03c6, 0.0, dZ_d\u03c6});
        }
        double R = Math.hypot(Z, rcos\u03c6);
        if (dstPts != null) {
            dstPts[dstOff] = \u03bb;
            dstPts[dstOff + 1] = Math.atan(Z / rcos\u03c6);
            dstPts[dstOff + 2] = R;
        }
        if (!derivate) {
            return null;
        }
        MatrixSIS derivative = Matrices.createDiagonal(3, wh ? 3 : 2);
        double R2 = R * R;
        if (R2 != 0.0) {
            double \u212f2\u03bd2 = this.eccentricitySquared * \u03bd2;
            double rsin\u03c6 = r * sin\u03c6;
            double Zsin\u03c6 = Z * sin\u03c6;
            double rcos2\u03c6 = rcos\u03c6 * cos\u03c6;
            derivative.setElement(1, 1, ((\u212f2\u03bd2 * sin\u03c6 * (\u03bd\u212f * rsin\u03c6 - \u03bd * Z) + (\u03bd\u212f + h) * r) * (cos\u03c6 * cos\u03c6) + Z * rsin\u03c6) / R2);
            derivative.setElement(2, 1, ((\u212f2\u03bd2 * (\u03bd\u212f * Zsin\u03c6 + \u03bd * rcos2\u03c6) - r * r) * sin\u03c6 + Z * (\u03bd\u212f + h)) * cos\u03c6 / R);
            if (wh) {
                derivative.setElement(1, 2, cos\u03c6 * (rsin\u03c6 - Z) / R2);
                derivative.setElement(2, 2, (Zsin\u03c6 + rcos2\u03c6) / R);
            }
        }
        return derivative;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            int dimSource = this.getSourceDimensions();
            switch (IterationStrategy.suggest(srcOff, dimSource, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * dimSource;
                    dstOff += (numPts - 1) * 3;
                    srcInc = -2 * dimSource;
                    dstInc = -6;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dimSource);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double \u03bb = srcPts[srcOff++];
            double \u03c6 = srcPts[srcOff++];
            double h = this.withHeight ? srcPts[srcOff++] : 0.0;
            double sin\u03c6 = Math.sin(\u03c6);
            double \u03bd = 1.0 / Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
            double rcos\u03c6 = (\u03bd + h) * Math.cos(\u03c6);
            double Z = (h + \u03bd * (1.0 - this.eccentricitySquared)) * sin\u03c6;
            if (this.toSphericalCS) {
                dstPts[dstOff++] = \u03bb;
                dstPts[dstOff++] = Math.atan(Z / rcos\u03c6);
                dstPts[dstOff++] = Math.hypot(Z, rcos\u03c6);
            } else {
                dstPts[dstOff++] = rcos\u03c6 * Math.cos(\u03bb);
                dstPts[dstOff++] = rcos\u03c6 * Math.sin(\u03bb);
                dstPts[dstOff++] = Z;
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 0;
        int dstInc = this.getSourceDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 3, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * 3;
                    dstOff += (numPts - 1) * dstInc;
                    srcInc = -6;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    dstPts = Arrays.copyOfRange(dstPts, dstOff, dstOff + numPts * dstInc);
                    dstOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double Z;
            double p;
            double \u03bb;
            if (this.toSphericalCS) {
                \u03bb = srcPts[srcOff++];
                double \u03a9 = srcPts[srcOff++];
                double R = srcPts[srcOff++];
                p = R * Math.cos(\u03a9);
                Z = R * Math.sin(\u03a9);
            } else {
                double X = srcPts[srcOff++];
                double Y = srcPts[srcOff++];
                Z = srcPts[srcOff++];
                p = Math.hypot(X, Y);
                \u03bb = Math.atan2(Y, X);
            }
            double tanq = Z / (p * this.axisRatio);
            double cos2q = 1.0 / (1.0 + tanq * tanq);
            double sin2q = 1.0 - cos2q;
            double \u03c6 = Math.atan((Z + Math.copySign(this.eccentricitySquared * (Math.sqrt(sin2q) * sin2q), tanq) / this.axisRatio) / (p - this.eccentricitySquared * (Math.sqrt(cos2q) * cos2q)));
            if (this.useIterations) {
                double i\u03bd;
                double sin\u03c6;
                double \u0394\u03c6;
                int it = 18;
                do {
                    if (--it >= 0) continue;
                    throw new TransformException(Resources.format((short)46));
                } while (Math.abs(\u0394\u03c6 = \u03c6 - (\u03c6 = Math.atan((Z + this.eccentricitySquared * (sin\u03c6 = Math.sin(\u03c6)) / (i\u03bd = Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6)))) / p))) >= 3.926676682852614E-10);
                if (this.withHeight) {
                    dstPts[dstOff + 2] = Math.abs(sin\u03c6) == 1.0 ? Math.abs(Z) - this.axisRatio : p / Math.cos(\u03c6) - 1.0 / i\u03bd;
                }
            }
            dstPts[dstOff] = \u03bb;
            dstPts[dstOff + 1] = \u03c6;
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        int code = super.computeHashCode() + Double.hashCode(this.eccentricitySquared);
        if (this.toSphericalCS) {
            code += 71;
        }
        if (this.withHeight) {
            code += 37;
        }
        return code;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            EllipsoidToCentricTransform that = (EllipsoidToCentricTransform)object;
            return this.withHeight == that.withHeight && this.toSphericalCS == that.toSphericalCS && Numerics.equals((double)this.axisRatio, (double)that.axisRatio) && Numerics.equals((double)this.eccentricitySquared, (double)that.eccentricitySquared);
        }
        return false;
    }

    @Override
    final int beforeFormat(List<Object> transforms, int index, boolean inverse) {
        index = super.beforeFormat(transforms, index, inverse);
        if (!this.withHeight) {
            transforms.add(index++, new Geographic3Dto2D.WKT(true));
        }
        return index;
    }

    @Override
    protected void tryConcatenate(TransformJoiner context) throws FactoryException {
        if (!(this.reduce(context, -1) || this.toSphericalCS && context.replacePassThrough(Map.of(0, 0)))) {
            super.tryConcatenate(context);
        }
    }

    private boolean reduce(TransformJoiner context, int checkAt) throws FactoryException {
        return this.withHeight && context.removeUnusedDimensions(checkAt, 2, 3, dimension -> {
            if (dimension != 2) {
                return null;
            }
            EllipsoidToCentricTransform reduced = new EllipsoidToCentricTransform(this);
            return checkAt >= 0 ? reduced.inverse() : reduced;
        });
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6859079700241660726L;

        Inverse() {
        }

        @Override
        public MathTransform inverse() {
            return EllipsoidToCentricTransform.this;
        }

        @Override
        protected ContextualParameters getContextualParameters() {
            return EllipsoidToCentricTransform.this.context.inverse(GeocentricToGeographic.PARAMETERS, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            Class<EllipsoidToCentricTransform> clazz = EllipsoidToCentricTransform.class;
            synchronized (EllipsoidToCentricTransform.class) {
                if (INVERSE_DESCRIPTOR == null) {
                    INVERSE_DESCRIPTOR = ReferencingUtilities.rename(EllipsoidToCentricTransform.this.getParameterDescriptors(), "Centric to ellipsoid (radians domain)");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INVERSE_DESCRIPTOR;
            }
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterValueGroup pg = this.getParameterDescriptors().createValue();
            pg.values().addAll(EllipsoidToCentricTransform.this.getParameterValues().values());
            return pg;
        }

        @Override
        public Matrix derivative(DirectPosition point) throws TransformException {
            double[] coordinates = point.getCoordinate();
            ArgumentChecks.ensureDimensionMatches((String)"point", (int)3, (double[])coordinates);
            return this.transform(coordinates, 0, coordinates, 0, true);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            int offset;
            double[] point;
            if (derivate && (dstPts == null || !EllipsoidToCentricTransform.this.withHeight)) {
                point = new double[3];
                offset = 0;
            } else {
                point = dstPts;
                offset = dstOff;
            }
            EllipsoidToCentricTransform.this.inverseTransform(srcPts, srcOff, point, offset, 1);
            if (!derivate) {
                return null;
            }
            if (dstPts != point && dstPts != null) {
                dstPts[dstOff] = point[0];
                dstPts[dstOff + 1] = point[1];
            }
            DirectPositionView.Double p = new DirectPositionView.Double(point, offset, 3);
            Matrix derivative = EllipsoidToCentricTransform.this.derivative(p);
            derivative = Matrices.inverse(derivative);
            if (!EllipsoidToCentricTransform.this.withHeight) {
                derivative = MatrixSIS.castOrCopy(derivative).removeRows(2, 3);
            }
            return derivative;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            EllipsoidToCentricTransform.this.inverseTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        }

        @Override
        protected void tryConcatenate(TransformJoiner context) throws FactoryException {
            if (!EllipsoidToCentricTransform.this.reduce(context, 1)) {
                super.tryConcatenate(context);
            }
        }

        @Override
        final int beforeFormat(List<Object> transforms, int index, boolean inverse) {
            index = super.beforeFormat(transforms, index, inverse);
            if (!EllipsoidToCentricTransform.this.withHeight) {
                transforms.add(++index, new Geographic3Dto2D.WKT(false));
            }
            return index;
        }
    }

    public static enum TargetType {
        CARTESIAN,
        SPHERICAL;


        public static TargetType of(Class<? extends CoordinateSystem> csType) {
            if (CartesianCS.class.isAssignableFrom(csType)) {
                return CARTESIAN;
            }
            if (SphericalCS.class.isAssignableFrom(csType)) {
                return SPHERICAL;
            }
            throw new IllegalArgumentException(Errors.format((short)200, csType));
        }
    }
}

