/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.tracing.zipkin.HttpServeRequestWrapper;
import org.apache.servicecomb.tracing.zipkin.HttpServerResponseWrapper;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZipkinProviderDelegate
implements ZipkinTracingDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ZipkinProviderDelegate.class);
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
    private final HttpTracing httpTracing;
    private final TraceContext.Extractor<Invocation> extractor;
    private final HttpServeRequestWrapper requestWrapper;
    private final HttpServerResponseWrapper responseWrapper;
    public static final String SPAN_ID_HEADER_NAME = "X-B3-SpanId";
    public static final String TRACE_ID_HEADER_NAME = "X-B3-TraceId";
    private static final Propagation.Getter<Invocation, String> INVOCATION_STRING_GETTER = (invocation, key) -> {
        String extracted = (String)invocation.getContext().get(key);
        if (StringUtils.isEmpty((CharSequence)extracted) && SPAN_ID_HEADER_NAME.equals(key)) {
            extracted = (String)invocation.getContext().get(TRACE_ID_HEADER_NAME);
            LOG.debug("try to extract X-B3-SpanId, but the value is empty, replace with TraceId = [{}]", (Object)extracted);
        }
        return extracted;
    };

    @VisibleForTesting
    static Propagation.Getter<Invocation, String> getInvocationStringGetter() {
        return INVOCATION_STRING_GETTER;
    }

    ZipkinProviderDelegate(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.extractor = httpTracing.tracing().propagation().extractor(this.extractor());
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.requestWrapper = new HttpServeRequestWrapper();
        this.responseWrapper = new HttpServerResponseWrapper();
    }

    @Override
    public Tracing tracer() {
        return this.httpTracing.tracing();
    }

    @Override
    public Span createSpan(Invocation invocation) {
        return this.handler.handleReceive((HttpServerRequest)this.requestWrapper.invocation(invocation));
    }

    @Override
    public void onResponse(Span span, Response response, Throwable error) {
        this.handler.handleSend((HttpServerResponse)this.responseWrapper.response(response).error(error).request(this.requestWrapper), span);
    }

    @Override
    public String name() {
        return "Zipkin provider";
    }

    private Propagation.Getter<Invocation, String> extractor() {
        return INVOCATION_STRING_GETTER;
    }
}

