/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.jms.JMSException;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.transport.ConnectionSettings;

public class MessageEncryptionHelper {
    public static final String ENCRYPTION_ALGORITHM_PROPERTY = "x-qpid-encryption-algorithm";
    public static final String KEY_INIT_VECTOR_PROPERTY = "x-qpid-key-init-vector";
    public static final String ENCRYPTED_KEYS_PROPERTY = "x-qpid-encrypted-keys";
    public static final String ENCRYPT_HEADER = "x-qpid-encrypt";
    public static final String ENCRYPT_RECIPIENTS_HEADER = "x-qpid-encrypt-recipients";
    public static final String UNENCRYPTED_PROPERTIES_HEADER = "x-qpid-unencrypted-properties";
    static final int AES_KEY_SIZE_BITS = 256;
    public static final int AES_KEY_SIZE_BYTES = 32;
    public static final String AES_ALGORITHM = "AES";
    public static final String DEFAULT_MESSAGE_ENCRYPTION_CIPHER_NAME = "AES/CBC/PKCS5Padding";
    public static final int AES_INITIALIZATION_VECTOR_LENGTH = 16;
    private final AMQSession<?, ?> _session;
    private static final int KEY_TRANSPORT_RECIPIENT_INFO_TYPE = 1;
    public static final String DEFAULT_KEY_ENCRYPTION_ALGORITHM = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private final Map<String, X509Certificate> _signingCertificateCache = Collections.synchronizedMap(new LinkedHashMap<String, X509Certificate>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, X509Certificate> eldest) {
            return this.size() > 128;
        }
    });
    private String _keyEncryptionAlgorithm = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private String _messageEncryptionCipherName = "AES/CBC/PKCS5Padding";
    private SecureRandom _random;

    public MessageEncryptionHelper(AMQSession<?, ?> session) {
        this._session = session;
    }

    public String getKeyEncryptionAlgorithm() {
        return this._keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
        this._keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public String getMessageEncryptionCipherName() {
        return this._messageEncryptionCipherName;
    }

    public void setMessageEncryptionCipherName(String messageEncryptionCipherName) {
        this._messageEncryptionCipherName = messageEncryptionCipherName;
    }

    public KeyStore getSigningCertificateStore() throws GeneralSecurityException, IOException {
        return this._session.getAMQConnection().getConnectionSettings().getEncryptionTrustStore(new ConnectionSettings.RemoteStoreFinder(){

            @Override
            public KeyStore getKeyStore(String name) throws GeneralSecurityException, IOException {
                try {
                    return MessageEncryptionHelper.this._session.getAMQConnection().getBrokerSuppliedTrustStore(name);
                }
                catch (JMSException e) {
                    throw new CertificateException("Could not load remote certificate store: '" + name + "'", e);
                }
            }
        });
    }

    public List<KeyTransportRecipientInfo> getKeyTransportRecipientInfo(List<String> recipients, SecretKeySpec secretKey) throws GeneralSecurityException, IOException {
        ArrayList<KeyTransportRecipientInfo> result = new ArrayList<KeyTransportRecipientInfo>();
        String keyEncryptionAlgorithm = this.getKeyEncryptionAlgorithm();
        for (String recipient : recipients) {
            X509Certificate cert = this.getSigningCertificate(recipient.trim());
            if (cert != null) {
                Cipher cipher = Cipher.getInstance(keyEncryptionAlgorithm);
                cipher.init(1, cert.getPublicKey());
                byte[] encryptedKey = cipher.doFinal(secretKey.getEncoded());
                String issuePrincipal = cert.getIssuerX500Principal().getName("CANONICAL");
                String serialNumber = cert.getSerialNumber().toString();
                result.add(new KeyTransportRecipientInfoImpl(keyEncryptionAlgorithm, issuePrincipal, serialNumber, encryptedKey));
                continue;
            }
            throw new CertificateException("Unable to find certificate for recipient '" + recipient + "'");
        }
        return result;
    }

    public X509Certificate getSigningCertificate(String name) throws GeneralSecurityException, IOException {
        X509Certificate returnVal = this._signingCertificateCache.get(name);
        if (returnVal == null) {
            X500Principal requestedPrincipal;
            KeyStore certStore = this.getSigningCertificateStore();
            ArrayList<X509Certificate> potentialCerts = new ArrayList<X509Certificate>();
            try {
                requestedPrincipal = new X500Principal(name);
            }
            catch (IllegalArgumentException e) {
                requestedPrincipal = null;
            }
            block4: for (String alias : Collections.list(certStore.aliases())) {
                Certificate cert = certStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                if (requestedPrincipal != null && requestedPrincipal.equals(x509Cert.getSubjectX500Principal())) {
                    potentialCerts.add(x509Cert);
                    continue;
                }
                if (x509Cert.getSubjectAlternativeNames() == null) continue;
                for (List<?> entry : x509Cert.getSubjectAlternativeNames()) {
                    int type = (Integer)entry.get(0);
                    if (type != 1 && type != 2 || !entry.get(1).toString().trim().equals(name)) continue;
                    potentialCerts.add(x509Cert);
                    continue block4;
                }
            }
            for (X509Certificate cert : potentialCerts) {
                try {
                    cert.checkValidity();
                    if (returnVal != null && returnVal.getNotAfter().getTime() <= cert.getNotAfter().getTime()) continue;
                    returnVal = cert;
                }
                catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {}
            }
            if (returnVal != null) {
                this._signingCertificateCache.put(name, returnVal);
            }
        }
        return returnVal;
    }

    public PrivateKey getEncryptionPrivateKey(X500Principal issuer, BigInteger serialNumber) throws GeneralSecurityException, IOException {
        ConnectionSettings connectionSettings = this._session.getAMQConnection().getConnectionSettings();
        KeyStore keyStore = connectionSettings.getEncryptionKeyStore();
        if (keyStore != null) {
            for (String alias : Collections.list(keyStore.aliases())) {
                try {
                    X509Certificate cert;
                    KeyStore.PrivateKeyEntry pkEntry;
                    KeyStore.Entry entry = keyStore.getEntry(alias, new KeyStore.PasswordProtection(connectionSettings.getEncryptionKeyStorePassword().toCharArray()));
                    if (!(entry instanceof KeyStore.PrivateKeyEntry) || !((pkEntry = (KeyStore.PrivateKeyEntry)entry).getCertificate() instanceof X509Certificate) || !(cert = (X509Certificate)pkEntry.getCertificate()).getIssuerX500Principal().equals(issuer) || !cert.getSerialNumber().equals(serialNumber)) continue;
                    return pkEntry.getPrivateKey();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
        }
        return null;
    }

    public SecretKeySpec createSecretKey() {
        byte[] key = new byte[32];
        this.getRandomBytes(key);
        return new SecretKeySpec(key, AES_ALGORITHM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRandomBytes(byte[] key) {
        MessageEncryptionHelper messageEncryptionHelper = this;
        synchronized (messageEncryptionHelper) {
            if (this._random == null) {
                this._random = new SecureRandom();
            }
            this._random.nextBytes(key);
        }
    }

    public byte[] getInitialisationVector() {
        byte[] ivbytes = new byte[16];
        this.getRandomBytes(ivbytes);
        return ivbytes;
    }

    public byte[] readFromCipherStream(byte[] unencryptedBytes, int offset, int length, Cipher cipher) throws IOException {
        byte[] encryptedBytes;
        try (CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(unencryptedBytes, offset, length), cipher);){
            int read;
            byte[] buf = new byte[512];
            int pos = 0;
            while ((read = cipherInputStream.read(buf, pos, buf.length - pos)) != -1) {
                if ((pos += read) != buf.length) continue;
                byte[] tmp = buf;
                buf = new byte[buf.length + 512];
                System.arraycopy(tmp, 0, buf, 0, tmp.length);
            }
            encryptedBytes = new byte[pos];
            System.arraycopy(buf, 0, encryptedBytes, 0, pos);
        }
        return encryptedBytes;
    }

    public byte[] readFromCipherStream(byte[] unencryptedBytes, Cipher cipher, AMQSession amqSession) throws IOException {
        return this.readFromCipherStream(unencryptedBytes, 0, unencryptedBytes.length, cipher);
    }

    public byte[] encrypt(SecretKeySpec secretKey, byte[] unencryptedBytes, byte[] ivbytes) {
        try {
            Cipher cipher = Cipher.getInstance(this.getMessageEncryptionCipherName());
            cipher.init(1, (Key)secretKey, new IvParameterSpec(ivbytes));
            return this.readFromCipherStream(unencryptedBytes, cipher, this._session);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to encrypt secret with secret key. Cipher: " + this.getMessageEncryptionCipherName() + " . Key of type " + secretKey.getAlgorithm() + " size " + secretKey.getEncoded().length, e);
        }
    }

    private static class KeyTransportRecipientInfoImpl
    implements KeyTransportRecipientInfo {
        private final String _keyEncryptionAlgorithm;
        private final String _issuePrincipal;
        private final String _serialNumber;
        private final byte[] _encryptedKey;

        public KeyTransportRecipientInfoImpl(String keyEncryptionAlgorithm, String issuePrincipal, String serialNumber, byte[] encryptedKey) {
            this._keyEncryptionAlgorithm = keyEncryptionAlgorithm;
            this._issuePrincipal = issuePrincipal;
            this._serialNumber = serialNumber;
            this._encryptedKey = encryptedKey;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public String getKeyEncryptionAlgorithm() {
            return this._keyEncryptionAlgorithm;
        }

        @Override
        public String getCertIssuerPrincipal() {
            return this._issuePrincipal;
        }

        @Override
        public String getCertSerialNumber() {
            return this._serialNumber;
        }

        @Override
        public byte[] getEncryptedKey() {
            return this._encryptedKey;
        }

        @Override
        public List<Object> asList() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(1);
            result.add(this._keyEncryptionAlgorithm);
            result.add(this._issuePrincipal);
            result.add(this._serialNumber);
            result.add(this._encryptedKey);
            return result;
        }
    }

    public static interface KeyTransportRecipientInfo {
        public int getType();

        public String getKeyEncryptionAlgorithm();

        public String getCertIssuerPrincipal();

        public String getCertSerialNumber();

        public byte[] getEncryptedKey();

        public List<Object> asList();
    }
}

