/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericColumnDescriptor;
import org.apache.derby.shared.common.util.ArrayUtil;

public class EmbedResultSetMetaData
implements ResultSetMetaData {
    private final ResultColumnDescriptor[] columnInfo;

    public EmbedResultSetMetaData(ResultColumnDescriptor[] resultColumnDescriptorArray) {
        this.columnInfo = (ResultColumnDescriptor[])ArrayUtil.copy((Object[])resultColumnDescriptorArray);
    }

    @Override
    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    @Override
    public final boolean isAutoIncrement(int n) throws SQLException {
        this.validColumnNumber(n);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        return resultColumnDescriptor.isAutoincrement();
    }

    @Override
    public final boolean isCaseSensitive(int n) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(n));
    }

    @Override
    public final boolean isSearchable(int n) throws SQLException {
        this.validColumnNumber(n);
        return true;
    }

    @Override
    public final boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public final int isNullable(int n) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(n));
    }

    @Override
    public final boolean isSigned(int n) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(n));
    }

    @Override
    public final int getColumnDisplaySize(int n) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(n));
    }

    @Override
    public final String getColumnLabel(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getName();
        return string == null ? "Column" + Integer.toString(n) : string;
    }

    @Override
    public final String getColumnName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getName();
        return string == null ? "" : string;
    }

    @Override
    public final String getSchemaName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getSourceSchemaName();
        return string == null ? "" : string;
    }

    @Override
    public final int getPrecision(int n) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(n));
    }

    @Override
    public final int getScale(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getScale();
    }

    @Override
    public final String getTableName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getSourceTableName();
        return string == null ? "" : string;
    }

    @Override
    public final String getCatalogName(int n) throws SQLException {
        this.validColumnNumber(n);
        return "";
    }

    @Override
    public final int getColumnType(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getTypeId().getJDBCTypeId();
    }

    @Override
    public final String getColumnTypeName(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getTypeId().getSQLTypeName();
    }

    @Override
    public final boolean isReadOnly(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    @Override
    public final boolean isWritable(int n) throws SQLException {
        this.validColumnNumber(n);
        return this.columnInfo[n - 1].updatableByCursor();
    }

    @Override
    public final boolean isDefinitelyWritable(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    private void validColumnNumber(int n) throws SQLException {
        if (n < 1 || n > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", n);
        }
    }

    private DataTypeDescriptor getColumnTypeDescriptor(int n) throws SQLException {
        this.validColumnNumber(n);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        return resultColumnDescriptor.getType();
    }

    @Override
    public final String getColumnClassName(int n) throws SQLException {
        return this.getColumnTypeDescriptor(n).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, int n, boolean bl) {
        return new GenericColumnDescriptor(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, bl));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, int n, boolean bl, int n2) {
        return new GenericColumnDescriptor(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, bl, n2));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, DataTypeDescriptor dataTypeDescriptor) {
        return new GenericColumnDescriptor(string, dataTypeDescriptor);
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException("XJ128.S", clazz);
        }
    }
}

