/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.LocalRowKeyIndex;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.TreeLocalRowKeyIndex;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidad.util.StringUtils;

public abstract class UIXHierarchy
extends UIXCollection
implements CollectionComponent,
LocalRowKeyIndex,
TreeLocalRowKeyIndex {
    protected UIXHierarchy(String rendererType) {
        super(rendererType);
    }

    protected UIXHierarchy() {
        this(null);
    }

    @Override
    public CollectionModel createCollectionModel(CollectionModel current, Object value) {
        TreeModel model = ModelUtils.toTreeModel(value);
        model.setRowKey(null);
        return model;
    }

    @Override
    public int getFirst() {
        return 0;
    }

    @Override
    public int getRows() {
        return 0;
    }

    public final void enterContainer() {
        this.preRowDataChange();
        this.getTreeModel().enterContainer();
        this.postRowDataChange();
    }

    public final void exitContainer() {
        this.preRowDataChange();
        this.getTreeModel().exitContainer();
        this.postRowDataChange();
    }

    public final boolean isContainer() {
        return this.getTreeModel().isContainer();
    }

    public boolean isContainerEmpty() {
        return this.getTreeModel().isContainerEmpty();
    }

    public int getDepth() {
        return this.getTreeModel().getDepth();
    }

    public int getDepth(Object rowKey) {
        return this.getTreeModel().getDepth(rowKey);
    }

    public Object getContainerRowKey() {
        return this.getTreeModel().getContainerRowKey();
    }

    public Object getContainerRowKey(Object childKey) {
        return this.getTreeModel().getContainerRowKey(childKey);
    }

    public List<Object> getAllAncestorContainerRowKeys(Object childRowKey) {
        return this.getTreeModel().getAllAncestorContainerRowKeys(childRowKey);
    }

    @Override
    public boolean isChildCollectionLocallyAvailable() {
        return this.getTreeModel().isChildCollectionLocallyAvailable();
    }

    @Override
    public boolean isChildCollectionLocallyAvailable(int index) {
        return this.getTreeModel().isChildCollectionLocallyAvailable(index);
    }

    @Override
    public boolean isChildCollectionLocallyAvailable(Object rowKey) {
        return this.getTreeModel().isChildCollectionLocallyAvailable(rowKey);
    }

    @Override
    public boolean areRowsLocallyAvailable(int startIndex, int rowCount, RowKeySet disclosedRowKeys) {
        return this.getTreeModel().areRowsLocallyAvailable(startIndex, rowCount, disclosedRowKeys);
    }

    @Override
    public boolean areRowsLocallyAvailable(Object startRowKey, int rowCount, RowKeySet disclosedRowKeys) {
        return this.getTreeModel().areRowsLocallyAvailable(startRowKey, rowCount, disclosedRowKeys);
    }

    @Override
    public boolean areRowsLocallyAvailable(int rowCount, RowKeySet disclosedRowKeys) {
        return this.getTreeModel().areRowsLocallyAvailable(rowCount, disclosedRowKeys);
    }

    @Override
    protected Map<String, Object> createVarStatusMap() {
        final Map<String, Object> map = super.createVarStatusMap();
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if ("hierarchicalIndex".equals(key)) {
                    return this._getHierarchicalIndex().toArray();
                }
                if ("hierarchicalLabel".equals(key)) {
                    List<Integer> rowIndices = this._getHierarchicalIndex();
                    if (rowIndices.size() == 0) {
                        return "";
                    }
                    Object[] indexArray = new Integer[rowIndices.size()];
                    for (int i = 0; i < rowIndices.size(); ++i) {
                        indexArray[i] = rowIndices.get(i) + 1;
                    }
                    return StringUtils.join(indexArray, '.');
                }
                return map.get(key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<Integer> _getHierarchicalIndex() {
                Object rowKey = UIXHierarchy.this.getRowKey();
                if (rowKey == null) {
                    return Collections.emptyList();
                }
                TreeModel treeModel = UIXHierarchy.this.getTreeModel();
                ArrayList<Integer> rowIndices = new ArrayList<Integer>();
                try {
                    rowIndices.add(treeModel.getRowIndex());
                    Object childRowKey = treeModel.getContainerRowKey(rowKey);
                    while (childRowKey != null) {
                        treeModel.setRowKey(childRowKey);
                        rowIndices.add(treeModel.getRowIndex());
                        childRowKey = treeModel.getContainerRowKey(childRowKey);
                    }
                    Collections.reverse(rowIndices);
                }
                finally {
                    treeModel.setRowKey(rowKey);
                }
                return rowIndices;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return map.entrySet();
            }
        };
    }

    protected final TreeModel getTreeModel() {
        TreeModel model = (TreeModel)this.getCollectionModel();
        return model;
    }

    @Override
    protected List<UIComponent> getStamps() {
        UIComponent nodeStamp = this.getFacet("nodeStamp");
        if (nodeStamp != null) {
            return Collections.singletonList(nodeStamp);
        }
        return Collections.emptyList();
    }

    public abstract Object getFocusRowKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean visitLevel(VisitContext visitContext, VisitCallback callback, List<UIComponent> stamps) {
        if (this.getRowCount() != 0 && !stamps.isEmpty()) {
            int oldRow = this.getRowIndex();
            int first = this.getFirst();
            int last = TableUtils.getLast(this, first);
            try {
                for (int i = first; i <= last; ++i) {
                    this.setRowIndex(i);
                    for (UIComponent currStamp : stamps) {
                        if (!UIXComponent.visitTree(visitContext, currStamp, callback)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.setRowIndex(oldRow);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean visitHierarchy(VisitContext visitContext, VisitCallback callback, List<UIComponent> stamps, RowKeySet disclosedRowKeys) {
        int oldRow = this.getRowIndex();
        int first = this.getFirst();
        int last = TableUtils.getLast(this, first);
        try {
            for (int i = first; i <= last; ++i) {
                this.setRowIndex(i);
                if (!stamps.isEmpty()) {
                    for (UIComponent currStamp : stamps) {
                        if (!UIXComponent.visitTree(visitContext, currStamp, callback)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if (!this.isContainer() || disclosedRowKeys != null && !disclosedRowKeys.isContained()) continue;
                this.enterContainer();
                try {
                    if (!this.visitHierarchy(visitContext, callback, stamps, disclosedRowKeys)) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.exitContainer();
                }
            }
        }
        finally {
            this.setRowIndex(oldRow);
        }
        return false;
    }
}

