/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.variant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariantExtractor;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

final class AccessibilityVariantExtractor
implements SkinVariantExtractor<AccessibilityProfile> {
    private final Collection<AccessibilityProfile> _accProfiles = new HashSet<AccessibilityProfile>();
    private static final AccessibilityProfile _HIGH_CONTRAST_ONLY = AccessibilityVariantExtractor._getAccessibilityProfile(true, false);
    private static final AccessibilityProfile _LARGE_FONTS_ONLY = AccessibilityVariantExtractor._getAccessibilityProfile(false, true);
    private static final AccessibilityProfile _HIGH_CONTRAST_LARGE_FONTS = AccessibilityVariantExtractor._getAccessibilityProfile(true, true);

    public AccessibilityVariantExtractor() {
        this._accProfiles.add(AccessibilityProfile.getDefaultInstance());
    }

    @Override
    public void visit(StyleSheetNode node) {
        Collection<String> accProps = node.getAccessibilityProperties();
        for (String accProp : accProps) {
            this._addAccessibilityProfile(accProp);
        }
    }

    @Override
    public List<AccessibilityProfile> getVariants() {
        this._addCompoundAccessibilityProfile();
        ArrayList<AccessibilityProfile> accProfilesList = new ArrayList<AccessibilityProfile>(this._accProfiles);
        return accProfilesList;
    }

    private void _addCompoundAccessibilityProfile() {
        if (this._accProfiles.contains(_HIGH_CONTRAST_ONLY) && this._accProfiles.contains(_LARGE_FONTS_ONLY) && !this._accProfiles.contains(_HIGH_CONTRAST_LARGE_FONTS)) {
            this._accProfiles.add(_HIGH_CONTRAST_LARGE_FONTS);
        }
    }

    private void _addAccessibilityProfile(String accProp) {
        AccessibilityProfile accProfile = AccessibilityVariantExtractor._toAccessibilityProfile(accProp);
        this._accProfiles.add(accProfile);
    }

    private static AccessibilityProfile _toAccessibilityProfile(String accProp) {
        boolean highContrast = false;
        boolean largeFonts = false;
        if (AccessibilityVariantExtractor._isHighContrast(accProp)) {
            highContrast = true;
        } else if (AccessibilityVariantExtractor._isLargeFonts(accProp)) {
            largeFonts = true;
        } else if (AccessibilityVariantExtractor._isHighContrastLargeFonts(accProp)) {
            highContrast = true;
            largeFonts = true;
        }
        return AccessibilityVariantExtractor._getAccessibilityProfile(highContrast, largeFonts);
    }

    private static boolean _isHighContrast(String accProp) {
        return "high-contrast".equals(accProp);
    }

    private static boolean _isLargeFonts(String accProp) {
        return "large-fonts".equals(accProp);
    }

    private static boolean _isHighContrastLargeFonts(String accProp) {
        return accProp.indexOf("high-contrast") > -1 && accProp.indexOf("large-fonts") > -1;
    }

    private static AccessibilityProfile _getAccessibilityProfile(boolean highContrast, boolean largeFonts) {
        return AccessibilityProfile.getInstance((AccessibilityProfile.ColorContrast)(highContrast ? AccessibilityProfile.ColorContrast.HIGH : AccessibilityProfile.ColorContrast.STANDARD), (AccessibilityProfile.FontSize)(largeFonts ? AccessibilityProfile.FontSize.LARGE : AccessibilityProfile.FontSize.MEDIUM));
    }
}

