/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;

public class FileInputStreamProvider
implements InputStreamProvider {
    private final File _file;
    private Object _cached;
    private long _lastModified = -1L;

    public FileInputStreamProvider(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this._file = file;
    }

    public InputStream openInputStream() throws IOException {
        this._lastModified = this._file.lastModified();
        return new BufferedInputStream(new FileInputStream(this._file));
    }

    public String getDisplayName() {
        return this._file.getName();
    }

    public Object getIdentifier() {
        return this._file;
    }

    public boolean hasSourceChanged() {
        return this._file.lastModified() != this._lastModified;
    }

    public Object getCachedResult() {
        return this._cached;
    }

    public void setCachedResult(Object value) {
        this._cached = value;
    }
}

