/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputColor;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.convert.ColorConverter;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputListOfValuesRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.AliasedScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.ColorFieldInfoScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.ConfigurationScriptlet;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;

public class SimpleInputColorRenderer
extends SimpleInputListOfValuesRenderer {
    private PropertyKey _chooseIdKey;
    private PropertyKey _compactKey;
    private static final String _COLOR_FIELD_LIB = "ColorField";
    private static boolean _colorScriptletsRegistered = false;
    private static final Integer _DEFAULT_COLUMNS = 11;
    private static final Object _CHOOSE_COLOR_IDS_KEY = new Object();
    private static final String _LAUNCH_PICKER_TIP_KEY = "af_inputColor.SELECT_PICKER_ALT";
    private static final String _AUTO_SWATCH_SCRIPT = "_cfsw(this);";
    private static final String _AUTO_FORMAT_SCRIPT = "_fixCFF(this);";
    private static final String _FOCUS_PREFIX = "_cfBus['";
    private static final String _FOCUS_SUFFIX = "']=this;";
    private static final String _CELL_SIZE = "15";
    private static final Converter _DEFAULT_CONVERTER = new ColorConverter();
    private static final Object _CACHED_CHOOSE_ID = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SimpleInputColorRenderer.class);

    public SimpleInputColorRenderer() {
        this(CoreInputColor.TYPE);
    }

    public SimpleInputColorRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._compactKey = type.findKey("compact");
        this._chooseIdKey = type.findKey("chooseId");
    }

    @Override
    protected void queueActionEvent(FacesContext context, UIComponent component) {
        FacesBean bean = this.getFacesBean(component);
        if (this.getActionExpression(component, bean) != null) {
            super.queueActionEvent(context, component);
        } else {
            Object submittedValue = this.getSubmittedValue(component, bean);
            try {
                this.getConvertedValue(context, component, submittedValue);
            }
            catch (ConverterException ce) {
                _LOG.fine((Throwable)ce);
            }
            RequestContext afContext = RequestContext.getCurrentInstance();
            Map parameters = null;
            afContext.launchDialog(GenericEntry.getGenericEntryViewRoot(context), parameters, component, true, null);
        }
    }

    @Override
    protected void queueReturnEvent(FacesContext context, UIComponent component, ReturnEvent event) {
        Object returnValue = event.getReturnValue();
        if (returnValue instanceof Color) {
            FacesBean bean = this.getFacesBean(component);
            Converter converter = this.getConverter(component, bean);
            if (converter == null) {
                converter = this.getDefaultConverter(context, component, bean);
            }
            returnValue = converter != null ? converter.getAsString(context, component, returnValue) : returnValue.toString();
            event = new ReturnEvent(component, returnValue, event.getReturnParameters());
        }
        event.queue();
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!_colorScriptletsRegistered) {
            ColorFieldInfoScriptlet.sharedInstance().registerSelf();
            new AliasedScriptlet(_COLOR_FIELD_LIB, null, new String[]{"openWindow()", "_getColorFieldFormat()", "ColorFieldInfo"}).registerSelf();
            _colorScriptletsRegistered = true;
        }
        String chooseId = this._computeChooseId(context, component, bean);
        rc.getProperties().put(_CACHED_CHOOSE_ID, chooseId);
        XhtmlUtils.addLib(context, rc, "_fixCFF()");
        XhtmlUtils.addLib(context, rc, _COLOR_FIELD_LIB);
        super.encodeAllAsElement(context, rc, component, bean);
        if (!this.getDisabled(component, bean)) {
            this._renderFirstColorFieldScript(context, rc, component, this._getChooseId(rc));
        }
        rc.getProperties().remove(_CACHED_CHOOSE_ID);
    }

    @Override
    protected void renderTextField(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!this.isCompact(component, bean) || !this._supportsSwatchAndChooser(rc)) {
            super.renderTextField(context, rc, component, bean);
        } else {
            if (this.isAutoSubmit(component, bean)) {
                AutoSubmitUtils.writeDependencies(context, rc);
            }
            this.addOnSubmitConverterValidators(context, rc, component, bean);
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("value", (Object)this.getConvertedString(context, component, bean), "value");
            String id = rc.getCurrentClientId();
            writer.writeAttribute("id", (Object)id, null);
            writer.writeAttribute("name", (Object)id, null);
            writer.endElement("input");
        }
    }

    @Override
    protected void renderContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean renderAsElement, boolean isTextArea) throws IOException {
        assert (!isTextArea);
        super.renderContent(context, rc, component, bean, renderAsElement, isTextArea);
        if (!renderAsElement) {
            this.renderAfterTextField(context, rc, component, bean);
        }
    }

    @Override
    protected void renderAfterTextField(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!this._supportsSwatchAndChooser(rc)) {
            return;
        }
        if (!this.isCompact(component, bean)) {
            this.renderSpacer(context, rc, "8", "1");
            this.renderIcon(context, rc, component, bean);
        } else {
            this.renderIcon(context, rc, component, bean);
        }
    }

    @Override
    protected void renderIcon(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean isEditable;
        boolean bl = isEditable = this._getChooseId(rc) == null && !this.getDisabled(component, bean) && !this.getReadOnly(context, component, bean);
        if (isEditable) {
            XhtmlUtils.addLib(context, rc, ConfigurationScriptlet.sharedInstance().getScriptletKey());
        }
        this._renderColorSwatch(context, rc, component, bean, isEditable);
    }

    @Override
    protected Converter getDefaultConverter(FacesContext context, UIComponent component, FacesBean bean) {
        return _DEFAULT_CONVERTER;
    }

    @Override
    protected String getLaunchOnclick(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getActionExpression(component, bean) != null || !Boolean.TRUE.equals(rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_MULTIPLE_WINDOWS))) {
            return super.getLaunchOnclick(context, rc, component, bean);
        }
        String id = rc.getCurrentClientId();
        if (id == null || rc.getFormData() == null) {
            return null;
        }
        StringBuffer onClickBuffer = new StringBuffer(100);
        onClickBuffer.append("_lcp('");
        onClickBuffer.append(rc.getFormData().getName());
        onClickBuffer.append("','");
        onClickBuffer.append(id);
        onClickBuffer.append("'); return false");
        return onClickBuffer.toString();
    }

    @Override
    protected String getOnfocus(UIComponent component, FacesBean bean) {
        String onfocus = super.getOnfocus(component, bean);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (!this._supportsSwatchAndChooser(arc)) {
            return onfocus;
        }
        String chooseId = this._getChooseId(arc);
        if (chooseId != null) {
            int length = _FOCUS_PREFIX.length() + _FOCUS_SUFFIX.length() + chooseId.length();
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(_FOCUS_PREFIX);
            buffer.append(chooseId);
            buffer.append(_FOCUS_SUFFIX);
            return XhtmlUtils.getChainedJS(buffer.toString(), onfocus, false);
        }
        return onfocus;
    }

    @Override
    protected String getOnblur(UIComponent component, FacesBean bean) {
        String onblur = super.getOnblur(component, bean);
        if (!this._supportsSwatchAndChooser(RenderingContext.getCurrentInstance())) {
            return XhtmlUtils.getChainedJS(_AUTO_FORMAT_SCRIPT, onblur, false);
        }
        return XhtmlUtils.getChainedJS("_fixCFF(this);_cfsw(this);", onblur, false);
    }

    @Override
    protected Integer getDefaultColumns(RenderingContext rc, UIComponent component, FacesBean bean) {
        Integer columnsInteger = null;
        Converter converter = this.getConverter(component, bean);
        if (converter instanceof ColorConverter) {
            int columns = ((ColorConverter)converter).getColumns(FacesContext.getCurrentInstance());
            columnsInteger = columns;
        } else {
            columnsInteger = _DEFAULT_COLUMNS;
        }
        return columnsInteger;
    }

    @Override
    protected Number getMaximumLength(UIComponent component, FacesBean bean) {
        return null;
    }

    @Override
    protected String getButtonIconName() {
        return "af|inputColor::launch-icon";
    }

    protected String getChooseId(UIComponent component, FacesBean bean) {
        return SimpleInputColorRenderer.toString((Object)bean.getProperty(this._chooseIdKey));
    }

    protected boolean isCompact(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._compactKey);
        if (o == null) {
            o = this._compactKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputColor";
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputColor::content";
    }

    private String _getChooseId(RenderingContext rc) {
        return (String)rc.getProperties().get(_CACHED_CHOOSE_ID);
    }

    private String _computeChooseId(FacesContext context, UIComponent component, FacesBean bean) {
        return RenderUtils.getRelativeId((FacesContext)context, (UIComponent)component, (String)this.getChooseId(component, bean));
    }

    private boolean _supportsSwatchAndChooser(RenderingContext rc) {
        return !SimpleInputColorRenderer.isPDA((RenderingContext)rc);
    }

    @Override
    protected String getSearchDesc(UIComponent component, FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (SimpleInputColorRenderer.isInaccessibleMode((RenderingContext)arc)) {
            return null;
        }
        return arc.getTranslatedString(_LAUNCH_PICKER_TIP_KEY);
    }

    private String _getColorSwatchId(RenderingContext rc) {
        return rc.getCurrentClientId() + "$sw";
    }

    private void _renderColorSwatch(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean editable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (editable) {
            writer.startElement("a", component);
            writer.writeAttribute("onclick", (Object)this.getLaunchOnclick(context, rc, component, bean), null);
            writer.writeURIAttribute("href", (Object)"#", null);
        }
        writer.startElement("img", component);
        String id = this._getColorSwatchId(rc);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("align", (Object)(SimpleInputColorRenderer.isScreenReaderMode((RenderingContext)rc) ? "middle" : "absmiddle"), null);
        writer.writeAttribute("width", (Object)_CELL_SIZE, null);
        writer.writeAttribute("height", (Object)_CELL_SIZE, null);
        Color color = this._getColorValue(component, bean);
        String inlineStyle = SimpleInputColorRenderer._getInlineStyleForColor(color);
        SimpleInputColorRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"p_OraColorFieldSwatch");
        writer.writeAttribute("style", (Object)inlineStyle, null);
        String altText = null;
        if (color != null && color.getAlpha() == 0) {
            Icon icon = rc.getIcon("cpt.gif");
            if (icon != null) {
                this.renderEncodedResourceURI(context, "src", icon.getImageURI(context, rc));
            }
            String key = editable ? "af_inputColor.LAUNCH_PICKER_TIP" : "af_chooseColor.TRANSPARENT";
            altText = rc.getTranslatedString(key);
        } else {
            String transparentURI = SimpleInputColorRenderer.getBaseImageUri(context, rc) + "t.gif";
            this.renderEncodedResourceURI(context, "src", transparentURI);
            altText = editable ? rc.getTranslatedString("af_inputColor.LAUNCH_PICKER_TIP") : "";
        }
        OutputUtils.renderAltAndTooltipForImage(context, rc, altText);
        writer.endElement("img");
        if (editable) {
            Icon overlay = rc.getIcon("af|inputColor::swatch-overlay-icon");
            if (overlay != null) {
                OutputUtils.renderIcon(context, rc, overlay, "", "middle");
            }
            writer.endElement("a");
        }
    }

    private Color _getColorValue(UIComponent component, FacesBean bean) {
        Object value = this.getValue(component, bean);
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    private void _renderFirstColorFieldScript(FacesContext context, RenderingContext rc, UIComponent component, String chooseId) throws IOException {
        if (chooseId == null) {
            return;
        }
        if (!this._supportsSwatchAndChooser(rc)) {
            return;
        }
        if (rc.getFormData() == null) {
            return;
        }
        String id = this.getClientId(context, component);
        HashMap<String, Boolean> chooseColorIds = (HashMap<String, Boolean>)rc.getProperties().get(_CHOOSE_COLOR_IDS_KEY);
        if (chooseColorIds == null) {
            chooseColorIds = new HashMap<String, Boolean>();
            rc.getProperties().put(_CHOOSE_COLOR_IDS_KEY, chooseColorIds);
        }
        if (chooseColorIds.get(chooseId) == null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            SimpleInputColorRenderer.renderScriptTypeAttribute(context, rc);
            SimpleInputColorRenderer.renderScriptDeferAttribute(context, rc);
            writer.writeText((Object)_FOCUS_PREFIX, null);
            writer.writeText((Object)chooseId, null);
            writer.writeText((Object)"']=document.forms['", null);
            writer.writeText((Object)rc.getFormData().getName(), null);
            writer.writeText((Object)"']['", null);
            writer.writeText((Object)id, null);
            writer.writeText((Object)"'];", null);
            writer.endElement("script");
            chooseColorIds.put(chooseId, Boolean.TRUE);
        }
    }

    private static String _getInlineStyleForColor(Color color) {
        if (color != null && color.getAlpha() > 0) {
            return "background-color:" + CSSUtils.getColorValue(color);
        }
        return null;
    }
}

