/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf;

import java.util.ArrayList;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.ui.UIExtension;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.LookAndFeel;
import org.apache.myfaces.trinidadinternal.ui.laf.LookAndFeelScorer;
import org.apache.myfaces.trinidadinternal.ui.laf.Score;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.simple.desktop.SimpleDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.simple.pda.SimplePdaUtils;

@Deprecated
public class LookAndFeelManager {
    private ArrayList<Object> _scorersAndLafs = new ArrayList(20);
    private ArrayList<UIExtension> _extensions = new ArrayList();
    private ArrayList<LookAndFeel> _lafs = new ArrayList();
    private static LookAndFeelManager _sDefaultInstance;
    private static final TrinidadLogger _LOG;

    public static LookAndFeelManager getDefaultLookAndFeelManager() {
        if (_sDefaultInstance == null) {
            _sDefaultInstance = LookAndFeelManager.createDefaultLookAndFeelManager();
        }
        return _sDefaultInstance;
    }

    public static LookAndFeelManager createDefaultLookAndFeelManager() {
        LookAndFeelManager manager = new LookAndFeelManager();
        BaseDesktopUtils.registerLookAndFeel(manager);
        SimpleDesktopUtils.registerLookAndFeel(manager);
        SimplePdaUtils.registerLookAndFeel(manager);
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookAndFeel getLookAndFeel(UIXRenderingContext context) {
        ArrayList<Object> arrayList = this._scorersAndLafs;
        synchronized (arrayList) {
            int currScore;
            LookAndFeelScorer currScorer;
            int i;
            int entryCount = this._scorersAndLafs.size();
            int maxEntryIndex = -1;
            int maxEntryScore = -999999;
            String lafName = "minimal";
            for (i = 0; i < entryCount; i += 2) {
                currScorer = (LookAndFeelScorer)this._scorersAndLafs.get(i);
                currScore = LookAndFeelManager._score(context, lafName, currScorer);
                if (currScore < maxEntryScore) continue;
                maxEntryScore = currScore;
                maxEntryIndex = i;
            }
            if (maxEntryIndex < 0) {
                for (i = 0; i < entryCount; i += 2) {
                    currScorer = (LookAndFeelScorer)this._scorersAndLafs.get(i);
                    currScore = LookAndFeelManager._score(context, null, currScorer);
                    if (currScore < maxEntryScore) continue;
                    maxEntryScore = currScore;
                    maxEntryIndex = i;
                }
            }
            if (maxEntryIndex >= 0) {
                return (LookAndFeel)this._scorersAndLafs.get(maxEntryIndex + 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookAndFeel getLookAndFeelById(String id) {
        if (id == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_ID"));
        }
        ArrayList<Object> arrayList = this._scorersAndLafs;
        synchronized (arrayList) {
            int entryCount = this._scorersAndLafs.size();
            for (int i = 1; i < entryCount; i += 2) {
                LookAndFeel laf = (LookAndFeel)this._scorersAndLafs.get(i);
                if (!id.equals(laf.getId())) continue;
                return laf;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookAndFeelScorer getLookAndFeelScorer(LookAndFeel laf) {
        ArrayList<Object> arrayList = this._scorersAndLafs;
        synchronized (arrayList) {
            int entryCount = this._scorersAndLafs.size();
            for (int i = 0; i < entryCount; i += 2) {
                Object currLaf = this._scorersAndLafs.get(i + 1);
                if (currLaf != laf) continue;
                return (LookAndFeelScorer)this._scorersAndLafs.get(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLookAndFeel(LookAndFeelScorer scorer, LookAndFeel laf) {
        if (scorer == null || laf == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = this._scorersAndLafs;
        synchronized (arrayList) {
            this._scorersAndLafs.add(scorer);
            this._scorersAndLafs.add(laf);
            if (!this._lafs.contains(laf)) {
                this._lafs.add(laf);
            }
            int extensionCount = this._extensions.size();
            for (int i = 0; i < extensionCount; ++i) {
                UIExtension extension = this._extensions.get(i);
                extension.registerSelf(laf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLookAndFeel(LookAndFeelScorer scorer) {
        ArrayList<Object> arrayList = this._scorersAndLafs;
        synchronized (arrayList) {
            int index = this._scorersAndLafs.indexOf(scorer);
            if (index >= 0) {
                this._scorersAndLafs.remove(index + 1);
                this._scorersAndLafs.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUIExtension(UIExtension extension) {
        ArrayList<Object> arrayList = this._scorersAndLafs;
        synchronized (arrayList) {
            if (!this._extensions.contains(extension)) {
                this._extensions.add(extension);
                int lafCount = this._lafs.size();
                for (int i = 0; i < lafCount; ++i) {
                    LookAndFeel laf = this._lafs.get(i);
                    extension.registerSelf(laf);
                }
            }
        }
    }

    private static int _score(UIXRenderingContext context, String lafName, LookAndFeelScorer scorer) {
        Score score = scorer.scoreLookAndFeel(context, lafName);
        int nameScore = score.getNameScore();
        int agentTypeScore = score.getAgentTypeScore();
        int agentApplicationScore = score.getAgentApplicationScore();
        int agentVersionScore = score.getAgentVersionScore();
        int agentOSScore = score.getAgentOSScore();
        int discriminantScore = score.getDiscriminantScore();
        if (nameScore == -1000000 || agentTypeScore == -1000000 || agentApplicationScore == -1000000 || agentVersionScore == -1000000 || agentOSScore == -1000000 || discriminantScore == -1000000) {
            return -1000000;
        }
        return nameScore + agentTypeScore + agentApplicationScore + agentVersionScore + agentOSScore + discriminantScore;
    }

    private LookAndFeelManager() {
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(LookAndFeelManager.class);
    }
}

