/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.util.HashMap;

public final class CapabilityKey {
    private String _capName;
    private int _capIndex = 0;
    private static final int DEFAULT_SIZE = 50;
    private static HashMap<String, CapabilityKey> _capKeyNames = new HashMap();
    private static CapabilityKey[] _keys = new CapabilityKey[50];
    private static int _count = 0;

    private CapabilityKey(String capabilityName, int index) {
        if (capabilityName == null) {
            throw new NullPointerException();
        }
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        this._capName = capabilityName.intern();
        this._capIndex = index;
        _capKeyNames.put(this._capName, this);
        if (_keys.length < this._capIndex) {
            CapabilityKey[] newKeys = new CapabilityKey[_keys.length + 50];
            System.arraycopy(_keys, 0, newKeys, 0, _keys.length);
        }
        CapabilityKey._keys[this._capIndex] = this;
    }

    public static CapabilityKey getCapabilityKey(String capabilityName, boolean createIfNull) {
        if (capabilityName == null) {
            return null;
        }
        Object key = _capKeyNames.get(capabilityName);
        if (createIfNull && key == null) {
            key = CapabilityKey._createKey(capabilityName);
        }
        return key;
    }

    public static CapabilityKey getCapabilityKey(String capabilityName) {
        return CapabilityKey.getCapabilityKey(capabilityName, false);
    }

    public String getCapabilityName() {
        return this._capName;
    }

    public int getIndex() {
        return this._capIndex;
    }

    public static CapabilityKey getKeyAt(int index) {
        if (index >= 0 && index <= _count) {
            return _keys[index];
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this._capIndex;
    }

    private static synchronized Object _createKey(String capabilityName) {
        CapabilityKey key = _capKeyNames.get(capabilityName);
        if (key == null) {
            key = new CapabilityKey(capabilityName, _count++);
        }
        return key;
    }

    public String toString() {
        return this._capName;
    }
}

