/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeIndent;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIndentRenderer<T extends AbstractUITreeIndent>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor(component, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        if (node == null) {
            throw new NullPointerException("No AbstractUITreeNodeBase as ancestor found from '" + component.getClientId() + "'");
        }
        if (data == null) {
            throw new NullPointerException("No AbstractUIData as ancestor found from '" + component.getClientId() + "'");
        }
        boolean folder = node.isFolder();
        boolean showJunctions = ((AbstractUITreeIndent)component).isShowJunctions();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(component.getClientId(facesContext));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeClassAttribute(TobagoClass.TOGGLE, !folder ? BootstrapClass.INVISIBLE : null, component.getCustomClass());
        if (!showJunctions) {
            return;
        }
        writer.startElement(HtmlElements.I);
        if (folder) {
            writer.writeClassAttribute(expanded ? Icons.DASH_SQUARE : Icons.PLUS_SQUARE);
            writer.writeAttribute(DataAttributes.OPEN, Icons.DASH_SQUARE.getName(), false);
            writer.writeAttribute(DataAttributes.CLOSED, Icons.PLUS_SQUARE.getName(), false);
        } else {
            writer.writeClassAttribute(Icons.SQUARE, BootstrapClass.INVISIBLE);
        }
        writer.endElement(HtmlElements.I);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SPAN);
    }
}

