/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.lang.invoke.MethodHandles;
import javax.faces.component.UIOutput;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.PreRenderViewEvent;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractUIConfig
extends UIOutput {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        if (event instanceof PreRenderViewEvent || event instanceof PostRestoreStateEvent) {
            Integer waitOverlayDelayAjax;
            Integer waitOverlayDelayFull;
            Boolean focusOnError = this.getFocusOnError();
            if (focusOnError != null) {
                TobagoContext.getInstance(event.getFacesContext()).setFocusOnError(focusOnError);
            }
            if ((waitOverlayDelayFull = this.getWaitOverlayDelayFull()) != null) {
                TobagoContext.getInstance(event.getFacesContext()).setWaitOverlayDelayFull(waitOverlayDelayFull);
            }
            if ((waitOverlayDelayAjax = this.getWaitOverlayDelayAjax()) != null) {
                TobagoContext.getInstance(event.getFacesContext()).setWaitOverlayDelayAjax(waitOverlayDelayAjax);
            }
        } else if (event instanceof PostAddToViewEvent) {
            this.getFacesContext().getViewRoot().subscribeToEvent(PreRenderViewEvent.class, (ComponentSystemEventListener)this);
        }
    }

    public abstract Boolean getFocusOnError();

    public abstract Integer getWaitOverlayDelayFull();

    public abstract Integer getWaitOverlayDelayAjax();
}

