/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterWrapper;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlRendererUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlRendererUtils.class);
    private static final String FOCUS_KEY = HtmlRendererUtils.class.getName() + ".FocusId";

    private HtmlRendererUtils() {
    }

    public static void renderFocus(String clientId, boolean focus, boolean error, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (!requestMap.containsKey(FOCUS_KEY) && (clientId.equals(TobagoContext.getInstance(facesContext).getFocusId()) || focus || error)) {
            requestMap.put(FOCUS_KEY, Boolean.TRUE);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.AUTOFOCUS, true);
        }
    }

    public static String getRendererName(FacesContext facesContext, UIComponent component) {
        String rendererType = component.getRendererType();
        return rendererType.substring(0, 1).toLowerCase(Locale.ENGLISH) + rendererType.substring(1);
    }

    public static void writeLabelWithAccessKey(TobagoResponseWriter writer, LabelWithAccessKey label) throws IOException {
        int pos = label.getPos();
        String text = label.getLabel();
        if (text != null) {
            if (pos == -1) {
                writer.writeText(text);
            } else {
                writer.writeText(text.substring(0, pos));
                writer.startElement(HtmlElements.U);
                writer.writeText(Character.toString(text.charAt(pos)));
                writer.endElement(HtmlElements.U);
                writer.writeText(text.substring(pos + 1));
            }
        }
    }

    @Deprecated
    public static void encodeIconWithLabel(TobagoResponseWriter writer, String image, String label) throws IOException {
        if (image != null && image.startsWith("fa-")) {
            writer.writeIcon(null, Icons.custom(image));
        }
        if (label != null) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeText(label);
            writer.endElement(HtmlElements.SPAN);
        }
    }

    public static void encodeIconOrImage(TobagoResponseWriter writer, String image) throws IOException {
        if (image != null) {
            if (image.startsWith("fa-")) {
                writer.startElement(HtmlElements.I);
                writer.writeClassAttribute(Icons.FA, Icons.custom(image));
                writer.endElement(HtmlElements.I);
            } else {
                writer.startElement(HtmlElements.IMG);
                writer.writeAttribute(HtmlAttributes.SRC, image, true);
                writer.writeAttribute(HtmlAttributes.ALT, "", false);
                writer.endElement(HtmlElements.IMG);
            }
        }
    }

    @Deprecated
    public static void encodeIconWithLabel(TobagoResponseWriter writer, FacesContext facesContext, String image, LabelWithAccessKey label, boolean disabled) throws IOException {
        if (image != null) {
            if (image.startsWith("fa-")) {
                writer.writeIcon(null, Icons.custom(image));
            } else {
                writer.startElement(HtmlElements.IMG);
                writer.writeAttribute(HtmlAttributes.SRC, image, true);
                writer.writeAttribute(HtmlAttributes.ALT, "", false);
                writer.endElement(HtmlElements.IMG);
            }
        }
        if (label.getLabel() != null) {
            writer.startElement(HtmlElements.SPAN);
            HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            writer.endElement(HtmlElements.SPAN);
        }
    }

    @Deprecated
    public static TobagoResponseWriter getTobagoResponseWriter(FacesContext facesContext) {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer instanceof TobagoResponseWriter) {
            return (TobagoResponseWriter)writer;
        }
        return new TobagoResponseWriterWrapper(writer);
    }

    public static String getTitleFromTipAndMessages(FacesContext facesContext, UIComponent component) {
        String messages = ComponentUtils.getFacesMessageAsString(facesContext, component);
        return HtmlRendererUtils.addTip(messages, ComponentUtils.getAttribute(component, Attributes.tip));
    }

    public static String addTip(String title, Object tip) {
        String result = title;
        if (tip != null) {
            result = result != null && result.length() > 0 ? result + " :: " : "";
            result = result + tip;
        }
        return result;
    }

    @Deprecated
    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        HtmlRendererUtils.renderSelectItems(component, optionClass, items, values, null, null, writer, facesContext);
    }

    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        HtmlRendererUtils.renderSelectItems(component, optionClass, items, values, submittedValues, null, writer, facesContext);
    }

    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object value, String submittedValue, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        String[] stringArray;
        Object[] objectArray;
        if (value != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        } else {
            objectArray = null;
        }
        if (submittedValue != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = submittedValue;
        } else {
            stringArray = null;
        }
        HtmlRendererUtils.renderSelectItems(component, optionClass, items, objectArray, stringArray, null, writer, facesContext);
    }

    public static void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, Boolean onlySelected, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("component id = '{}'", (Object)component.getId());
            LOG.debug("values = '{}'", (Object)Arrays.toString(values));
            LOG.debug("submittedValues = '{}'", (Object)Arrays.toString(submittedValues));
        }
        for (SelectItem item : items) {
            Markup markup;
            String image;
            if (item instanceof SelectItemGroup) {
                writer.startElement(HtmlElements.OPTGROUP);
                writer.writeAttribute(HtmlAttributes.LABEL, item.getLabel(), true);
                if (item.isDisabled()) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
                }
                SelectItem[] selectItems = ((SelectItemGroup)item).getSelectItems();
                HtmlRendererUtils.renderSelectItems(component, optionClass, Arrays.asList(selectItems), values, submittedValues, onlySelected, writer, facesContext);
                writer.endElement(HtmlElements.OPTGROUP);
                continue;
            }
            Object itemValue = item.getValue();
            if (itemValue instanceof String && values != null && values.length > 0 && !(values[0] instanceof String)) {
                itemValue = ComponentUtils.getConvertedValue(facesContext, (UIComponent)component, (String)itemValue);
            }
            String formattedValue = ComponentUtils.getFormattedValue(facesContext, (UIComponent)component, itemValue);
            boolean contains = submittedValues == null ? ArrayUtils.contains(values, itemValue) : ArrayUtils.contains(submittedValues, formattedValue);
            if (onlySelected != null && (onlySelected != false ? !contains : contains)) continue;
            writer.startElement(HtmlElements.OPTION);
            writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
            if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
                style.setTransient(true);
                style.setBackgroundImage(image);
                style.setSelector(StyleRenderUtils.encodeIdSelector(component.getClientId(facesContext)) + " option[value=" + formattedValue + "]");
                component.getChildren().add(style);
            }
            Markup markup2 = markup = item instanceof Visual ? ((Visual)item).getMarkup() : Markup.NULL;
            if (onlySelected == null && contains) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SELECTED, true);
                markup = Markup.SELECTED.add(markup);
            }
            if (item.isDisabled()) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
                markup = Markup.DISABLED.add(markup);
            }
            writer.writeClassAttribute((CssItem)optionClass, optionClass.createMarkup(markup), new CssItem[0]);
            writer.writeText(item.getLabel());
            writer.endElement(HtmlElements.OPTION);
        }
    }

    public static void writeDataAttributes(FacesContext context, TobagoResponseWriter writer, UIComponent component) throws IOException {
        Map<Object, Object> dataAttributes = ComponentUtils.getDataAttributes(component);
        if (dataAttributes == null) {
            return;
        }
        ELContext elContext = context.getELContext();
        for (Map.Entry<Object, Object> entry : dataAttributes.entrySet()) {
            Object mapKey = entry.getKey();
            String name = mapKey instanceof ValueExpression ? ((ValueExpression)mapKey).getValue(elContext).toString() : mapKey.toString();
            Object mapValue = entry.getValue();
            String value = mapValue instanceof ValueExpression ? ((ValueExpression)mapValue).getValue(elContext).toString() : mapValue.toString();
            writer.writeAttribute(DataAttributes.dynamic(name), value, true);
        }
    }
}

