/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeLabel;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeLabelRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        boolean listbox = data instanceof AbstractUITreeListbox;
        AbstractUITreeLabel label = (AbstractUITreeLabel)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String text = StringUtils.defaultString((String)label.getValue());
        if (listbox) {
            writer.writeText(text);
        } else {
            writer.startElement(HtmlElements.LABEL);
            writer.writeClassAttribute((CssItem)TobagoClass.TREE_LABEL, TobagoClass.TREE_LABEL.createMarkup(label.getMarkup()), new CssItem[]{label.getCustomClass()});
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)label);
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)label);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
            writer.writeText(text);
            writer.endElement(HtmlElements.LABEL);
        }
    }
}

