/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIIn;
import org.apache.myfaces.tobago.component.UISuggest;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.model.AutoSuggestItem;
import org.apache.myfaces.tobago.model.AutoSuggestItems;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SuggestRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISuggest suggest = (UISuggest)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        if (suggest.getParent() instanceof UIIn) {
            this.writeInSuggestElements(facesContext, writer, suggest);
        } else if (suggest.isSelect2()) {
            this.writeSelect2SuggestElements(facesContext, writer, suggest);
        }
    }

    public void writeInSuggestElements(FacesContext facesContext, TobagoResponseWriter writer, UISuggest suggest) throws IOException {
        UIIn in = (UIIn)suggest.getParent();
        String inClientId = in.getClientId(facesContext);
        AutoSuggestItems items = suggest.getSuggestItems(facesContext);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)suggest));
        writer.writeIdAttribute(suggest.getClientId(facesContext));
        writer.writeAttribute("data-tobago-for", inClientId, false);
        writer.writeAttribute("data-tobago-suggest-min-chars", suggest.getMinimumCharacters().intValue());
        writer.writeAttribute("data-tobago-suggest-delay", suggest.getDelay().intValue());
        writer.writeAttribute("data-tobago-suggest-max-items", suggest.getMaximumItems().intValue());
        writer.writeAttribute("data-tobago-suggest-update", Boolean.toString(suggest.isUpdate()), false);
        int totalCount = suggest.getTotalCount();
        if (totalCount == -1) {
            totalCount = items.getItems().size();
        }
        writer.writeAttribute("data-tobago-suggest-total-count", totalCount);
        writer.startElement("ol", null);
        writer.writeClassAttribute("tobago-menuBar");
        writer.startElement("li", null);
        writer.writeClassAttribute("tobago-menu tobago-menu-markup-top");
        writer.startElement("a", null);
        writer.writeAttribute("href", "#", false);
        writer.writeAttribute("tabindex", -1);
        writer.endElement("a");
        writer.startElement("ol", null);
        for (AutoSuggestItem item : items.getItems()) {
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", "#", false);
            writer.writeAttribute("data-tobago-suggest-item-for", inClientId, false);
            writer.writeText(item.getLabel());
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.startElement("li", null);
        writer.writeAttribute("disabled", true);
        String title = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.in.inputSuggest.moreElements");
        writer.writeAttribute("title", title, true);
        writer.startElement("a", null);
        writer.writeAttribute("href", "#", false);
        writer.writeText("...");
        writer.endElement("a");
        writer.endElement("li");
        writer.endElement("ol");
        writer.endElement("li");
        writer.endElement("ol");
        writer.endElement("div");
    }

    public void writeSelect2SuggestElements(FacesContext facesContext, TobagoResponseWriter writer, UISuggest suggest) throws IOException {
        UIComponent selectManyBox = suggest.getParent();
        String inClientId = selectManyBox.getClientId(facesContext);
        String id = suggest.getClientId(facesContext);
        AutoSuggestItems items = suggest.getSuggestItems(facesContext);
        writer.startElement("input", null);
        writer.writeClassAttribute(Classes.create((UIComponent)suggest));
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        writer.writeAttribute("data-tobago-for", inClientId, false);
        writer.writeAttribute("data-tobago-suggest-min-chars", suggest.getMinimumCharacters().intValue());
        writer.writeAttribute("data-tobago-suggest-delay", suggest.getDelay().intValue());
        writer.writeAttribute("data-tobago-suggest-max-items", suggest.getMaximumItems().intValue());
        writer.writeAttribute("data-tobago-suggest-update", Boolean.toString(suggest.isUpdate()), false);
        int totalCount = suggest.getTotalCount();
        if (totalCount == -1) {
            totalCount = items.getItems().size();
        }
        writer.writeAttribute("data-tobago-suggest-total-count", totalCount);
        StringBuilder builder = new StringBuilder("{\"results\":[");
        for (AutoSuggestItem item : items.getItems()) {
            builder.append("{");
            builder.append("\"id\":\"").append(this.encode(item.getValue())).append("\",");
            builder.append("\"text\":\"").append(this.encode(item.getLabel())).append("\"");
            builder.append("},");
        }
        if (builder.toString().endsWith(",")) {
            builder.setLength(builder.length() - 1);
        }
        builder.append("]}");
        writer.writeAttribute("data-tobago-suggest-response-data", builder.toString(), true);
        writer.endElement("input");
    }

    private String encode(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

