/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.internal.component.AbstractUISplitLayout;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.GridLayoutRenderer;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitLayoutRenderer
extends GridLayoutRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SplitLayoutRenderer.class);
    private static final String POSITION_ID_POSTFIX = "_spLP";

    public void decode(FacesContext facesContext, UIComponent component) {
        String clientId = component.getClientId();
        if (clientId.equals(ComponentUtils.findPage((FacesContext)facesContext).getActionId())) {
            Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String position = (String)parameterMap.get(clientId + POSITION_ID_POSTFIX);
            ((AbstractUISplitLayout)component).updateLayout(Double.valueOf(position).intValue());
        }
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        LayoutContainer container = (LayoutContainer)((AbstractUISplitLayout)component).getParent();
        if (!container.isLayoutChildren()) {
            return;
        }
        List components = container.getComponents();
        if (components.size() != 2) {
            LOG.warn("Illegal component count in splitLayout: {}", (Object)components.size());
        }
        RenderUtils.encode(facesContext, (UIComponent)components.get(0));
        RenderUtils.encode(facesContext, (UIComponent)components.get(1));
        if (((UIComponent)components.get(0)).isRendered() && ((UIComponent)components.get(1)).isRendered()) {
            this.encodeHandle(facesContext, (AbstractUISplitLayout)component);
        }
    }

    protected void encodeHandle(FacesContext facesContext, AbstractUISplitLayout layout) throws IOException {
        String id = layout.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("span", (UIComponent)layout);
        writer.writeIdAttribute(id);
        writer.writeAttribute("data-tobago-split-layout", layout.getOrientation().toLowerCase(), true);
        writer.writeAttribute("data-tobago-split-layout-containment", this.createDraggableContainment(layout), true);
        Style style = this.calculateHandleStyle(facesContext, layout);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)layout, (String)layout.getOrientation().toLowerCase()));
        int position = AbstractUISplitLayout.HORIZONTAL.equals(layout.getOrientation()) ? style.getLeft().getPixel() : style.getTop().getPixel();
        writer.startElement("input", null);
        writer.writeIdAttribute(id + POSITION_ID_POSTFIX);
        writer.writeNameAttribute(id + POSITION_ID_POSTFIX);
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", Integer.toString(position), false);
        writer.endElement("input");
        writer.endElement("span");
    }

    private String createDraggableContainment(AbstractUISplitLayout layout) {
        LayoutContainer container = (LayoutContainer)layout.getParent();
        LayoutComponent firstComponent = (LayoutComponent)container.getComponents().get(0);
        LayoutComponent secondComponent = (LayoutComponent)container.getComponents().get(1);
        if (AbstractUISplitLayout.HORIZONTAL.equals(layout.getOrientation())) {
            Measure minimum = firstComponent.getMinimumWidth();
            int minimumSize1 = minimum != null ? minimum.getPixel() : 0;
            minimum = secondComponent.getMinimumWidth();
            int minimumSize2 = minimum != null ? minimum.getPixel() : 0;
            int totalSize = container.getCurrentWidth().getPixel();
            return "[" + minimumSize1 + ", 0, " + (totalSize - minimumSize2) + ", 0]";
        }
        Measure minimum = firstComponent.getMinimumHeight();
        int minimumSize1 = minimum != null ? minimum.getPixel() : 0;
        minimum = secondComponent.getMinimumHeight();
        int minimumSize2 = minimum != null ? minimum.getPixel() : 0;
        int totalSize = container.getCurrentHeight().getPixel();
        return "[0, " + minimumSize1 + ", 0, " + (totalSize - minimumSize2) + "]";
    }

    private Style calculateHandleStyle(FacesContext facesContext, AbstractUISplitLayout layout) {
        LayoutContainer container = (LayoutContainer)layout.getParent();
        LayoutComponent secondComponent = (LayoutComponent)container.getComponents().get(1);
        Style style = new Style();
        if (AbstractUISplitLayout.HORIZONTAL.equals(layout.getOrientation())) {
            Measure columnSpacing = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)layout, "columnSpacing");
            style.setWidth(columnSpacing);
            style.setHeight(container.getCurrentHeight());
            style.setLeft(Measure.valueOf((Measure)secondComponent.getLeft().subtract(columnSpacing)));
            style.setTop(Measure.valueOf((int)0));
        } else {
            style.setWidth(container.getCurrentWidth());
            Measure rowSpacing = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)layout, "rowSpacing");
            style.setHeight(rowSpacing);
            style.setLeft(Measure.valueOf((int)0));
            style.setTop(Measure.valueOf((Measure)Measure.valueOf((Measure)secondComponent.getTop().subtract(rowSpacing))));
        }
        style.setDisplay(Display.BLOCK);
        style.setPosition(Position.ABSOLUTE);
        return style;
    }
}

