/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Box;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRendererBase
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PageRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (component instanceof AbstractUIPage) {
            AbstractUIPage page = (AbstractUIPage)component;
            this.decodeActionPosition(facesContext, page);
            this.decodePageState(facesContext, page);
        }
    }

    private void decodeActionPosition(FacesContext facesContext, AbstractUIPage page) {
        String actionIdName = page.getClientId(facesContext) + "::" + "form-action";
        String newActionId = (String)facesContext.getExternalContext().getRequestParameterMap().get(actionIdName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("action = " + newActionId);
        }
        page.setActionId(newActionId);
        FacesContextUtils.setActionId((FacesContext)facesContext, (String)newActionId);
        try {
            String actionPositionName = page.getClientId(facesContext) + "::" + "action-position";
            String actionPositionString = (String)facesContext.getExternalContext().getRequestParameterMap().get(actionPositionName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("actionPosition='" + actionPositionString + "'");
            }
            if (StringUtils.isNotEmpty((String)actionPositionString)) {
                Box actionPosition = new Box(actionPositionString);
                page.setActionPosition(actionPosition);
            } else {
                page.setActionPosition(null);
            }
        }
        catch (Exception e) {
            LOG.warn("Can't analyse parameter for action-position", (Throwable)e);
        }
    }

    private void decodePageState(FacesContext facesContext, AbstractUIPage page) {
        String value = null;
        try {
            String name = page.getClientId(facesContext) + "::" + "form-clientDimension";
            value = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
            if (StringUtils.isNotBlank((String)value)) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                Measure width = Measure.valueOf((String)tokenizer.nextToken());
                Measure height = Measure.valueOf((String)tokenizer.nextToken());
                PageState pageState = page.getPageState(facesContext);
                if (pageState != null) {
                    pageState.setClientWidth(width.getPixel());
                    pageState.setClientHeight(height.getPixel());
                }
                ClientProperties clientProperties = ClientProperties.getInstance((FacesContext)facesContext);
                clientProperties.setPageWidth(width);
                clientProperties.setPageHeight(height);
            }
        }
        catch (Exception e) {
            LOG.error("Error in decoding state: value='" + value + "'", (Throwable)e);
        }
    }
}

