/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.myfaces.tobago.model.DateModel;

public class CalendarModel {
    private DateModel[][] calendarArray;
    private int firstDayOffset;

    public CalendarModel(Calendar calendar) {
        int weekCount = 6;
        this.calendarArray = new DateModel[6][7];
        Calendar c = (Calendar)calendar.clone();
        c.clear(5);
        c.set(5, 1);
        this.firstDayOffset = this.firstDayOffset(c);
        c.add(7, -this.firstDayOffset);
        for (int week = 0; week < 6; ++week) {
            for (int day = 0; day < 7; ++day) {
                this.calendarArray[week][day] = new DateModel(c);
                c.add(5, 1);
            }
        }
    }

    public int getWeekCount() {
        return this.calendarArray.length;
    }

    public int getMonth() {
        return this.calendarArray[0][this.firstDayOffset].getMonth();
    }

    public int getYear() {
        return this.calendarArray[0][this.firstDayOffset].getYear();
    }

    public DateModel getDate(int week, int day) {
        return this.calendarArray[week][day];
    }

    private int firstDayOffset(Calendar calendar) {
        Calendar c = (Calendar)calendar.clone();
        c.clear(5);
        c.set(5, 1);
        int day = c.get(7);
        int firstDayOfWeek = c.getFirstDayOfWeek();
        return (day + 7 - firstDayOfWeek) % 7;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Month: ").append(this.getMonth()).append("\n");
        int weekCount = this.getWeekCount();
        DecimalFormat format = new DecimalFormat("00");
        SimpleDateFormat dateFormat = new SimpleDateFormat("E");
        for (int day = 0; day < 7; ++day) {
            DateModel date = this.getDate(0, day);
            String dayName = dateFormat.format(date.getCalendar().getTime());
            buffer.append(dayName.substring(0, 2)).append(" ");
        }
        buffer.append("\n");
        for (int week = 0; week < weekCount; ++week) {
            for (int day = 0; day < 7; ++day) {
                DateModel date = this.getDate(week, day);
                buffer.append(format.format(date.getDay())).append(" ");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

