/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIWizard;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WizardTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(WizardTag.class);
    private ValueExpression title;
    private ValueExpression allowJumpForward;
    private String outcome;
    private ValueExpression controller;
    private ValueExpression markup;
    private String var;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Wizard";
    }

    public String getRendererType() {
        return "Wizard";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIWizard component = (UIWizard)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.title != null) {
            component.setValueExpression("title", this.title);
        }
        if (this.allowJumpForward != null) {
            if (!this.allowJumpForward.isLiteralText()) {
                component.setValueExpression("allowJumpForward", this.allowJumpForward);
            } else {
                component.setAllowJumpForward(Boolean.parseBoolean(this.allowJumpForward.getExpressionString()));
            }
        }
        if (this.outcome != null) {
            component.setOutcome(this.outcome);
        }
        if (this.controller != null && !this.controller.isLiteralText()) {
            component.setValueExpression("controller", this.controller);
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.var != null) {
            component.setVar(this.var);
        }
    }

    public ValueExpression getTitle() {
        return this.title;
    }

    public void setTitle(ValueExpression title) {
        this.title = title;
    }

    public ValueExpression getAllowJumpForward() {
        return this.allowJumpForward;
    }

    public void setAllowJumpForward(ValueExpression allowJumpForward) {
        this.allowJumpForward = allowJumpForward;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public ValueExpression getController() {
        return this.controller;
    }

    public void setController(ValueExpression controller) {
        this.controller = controller;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void release() {
        super.release();
        this.title = null;
        this.allowJumpForward = null;
        this.outcome = null;
        this.controller = null;
        this.markup = null;
        this.var = null;
    }
}

