/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.compat.FacesUtilsEL;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.component.SupportsRenderedPartially;
import org.apache.myfaces.tobago.component.UITab;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource2;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUITabGroup
extends AbstractUIPanelBase
implements TabChangeSource2,
ActionSource2,
LayoutContainer,
LayoutComponent,
OnComponentPopulated,
SupportsRenderedPartially {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUITabGroup.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TabGroup";
    public static final String SWITCH_TYPE_CLIENT = "client";
    public static final String SWITCH_TYPE_RELOAD_PAGE = "reloadPage";
    public static final String SWITCH_TYPE_RELOAD_TAB = "reloadTab";

    public void encodeBegin(FacesContext facesContext) throws IOException {
        super.encodeBegin(facesContext);
        ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeBegin(facesContext);
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeEnd(facesContext);
        this.resetTabLayout();
        super.encodeEnd(facesContext);
        this.setRenderedIndex(this.getSelectedIndex());
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void queueEvent(FacesEvent event) {
        if (this == event.getSource()) {
            if (this.isImmediate() || this.isSwitchTypeClient()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    private void resetTabLayout() {
        for (UIComponent component : this.getChildren()) {
            component.getAttributes().remove("layoutWidth");
            component.getAttributes().remove("layoutHeight");
        }
    }

    public AbstractUIPanelBase[] getTabs() {
        ArrayList<AbstractUIPanelBase> tabs = new ArrayList<AbstractUIPanelBase>();
        for (UIComponent kid : this.getChildren()) {
            if (kid instanceof AbstractUIPanelBase) {
                tabs.add((AbstractUIPanelBase)kid);
                continue;
            }
            LOG.error("Invalid component in UITabGroup: " + kid);
        }
        return tabs.toArray(new AbstractUIPanelBase[tabs.size()]);
    }

    public AbstractUIPanelBase getActiveTab() {
        return this.getTab(this.getSelectedIndex());
    }

    public void processDecodes(FacesContext context) {
        if (!this.isSwitchTypeClient()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            int index = 0;
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UITab)) continue;
                UITab tab = (UITab)child;
                if (tab.isRendered()) {
                    if (this.getRenderedIndex() == index) {
                        tab.processDecodes(context);
                    } else {
                        UIComponent facet = tab.getFacet("toolBar");
                        if (facet != null) {
                            facet.processDecodes(context);
                        }
                    }
                }
                ++index;
            }
            for (UIComponent facet : this.getFacets().values()) {
                facet.processDecodes(context);
            }
            try {
                this.decode(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isSwitchTypeClient()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            AbstractUIPanelBase renderedTab = this.getRenderedTab();
            renderedTab.processValidators(context);
            for (UIComponent facet : this.getFacets().values()) {
                facet.processValidators(context);
            }
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isSwitchTypeClient()) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            AbstractUIPanelBase renderedTab = this.getRenderedTab();
            renderedTab.processUpdates(context);
            for (UIComponent facet : this.getFacets().values()) {
                facet.processUpdates(context);
            }
        } else {
            super.processUpdates(context);
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof TabChangeEvent && facesEvent.getComponent() == this) {
            ActionListener defaultActionListener;
            TabChangeEvent event = (TabChangeEvent)facesEvent;
            MethodExpression methodExpression = this.getTabChangeListenerExpression();
            if (methodExpression != null) {
                FacesUtilsEL.invokeMethodExpression(FacesContext.getCurrentInstance(), methodExpression, facesEvent);
            }
            if (!this.isSwitchTypeClient() && (defaultActionListener = this.getFacesContext().getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
            Integer index = event.getNewTabIndex();
            ValueExpression expression = this.getValueExpression("selectedIndex");
            if (expression != null) {
                expression.setValue(this.getFacesContext().getELContext(), (Object)index);
            } else {
                this.setSelectedIndex(index);
            }
        }
    }

    @Override
    public void addTabChangeListener(TabChangeListener listener) {
        if (LOG.isWarnEnabled() && this.isSwitchTypeClient()) {
            LOG.warn("Adding TabChangeListener to client side TabGroup!");
        }
        this.addFacesListener(listener);
    }

    public boolean isSwitchTypeClient() {
        String switchType = this.getSwitchType();
        return switchType == null || switchType.equals(SWITCH_TYPE_CLIENT);
    }

    @Override
    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public TabChangeListener[] getTabChangeListeners() {
        return (TabChangeListener[])this.getFacesListeners(TabChangeListener.class);
    }

    public abstract Integer getRenderedIndex();

    public abstract void setRenderedIndex(Integer var1);

    public abstract Integer getSelectedIndex();

    public abstract void setSelectedIndex(Integer var1);

    public abstract String getSwitchType();

    private AbstractUIPanelBase getTab(int index) {
        int i = 0;
        for (UIComponent component : this.getChildren()) {
            if (component instanceof AbstractUIPanelBase) {
                if (i == index) {
                    return (AbstractUIPanelBase)component;
                }
                ++i;
                continue;
            }
            LOG.error("Invalid component in UITabGroup: " + component);
        }
        LOG.error("Found no component with index: " + index + " childCount: " + this.getChildCount());
        return null;
    }

    private AbstractUIPanelBase getRenderedTab() {
        return this.getTab(this.getRenderedIndex());
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    @Override
    public List<LayoutComponent> getComponents() {
        return LayoutUtils.findLayoutChildren(this);
    }

    @Override
    public void onComponentPopulated(FacesContext facesContext, UIComponent parent) {
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(CreateComponentUtils.createAndInitLayout(facesContext, "org.apache.myfaces.tobago.TabGroupLayout", "TabGroupLayout", parent));
        }
    }

    @Override
    public LayoutManager getLayoutManager() {
        return (LayoutManager)this.getFacet("layout");
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.getFacets().put("layout", (AbstractUILayoutBase)((Object)layoutManager));
    }

    @Override
    public boolean isLayoutChildren() {
        return this.isRendered();
    }
}

