/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.html.Popup;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;

public class Command {
    private String action;
    private Boolean transition;
    private String target;
    private String url;
    private String[] partially;
    private String focus;
    private String confirmation;
    private Integer delay;
    private Popup popup;
    private Boolean omit;
    @Deprecated
    private String script;

    public Command() {
    }

    public Command(String action, Boolean transition, String target, String url, String[] partially, String focus, String confirmation, Integer delay, Popup popup, Boolean omit) {
        this.action = action;
        this.transition = transition;
        this.target = target;
        this.url = url;
        this.partially = partially;
        this.focus = focus;
        this.confirmation = confirmation;
        this.delay = delay;
        this.popup = popup;
        this.omit = omit;
    }

    public Command(FacesContext facesContext, AbstractUICommand command) {
        this(null, command.isTransition(), command.getTarget(), RenderUtils.generateUrl(facesContext, command), ComponentUtils.evaluateClientIds((FacesContext)facesContext, (UIComponent)command, (String[])command.getRenderedPartially()), null, Command.getConfirmation(command), null, Popup.createPopup(command), command.isOmit());
        if (command.getOnclick() != null) {
            this.script = command.getOnclick();
        }
    }

    public Command(FacesContext facesContext, UIComponent facetComponent, String focusId) {
        String targetAttribute;
        UIComponent facet;
        if (facetComponent instanceof UIForm && facetComponent.getChildCount() == 1) {
            Deprecation.LOG.warn("Please don't use a form, but a command with immediate=true instead.");
            facet = (UIComponent)facetComponent.getChildren().get(0);
        } else {
            facet = facetComponent;
        }
        this.action = facet.getClientId(facesContext);
        if (!ComponentUtils.getBooleanAttribute((UIComponent)facet, (String)"transition")) {
            this.transition = Boolean.FALSE;
        }
        if ((targetAttribute = ComponentUtils.getStringAttribute((UIComponent)facet, (String)"target")) != null) {
            this.target = targetAttribute;
        }
        if (facet instanceof AbstractUICommand && ((AbstractUICommand)facet).getRenderedPartially().length > 0) {
            this.partially = ComponentUtils.evaluateClientIds((FacesContext)facesContext, (UIComponent)facet, (String[])((UICommand)facet).getRenderedPartially());
        } else {
            String facetAction = (String)facet.getAttributes().get("onclick");
            if (facetAction != null) {
                this.script = facetAction = StringUtils.replace((String)facetAction, (String)"@autoId", (String)facet.getClientId(facesContext));
            }
            if (focusId != null) {
                this.focus = focusId;
            }
        }
        int delayAttribute = ComponentUtils.getIntAttribute((UIComponent)facet, (String)"delay");
        if (delayAttribute > 0) {
            this.delay = delayAttribute;
        }
        if (ComponentUtils.getBooleanAttribute((UIComponent)facet, (String)"omit")) {
            this.omit = Boolean.TRUE;
        }
    }

    private static String getConfirmation(AbstractUICommand command) {
        ValueHolder facet = (ValueHolder)command.getFacet("confirmation");
        return facet != null && ((UIComponent)facet).isRendered() ? "" + facet.getValue() : null;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Boolean getTransition() {
        return this.transition;
    }

    public void setTransition(Boolean transition) {
        this.transition = transition;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String[] getPartially() {
        return this.partially;
    }

    public void setPartially(String[] partially) {
        this.partially = partially;
    }

    public String getFocus() {
        return this.focus;
    }

    public void setFocus(String focus) {
        this.focus = focus;
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Popup getPopup() {
        return this.popup;
    }

    public void setPopup(Popup popup) {
        this.popup = popup;
    }

    public Boolean getOmit() {
        return this.omit;
    }

    public void setOmit(Boolean omit) {
        this.omit = omit;
    }

    @Deprecated
    public String getScript() {
        return this.script;
    }

    @Deprecated
    public void setScript(String script) {
        this.script = script;
    }
}

