/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.tobago.component.UIStyle;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyleTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(StyleTag.class);
    private ValueExpression file;
    private ValueExpression style;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Style";
    }

    public String getRendererType() {
        return "Style";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIStyle component = (UIStyle)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.file != null) {
            component.setValueExpression("file", this.file);
        }
        if (this.style != null) {
            component.setValueExpression("style", this.style);
        }
    }

    public ValueExpression getFile() {
        return this.file;
    }

    public void setFile(ValueExpression file) {
        this.file = file;
    }

    public ValueExpression getStyle() {
        return this.style;
    }

    public void setStyle(ValueExpression style) {
        this.style = style;
    }

    public int doAfterBody() throws JspException {
        String content = this.bodyContent.getString();
        this.bodyContent.clearBody();
        if (StringUtils.isNotBlank(content)) {
            UIStyle component = (UIStyle)this.getComponentInstance();
            component.setStyle(content.trim());
        }
        return super.doAfterBody();
    }

    public void release() {
        super.release();
        this.file = null;
        this.style = null;
    }
}

