/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.layout;

import java.text.DecimalFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutContext {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutContext.class);
    private LayoutContainer container;

    public LayoutContext(LayoutContainer container) {
        this.container = container;
    }

    public void layout() {
        long begin = 0L;
        boolean debug = LOG.isDebugEnabled();
        boolean trace = LOG.isTraceEnabled();
        if (debug) {
            begin = System.nanoTime();
        }
        LayoutManager layoutManager = this.container.getLayoutManager();
        layoutManager.init();
        if (trace) {
            this.log("after init", true);
        }
        layoutManager.fixRelativeInsideAuto(Orientation.VERTICAL, false);
        if (trace) {
            this.log("after fixRelativeInsideAuto vertical", true);
        }
        layoutManager.fixRelativeInsideAuto(Orientation.HORIZONTAL, false);
        if (trace) {
            this.log("after fixRelativeInsideAuto horizontal", true);
        }
        layoutManager.preProcessing(Orientation.VERTICAL);
        if (trace) {
            this.log("after preProcessing vertical", true);
        }
        layoutManager.preProcessing(Orientation.HORIZONTAL);
        if (trace) {
            this.log("after preProcessing horizontal", true);
        }
        layoutManager.mainProcessing(Orientation.VERTICAL);
        if (trace) {
            this.log("after mainProcessing vertical", true);
        }
        layoutManager.mainProcessing(Orientation.HORIZONTAL);
        if (trace) {
            this.log("after mainProcessing horizontal", true);
        }
        layoutManager.postProcessing(Orientation.VERTICAL);
        if (trace) {
            this.log("after postProcessing vertical", true);
        }
        layoutManager.postProcessing(Orientation.HORIZONTAL);
        if (trace) {
            this.log("after postProcessing horizontal", true);
        }
        if (debug) {
            LOG.debug("Laying out takes: {} ns", (Object)new DecimalFormat("#,##0").format(System.nanoTime() - begin));
            this.log("after layout", false);
        }
    }

    private void log(String message, boolean trace) {
        StringBuffer buffer = new StringBuffer(message + "\n");
        this.log(buffer, (UIComponent)this.container, 0);
        if (trace) {
            LOG.trace(buffer.toString());
        } else {
            LOG.debug(buffer.toString());
        }
    }

    private void log(StringBuffer buffer, UIComponent component, int depth) {
        LayoutManager layoutManager;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        buffer.append(StringUtils.repeat("  ", depth));
        buffer.append(component.getClass().getSimpleName());
        buffer.append("#");
        buffer.append(component.getClientId(facesContext));
        if (component instanceof LayoutBase) {
            buffer.append("(");
            buffer.append(((LayoutBase)component).getCurrentWidth());
            buffer.append(", ");
            buffer.append(((LayoutBase)component).getCurrentHeight());
            buffer.append(")");
        }
        if (component instanceof LayoutContainer && (layoutManager = ((LayoutContainer)component).getLayoutManager()) instanceof AbstractUIGridLayout) {
            buffer.append("\n");
            buffer.append(StringUtils.repeat("  ", depth + 4));
            buffer.append("layout: ");
            buffer.append(((AbstractUIGridLayout)layoutManager).toString(depth));
        }
        buffer.append("\n");
        for (UIComponent child : component.getChildren()) {
            this.log(buffer, child, depth + 2);
        }
    }
}

