/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.collector;

import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.collector.ProjectCollectionStrategy;
import org.apache.maven.project.collector.ProjectsSelector;

@Named(value="RequestPomCollectionStrategy")
@Singleton
public class RequestPomCollectionStrategy
implements ProjectCollectionStrategy {
    private final ProjectsSelector projectsSelector;

    @Inject
    public RequestPomCollectionStrategy(ProjectsSelector projectsSelector) {
        this.projectsSelector = projectsSelector;
    }

    @Override
    public List<MavenProject> collectProjects(MavenExecutionRequest request) throws ProjectBuildingException {
        List<File> files = Collections.singletonList(request.getPom().getAbsoluteFile());
        return this.projectsSelector.selectProjects(files, request);
    }
}

